define("tiny_c4l/components",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;
/**
   * Tiny C4L components.
   *
   * @module      tiny_c4l/components
   * @copyright   2022 Marc Català <reskit@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const components=[{id:"0",name:"keyconcept",type:"contextual",imageClass:"c4l-keyconcept-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-keyconcept {{VARIANTS}}" aria-label="{{#keyconcept}}">{{PLACEHOLDER}}</div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc tempor odio vel turpis consequat sodales.",variants:["full-width"]},{id:"1",name:"tip",type:"contextual",imageClass:"c4l-tip-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-tip {{VARIANTS}}" aria-label="{{#tip}}">\n            {{PLACEHOLDER}}</div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc tempor odio vel turpis consequat sodales.",variants:["full-width"]},{id:"2",name:"reminder",type:"contextual",imageClass:"c4l-reminder-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-reminder {{VARIANTS}}"\n             aria-label="{{#reminder}}">\n            {{PLACEHOLDER}}</div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc tempor odio vel turpis consequat sodales.",variants:["full-width"]},{id:"3",name:"quote",type:"contextual",imageClass:"c4l-quote-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-quote {{VARIANTS}}"\n            aria-label="{{#quote}}">\n            <div class="c4l-quote-body"><div class="c4l-quote-line"></div><div class="c4l-quote-text">\n            <p>{{PLACEHOLDER}}</p>\n            </div></div>\n            {{VARIANTSHTML}}\n            </div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus a posuere nibh, eu mollis lacus. Praesent dictum in velit sed dapibus.",variants:["full-width","quote"]},{id:"4",name:"dodontcards",type:"contextual",imageClass:"c4l-dodontcards-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-dodontcards {{VARIANTS}}"\n            aria-label="{{#dodontcards}}">\n            <div class="c4l-dodontcards-do" aria-label="{{#do-card}}">{{PLACEHOLDER}}</div>\n            <div class="c4l-dodontcards-dont" aria-label="{{#dont-card}}">\n            Lorem ipsum dolor sit amet, consectetur adipiscing elit.\n            Phasellus a posuere nibh, eu mollis lacus.\n            Praesent dictum in velit sed dapibus. Orci varius natoque penatibus et magnis dis parturient montes,\n            nascetur ridiculus mus.</div></div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus a posuere nibh, eu mollis lacus. Praesent dictum in velit sed dapibus.Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.",variants:["full-width"]},{id:"5",name:"readingcontext",type:"contextual",imageClass:"c4l-readingcontext-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-readingcontext {{VARIANTS}}"\n            aria-label="{{#readingcontext}}">\n            <p>{{PLACEHOLDER}}</p>{{VARIANTSHTML}}</div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus leo, hendrerit ac sem vitae, posuere egestas nisi. Lorem ipsum dolor sit amet. Phasellus leo, hendrerit ac sem vitae, posuere egestas nisi.",variants:["full-width","quote","comfort-reading"]},{id:"6",name:"example",type:"contextual",imageClass:"c4l-example-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-example {{VARIANTS}}"\n            aria-label="{{#example}}"><h1>Lorem ipsum dolor sit amet</h1>\n             <p>{{PLACEHOLDER}}</p></div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus a posuere nibh, eu mollis lacus. Praesent dictum in velit sed dapibus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.",variants:["full-width"]},{id:"7",name:"figure",type:"contextual",imageClass:"c4l-figure-icon",code:'<p class="c4l-spacer"></p><figure class="c4lv-figure {{VARIANTS}}"\n            aria-label="{{#figure}}"><img src="" alt="Lorem ipsum dolor sit amet">\n            {{VARIANTSHTML}}</figure><p><br></p>',text:"Consectetur adipiscing elit.",variants:["full-width","caption"]},{id:"8",name:"tag",type:"contextual",imageClass:"c4l-tag-icon",code:'<p class="c4l-spacer"></p><div class="c4l-display-left" aria-label="{{#tag}}">\n            <div class="c4lv-tag {{VARIANTS}}">{{PLACEHOLDER}}</div></div>',text:"Lorem ipsum",variants:["align-right"]},{id:"9",name:"inlinetag",type:"contextual",imageClass:"c4l-inlinetag-icon",code:'<span class="c4lv-inlinetag {{VARIANTS}}" aria-label="{{#inlinetag}}">{{PLACEHOLDER}}</span>',text:"Text",variants:[]},{id:"10",name:"attention",type:"procedural",imageClass:"c4l-attention-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-attention {{VARIANTS}}" aria-label="{{#attention}}">\n            {{PLACEHOLDER}}</div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc tempor odio vel turpis consequat sodales.",variants:["full-width"]},{id:"11",name:"estimatedtime",type:"procedural",imageClass:"c4l-estimatedtime-icon",code:'<p class="c4l-spacer"></p><div class="c4l-inline-group"><div class="c4lv-estimatedtime {{VARIANTS}}"\n            aria-label="{{#estimatedtime}}">{{PLACEHOLDER}} <span>{{#min}}</span></div></div>',text:"15",variants:["align-left"]},{id:"12",name:"duedate",type:"procedural",imageClass:"c4l-duedate-icon",code:'<p class="c4l-spacer"></p><div class="c4l-inline-group"><div class="c4lv-duedate {{VARIANTS}}"\n            aria-label="{{#duedate}}">{{PLACEHOLDER}}</div></div>',text:"November 17th",variants:["align-left"]},{id:"13",name:"proceduralcontext",type:"procedural",imageClass:"c4l-proceduralcontext-icon",code:'<p class="c4l-spacer"></p><p class="c4lv-proceduralcontext {{VARIANTS}}"\n            aria-label="{{#proceduralcontext}}" >\n            {{PLACEHOLDER}}</p><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus a posuere nibh, eu mollis lacus. Praesent dictum in velit sed dapibus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla quis lorem aliquet, fermentum dolor ac, venenatis turpis.",variants:["full-width"]},{id:"14",name:"learningoutcomes",type:"procedural",imageClass:"c4l-learningoutcomes-icon",code:'<p class="c4l-spacer"></p>\n            <div class="c4lv-learningoutcomes {{VARIANTS}}" aria-label="{{#learningoutcomes}}">\n            <h6 class="c4l-learningoutcomes-title">{{#learningoutcomes}}</h6>\n            <ul class="c4l-learningoutcomes-list"><li>{{PLACEHOLDER}}</li><li>Curabitur non nulla sit amet\n            nisl tempus convallis quis ac lectus. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi.</li>\n            <li> Nulla porttitor accumsan tincidunt. Curabitur aliquet quam id dui posuere blandit.\n             Curabitur non nulla sit amet nisl tempus convallis quis ac lectus.</li></ul></div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut porta, neque id feugiat consectetur, enim ipsum tincidunt nunc, id suscipit mauris urna sit amet lectus.",variants:["full-width","ordered-list"]},{id:"15",name:"gradingvalue",type:"evaluative",imageClass:"c4l-gradingvalue-icon",code:'<p class="c4l-spacer"></p><div class="c4l-inline-group"><div class="c4lv-gradingvalue {{VARIANTS}}"\n             aria-label="{{#gradingvalue}}"><span>{{#gradingvalue}}: </span>{{PLACEHOLDER}}</div></div>',text:"33.3%",variants:["align-left"]},{id:"16",name:"expectedfeedback",type:"evaluative",imageClass:"c4l-expectedfeedback-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-expectedfeedback {{VARIANTS}}"\n            aria-label="{{#expectedfeedback}}">\n            <p>{{PLACEHOLDER}}</p></div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus a posuere nibh, eu mollis lacus. Praesent dictum in velit sed dapibus.",variants:["full-width"]},{id:"17",name:"allpurposecard",type:"helper",imageClass:"c4l-allpurposecard-icon",code:'<p class="c4l-spacer"></p><div class="c4lv-allpurposecard {{VARIANTS}}"\n            aria-label="{{#allpurposecard}}"><p>{{PLACEHOLDER}}</p></div><p><br></p>',text:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus a posuere nibh, eu mollis lacus. Praesent dictum in velit sed dapibus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.",variants:["full-width"]}];_exports.default={components:components};return _exports.default}));

//# sourceMappingURL=components.min.js.map