define("tiny_fontsize/commands",["exports","editor_tiny/utils","core/str","./common"],(function(_exports,_utils,_str,_common){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.getSetup=void 0;
/**
   * Commands helper for the Moodle tiny_fontsize plugin.
   *
   * @module      plugintype_pluginname/commands
   * @copyright   2023 Mikko Haiku <mikko.haiku@mediamaisteri.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const handleAction=(editor,fontsize)=>{editor.selection.dom.setAttrib(editor.selection.getNode(),"style","font-size: "+fontsize+"pt")};_exports.getSetup=async()=>{const[fontsizeButtonNameTitle,fontsizeMenuItemNameTitle,buttonImage]=await Promise.all([(0,_str.get_string)("button_fontsize",_common.component),(0,_str.get_string)("menuitem_fontsize",_common.component),(0,_utils.getButtonImage)("icon",_common.component)]);return editor=>{editor.ui.registry.addIcon(_common.icon,buttonImage.html),editor.ui.registry.addButton(_common.fontsizeButtonName,{icon:_common.icon,tooltip:fontsizeButtonNameTitle,onAction:()=>handleAction(editor)}),editor.ui.registry.addMenuItem(_common.fontsizeMenuItemName,{icon:_common.icon,text:fontsizeMenuItemNameTitle,onAction:()=>handleAction(editor)});function handleFontSize(editor,size){return()=>handleAction(editor,size)}const submenuItems=[{size:8,label:"8 pt"},{size:10,label:"10 pt"},{size:12,label:"12 pt"},{size:14,label:"14 pt"},{size:18,label:"18 pt"},{size:24,label:"24 pt"},{size:36,label:"36 pt"}].map((_ref=>{let{size:size,label:label}=_ref;return{type:"menuitem",text:label,onAction:handleFontSize(editor,size)}}));editor.ui.registry.addNestedMenuItem(_common.fontsizeMenuItemName,{icon:_common.icon,text:fontsizeMenuItemNameTitle,getSubmenuItems:()=>submenuItems}),editor.ui.registry.addMenuButton(_common.fontsizeButtonName,{icon:_common.icon,fetch:callback=>{callback(submenuItems)}})}}}));

//# sourceMappingURL=commands.min.js.map