<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Lang en file
 *
 * @package    local_kopere_mobile
 * @copyright  2024 Eduardo Kraus {@link http://eduardokraus.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */



$string['androidappfile'] = 'File to download the Android app';
$string['androidappfile_desc'] = 'Leave this setting blank unless you have an Android app hosted on your server.';
$string['androidappid'] = 'The unique identifier of the Android app';
$string['androidappid_desc'] = 'This setting can be left as default unless you have a custom Android application.';
$string['app_title'] = 'APP Data in stores';
$string['config_deleted'] = 'User deleted!';
$string['config_lgpd_reason'] = 'Reason for deletion';
$string['config_not_confirmed'] = 'User not confirmed!';
$string['config_not_manual'] = 'User must have Manual authentication!';
$string['config_not_user'] = 'User needs to be created';
$string['config_suspended'] = 'User suspended!';
$string['config_test_correct'] = 'The value is incorrect for the APP to function properly';
$string['config_test_title'] = 'Status of the required configurations for the APP to function';
$string['customfield_field_description'] = 'This image will be used as the background for the course list in the app, with specific dimensions of 600 x 300 pixels.';
$string['customfield_field_extradescription'] = '<div class="alert alert-warning">You need to install the <a href="https://moodle.org/plugins/customfield_picture" target="_blank">customfield_picture</a> plugin in order to customize the background image.</div>';
$string['customfield_field_name'] = 'App Background Image';
$string['customizationapp'] = 'APP Customization';
$string['customizationappcss'] = 'APP Customization CSS';
$string['customizationappcss_desc'] = 'This file contains the custom CSS that will be applied to the app, allowing visual adjustments according to the specific needs of the project.';
$string['customizationapphome'] = 'Course list on Home';
$string['customizationapphome_background'] = 'Background image';
$string['customizationapphome_default'] = 'Image on the side';
$string['customizationapphome_desc'] = 'This option allows you to customize the display of courses on the application\'s home page. You can choose from different layouts and display styles to highlight the courses according to your preferences and needs.';
$string['customizationapptopo'] = 'Top image on the APP home screen';
$string['customizationapptopo_desc'] = 'This field allows you to upload an image that will be displayed as a header on the app\'s home page. Dimensions: 1080 x 441px';
$string['download_info'] = '<p>With the Moodle app, you can learn from anywhere, anytime, with the following app features:</p>
    <ul>
        <li>Easily access course content - browse your course content with ease, even when you are offline.</li>
        <!--li>Connect with course participants - quickly find and contact others who are taking the same courses as you.</li-->
        <li>Stay updated - receive instant notifications for messages and other important events, such as assignment submissions.</li>
        <li>Track your progress - view your grades, check course completion progress.</li>
        <li>Complete activities anywhere, anytime, play SCORM packages, and more, both online and offline.</li>
        <li>... and much more!</li>
    </ul>';
$string['download_title'] = 'Download mobile device';
$string['facial:manage'] = 'Manager Kopere Mobile';
$string['facial:view'] = 'View Kopere Mobile';
$string['htmllogin'] = 'Extra Login HTML';
$string['htmllogin_desc'] = 'This setting allows you to add custom HTML code to the login page. It can be used to include additional contact and support information, such as emails, phone numbers, or useful links for users. The HTML inserted here will be displayed directly on the login interface.';
$string['iosappid'] = 'IOS app numeric ID';
$string['iosappid_desc'] = 'This setting can be left as the default unless you have a custom iOS application.';
$string['lgpd_email'] = 'Data deletion email';
$string['lgpd_email_desc'] = 'Enter the email address to direct data deletion requests.';
$string['lgpd_okok'] = 'Submission confirmation message';
$string['lgpd_okok_desc'] = 'Message after the data has been sent to the responsible party';
$string['lgpd_okok_msgdefault'] = '<p>Thank you for submitting your data deletion request. We are committed to ensuring the security and privacy of our users\' information.</p>
<p>Your request has been successfully received and will be processed by our data protection team. We emphasize that, according to current legislation, only non-mandatory data will be deleted, preserving essential information required by legal authorities.</p>
<p>If additional information is needed or if you have any questions, our team will contact you within the timeframe stipulated by law. Please keep your contact details updated to facilitate communication.</p>
<p>Thank you for your understanding and trust in our platform. We are here to ensure a safe and transparent experience.</p>';
$string['lgpd_text'] = 'Data deletion policy';
$string['lgpd_text_desc'] = 'Describe the Data Deletion Policy in accordance with international data protection laws (e.g., GDPR) in Moodle';
$string['lgpd_text_msgdefault'] = '<p>In compliance with international data protection regulations, such as the General Data Protection Regulation (GDPR), this page provides detailed information on how we manage and protect your personal data within the Moodle virtual environment. The main goal of these regulations is to ensure the privacy, security, and transparency in the processing of personal information.</p>
<p>You have the right to request the deletion of your personal data stored in our system. However, please note that certain data may be retained in accordance with applicable legal requirements and regulations from educational authorities for the maintenance of academic and administrative records.</p>
<p>We appreciate your understanding in ensuring compliance with international data protection standards. Please feel free to reach out if you have any questions or require further information regarding the processing of your personal data.</p>
<h2>Data Deletion Request Form:</h2>
<p>To request the deletion of your data, please complete the form below. Upon receiving your request, we will review and respond as promptly as possible to ensure legal compliance.</p>';
$string['lgpd_title'] = 'Information about Data Protection (GDPR)';

$string['logologin'] = 'PNG/SVG logo for login screen';
$string['logologin_desc'] = 'Upload the logo in PNG or SVG format to be displayed on the login screen. The logo should be clear and representative of your institution or company\'s visual identity, ensuring a professional and consistent login experience for users.';
$string['modulename'] = 'Kopere Mobile';
$string['pluginname'] = 'Kopere Mobile';
$string['privacy:metadata'] = 'The Plugin custom field plugin does not store any personal data';
$string['setting_title'] = 'Kopere Mobile Settings';
$string['settings'] = 'Setting Kopere Mobile';
$string['status_app'] = 'APP Status';
