<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Cache file.
 *
 * @package   theme_boost_magnific
 * @copyright 2024 Eduardo Kraus {@link http://eduardokraus.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

$definitions = [
    "css_cache" => [
        "mode" => cache_store::MODE_APPLICATION,
        "ttl" => 1 * 24 * 60 * 60, // 1d.
    ],
    "logo_cache" => [
        "mode" => cache_store::MODE_APPLICATION,
        "ttl" => 1 * 24 * 60 * 60, // 1d.
    ],
    "layout_cache" => [
        "mode" => cache_store::MODE_APPLICATION,
        "ttl" => 1 * 24 * 60 * 60, // 1d.
    ],
    "darkmode_cache" => [
        "mode" => cache_store::MODE_APPLICATION,
        "ttl" => 1 * 24 * 60 * 60, // 1d.
    ],
];
