<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Class userprerence
 *
 * @package   theme_boost_magnific
 * @copyright 2024 Eduardo Kraus {@link http://eduardokraus.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace theme_boost_magnific\external;

defined('MOODLE_INTERNAL') || die;
require_once("{$CFG->libdir}/externallib.php");

/**
 * Class userprerence
 *
 * @package theme_boost_magnific\external
 */
class userprerence extends \external_api {

    /**
     * layout_parameters function
     *
     * @return \external_function_parameters
     */
    public static function layout_parameters() {
        return new \external_function_parameters([
            "thememode" => new \external_value(PARAM_TEXT, "The layout mode"),
        ]);
    }

    /**
     * layout function
     *
     * @param string $darkmode
     *
     * @return array
     * @throws \coding_exception
     */
    public static function layout($darkmode) {
        global $CFG, $USER;

        // Check if the user is a guest (not logged in).
        if (isguestuser()) {
            // Calculate the expiration date (1 year from now).
            $expiry = time() + (365 * 24 * 60 * 60); // 1 year in seconds.

            // Set the cookie.
            setcookie("darkmode", $darkmode, $expiry, $CFG->sessioncookiepath);

            return ["status" => true];
        }

        set_user_preference("darkmode", $darkmode);
        $cache = \cache::make("theme_boost_magnific", "darkmode_cache");
        $cachekey = "html_attributes-{$USER->id}";
        $cache->set($cachekey, null);

        return ["status" => true];
    }

    /**
     * layout_returns function
     *
     * @return \external_description
     */
    public static function layout_returns() {
        return new \external_single_structure([
            "status" => new \external_value(PARAM_BOOL, "the status"),
        ]);
    }
}
