<?php
/**
 * User: Eduardo Kraus
 * Date: 26/06/2024
 * Time: 20:04
 */

require_once('../../config.php');

$modulename = "videofront";

if (!$module = $DB->get_record('modules', ['name' => $modulename])) {
    die("OPs module");
}

if (!$count = $DB->count_records('course_modules', ['module' => $module->id])) {
    die("OPs course_modules");
}

$sql = "SELECT *, cm.id AS cmid
          FROM {course_modules} cm
          JOIN {{$modulename}}   m  ON m.id = cm.instance
         WHERE module = :mid";
$coursemodules = $DB->get_records_sql($sql, ['mid' => $module->id]);

$count = 0;
foreach ($coursemodules as $coursemodule) {

//    echo '<pre>';
//    print_r($coursemodule);
//    echo '</pre>';

    $video = \mod_cloudstudio\util\cloudstudio_api::get("Arquivo/{$coursemodule->identifier}/status");

    //set_coursemodule_visible($coursemodule->cmid, 1);
    if ($coursemodule->visible) {
        $count++;
        echo "<p>{$count}: Anterior: <a href='/mod/{$modulename}/view.php?id={$coursemodule->cmid}' target='aaaa'>{$coursemodule->name}</a></p>\n";

        $createvideo = new createvideo($coursemodule->course, "cloudstudio", $coursemodule->section, $coursemodule->cmid);
        $createvideo->create($coursemodule->name, $video->descricao, $coursemodule->identifier);

        echo "<p>{$count}: Movido para: <a href='/mod/cloudstudio/view.php?id={$createvideo->cm->id}' target='aaaa'>{$coursemodule->name}</a></p>\n";
    }else{
        echo "<p>{$count}: Anterior Oculto: <a href='/mod/{$modulename}/view.php?id={$coursemodule->cmid}' target='aaaa'>{$coursemodule->name}</a></p>\n";
    }

//    $shell[$coursemodule->identifier] = "
//echo 'Baixar {$coursemodule->identifier}'
//curl 'https://nyc3.digitaloceanspaces.com/vfvideos/kraush-eadtech/video/{$coursemodule->identifier}/qualidade-1080.mp4' -o {$coursemodule->identifier}.mp4
//echo 'Enviar {$coursemodule->identifier}'
//curl 'https://eadtech.cloudstudio.com.br/api/v1/Envio' \
//     --connect-timeout 130070000 \
//     --header 'authorization: HMAC-SHA4096-seu-token' \
//     --form 'file=@{$coursemodule->identifier}.mp4' \
//     --form 'identificador={$coursemodule->identifier}' \
//     --form 'titulo={$coursemodule->name}' -o {$coursemodule->identifier}.txt
//rm -f {$coursemodule->identifier}.mp4\n";
}

//echo '<pre>';
//print_r($shell);
//echo '</pre>';

// https://www.brasilqualificamais.com.br/course/modedit.php?add=cloudstudio&type&course=13&section=3&return=0&sr=0&beforemod=43

/**
 * Class createvideo
 */
class createvideo {

    /**
     * Var course
     *
     * @var mixed
     */
    public $course;
    /**
     * Var section
     *
     * @var
     */
    public $section;
    /**
     * Var module
     *
     * @var mixed
     */
    public $module;
    /**
     * Var type
     *
     * @var string
     */
    public $type;
    /**
     * Var beforemod
     *
     * @var
     */
    public $beforemod;
    /**
     * Var displayname
     *
     * @var
     */
    public $displayname;

    /**
     * Var cm
     *
     * @var
     */
    public $cm;
    /**
     * Var identificador
     *
     * @var
     */
    public $identificador;
    /**
     * Var intro
     *
     * @var
     */
    public $intro;

    /**
     * createvideo constructor.
     *
     * @param $courseid
     * @param $modulename
     * @param $section
     * @param $beforemod
     * @throws dml_exception
     */
    public function __construct($courseid, $modulename, $section, $beforemod) {
        global $DB;

        $this->course = $DB->get_record('course', ['id' => $courseid], '*', MUST_EXIST);

        $section = $DB->get_record('course_sections', ['id' => $section], '*', MUST_EXIST);
        $this->section = $section->section;

        $this->module = $DB->get_record('modules', ['name' => $modulename]);

        $this->type = "Files";
        $this->beforemod = $beforemod;
    }

    /**
     * Function create_course_module
     *
     */
    private function create_course_module() {
        global $CFG;
        require_once(__DIR__ . '/lib.php');
        require_once($CFG->dirroot . '/course/modlib.php');
        list($module, $context, $cw, $cm, $data) = prepare_new_moduleinfo_data($this->course, $this->module->name, $this->section);

        $data->coursemodule = $data->id = add_course_module($data);
        $this->cm = $data;
    }

    /**
     * Function create
     *
     * @param $displayname
     * @param $intro
     * @param $identificador
     */
    public function create($displayname, $intro, $identificador) {

        $this->displayname = $displayname;
        $this->intro = $intro;
        $this->identificador = $identificador;

        // Create a course module to hold the new instance.
        $this->create_course_module();

        // Ask the module to set itself up.
        $moduledata = $this->prepare_module_data();
        $instanceid = $this->cloudstudio_dndupload_handle($moduledata);

        // Finish setting up the course module.
        $this->finish_setup_course_module($instanceid);
    }

    /**
     * Function cloudstudio_dndupload_handle
     *
     * @param $uploadinfo
     *
     * @return bool|int
     * @throws coding_exception
     * @throws dml_exception
     */
    private function cloudstudio_dndupload_handle($uploadinfo) {
        // Gather the required info.
        $data = new stdClass();
        $data->course = $uploadinfo->course->id;
        $data->name = $uploadinfo->displayname;
        $data->intro = $this->intro;
        $data->introformat = FORMAT_HTML;
        $data->coursemodule = $uploadinfo->coursemodule;
        $data->identificador = $this->identificador;

        $data->grade_approval = 0;

        $data->livro = 1;
        $data->mapamental = 1;

        $data->instance = cloudstudio_add_instance($data, null);

        return $data->instance;
    }

    /**
     * Function prepare_module_data
     *
     * @return stdClass
     */
    private function prepare_module_data() {
        $data = new stdClass();
        $data->type = $this->type;
        $data->course = $this->course;
        $data->coursemodule = $this->cm->id;
        $data->displayname = $this->displayname;
        return $data;
    }

    /**
     * Function finish_setup_course_module
     *
     * @param $instanceid
     *
     * @throws coding_exception
     * @throws dml_exception
     * @throws moodle_exception
     */
    private function finish_setup_course_module($instanceid) {
        global $DB;

        // Note the section visibility
        $visible = get_fast_modinfo($this->course)->get_section_info($this->section)->visible;

        $DB->set_field('course_modules', 'instance', $instanceid, ['id' => $this->cm->id]);

        \course_modinfo::purge_course_module_cache($this->course->id, $this->cm->id);
        // Rebuild the course cache after update action
        rebuild_course_cache($this->course->id, true, true);

        course_add_cm_to_section($this->course, $this->cm->id, $this->section, $this->beforemod);

        set_coursemodule_visible($this->cm->id, $visible);
        set_coursemodule_visible($this->beforemod, !$visible);
    }
}
