/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */

(function webpackUniversalModuleDefinition(root, factory) {
    if (typeof exports === 'object' && typeof module === 'object')
        module.exports = factory();
    else if (typeof define === 'function' && define.amd)
        define("pdfjs-dist/build/pdf.worker", [], factory);
    else if (typeof exports === 'object')
        exports["pdfjs-dist/build/pdf.worker"] = factory();
    else
        root["pdfjs-dist/build/pdf.worker"] = root.pdfjsWorker = factory();
})(this, function() {
    return /******/ (() => { // webpackBootstrap
        /******/
        var __webpack_modules__ = ([
            /* 0 */,
            /* 1 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.WorkerTask = exports.WorkerMessageHandler = void 0;

                var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

                var _util = __w_pdfjs_require__(4);

                var _primitives = __w_pdfjs_require__(125);

                var _pdf_manager = __w_pdfjs_require__(126);

                var _writer = __w_pdfjs_require__(168);

                var _is_node = __w_pdfjs_require__(6);

                var _message_handler = __w_pdfjs_require__(189);

                var _worker_stream = __w_pdfjs_require__(190);

                var _core_utils = __w_pdfjs_require__(128);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {"default" : obj};
                }

                function _createForOfIteratorHelper(o, allowArrayLike) {
                    var it;
                    if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
                        if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
                            if (it) o = it;
                            var i = 0;
                            var F = function F() {
                            };
                            return {
                                s    : F, n : function n() {
                                    if (i >= o.length) return {done : true};
                                    return {done : false, value : o[i++]};
                                }, e : function e(_e2) {
                                    throw _e2;
                                }, f : F
                            };
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                    }
                    var normalCompletion = true, didErr = false, err;
                    return {
                        s    : function s() {
                            it = o[Symbol.iterator]();
                        }, n : function n() {
                            var step = it.next();
                            normalCompletion = step.done;
                            return step;
                        }, e : function e(_e3) {
                            didErr = true;
                            err = _e3;
                        }, f : function f() {
                            try {
                                if (!normalCompletion && it["return"] != null) it["return"]();
                            } finally {
                                if (didErr) throw err;
                            }
                        }
                    };
                }

                function _toArray(arr) {
                    return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest();
                }

                function _iterableToArray(iter) {
                    if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
                }

                function _slicedToArray(arr, i) {
                    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
                }

                function _nonIterableRest() {
                    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                }

                function _unsupportedIterableToArray(o, minLen) {
                    if (!o) return;
                    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
                    var n = Object.prototype.toString.call(o).slice(8, -1);
                    if (n === "Object" && o.constructor) n = o.constructor.name;
                    if (n === "Map" || n === "Set") return Array.from(o);
                    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
                }

                function _arrayLikeToArray(arr, len) {
                    if (len == null || len > arr.length) len = arr.length;
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i];
                    }
                    return arr2;
                }

                function _iterableToArrayLimit(arr, i) {
                    if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
                    var _arr = [];
                    var _n = true;
                    var _d = false;
                    var _e = undefined;
                    try {
                        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                            _arr.push(_s.value);
                            if (i && _arr.length === i) break;
                        }
                    } catch (err) {
                        _d = true;
                        _e = err;
                    } finally {
                        try {
                            if (!_n && _i["return"] != null) _i["return"]();
                        } finally {
                            if (_d) throw _e;
                        }
                    }
                    return _arr;
                }

                function _arrayWithHoles(arr) {
                    if (Array.isArray(arr)) return arr;
                }

                function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
                    try {
                        var info = gen[key](arg);
                        var value = info.value;
                    } catch (error) {
                        reject(error);
                        return;
                    }
                    if (info.done) {
                        resolve(value);
                    } else {
                        Promise.resolve(value).then(_next, _throw);
                    }
                }

                function _asyncToGenerator(fn) {
                    return function() {
                        var self = this, args = arguments;
                        return new Promise(function(resolve, reject) {
                            var gen = fn.apply(self, args);

                            function _next(value) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
                            }

                            function _throw(err) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
                            }

                            _next(undefined);
                        });
                    };
                }

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                var WorkerTask = /*#__PURE__*/function() {
                    function WorkerTask(name) {
                        _classCallCheck(this, WorkerTask);

                        this.name = name;
                        this.terminated = false;
                        this._capability = (0, _util.createPromiseCapability)();
                    }

                    _createClass(WorkerTask, [{
                        key : "finished",
                        get : function get() {
                            return this._capability.promise;
                        }
                    }, {
                        key   : "finish",
                        value : function finish() {
                            this._capability.resolve();
                        }
                    }, {
                        key   : "terminate",
                        value : function terminate() {
                            this.terminated = true;
                        }
                    }, {
                        key   : "ensureNotTerminated",
                        value : function ensureNotTerminated() {
                            if (this.terminated) {
                                throw new Error("Worker task was terminated");
                            }
                        }
                    }]);

                    return WorkerTask;
                }();

                exports.WorkerTask = WorkerTask;

                var WorkerMessageHandler = /*#__PURE__*/function() {
                    function WorkerMessageHandler() {
                        _classCallCheck(this, WorkerMessageHandler);
                    }

                    _createClass(WorkerMessageHandler, null, [{
                        key   : "setup",
                        value : function setup(handler, port) {
                            var testMessageProcessed = false;
                            handler.on("test", function wphSetupTest(data) {
                                if (testMessageProcessed) {
                                    return;
                                }

                                testMessageProcessed = true;

                                if (!(data instanceof Uint8Array)) {
                                    handler.send("test", null);
                                    return;
                                }

                                var supportTransfers = data[0] === 255;
                                handler.postMessageTransfers = supportTransfers;
                                handler.send("test", {
                                    supportTransfers : supportTransfers
                                });
                            });
                            handler.on("configure", function wphConfigure(data) {
                                (0, _util.setVerbosityLevel)(data.verbosity);
                            });
                            handler.on("GetDocRequest", function wphSetupDoc(data) {
                                return WorkerMessageHandler.createDocumentHandler(data, port);
                            });
                        }
                    }, {
                        key   : "createDocumentHandler",
                        value : function createDocumentHandler(docParams, port) {
                            var pdfManager;
                            var terminated = false;
                            var cancelXHRs = null;
                            var WorkerTasks = [];
                            var verbosity = (0, _util.getVerbosityLevel)();
                            var apiVersion = docParams.apiVersion;
                            var workerVersion = '2.8.335';

                            if (apiVersion !== workerVersion) {
                                throw new Error("The API version \"".concat(apiVersion, "\" does not match ") + "the Worker version \"".concat(workerVersion, "\"."));
                            }

                            var enumerableProperties = [];

                            for (var property in []) {
                                enumerableProperties.push(property);
                            }

                            if (enumerableProperties.length) {
                                throw new Error("The `Array.prototype` contains unexpected enumerable properties: " + enumerableProperties.join(", ") + "; thus breaking e.g. `for...in` iteration of `Array`s.");
                            }

                            var docId = docParams.docId;
                            var docBaseUrl = docParams.docBaseUrl;
                            var workerHandlerName = docParams.docId + "_worker";
                            var handler = new _message_handler.MessageHandler(workerHandlerName, docId, port);
                            handler.postMessageTransfers = docParams.postMessageTransfers;

                            function ensureNotTerminated() {
                                if (terminated) {
                                    throw new Error("Worker was terminated");
                                }
                            }

                            function startWorkerTask(task) {
                                WorkerTasks.push(task);
                            }

                            function finishWorkerTask(task) {
                                task.finish();
                                var i = WorkerTasks.indexOf(task);
                                WorkerTasks.splice(i, 1);
                            }

                            function loadDocument(_x) {
                                return _loadDocument.apply(this, arguments);
                            }

                            function _loadDocument() {
                                _loadDocument = _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee(recoveryMode) {
                                    var _yield$Promise$all, _yield$Promise$all2, numPages, fingerprint, isPureXfa;

                                    return _regenerator["default"].wrap(function _callee$(_context) {
                                        while (1) {
                                            switch (_context.prev = _context.next) {
                                                case 0:
                                                    _context.next = 2;
                                                    return pdfManager.ensureDoc("checkHeader");

                                                case 2:
                                                    _context.next = 4;
                                                    return pdfManager.ensureDoc("parseStartXRef");

                                                case 4:
                                                    _context.next = 6;
                                                    return pdfManager.ensureDoc("parse", [recoveryMode]);

                                                case 6:
                                                    if (recoveryMode) {
                                                        _context.next = 9;
                                                        break;
                                                    }

                                                    _context.next = 9;
                                                    return pdfManager.ensureDoc("checkFirstPage");

                                                case 9:
                                                    _context.next = 11;
                                                    return Promise.all([pdfManager.ensureDoc("numPages"), pdfManager.ensureDoc("fingerprint"), pdfManager.ensureDoc("isPureXfa")]);

                                                case 11:
                                                    _yield$Promise$all = _context.sent;
                                                    _yield$Promise$all2 = _slicedToArray(_yield$Promise$all, 3);
                                                    numPages = _yield$Promise$all2[0];
                                                    fingerprint = _yield$Promise$all2[1];
                                                    isPureXfa = _yield$Promise$all2[2];
                                                    return _context.abrupt("return", {
                                                        numPages    : numPages,
                                                        fingerprint : fingerprint,
                                                        isPureXfa   : isPureXfa
                                                    });

                                                case 17:
                                                case "end":
                                                    return _context.stop();
                                            }
                                        }
                                    }, _callee);
                                }));
                                return _loadDocument.apply(this, arguments);
                            }

                            function getPdfManager(data, evaluatorOptions, enableXfa) {
                                var pdfManagerCapability = (0, _util.createPromiseCapability)();
                                var newPdfManager;
                                var source = data.source;

                                if (source.data) {
                                    try {
                                        newPdfManager = new _pdf_manager.LocalPdfManager(docId, source.data, source.password, evaluatorOptions, enableXfa, docBaseUrl);
                                        pdfManagerCapability.resolve(newPdfManager);
                                    } catch (ex) {
                                        pdfManagerCapability.reject(ex);
                                    }

                                    return pdfManagerCapability.promise;
                                }

                                var pdfStream,
                                    cachedChunks = [];

                                try {
                                    pdfStream = new _worker_stream.PDFWorkerStream(handler);
                                } catch (ex) {
                                    pdfManagerCapability.reject(ex);
                                    return pdfManagerCapability.promise;
                                }

                                var fullRequest = pdfStream.getFullReader();
                                fullRequest.headersReady.then(function() {
                                    if (!fullRequest.isRangeSupported) {
                                        return;
                                    }

                                    var disableAutoFetch = source.disableAutoFetch || fullRequest.isStreamingSupported;
                                    newPdfManager = new _pdf_manager.NetworkPdfManager(docId, pdfStream, {
                                        msgHandler       : handler,
                                        password         : source.password,
                                        length           : fullRequest.contentLength,
                                        disableAutoFetch : disableAutoFetch,
                                        rangeChunkSize   : source.rangeChunkSize
                                    }, evaluatorOptions, enableXfa, docBaseUrl);

                                    for (var i = 0; i < cachedChunks.length; i++) {
                                        newPdfManager.sendProgressiveData(cachedChunks[i]);
                                    }

                                    cachedChunks = [];
                                    pdfManagerCapability.resolve(newPdfManager);
                                    cancelXHRs = null;
                                })["catch"](function(reason) {
                                    pdfManagerCapability.reject(reason);
                                    cancelXHRs = null;
                                });
                                var loaded = 0;

                                var flushChunks = function flushChunks() {
                                    var pdfFile = (0, _util.arraysToBytes)(cachedChunks);

                                    if (source.length && pdfFile.length !== source.length) {
                                        (0, _util.warn)("reported HTTP length is different from actual");
                                    }

                                    try {
                                        newPdfManager = new _pdf_manager.LocalPdfManager(docId, pdfFile, source.password, evaluatorOptions, enableXfa, docBaseUrl);
                                        pdfManagerCapability.resolve(newPdfManager);
                                    } catch (ex) {
                                        pdfManagerCapability.reject(ex);
                                    }

                                    cachedChunks = [];
                                };

                                var readPromise = new Promise(function(resolve, reject) {
                                    var readChunk = function readChunk(_ref) {
                                        var value = _ref.value,
                                            done  = _ref.done;

                                        try {
                                            ensureNotTerminated();

                                            if (done) {
                                                if (!newPdfManager) {
                                                    flushChunks();
                                                }

                                                cancelXHRs = null;
                                                return;
                                            }

                                            loaded += (0, _util.arrayByteLength)(value);

                                            if (!fullRequest.isStreamingSupported) {
                                                handler.send("DocProgress", {
                                                    loaded : loaded,
                                                    total  : Math.max(loaded, fullRequest.contentLength || 0)
                                                });
                                            }

                                            if (newPdfManager) {
                                                newPdfManager.sendProgressiveData(value);
                                            } else {
                                                cachedChunks.push(value);
                                            }

                                            fullRequest.read().then(readChunk, reject);
                                        } catch (e) {
                                            reject(e);
                                        }
                                    };

                                    fullRequest.read().then(readChunk, reject);
                                });
                                readPromise["catch"](function(e) {
                                    pdfManagerCapability.reject(e);
                                    cancelXHRs = null;
                                });

                                cancelXHRs = function cancelXHRs(reason) {
                                    pdfStream.cancelAllRequests(reason);
                                };

                                return pdfManagerCapability.promise;
                            }

                            function setupDoc(data) {
                                function onSuccess(doc) {
                                    ensureNotTerminated();
                                    handler.send("GetDoc", {
                                        pdfInfo : doc
                                    });
                                }

                                function onFailure(ex) {
                                    ensureNotTerminated();

                                    if (ex instanceof _util.PasswordException) {
                                        var task = new WorkerTask("PasswordException: response ".concat(ex.code));
                                        startWorkerTask(task);
                                        handler.sendWithPromise("PasswordRequest", ex).then(function(_ref2) {
                                            var password = _ref2.password;
                                            finishWorkerTask(task);
                                            pdfManager.updatePassword(password);
                                            pdfManagerReady();
                                        })["catch"](function() {
                                            finishWorkerTask(task);
                                            handler.send("DocException", ex);
                                        });
                                    } else if (ex instanceof _util.InvalidPDFException || ex instanceof _util.MissingPDFException || ex instanceof _util.UnexpectedResponseException || ex instanceof _util.UnknownErrorException) {
                                        handler.send("DocException", ex);
                                    } else {
                                        handler.send("DocException", new _util.UnknownErrorException(ex.message, ex.toString()));
                                    }
                                }

                                function pdfManagerReady() {
                                    ensureNotTerminated();
                                    loadDocument(false).then(onSuccess, function(reason) {
                                        ensureNotTerminated();

                                        if (!(reason instanceof _core_utils.XRefParseException)) {
                                            onFailure(reason);
                                            return;
                                        }

                                        pdfManager.requestLoadedStream();
                                        pdfManager.onLoadedStream().then(function() {
                                            ensureNotTerminated();
                                            loadDocument(true).then(onSuccess, onFailure);
                                        });
                                    });
                                }

                                ensureNotTerminated();
                                var evaluatorOptions = {
                                    maxImageSize        : data.maxImageSize,
                                    disableFontFace     : data.disableFontFace,
                                    ignoreErrors        : data.ignoreErrors,
                                    isEvalSupported     : data.isEvalSupported,
                                    fontExtraProperties : data.fontExtraProperties
                                };
                                getPdfManager(data, evaluatorOptions, data.enableXfa).then(function(newPdfManager) {
                                    if (terminated) {
                                        newPdfManager.terminate(new _util.AbortException("Worker was terminated."));
                                        throw new Error("Worker was terminated");
                                    }

                                    pdfManager = newPdfManager;
                                    pdfManager.onLoadedStream().then(function(stream) {
                                        handler.send("DataLoaded", {
                                            length : stream.bytes.byteLength
                                        });
                                    });
                                }).then(pdfManagerReady, onFailure);
                            }

                            handler.on("GetPage", function wphSetupGetPage(data) {
                                return pdfManager.getPage(data.pageIndex).then(function(page) {
                                    return Promise.all([pdfManager.ensure(page, "rotate"), pdfManager.ensure(page, "ref"), pdfManager.ensure(page, "userUnit"), pdfManager.ensure(page, "view")]).then(function(_ref3) {
                                        var _ref4    = _slicedToArray(_ref3, 4),
                                            rotate   = _ref4[0],
                                            ref      = _ref4[1],
                                            userUnit = _ref4[2],
                                            view     = _ref4[3];

                                        return {
                                            rotate   : rotate,
                                            ref      : ref,
                                            userUnit : userUnit,
                                            view     : view
                                        };
                                    });
                                });
                            });
                            handler.on("GetPageIndex", function wphSetupGetPageIndex(_ref5) {
                                var ref = _ref5.ref;

                                var pageRef = _primitives.Ref.get(ref.num, ref.gen);

                                return pdfManager.ensureCatalog("getPageIndex", [pageRef]);
                            });
                            handler.on("GetDestinations", function wphSetupGetDestinations(data) {
                                return pdfManager.ensureCatalog("destinations");
                            });
                            handler.on("GetDestination", function wphSetupGetDestination(data) {
                                return pdfManager.ensureCatalog("getDestination", [data.id]);
                            });
                            handler.on("GetPageLabels", function wphSetupGetPageLabels(data) {
                                return pdfManager.ensureCatalog("pageLabels");
                            });
                            handler.on("GetPageLayout", function wphSetupGetPageLayout(data) {
                                return pdfManager.ensureCatalog("pageLayout");
                            });
                            handler.on("GetPageMode", function wphSetupGetPageMode(data) {
                                return pdfManager.ensureCatalog("pageMode");
                            });
                            handler.on("GetViewerPreferences", function(data) {
                                return pdfManager.ensureCatalog("viewerPreferences");
                            });
                            handler.on("GetOpenAction", function(data) {
                                return pdfManager.ensureCatalog("openAction");
                            });
                            handler.on("GetAttachments", function wphSetupGetAttachments(data) {
                                return pdfManager.ensureCatalog("attachments");
                            });
                            handler.on("GetJavaScript", function wphSetupGetJavaScript(data) {
                                return pdfManager.ensureCatalog("javaScript");
                            });
                            handler.on("GetDocJSActions", function wphSetupGetDocJSActions(data) {
                                return pdfManager.ensureCatalog("jsActions");
                            });
                            handler.on("GetPageJSActions", function(_ref6) {
                                var pageIndex = _ref6.pageIndex;
                                return pdfManager.getPage(pageIndex).then(function(page) {
                                    return page.jsActions;
                                });
                            });
                            handler.on("GetPageXfa", function wphSetupGetXfa(_ref7) {
                                var pageIndex = _ref7.pageIndex;
                                return pdfManager.getPage(pageIndex).then(function(page) {
                                    return pdfManager.ensure(page, "xfaData");
                                });
                            });
                            handler.on("GetIsPureXfa", function wphSetupGetIsPureXfa(data) {
                                return pdfManager.ensureDoc("isPureXfa");
                            });
                            handler.on("GetOutline", function wphSetupGetOutline(data) {
                                return pdfManager.ensureCatalog("documentOutline");
                            });
                            handler.on("GetOptionalContentConfig", function(data) {
                                return pdfManager.ensureCatalog("optionalContentConfig");
                            });
                            handler.on("GetPermissions", function(data) {
                                return pdfManager.ensureCatalog("permissions");
                            });
                            handler.on("GetMetadata", function wphSetupGetMetadata(data) {
                                return Promise.all([pdfManager.ensureDoc("documentInfo"), pdfManager.ensureCatalog("metadata")]);
                            });
                            handler.on("GetMarkInfo", function wphSetupGetMarkInfo(data) {
                                return pdfManager.ensureCatalog("markInfo");
                            });
                            handler.on("GetData", function wphSetupGetData(data) {
                                pdfManager.requestLoadedStream();
                                return pdfManager.onLoadedStream().then(function(stream) {
                                    return stream.bytes;
                                });
                            });
                            handler.on("GetStats", function wphSetupGetStats(data) {
                                return pdfManager.ensureXRef("stats");
                            });
                            handler.on("GetAnnotations", function(_ref8) {
                                var pageIndex = _ref8.pageIndex,
                                    intent    = _ref8.intent;
                                return pdfManager.getPage(pageIndex).then(function(page) {
                                    return page.getAnnotationsData(intent);
                                });
                            });
                            handler.on("GetFieldObjects", function(data) {
                                return pdfManager.ensureDoc("fieldObjects");
                            });
                            handler.on("HasJSActions", function(data) {
                                return pdfManager.ensureDoc("hasJSActions");
                            });
                            handler.on("GetCalculationOrderIds", function(data) {
                                return pdfManager.ensureDoc("calculationOrderIds");
                            });
                            handler.on("SaveDocument", function(_ref9) {
                                var numPages          = _ref9.numPages,
                                    annotationStorage = _ref9.annotationStorage,
                                    filename          = _ref9.filename;
                                pdfManager.requestLoadedStream();
                                var promises = [pdfManager.onLoadedStream(), pdfManager.ensureCatalog("acroForm"), pdfManager.ensureDoc("xref"), pdfManager.ensureDoc("startXRef")];

                                var _loop = function _loop(pageIndex) {
                                    promises.push(pdfManager.getPage(pageIndex).then(function(page) {
                                        var task = new WorkerTask("Save: page ".concat(pageIndex));
                                        startWorkerTask(task);
                                        return page.save(handler, task, annotationStorage)["finally"](function() {
                                            finishWorkerTask(task);
                                        });
                                    }));
                                };

                                for (var pageIndex = 0; pageIndex < numPages; pageIndex++) {
                                    _loop(pageIndex);
                                }

                                return Promise.all(promises).then(function(_ref10) {
                                    var _ref11    = _toArray(_ref10),
                                        stream    = _ref11[0],
                                        acroForm  = _ref11[1],
                                        xref      = _ref11[2],
                                        startXRef = _ref11[3],
                                        refs      = _ref11.slice(4);

                                    var newRefs = [];

                                    var _iterator = _createForOfIteratorHelper(refs),
                                        _step;

                                    try {
                                        for (_iterator.s(); !(_step = _iterator.n()).done;) {
                                            var ref = _step.value;
                                            newRefs = ref.filter(function(x) {
                                                return x !== null;
                                            }).reduce(function(a, b) {
                                                return a.concat(b);
                                            }, newRefs);
                                        }
                                    } catch (err) {
                                        _iterator.e(err);
                                    } finally {
                                        _iterator.f();
                                    }

                                    if (newRefs.length === 0) {
                                        return stream.bytes;
                                    }

                                    var xfa = acroForm instanceof _primitives.Dict && acroForm.get("XFA") || [];
                                    var xfaDatasets = null;

                                    if (Array.isArray(xfa)) {
                                        for (var i = 0, ii = xfa.length; i < ii; i += 2) {
                                            if (xfa[i] === "datasets") {
                                                xfaDatasets = xfa[i + 1];
                                            }
                                        }
                                    } else {
                                        (0, _util.warn)("Unsupported XFA type.");
                                    }

                                    var newXrefInfo = Object.create(null);

                                    if (xref.trailer) {
                                        var infoObj = Object.create(null);
                                        var xrefInfo = xref.trailer.get("Info") || null;

                                        if (xrefInfo instanceof _primitives.Dict) {
                                            xrefInfo.forEach(function(key, value) {
                                                if ((0, _util.isString)(key) && (0, _util.isString)(value)) {
                                                    infoObj[key] = (0, _util.stringToPDFString)(value);
                                                }
                                            });
                                        }

                                        newXrefInfo = {
                                            rootRef   : xref.trailer.getRaw("Root") || null,
                                            encrypt   : xref.trailer.getRaw("Encrypt") || null,
                                            newRef    : xref.getNewRef(),
                                            infoRef   : xref.trailer.getRaw("Info") || null,
                                            info      : infoObj,
                                            fileIds   : xref.trailer.getRaw("ID") || null,
                                            startXRef : startXRef,
                                            filename  : filename
                                        };
                                    }

                                    xref.resetNewRef();
                                    return (0, _writer.incrementalUpdate)({
                                        originalData : stream.bytes,
                                        xrefInfo     : newXrefInfo,
                                        newRefs      : newRefs,
                                        xref         : xref,
                                        datasetsRef  : xfaDatasets
                                    });
                                });
                            });
                            handler.on("GetOperatorList", function wphSetupRenderPage(data, sink) {
                                var pageIndex = data.pageIndex;
                                pdfManager.getPage(pageIndex).then(function(page) {
                                    var task = new WorkerTask("GetOperatorList: page ".concat(pageIndex));
                                    startWorkerTask(task);
                                    var start = verbosity >= _util.VerbosityLevel.INFOS ? Date.now() : 0;
                                    page.getOperatorList({
                                        handler                : handler,
                                        sink                   : sink,
                                        task                   : task,
                                        intent                 : data.intent,
                                        renderInteractiveForms : data.renderInteractiveForms,
                                        annotationStorage      : data.annotationStorage
                                    }).then(function(operatorListInfo) {
                                        finishWorkerTask(task);

                                        if (start) {
                                            (0, _util.info)("page=".concat(pageIndex + 1, " - getOperatorList: time=") + "".concat(Date.now() - start, "ms, len=").concat(operatorListInfo.length));
                                        }

                                        sink.close();
                                    }, function(reason) {
                                        finishWorkerTask(task);

                                        if (task.terminated) {
                                            return;
                                        }

                                        handler.send("UnsupportedFeature", {
                                            featureId : _util.UNSUPPORTED_FEATURES.errorOperatorList
                                        });
                                        sink.error(reason);
                                    });
                                });
                            });
                            handler.on("GetTextContent", function wphExtractText(data, sink) {
                                var pageIndex = data.pageIndex;

                                sink.onPull = function(desiredSize) {
                                };

                                sink.onCancel = function(reason) {
                                };

                                pdfManager.getPage(pageIndex).then(function(page) {
                                    var task = new WorkerTask("GetTextContent: page " + pageIndex);
                                    startWorkerTask(task);
                                    var start = verbosity >= _util.VerbosityLevel.INFOS ? Date.now() : 0;
                                    page.extractTextContent({
                                        handler             : handler,
                                        task                : task,
                                        sink                : sink,
                                        normalizeWhitespace : data.normalizeWhitespace,
                                        combineTextItems    : data.combineTextItems
                                    }).then(function() {
                                        finishWorkerTask(task);

                                        if (start) {
                                            (0, _util.info)("page=".concat(pageIndex + 1, " - getTextContent: time=") + "".concat(Date.now() - start, "ms"));
                                        }

                                        sink.close();
                                    }, function(reason) {
                                        finishWorkerTask(task);

                                        if (task.terminated) {
                                            return;
                                        }

                                        sink.error(reason);
                                    });
                                });
                            });
                            handler.on("FontFallback", function(data) {
                                return pdfManager.fontFallback(data.id, handler);
                            });
                            handler.on("Cleanup", function wphCleanup(data) {
                                return pdfManager.cleanup(true);
                            });
                            handler.on("Terminate", function wphTerminate(data) {
                                terminated = true;
                                var waitOn = [];

                                if (pdfManager) {
                                    pdfManager.terminate(new _util.AbortException("Worker was terminated."));
                                    var cleanupPromise = pdfManager.cleanup();
                                    waitOn.push(cleanupPromise);
                                    pdfManager = null;
                                } else {
                                    (0, _primitives.clearPrimitiveCaches)();
                                }

                                if (cancelXHRs) {
                                    cancelXHRs(new _util.AbortException("Worker was terminated."));
                                }

                                WorkerTasks.forEach(function(task) {
                                    waitOn.push(task.finished);
                                    task.terminate();
                                });
                                return Promise.all(waitOn).then(function() {
                                    handler.destroy();
                                    handler = null;
                                });
                            });
                            handler.on("Ready", function wphReady(data) {
                                setupDoc(docParams);
                                docParams = null;
                            });
                            return workerHandlerName;
                        }
                    }, {
                        key   : "initializeFromPort",
                        value : function initializeFromPort(port) {
                            var handler = new _message_handler.MessageHandler("worker", "main", port);
                            WorkerMessageHandler.setup(handler, port);
                            handler.send("ready", null);
                        }
                    }]);

                    return WorkerMessageHandler;
                }();

                exports.WorkerMessageHandler = WorkerMessageHandler;

                function isMessagePort(maybePort) {
                    return typeof maybePort.postMessage === "function" && "onmessage" in maybePort;
                }

                if (typeof window === "undefined" && !_is_node.isNodeJS && typeof self !== "undefined" && isMessagePort(self)) {
                    WorkerMessageHandler.initializeFromPort(self);
                }

                /***/
            }),
            /* 2 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                module.exports = __w_pdfjs_require__(3);

                /***/
            }),
            /* 3 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";
                /* module decorator */
                module = __w_pdfjs_require__.nmd(module);

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                var runtime = function(exports) {
                    "use strict";

                    var Op = Object.prototype;
                    var hasOwn = Op.hasOwnProperty;
                    var undefined;
                    var $Symbol = typeof Symbol === "function" ? Symbol : {};
                    var iteratorSymbol = $Symbol.iterator || "@@iterator";
                    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
                    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

                    function define(obj, key, value) {
                        Object.defineProperty(obj, key, {
                            value        : value,
                            enumerable   : true,
                            configurable : true,
                            writable     : true
                        });
                        return obj[key];
                    }

                    try {
                        define({}, "");
                    } catch (err) {
                        define = function define(obj, key, value) {
                            return obj[key] = value;
                        };
                    }

                    function wrap(innerFn, outerFn, self, tryLocsList) {
                        var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
                        var generator = Object.create(protoGenerator.prototype);
                        var context = new Context(tryLocsList || []);
                        generator._invoke = makeInvokeMethod(innerFn, self, context);
                        return generator;
                    }

                    exports.wrap = wrap;

                    function tryCatch(fn, obj, arg) {
                        try {
                            return {
                                type : "normal",
                                arg  : fn.call(obj, arg)
                            };
                        } catch (err) {
                            return {
                                type : "throw",
                                arg  : err
                            };
                        }
                    }

                    var GenStateSuspendedStart = "suspendedStart";
                    var GenStateSuspendedYield = "suspendedYield";
                    var GenStateExecuting = "executing";
                    var GenStateCompleted = "completed";
                    var ContinueSentinel = {};

                    function Generator() {
                    }

                    function GeneratorFunction() {
                    }

                    function GeneratorFunctionPrototype() {
                    }

                    var IteratorPrototype = {};

                    IteratorPrototype[iteratorSymbol] = function() {
                        return this;
                    };

                    var getProto = Object.getPrototypeOf;
                    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));

                    if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
                        IteratorPrototype = NativeIteratorPrototype;
                    }

                    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
                    GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
                    GeneratorFunctionPrototype.constructor = GeneratorFunction;
                    GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction");

                    function defineIteratorMethods(prototype) {
                        ["next", "throw", "return"].forEach(function(method) {
                            define(prototype, method, function(arg) {
                                return this._invoke(method, arg);
                            });
                        });
                    }

                    exports.isGeneratorFunction = function(genFun) {
                        var ctor = typeof genFun === "function" && genFun.constructor;
                        return ctor ? ctor === GeneratorFunction || (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
                    };

                    exports.mark = function(genFun) {
                        if (Object.setPrototypeOf) {
                            Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
                        } else {
                            genFun.__proto__ = GeneratorFunctionPrototype;
                            define(genFun, toStringTagSymbol, "GeneratorFunction");
                        }

                        genFun.prototype = Object.create(Gp);
                        return genFun;
                    };

                    exports.awrap = function(arg) {
                        return {
                            __await : arg
                        };
                    };

                    function AsyncIterator(generator, PromiseImpl) {
                        function invoke(method, arg, resolve, reject) {
                            var record = tryCatch(generator[method], generator, arg);

                            if (record.type === "throw") {
                                reject(record.arg);
                            } else {
                                var result = record.arg;
                                var value = result.value;

                                if (value && _typeof(value) === "object" && hasOwn.call(value, "__await")) {
                                    return PromiseImpl.resolve(value.__await).then(function(value) {
                                        invoke("next", value, resolve, reject);
                                    }, function(err) {
                                        invoke("throw", err, resolve, reject);
                                    });
                                }

                                return PromiseImpl.resolve(value).then(function(unwrapped) {
                                    result.value = unwrapped;
                                    resolve(result);
                                }, function(error) {
                                    return invoke("throw", error, resolve, reject);
                                });
                            }
                        }

                        var previousPromise;

                        function enqueue(method, arg) {
                            function callInvokeWithMethodAndArg() {
                                return new PromiseImpl(function(resolve, reject) {
                                    invoke(method, arg, resolve, reject);
                                });
                            }

                            return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
                        }

                        this._invoke = enqueue;
                    }

                    defineIteratorMethods(AsyncIterator.prototype);

                    AsyncIterator.prototype[asyncIteratorSymbol] = function() {
                        return this;
                    };

                    exports.AsyncIterator = AsyncIterator;

                    exports.async = function(innerFn, outerFn, self, tryLocsList, PromiseImpl) {
                        if (PromiseImpl === void 0) PromiseImpl = Promise;
                        var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
                        return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function(result) {
                            return result.done ? result.value : iter.next();
                        });
                    };

                    function makeInvokeMethod(innerFn, self, context) {
                        var state = GenStateSuspendedStart;
                        return function invoke(method, arg) {
                            if (state === GenStateExecuting) {
                                throw new Error("Generator is already running");
                            }

                            if (state === GenStateCompleted) {
                                if (method === "throw") {
                                    throw arg;
                                }

                                return doneResult();
                            }

                            context.method = method;
                            context.arg = arg;

                            while (true) {
                                var delegate = context.delegate;

                                if (delegate) {
                                    var delegateResult = maybeInvokeDelegate(delegate, context);

                                    if (delegateResult) {
                                        if (delegateResult === ContinueSentinel) continue;
                                        return delegateResult;
                                    }
                                }

                                if (context.method === "next") {
                                    context.sent = context._sent = context.arg;
                                } else if (context.method === "throw") {
                                    if (state === GenStateSuspendedStart) {
                                        state = GenStateCompleted;
                                        throw context.arg;
                                    }

                                    context.dispatchException(context.arg);
                                } else if (context.method === "return") {
                                    context.abrupt("return", context.arg);
                                }

                                state = GenStateExecuting;
                                var record = tryCatch(innerFn, self, context);

                                if (record.type === "normal") {
                                    state = context.done ? GenStateCompleted : GenStateSuspendedYield;

                                    if (record.arg === ContinueSentinel) {
                                        continue;
                                    }

                                    return {
                                        value : record.arg,
                                        done  : context.done
                                    };
                                } else if (record.type === "throw") {
                                    state = GenStateCompleted;
                                    context.method = "throw";
                                    context.arg = record.arg;
                                }
                            }
                        };
                    }

                    function maybeInvokeDelegate(delegate, context) {
                        var method = delegate.iterator[context.method];

                        if (method === undefined) {
                            context.delegate = null;

                            if (context.method === "throw") {
                                if (delegate.iterator["return"]) {
                                    context.method = "return";
                                    context.arg = undefined;
                                    maybeInvokeDelegate(delegate, context);

                                    if (context.method === "throw") {
                                        return ContinueSentinel;
                                    }
                                }

                                context.method = "throw";
                                context.arg = new TypeError("The iterator does not provide a 'throw' method");
                            }

                            return ContinueSentinel;
                        }

                        var record = tryCatch(method, delegate.iterator, context.arg);

                        if (record.type === "throw") {
                            context.method = "throw";
                            context.arg = record.arg;
                            context.delegate = null;
                            return ContinueSentinel;
                        }

                        var info = record.arg;

                        if (!info) {
                            context.method = "throw";
                            context.arg = new TypeError("iterator result is not an object");
                            context.delegate = null;
                            return ContinueSentinel;
                        }

                        if (info.done) {
                            context[delegate.resultName] = info.value;
                            context.next = delegate.nextLoc;

                            if (context.method !== "return") {
                                context.method = "next";
                                context.arg = undefined;
                            }
                        } else {
                            return info;
                        }

                        context.delegate = null;
                        return ContinueSentinel;
                    }

                    defineIteratorMethods(Gp);
                    define(Gp, toStringTagSymbol, "Generator");

                    Gp[iteratorSymbol] = function() {
                        return this;
                    };

                    Gp.toString = function() {
                        return "[object Generator]";
                    };

                    function pushTryEntry(locs) {
                        var entry = {
                            tryLoc : locs[0]
                        };

                        if (1 in locs) {
                            entry.catchLoc = locs[1];
                        }

                        if (2 in locs) {
                            entry.finallyLoc = locs[2];
                            entry.afterLoc = locs[3];
                        }

                        this.tryEntries.push(entry);
                    }

                    function resetTryEntry(entry) {
                        var record = entry.completion || {};
                        record.type = "normal";
                        delete record.arg;
                        entry.completion = record;
                    }

                    function Context(tryLocsList) {
                        this.tryEntries = [{
                            tryLoc : "root"
                        }];
                        tryLocsList.forEach(pushTryEntry, this);
                        this.reset(true);
                    }

                    exports.keys = function(object) {
                        var keys = [];

                        for (var key in object) {
                            keys.push(key);
                        }

                        keys.reverse();
                        return function next() {
                            while (keys.length) {
                                var key = keys.pop();

                                if (key in object) {
                                    next.value = key;
                                    next.done = false;
                                    return next;
                                }
                            }

                            next.done = true;
                            return next;
                        };
                    };

                    function values(iterable) {
                        if (iterable) {
                            var iteratorMethod = iterable[iteratorSymbol];

                            if (iteratorMethod) {
                                return iteratorMethod.call(iterable);
                            }

                            if (typeof iterable.next === "function") {
                                return iterable;
                            }

                            if (!isNaN(iterable.length)) {
                                var i    = -1,
                                    next = function next() {
                                        while (++i < iterable.length) {
                                            if (hasOwn.call(iterable, i)) {
                                                next.value = iterable[i];
                                                next.done = false;
                                                return next;
                                            }
                                        }

                                        next.value = undefined;
                                        next.done = true;
                                        return next;
                                    };

                                return next.next = next;
                            }
                        }

                        return {
                            next : doneResult
                        };
                    }

                    exports.values = values;

                    function doneResult() {
                        return {
                            value : undefined,
                            done  : true
                        };
                    }

                    Context.prototype = {
                        constructor       : Context,
                        reset             : function reset(skipTempReset) {
                            this.prev = 0;
                            this.next = 0;
                            this.sent = this._sent = undefined;
                            this.done = false;
                            this.delegate = null;
                            this.method = "next";
                            this.arg = undefined;
                            this.tryEntries.forEach(resetTryEntry);

                            if (!skipTempReset) {
                                for (var name in this) {
                                    if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
                                        this[name] = undefined;
                                    }
                                }
                            }
                        },
                        stop              : function stop() {
                            this.done = true;
                            var rootEntry = this.tryEntries[0];
                            var rootRecord = rootEntry.completion;

                            if (rootRecord.type === "throw") {
                                throw rootRecord.arg;
                            }

                            return this.rval;
                        },
                        dispatchException : function dispatchException(exception) {
                            if (this.done) {
                                throw exception;
                            }

                            var context = this;

                            function handle(loc, caught) {
                                record.type = "throw";
                                record.arg = exception;
                                context.next = loc;

                                if (caught) {
                                    context.method = "next";
                                    context.arg = undefined;
                                }

                                return !!caught;
                            }

                            for (var i = this.tryEntries.length - 1; i >= 0; --i) {
                                var entry = this.tryEntries[i];
                                var record = entry.completion;

                                if (entry.tryLoc === "root") {
                                    return handle("end");
                                }

                                if (entry.tryLoc <= this.prev) {
                                    var hasCatch = hasOwn.call(entry, "catchLoc");
                                    var hasFinally = hasOwn.call(entry, "finallyLoc");

                                    if (hasCatch && hasFinally) {
                                        if (this.prev < entry.catchLoc) {
                                            return handle(entry.catchLoc, true);
                                        } else if (this.prev < entry.finallyLoc) {
                                            return handle(entry.finallyLoc);
                                        }
                                    } else if (hasCatch) {
                                        if (this.prev < entry.catchLoc) {
                                            return handle(entry.catchLoc, true);
                                        }
                                    } else if (hasFinally) {
                                        if (this.prev < entry.finallyLoc) {
                                            return handle(entry.finallyLoc);
                                        }
                                    } else {
                                        throw new Error("try statement without catch or finally");
                                    }
                                }
                            }
                        },
                        abrupt            : function abrupt(type, arg) {
                            for (var i = this.tryEntries.length - 1; i >= 0; --i) {
                                var entry = this.tryEntries[i];

                                if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
                                    var finallyEntry = entry;
                                    break;
                                }
                            }

                            if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
                                finallyEntry = null;
                            }

                            var record = finallyEntry ? finallyEntry.completion : {};
                            record.type = type;
                            record.arg = arg;

                            if (finallyEntry) {
                                this.method = "next";
                                this.next = finallyEntry.finallyLoc;
                                return ContinueSentinel;
                            }

                            return this.complete(record);
                        },
                        complete          : function complete(record, afterLoc) {
                            if (record.type === "throw") {
                                throw record.arg;
                            }

                            if (record.type === "break" || record.type === "continue") {
                                this.next = record.arg;
                            } else if (record.type === "return") {
                                this.rval = this.arg = record.arg;
                                this.method = "return";
                                this.next = "end";
                            } else if (record.type === "normal" && afterLoc) {
                                this.next = afterLoc;
                            }

                            return ContinueSentinel;
                        },
                        finish            : function finish(finallyLoc) {
                            for (var i = this.tryEntries.length - 1; i >= 0; --i) {
                                var entry = this.tryEntries[i];

                                if (entry.finallyLoc === finallyLoc) {
                                    this.complete(entry.completion, entry.afterLoc);
                                    resetTryEntry(entry);
                                    return ContinueSentinel;
                                }
                            }
                        },
                        "catch"           : function _catch(tryLoc) {
                            for (var i = this.tryEntries.length - 1; i >= 0; --i) {
                                var entry = this.tryEntries[i];

                                if (entry.tryLoc === tryLoc) {
                                    var record = entry.completion;

                                    if (record.type === "throw") {
                                        var thrown = record.arg;
                                        resetTryEntry(entry);
                                    }

                                    return thrown;
                                }
                            }

                            throw new Error("illegal catch attempt");
                        },
                        delegateYield     : function delegateYield(iterable, resultName, nextLoc) {
                            this.delegate = {
                                iterator   : values(iterable),
                                resultName : resultName,
                                nextLoc    : nextLoc
                            };

                            if (this.method === "next") {
                                this.arg = undefined;
                            }

                            return ContinueSentinel;
                        }
                    };
                    return exports;
                }((false ? 0 : _typeof(module)) === "object" ? module.exports : {});

                try {
                    regeneratorRuntime = runtime;
                } catch (accidentalStrictMode) {
                    Function("r", "regeneratorRuntime = r")(runtime);
                }

                /***/
            }),
            /* 4 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.arrayByteLength = arrayByteLength;
                exports.arraysToBytes = arraysToBytes;
                exports.assert = assert;
                exports.bytesToString = bytesToString;
                exports.createObjectURL = createObjectURL;
                exports.createPromiseCapability = createPromiseCapability;
                exports.createValidAbsoluteUrl = createValidAbsoluteUrl;
                exports.escapeString = escapeString;
                exports.getModificationDate = getModificationDate;
                exports.getVerbosityLevel = getVerbosityLevel;
                exports.info = info;
                exports.isArrayBuffer = isArrayBuffer;
                exports.isArrayEqual = isArrayEqual;
                exports.isAscii = isAscii;
                exports.isBool = isBool;
                exports.isNum = isNum;
                exports.isSameOrigin = isSameOrigin;
                exports.isString = isString;
                exports.objectFromMap = objectFromMap;
                exports.objectSize = objectSize;
                exports.removeNullCharacters = removeNullCharacters;
                exports.setVerbosityLevel = setVerbosityLevel;
                exports.shadow = shadow;
                exports.string32 = string32;
                exports.stringToBytes = stringToBytes;
                exports.stringToPDFString = stringToPDFString;
                exports.stringToUTF16BEString = stringToUTF16BEString;
                exports.stringToUTF8String = stringToUTF8String;
                exports.unreachable = unreachable;
                exports.utf8StringToString = utf8StringToString;
                exports.warn = warn;
                exports.VerbosityLevel = exports.Util = exports.UNSUPPORTED_FEATURES = exports.UnknownErrorException = exports.UnexpectedResponseException = exports.TextRenderingMode = exports.StreamType = exports.PermissionFlag = exports.PasswordResponses = exports.PasswordException = exports.PageActionEventType = exports.OPS = exports.MissingPDFException = exports.IsLittleEndianCached = exports.IsEvalSupportedCached = exports.InvalidPDFException = exports.ImageKind = exports.IDENTITY_MATRIX = exports.FormatError = exports.FontType = exports.FONT_IDENTITY_MATRIX = exports.DocumentActionEventType = exports.CMapCompressionType = exports.BaseException = exports.AnnotationType = exports.AnnotationStateModelType = exports.AnnotationReviewState = exports.AnnotationReplyType = exports.AnnotationMarkedState = exports.AnnotationFlag = exports.AnnotationFieldFlag = exports.AnnotationBorderStyleType = exports.AnnotationActionEventType = exports.AbortException = void 0;

                __w_pdfjs_require__(5);

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                function _toConsumableArray(arr) {
                    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
                }

                function _nonIterableSpread() {
                    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                }

                function _iterableToArray(iter) {
                    if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
                }

                function _arrayWithoutHoles(arr) {
                    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
                }

                function _slicedToArray(arr, i) {
                    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
                }

                function _nonIterableRest() {
                    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                }

                function _iterableToArrayLimit(arr, i) {
                    if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
                    var _arr = [];
                    var _n = true;
                    var _d = false;
                    var _e = undefined;
                    try {
                        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                            _arr.push(_s.value);
                            if (i && _arr.length === i) break;
                        }
                    } catch (err) {
                        _d = true;
                        _e = err;
                    } finally {
                        try {
                            if (!_n && _i["return"] != null) _i["return"]();
                        } finally {
                            if (_d) throw _e;
                        }
                    }
                    return _arr;
                }

                function _arrayWithHoles(arr) {
                    if (Array.isArray(arr)) return arr;
                }

                function _createForOfIteratorHelper(o, allowArrayLike) {
                    var it;
                    if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
                        if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
                            if (it) o = it;
                            var i = 0;
                            var F = function F() {
                            };
                            return {
                                s    : F, n : function n() {
                                    if (i >= o.length) return {done : true};
                                    return {done : false, value : o[i++]};
                                }, e : function e(_e2) {
                                    throw _e2;
                                }, f : F
                            };
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                    }
                    var normalCompletion = true, didErr = false, err;
                    return {
                        s    : function s() {
                            it = o[Symbol.iterator]();
                        }, n : function n() {
                            var step = it.next();
                            normalCompletion = step.done;
                            return step;
                        }, e : function e(_e3) {
                            didErr = true;
                            err = _e3;
                        }, f : function f() {
                            try {
                                if (!normalCompletion && it["return"] != null) it["return"]();
                            } finally {
                                if (didErr) throw err;
                            }
                        }
                    };
                }

                function _unsupportedIterableToArray(o, minLen) {
                    if (!o) return;
                    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
                    var n = Object.prototype.toString.call(o).slice(8, -1);
                    if (n === "Object" && o.constructor) n = o.constructor.name;
                    if (n === "Map" || n === "Set") return Array.from(o);
                    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
                }

                function _arrayLikeToArray(arr, len) {
                    if (len == null || len > arr.length) len = arr.length;
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i];
                    }
                    return arr2;
                }

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _inherits(subClass, superClass) {
                    if (typeof superClass !== "function" && superClass !== null) {
                        throw new TypeError("Super expression must either be null or a function");
                    }
                    subClass.prototype = Object.create(superClass && superClass.prototype, {
                        constructor : {
                            value        : subClass,
                            writable     : true,
                            configurable : true
                        }
                    });
                    if (superClass) _setPrototypeOf(subClass, superClass);
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
                        o.__proto__ = p;
                        return o;
                    };
                    return _setPrototypeOf(o, p);
                }

                function _createSuper(Derived) {
                    var hasNativeReflectConstruct = _isNativeReflectConstruct();
                    return function _createSuperInternal() {
                        var Super = _getPrototypeOf(Derived), result;
                        if (hasNativeReflectConstruct) {
                            var NewTarget = _getPrototypeOf(this).constructor;
                            result = Reflect.construct(Super, arguments, NewTarget);
                        } else {
                            result = Super.apply(this, arguments);
                        }
                        return _possibleConstructorReturn(this, result);
                    };
                }

                function _possibleConstructorReturn(self, call) {
                    if (call && (_typeof(call) === "object" || typeof call === "function")) {
                        return call;
                    }
                    return _assertThisInitialized(self);
                }

                function _assertThisInitialized(self) {
                    if (self === void 0) {
                        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                    }
                    return self;
                }

                function _isNativeReflectConstruct() {
                    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
                    if (Reflect.construct.sham) return false;
                    if (typeof Proxy === "function") return true;
                    try {
                        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
                        }));
                        return true;
                    } catch (e) {
                        return false;
                    }
                }

                function _getPrototypeOf(o) {
                    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
                        return o.__proto__ || Object.getPrototypeOf(o);
                    };
                    return _getPrototypeOf(o);
                }

                var IDENTITY_MATRIX = [1, 0, 0, 1, 0, 0];
                exports.IDENTITY_MATRIX = IDENTITY_MATRIX;
                var FONT_IDENTITY_MATRIX = [0.001, 0, 0, 0.001, 0, 0];
                exports.FONT_IDENTITY_MATRIX = FONT_IDENTITY_MATRIX;
                var PermissionFlag = {
                    PRINT                  : 0x04,
                    MODIFY_CONTENTS        : 0x08,
                    COPY                   : 0x10,
                    MODIFY_ANNOTATIONS     : 0x20,
                    FILL_INTERACTIVE_FORMS : 0x100,
                    COPY_FOR_ACCESSIBILITY : 0x200,
                    ASSEMBLE               : 0x400,
                    PRINT_HIGH_QUALITY     : 0x800
                };
                exports.PermissionFlag = PermissionFlag;
                var TextRenderingMode = {
                    FILL                    : 0,
                    STROKE                  : 1,
                    FILL_STROKE             : 2,
                    INVISIBLE               : 3,
                    FILL_ADD_TO_PATH        : 4,
                    STROKE_ADD_TO_PATH      : 5,
                    FILL_STROKE_ADD_TO_PATH : 6,
                    ADD_TO_PATH             : 7,
                    FILL_STROKE_MASK        : 3,
                    ADD_TO_PATH_FLAG        : 4
                };
                exports.TextRenderingMode = TextRenderingMode;
                var ImageKind = {
                    GRAYSCALE_1BPP : 1,
                    RGB_24BPP      : 2,
                    RGBA_32BPP     : 3
                };
                exports.ImageKind = ImageKind;
                var AnnotationType = {
                    TEXT           : 1,
                    LINK           : 2,
                    FREETEXT       : 3,
                    LINE           : 4,
                    SQUARE         : 5,
                    CIRCLE         : 6,
                    POLYGON        : 7,
                    POLYLINE       : 8,
                    HIGHLIGHT      : 9,
                    UNDERLINE      : 10,
                    SQUIGGLY       : 11,
                    STRIKEOUT      : 12,
                    STAMP          : 13,
                    CARET          : 14,
                    INK            : 15,
                    POPUP          : 16,
                    FILEATTACHMENT : 17,
                    SOUND          : 18,
                    MOVIE          : 19,
                    WIDGET         : 20,
                    SCREEN         : 21,
                    PRINTERMARK    : 22,
                    TRAPNET        : 23,
                    WATERMARK      : 24,
                    THREED         : 25,
                    REDACT         : 26
                };
                exports.AnnotationType = AnnotationType;
                var AnnotationStateModelType = {
                    MARKED : "Marked",
                    REVIEW : "Review"
                };
                exports.AnnotationStateModelType = AnnotationStateModelType;
                var AnnotationMarkedState = {
                    MARKED   : "Marked",
                    UNMARKED : "Unmarked"
                };
                exports.AnnotationMarkedState = AnnotationMarkedState;
                var AnnotationReviewState = {
                    ACCEPTED  : "Accepted",
                    REJECTED  : "Rejected",
                    CANCELLED : "Cancelled",
                    COMPLETED : "Completed",
                    NONE      : "None"
                };
                exports.AnnotationReviewState = AnnotationReviewState;
                var AnnotationReplyType = {
                    GROUP : "Group",
                    REPLY : "R"
                };
                exports.AnnotationReplyType = AnnotationReplyType;
                var AnnotationFlag = {
                    INVISIBLE      : 0x01,
                    HIDDEN         : 0x02,
                    PRINT          : 0x04,
                    NOZOOM         : 0x08,
                    NOROTATE       : 0x10,
                    NOVIEW         : 0x20,
                    READONLY       : 0x40,
                    LOCKED         : 0x80,
                    TOGGLENOVIEW   : 0x100,
                    LOCKEDCONTENTS : 0x200
                };
                exports.AnnotationFlag = AnnotationFlag;
                var AnnotationFieldFlag = {
                    READONLY          : 0x0000001,
                    REQUIRED          : 0x0000002,
                    NOEXPORT          : 0x0000004,
                    MULTILINE         : 0x0001000,
                    PASSWORD          : 0x0002000,
                    NOTOGGLETOOFF     : 0x0004000,
                    RADIO             : 0x0008000,
                    PUSHBUTTON        : 0x0010000,
                    COMBO             : 0x0020000,
                    EDIT              : 0x0040000,
                    SORT              : 0x0080000,
                    FILESELECT        : 0x0100000,
                    MULTISELECT       : 0x0200000,
                    DONOTSPELLCHECK   : 0x0400000,
                    DONOTSCROLL       : 0x0800000,
                    COMB              : 0x1000000,
                    RICHTEXT          : 0x2000000,
                    RADIOSINUNISON    : 0x2000000,
                    COMMITONSELCHANGE : 0x4000000
                };
                exports.AnnotationFieldFlag = AnnotationFieldFlag;
                var AnnotationBorderStyleType = {
                    SOLID     : 1,
                    DASHED    : 2,
                    BEVELED   : 3,
                    INSET     : 4,
                    UNDERLINE : 5
                };
                exports.AnnotationBorderStyleType = AnnotationBorderStyleType;
                var AnnotationActionEventType = {
                    E  : "Mouse Enter",
                    X  : "Mouse Exit",
                    D  : "Mouse Down",
                    U  : "Mouse Up",
                    Fo : "Focus",
                    Bl : "Blur",
                    PO : "PageOpen",
                    PC : "PageClose",
                    PV : "PageVisible",
                    PI : "PageInvisible",
                    K  : "Keystroke",
                    F  : "Format",
                    V  : "Validate",
                    C  : "Calculate"
                };
                exports.AnnotationActionEventType = AnnotationActionEventType;
                var DocumentActionEventType = {
                    WC : "WillClose",
                    WS : "WillSave",
                    DS : "DidSave",
                    WP : "WillPrint",
                    DP : "DidPrint"
                };
                exports.DocumentActionEventType = DocumentActionEventType;
                var PageActionEventType = {
                    O : "PageOpen",
                    C : "PageClose"
                };
                exports.PageActionEventType = PageActionEventType;
                var StreamType = {
                    UNKNOWN : "UNKNOWN",
                    FLATE   : "FLATE",
                    LZW     : "LZW",
                    DCT     : "DCT",
                    JPX     : "JPX",
                    JBIG    : "JBIG",
                    A85     : "A85",
                    AHX     : "AHX",
                    CCF     : "CCF",
                    RLX     : "RLX"
                };
                exports.StreamType = StreamType;
                var FontType = {
                    UNKNOWN       : "UNKNOWN",
                    TYPE1         : "TYPE1",
                    TYPE1C        : "TYPE1C",
                    CIDFONTTYPE0  : "CIDFONTTYPE0",
                    CIDFONTTYPE0C : "CIDFONTTYPE0C",
                    TRUETYPE      : "TRUETYPE",
                    CIDFONTTYPE2  : "CIDFONTTYPE2",
                    TYPE3         : "TYPE3",
                    OPENTYPE      : "OPENTYPE",
                    TYPE0         : "TYPE0",
                    MMTYPE1       : "MMTYPE1"
                };
                exports.FontType = FontType;
                var VerbosityLevel = {
                    ERRORS   : 0,
                    WARNINGS : 1,
                    INFOS    : 5
                };
                exports.VerbosityLevel = VerbosityLevel;
                var CMapCompressionType = {
                    NONE   : 0,
                    BINARY : 1,
                    STREAM : 2
                };
                exports.CMapCompressionType = CMapCompressionType;
                var OPS = {
                    dependency                   : 1,
                    setLineWidth                 : 2,
                    setLineCap                   : 3,
                    setLineJoin                  : 4,
                    setMiterLimit                : 5,
                    setDash                      : 6,
                    setRenderingIntent           : 7,
                    setFlatness                  : 8,
                    setGState                    : 9,
                    save                         : 10,
                    restore                      : 11,
                    transform                    : 12,
                    moveTo                       : 13,
                    lineTo                       : 14,
                    curveTo                      : 15,
                    curveTo2                     : 16,
                    curveTo3                     : 17,
                    closePath                    : 18,
                    rectangle                    : 19,
                    stroke                       : 20,
                    closeStroke                  : 21,
                    fill                         : 22,
                    eoFill                       : 23,
                    fillStroke                   : 24,
                    eoFillStroke                 : 25,
                    closeFillStroke              : 26,
                    closeEOFillStroke            : 27,
                    endPath                      : 28,
                    clip                         : 29,
                    eoClip                       : 30,
                    beginText                    : 31,
                    endText                      : 32,
                    setCharSpacing               : 33,
                    setWordSpacing               : 34,
                    setHScale                    : 35,
                    setLeading                   : 36,
                    setFont                      : 37,
                    setTextRenderingMode         : 38,
                    setTextRise                  : 39,
                    moveText                     : 40,
                    setLeadingMoveText           : 41,
                    setTextMatrix                : 42,
                    nextLine                     : 43,
                    showText                     : 44,
                    showSpacedText               : 45,
                    nextLineShowText             : 46,
                    nextLineSetSpacingShowText   : 47,
                    setCharWidth                 : 48,
                    setCharWidthAndBounds        : 49,
                    setStrokeColorSpace          : 50,
                    setFillColorSpace            : 51,
                    setStrokeColor               : 52,
                    setStrokeColorN              : 53,
                    setFillColor                 : 54,
                    setFillColorN                : 55,
                    setStrokeGray                : 56,
                    setFillGray                  : 57,
                    setStrokeRGBColor            : 58,
                    setFillRGBColor              : 59,
                    setStrokeCMYKColor           : 60,
                    setFillCMYKColor             : 61,
                    shadingFill                  : 62,
                    beginInlineImage             : 63,
                    beginImageData               : 64,
                    endInlineImage               : 65,
                    paintXObject                 : 66,
                    markPoint                    : 67,
                    markPointProps               : 68,
                    beginMarkedContent           : 69,
                    beginMarkedContentProps      : 70,
                    endMarkedContent             : 71,
                    beginCompat                  : 72,
                    endCompat                    : 73,
                    paintFormXObjectBegin        : 74,
                    paintFormXObjectEnd          : 75,
                    beginGroup                   : 76,
                    endGroup                     : 77,
                    beginAnnotations             : 78,
                    endAnnotations               : 79,
                    beginAnnotation              : 80,
                    endAnnotation                : 81,
                    paintJpegXObject             : 82,
                    paintImageMaskXObject        : 83,
                    paintImageMaskXObjectGroup   : 84,
                    paintImageXObject            : 85,
                    paintInlineImageXObject      : 86,
                    paintInlineImageXObjectGroup : 87,
                    paintImageXObjectRepeat      : 88,
                    paintImageMaskXObjectRepeat  : 89,
                    paintSolidColorImageMask     : 90,
                    constructPath                : 91
                };
                exports.OPS = OPS;
                var UNSUPPORTED_FEATURES = {
                    unknown             : "unknown",
                    forms               : "forms",
                    javaScript          : "javaScript",
                    smask               : "smask",
                    shadingPattern      : "shadingPattern",
                    font                : "font",
                    errorTilingPattern  : "errorTilingPattern",
                    errorExtGState      : "errorExtGState",
                    errorXObject        : "errorXObject",
                    errorFontLoadType3  : "errorFontLoadType3",
                    errorFontState      : "errorFontState",
                    errorFontMissing    : "errorFontMissing",
                    errorFontTranslate  : "errorFontTranslate",
                    errorColorSpace     : "errorColorSpace",
                    errorOperatorList   : "errorOperatorList",
                    errorFontToUnicode  : "errorFontToUnicode",
                    errorFontLoadNative : "errorFontLoadNative",
                    errorFontGetPath    : "errorFontGetPath",
                    errorMarkedContent  : "errorMarkedContent"
                };
                exports.UNSUPPORTED_FEATURES = UNSUPPORTED_FEATURES;
                var PasswordResponses = {
                    NEED_PASSWORD      : 1,
                    INCORRECT_PASSWORD : 2
                };
                exports.PasswordResponses = PasswordResponses;
                var verbosity = VerbosityLevel.WARNINGS;

                function setVerbosityLevel(level) {
                    if (Number.isInteger(level)) {
                        verbosity = level;
                    }
                }

                function getVerbosityLevel() {
                    return verbosity;
                }

                function info(msg) {
                    if (verbosity >= VerbosityLevel.INFOS) {
                        console.log("Info: ".concat(msg));
                    }
                }

                function warn(msg) {
                    if (verbosity >= VerbosityLevel.WARNINGS) {
                        console.log("Warning: ".concat(msg));
                    }
                }

                function unreachable(msg) {
                    throw new Error(msg);
                }

                function assert(cond, msg) {
                    if (!cond) {
                        unreachable(msg);
                    }
                }

                function isSameOrigin(baseUrl, otherUrl) {
                    var base;

                    try {
                        base = new URL(baseUrl);

                        if (!base.origin || base.origin === "null") {
                            return false;
                        }
                    } catch (e) {
                        return false;
                    }

                    var other = new URL(otherUrl, base);
                    return base.origin === other.origin;
                }

                function _isValidProtocol(url) {
                    if (!url) {
                        return false;
                    }

                    switch (url.protocol) {
                        case "http:":
                        case "https:":
                        case "ftp:":
                        case "mailto:":
                        case "tel:":
                            return true;

                        default:
                            return false;
                    }
                }

                function createValidAbsoluteUrl(url, baseUrl) {
                    if (!url) {
                        return null;
                    }

                    try {
                        var absoluteUrl = baseUrl ? new URL(url, baseUrl) : new URL(url);

                        if (_isValidProtocol(absoluteUrl)) {
                            return absoluteUrl;
                        }
                    } catch (ex) {
                    }

                    return null;
                }

                function shadow(obj, prop, value) {
                    Object.defineProperty(obj, prop, {
                        value        : value,
                        enumerable   : true,
                        configurable : true,
                        writable     : false
                    });
                    return value;
                }

                var BaseException = function BaseExceptionClosure() {
                    function BaseException(message) {
                        if (this.constructor === BaseException) {
                            unreachable("Cannot initialize BaseException.");
                        }

                        this.message = message;
                        this.name = this.constructor.name;
                    }

                    BaseException.prototype = new Error();
                    BaseException.constructor = BaseException;
                    return BaseException;
                }();

                exports.BaseException = BaseException;

                var PasswordException = /*#__PURE__*/function(_BaseException) {
                    _inherits(PasswordException, _BaseException);

                    var _super = _createSuper(PasswordException);

                    function PasswordException(msg, code) {
                        var _this;

                        _classCallCheck(this, PasswordException);

                        _this = _super.call(this, msg);
                        _this.code = code;
                        return _this;
                    }

                    return PasswordException;
                }(BaseException);

                exports.PasswordException = PasswordException;

                var UnknownErrorException = /*#__PURE__*/function(_BaseException2) {
                    _inherits(UnknownErrorException, _BaseException2);

                    var _super2 = _createSuper(UnknownErrorException);

                    function UnknownErrorException(msg, details) {
                        var _this2;

                        _classCallCheck(this, UnknownErrorException);

                        _this2 = _super2.call(this, msg);
                        _this2.details = details;
                        return _this2;
                    }

                    return UnknownErrorException;
                }(BaseException);

                exports.UnknownErrorException = UnknownErrorException;

                var InvalidPDFException = /*#__PURE__*/function(_BaseException3) {
                    _inherits(InvalidPDFException, _BaseException3);

                    var _super3 = _createSuper(InvalidPDFException);

                    function InvalidPDFException() {
                        _classCallCheck(this, InvalidPDFException);

                        return _super3.apply(this, arguments);
                    }

                    return InvalidPDFException;
                }(BaseException);

                exports.InvalidPDFException = InvalidPDFException;

                var MissingPDFException = /*#__PURE__*/function(_BaseException4) {
                    _inherits(MissingPDFException, _BaseException4);

                    var _super4 = _createSuper(MissingPDFException);

                    function MissingPDFException() {
                        _classCallCheck(this, MissingPDFException);

                        return _super4.apply(this, arguments);
                    }

                    return MissingPDFException;
                }(BaseException);

                exports.MissingPDFException = MissingPDFException;

                var UnexpectedResponseException = /*#__PURE__*/function(_BaseException5) {
                    _inherits(UnexpectedResponseException, _BaseException5);

                    var _super5 = _createSuper(UnexpectedResponseException);

                    function UnexpectedResponseException(msg, status) {
                        var _this3;

                        _classCallCheck(this, UnexpectedResponseException);

                        _this3 = _super5.call(this, msg);
                        _this3.status = status;
                        return _this3;
                    }

                    return UnexpectedResponseException;
                }(BaseException);

                exports.UnexpectedResponseException = UnexpectedResponseException;

                var FormatError = /*#__PURE__*/function(_BaseException6) {
                    _inherits(FormatError, _BaseException6);

                    var _super6 = _createSuper(FormatError);

                    function FormatError() {
                        _classCallCheck(this, FormatError);

                        return _super6.apply(this, arguments);
                    }

                    return FormatError;
                }(BaseException);

                exports.FormatError = FormatError;

                var AbortException = /*#__PURE__*/function(_BaseException7) {
                    _inherits(AbortException, _BaseException7);

                    var _super7 = _createSuper(AbortException);

                    function AbortException() {
                        _classCallCheck(this, AbortException);

                        return _super7.apply(this, arguments);
                    }

                    return AbortException;
                }(BaseException);

                exports.AbortException = AbortException;
                var NullCharactersRegExp = /\x00/g;

                function removeNullCharacters(str) {
                    if (typeof str !== "string") {
                        warn("The argument for removeNullCharacters must be a string.");
                        return str;
                    }

                    return str.replace(NullCharactersRegExp, "");
                }

                function bytesToString(bytes) {
                    assert(bytes !== null && _typeof(bytes) === "object" && bytes.length !== undefined, "Invalid argument for bytesToString");
                    var length = bytes.length;
                    var MAX_ARGUMENT_COUNT = 8192;

                    if (length < MAX_ARGUMENT_COUNT) {
                        return String.fromCharCode.apply(null, bytes);
                    }

                    var strBuf = [];

                    for (var i = 0; i < length; i += MAX_ARGUMENT_COUNT) {
                        var chunkEnd = Math.min(i + MAX_ARGUMENT_COUNT, length);
                        var chunk = bytes.subarray(i, chunkEnd);
                        strBuf.push(String.fromCharCode.apply(null, chunk));
                    }

                    return strBuf.join("");
                }

                function stringToBytes(str) {
                    assert(typeof str === "string", "Invalid argument for stringToBytes");
                    var length = str.length;
                    var bytes = new Uint8Array(length);

                    for (var i = 0; i < length; ++i) {
                        bytes[i] = str.charCodeAt(i) & 0xff;
                    }

                    return bytes;
                }

                function arrayByteLength(arr) {
                    if (arr.length !== undefined) {
                        return arr.length;
                    }

                    assert(arr.byteLength !== undefined, "arrayByteLength - invalid argument.");
                    return arr.byteLength;
                }

                function arraysToBytes(arr) {
                    var length = arr.length;

                    if (length === 1 && arr[0] instanceof Uint8Array) {
                        return arr[0];
                    }

                    var resultLength = 0;

                    for (var i = 0; i < length; i++) {
                        resultLength += arrayByteLength(arr[i]);
                    }

                    var pos = 0;
                    var data = new Uint8Array(resultLength);

                    for (var _i = 0; _i < length; _i++) {
                        var item = arr[_i];

                        if (!(item instanceof Uint8Array)) {
                            if (typeof item === "string") {
                                item = stringToBytes(item);
                            } else {
                                item = new Uint8Array(item);
                            }
                        }

                        var itemLength = item.byteLength;
                        data.set(item, pos);
                        pos += itemLength;
                    }

                    return data;
                }

                function string32(value) {
                    return String.fromCharCode(value >> 24 & 0xff, value >> 16 & 0xff, value >> 8 & 0xff, value & 0xff);
                }

                function objectSize(obj) {
                    return Object.keys(obj).length;
                }

                function objectFromMap(map) {
                    var obj = Object.create(null);

                    var _iterator = _createForOfIteratorHelper(map),
                        _step;

                    try {
                        for (_iterator.s(); !(_step = _iterator.n()).done;) {
                            var _step$value = _slicedToArray(_step.value, 2),
                                key         = _step$value[0],
                                value       = _step$value[1];

                            obj[key] = value;
                        }
                    } catch (err) {
                        _iterator.e(err);
                    } finally {
                        _iterator.f();
                    }

                    return obj;
                }

                function isLittleEndian() {
                    var buffer8 = new Uint8Array(4);
                    buffer8[0] = 1;
                    var view32 = new Uint32Array(buffer8.buffer, 0, 1);
                    return view32[0] === 1;
                }

                var IsLittleEndianCached = {
                    get value() {
                        return shadow(this, "value", isLittleEndian());
                    }

                };
                exports.IsLittleEndianCached = IsLittleEndianCached;

                function isEvalSupported() {
                    try {
                        new Function("");
                        return true;
                    } catch (e) {
                        return false;
                    }
                }

                var IsEvalSupportedCached = {
                    get value() {
                        return shadow(this, "value", isEvalSupported());
                    }

                };
                exports.IsEvalSupportedCached = IsEvalSupportedCached;

                var hexNumbers = _toConsumableArray(Array(256).keys()).map(function(n) {
                    return n.toString(16).padStart(2, "0");
                });

                var Util = /*#__PURE__*/function() {
                    function Util() {
                        _classCallCheck(this, Util);
                    }

                    _createClass(Util, null, [{
                        key   : "makeHexColor",
                        value : function makeHexColor(r, g, b) {
                            return "#".concat(hexNumbers[r]).concat(hexNumbers[g]).concat(hexNumbers[b]);
                        }
                    }, {
                        key   : "transform",
                        value : function transform(m1, m2) {
                            return [m1[0] * m2[0] + m1[2] * m2[1], m1[1] * m2[0] + m1[3] * m2[1], m1[0] * m2[2] + m1[2] * m2[3], m1[1] * m2[2] + m1[3] * m2[3], m1[0] * m2[4] + m1[2] * m2[5] + m1[4], m1[1] * m2[4] + m1[3] * m2[5] + m1[5]];
                        }
                    }, {
                        key   : "applyTransform",
                        value : function applyTransform(p, m) {
                            var xt = p[0] * m[0] + p[1] * m[2] + m[4];
                            var yt = p[0] * m[1] + p[1] * m[3] + m[5];
                            return [xt, yt];
                        }
                    }, {
                        key   : "applyInverseTransform",
                        value : function applyInverseTransform(p, m) {
                            var d = m[0] * m[3] - m[1] * m[2];
                            var xt = (p[0] * m[3] - p[1] * m[2] + m[2] * m[5] - m[4] * m[3]) / d;
                            var yt = (-p[0] * m[1] + p[1] * m[0] + m[4] * m[1] - m[5] * m[0]) / d;
                            return [xt, yt];
                        }
                    }, {
                        key   : "getAxialAlignedBoundingBox",
                        value : function getAxialAlignedBoundingBox(r, m) {
                            var p1 = Util.applyTransform(r, m);
                            var p2 = Util.applyTransform(r.slice(2, 4), m);
                            var p3 = Util.applyTransform([r[0], r[3]], m);
                            var p4 = Util.applyTransform([r[2], r[1]], m);
                            return [Math.min(p1[0], p2[0], p3[0], p4[0]), Math.min(p1[1], p2[1], p3[1], p4[1]), Math.max(p1[0], p2[0], p3[0], p4[0]), Math.max(p1[1], p2[1], p3[1], p4[1])];
                        }
                    }, {
                        key   : "inverseTransform",
                        value : function inverseTransform(m) {
                            var d = m[0] * m[3] - m[1] * m[2];
                            return [m[3] / d, -m[1] / d, -m[2] / d, m[0] / d, (m[2] * m[5] - m[4] * m[3]) / d, (m[4] * m[1] - m[5] * m[0]) / d];
                        }
                    }, {
                        key   : "apply3dTransform",
                        value : function apply3dTransform(m, v) {
                            return [m[0] * v[0] + m[1] * v[1] + m[2] * v[2], m[3] * v[0] + m[4] * v[1] + m[5] * v[2], m[6] * v[0] + m[7] * v[1] + m[8] * v[2]];
                        }
                    }, {
                        key   : "singularValueDecompose2dScale",
                        value : function singularValueDecompose2dScale(m) {
                            var transpose = [m[0], m[2], m[1], m[3]];
                            var a = m[0] * transpose[0] + m[1] * transpose[2];
                            var b = m[0] * transpose[1] + m[1] * transpose[3];
                            var c = m[2] * transpose[0] + m[3] * transpose[2];
                            var d = m[2] * transpose[1] + m[3] * transpose[3];
                            var first = (a + d) / 2;
                            var second = Math.sqrt(Math.pow(a + d, 2) - 4 * (a * d - c * b)) / 2;
                            var sx = first + second || 1;
                            var sy = first - second || 1;
                            return [Math.sqrt(sx), Math.sqrt(sy)];
                        }
                    }, {
                        key   : "normalizeRect",
                        value : function normalizeRect(rect) {
                            var r = rect.slice(0);

                            if (rect[0] > rect[2]) {
                                r[0] = rect[2];
                                r[2] = rect[0];
                            }

                            if (rect[1] > rect[3]) {
                                r[1] = rect[3];
                                r[3] = rect[1];
                            }

                            return r;
                        }
                    }, {
                        key   : "intersect",
                        value : function intersect(rect1, rect2) {
                            function compare(a, b) {
                                return a - b;
                            }

                            var orderedX = [rect1[0], rect1[2], rect2[0], rect2[2]].sort(compare);
                            var orderedY = [rect1[1], rect1[3], rect2[1], rect2[3]].sort(compare);
                            var result = [];
                            rect1 = Util.normalizeRect(rect1);
                            rect2 = Util.normalizeRect(rect2);

                            if (orderedX[0] === rect1[0] && orderedX[1] === rect2[0] || orderedX[0] === rect2[0] && orderedX[1] === rect1[0]) {
                                result[0] = orderedX[1];
                                result[2] = orderedX[2];
                            } else {
                                return null;
                            }

                            if (orderedY[0] === rect1[1] && orderedY[1] === rect2[1] || orderedY[0] === rect2[1] && orderedY[1] === rect1[1]) {
                                result[1] = orderedY[1];
                                result[3] = orderedY[2];
                            } else {
                                return null;
                            }

                            return result;
                        }
                    }]);

                    return Util;
                }();

                exports.Util = Util;
                var PDFStringTranslateTable = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2D8, 0x2C7, 0x2C6, 0x2D9, 0x2DD, 0x2DB, 0x2DA, 0x2DC, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2022, 0x2020, 0x2021, 0x2026, 0x2014, 0x2013, 0x192, 0x2044, 0x2039, 0x203A, 0x2212, 0x2030, 0x201E, 0x201C, 0x201D, 0x2018, 0x2019, 0x201A, 0x2122, 0xFB01, 0xFB02, 0x141, 0x152, 0x160, 0x178, 0x17D, 0x131, 0x142, 0x153, 0x161, 0x17E, 0, 0x20AC];

                function stringToPDFString(str) {
                    var length = str.length,
                        strBuf = [];

                    if (str[0] === "\xFE" && str[1] === "\xFF") {
                        for (var i = 2; i < length; i += 2) {
                            strBuf.push(String.fromCharCode(str.charCodeAt(i) << 8 | str.charCodeAt(i + 1)));
                        }
                    } else if (str[0] === "\xFF" && str[1] === "\xFE") {
                        for (var _i2 = 2; _i2 < length; _i2 += 2) {
                            strBuf.push(String.fromCharCode(str.charCodeAt(_i2 + 1) << 8 | str.charCodeAt(_i2)));
                        }
                    } else {
                        for (var _i3 = 0; _i3 < length; ++_i3) {
                            var code = PDFStringTranslateTable[str.charCodeAt(_i3)];
                            strBuf.push(code ? String.fromCharCode(code) : str.charAt(_i3));
                        }
                    }

                    return strBuf.join("");
                }

                function escapeString(str) {
                    return str.replace(/([()\\\n\r])/g, function(match) {
                        if (match === "\n") {
                            return "\\n";
                        } else if (match === "\r") {
                            return "\\r";
                        }

                        return "\\".concat(match);
                    });
                }

                function isAscii(str) {
                    return /^[\x00-\x7F]*$/.test(str);
                }

                function stringToUTF16BEString(str) {
                    var buf = ["\xFE\xFF"];

                    for (var i = 0, ii = str.length; i < ii; i++) {
                        var _char = str.charCodeAt(i);

                        buf.push(String.fromCharCode(_char >> 8 & 0xff));
                        buf.push(String.fromCharCode(_char & 0xff));
                    }

                    return buf.join("");
                }

                function stringToUTF8String(str) {
                    return decodeURIComponent(escape(str));
                }

                function utf8StringToString(str) {
                    return unescape(encodeURIComponent(str));
                }

                function isBool(v) {
                    return typeof v === "boolean";
                }

                function isNum(v) {
                    return typeof v === "number";
                }

                function isString(v) {
                    return typeof v === "string";
                }

                function isArrayBuffer(v) {
                    return _typeof(v) === "object" && v !== null && v.byteLength !== undefined;
                }

                function isArrayEqual(arr1, arr2) {
                    if (arr1.length !== arr2.length) {
                        return false;
                    }

                    for (var i = 0, ii = arr1.length; i < ii; i++) {
                        if (arr1[i] !== arr2[i]) {
                            return false;
                        }
                    }

                    return true;
                }

                function getModificationDate() {
                    var date = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Date();
                    var buffer = [date.getUTCFullYear().toString(), (date.getUTCMonth() + 1).toString().padStart(2, "0"), date.getUTCDate().toString().padStart(2, "0"), date.getUTCHours().toString().padStart(2, "0"), date.getUTCMinutes().toString().padStart(2, "0"), date.getUTCSeconds().toString().padStart(2, "0")];
                    return buffer.join("");
                }

                function createPromiseCapability() {
                    var capability = Object.create(null);
                    var isSettled = false;
                    Object.defineProperty(capability, "settled", {
                        get : function get() {
                            return isSettled;
                        }
                    });
                    capability.promise = new Promise(function(resolve, reject) {
                        capability.resolve = function(data) {
                            isSettled = true;
                            resolve(data);
                        };

                        capability.reject = function(reason) {
                            isSettled = true;
                            reject(reason);
                        };
                    });
                    return capability;
                }

                function createObjectURL(data) {
                    var contentType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "";
                    var forceDataSchema = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

                    if (URL.createObjectURL && !forceDataSchema) {
                        return URL.createObjectURL(new Blob([data], {
                            type : contentType
                        }));
                    }

                    var digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
                    var buffer = "data:".concat(contentType, ";base64,");

                    for (var i = 0, ii = data.length; i < ii; i += 3) {
                        var b1 = data[i] & 0xff;
                        var b2 = data[i + 1] & 0xff;
                        var b3 = data[i + 2] & 0xff;
                        var d1 = b1 >> 2,
                            d2 = (b1 & 3) << 4 | b2 >> 4;
                        var d3 = i + 1 < ii ? (b2 & 0xf) << 2 | b3 >> 6 : 64;
                        var d4 = i + 2 < ii ? b3 & 0x3f : 64;
                        buffer += digits[d1] + digits[d2] + digits[d3] + digits[d4];
                    }

                    return buffer;
                }

                /***/
            }),
            /* 5 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var _is_node = __w_pdfjs_require__(6);

                if (typeof globalThis === "undefined" || !globalThis._pdfjsCompatibilityChecked) {
                    if (typeof globalThis === "undefined" || globalThis.Math !== Math) {
                        globalThis = __w_pdfjs_require__(7);
                    }

                    globalThis._pdfjsCompatibilityChecked = true;

                    (function checkNodeBtoa() {
                        if (globalThis.btoa || !_is_node.isNodeJS) {
                            return;
                        }

                        globalThis.btoa = function(chars) {
                            return Buffer.from(chars, "binary").toString("base64");
                        };
                    })();

                    (function checkNodeAtob() {
                        if (globalThis.atob || !_is_node.isNodeJS) {
                            return;
                        }

                        globalThis.atob = function(input) {
                            return Buffer.from(input, "base64").toString("binary");
                        };
                    })();

                    (function checkObjectFromEntries() {
                        if (Object.fromEntries) {
                            return;
                        }

                        __w_pdfjs_require__(52);
                    })();

                    (function checkPromise() {
                        if (globalThis.Promise.allSettled) {
                            return;
                        }

                        globalThis.Promise = __w_pdfjs_require__(85);
                    })();

                    (function checkReadableStream() {
                        var isReadableStreamSupported = false;

                        if (typeof ReadableStream !== "undefined") {
                            try {
                                new ReadableStream({
                                    start : function start(controller) {
                                        controller.close();
                                    }
                                });
                                isReadableStreamSupported = true;
                            } catch (e) {
                            }
                        }

                        if (isReadableStreamSupported) {
                            return;
                        }

                        globalThis.ReadableStream = __w_pdfjs_require__(111).ReadableStream;
                    })();

                    (function checkStringPadStart() {
                        if (String.prototype.padStart) {
                            return;
                        }

                        __w_pdfjs_require__(112);
                    })();

                    (function checkStringPadEnd() {
                        if (String.prototype.padEnd) {
                            return;
                        }

                        __w_pdfjs_require__(118);
                    })();

                    (function checkObjectValues() {
                        if (Object.values) {
                            return;
                        }

                        Object.values = __w_pdfjs_require__(120);
                    })();

                    (function checkObjectEntries() {
                        if (Object.entries) {
                            return;
                        }

                        Object.entries = __w_pdfjs_require__(123);
                    })();
                }

                /***/
            }),
            /* 6 */
            /***/ ((__unused_webpack_module, exports) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.isNodeJS = void 0;

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                var isNodeJS = (typeof process === "undefined" ? "undefined" : _typeof(process)) === "object" && process + "" === "[object process]" && !process.versions.nw && !(process.versions.electron && process.type && process.type !== "browser");
                exports.isNodeJS = isNodeJS;

                /***/
            }),
            /* 7 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                __w_pdfjs_require__(8);
                module.exports = __w_pdfjs_require__(10);

                /***/
            }),
            /* 8 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var $ = __w_pdfjs_require__(9);
                var global = __w_pdfjs_require__(10);
                $({global : true}, {globalThis : global});

                /***/
            }),
            /* 9 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var getOwnPropertyDescriptor = __w_pdfjs_require__(11).f;
                var createNonEnumerableProperty = __w_pdfjs_require__(25);
                var redefine = __w_pdfjs_require__(28);
                var setGlobal = __w_pdfjs_require__(29);
                var copyConstructorProperties = __w_pdfjs_require__(39);
                var isForced = __w_pdfjs_require__(51);
                module.exports = function(options, source) {
                    var TARGET = options.target;
                    var GLOBAL = options.global;
                    var STATIC = options.stat;
                    var FORCED, target, key, targetProperty, sourceProperty, descriptor;
                    if (GLOBAL) {
                        target = global;
                    } else if (STATIC) {
                        target = global[TARGET] || setGlobal(TARGET, {});
                    } else {
                        target = (global[TARGET] || {}).prototype;
                    }
                    if (target)
                        for (key in source) {
                            sourceProperty = source[key];
                            if (options.noTargetGet) {
                                descriptor = getOwnPropertyDescriptor(target, key);
                                targetProperty = descriptor && descriptor.value;
                            } else
                                targetProperty = target[key];
                            FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
                            if (!FORCED && targetProperty !== undefined) {
                                if (typeof sourceProperty === typeof targetProperty)
                                    continue;
                                copyConstructorProperties(sourceProperty, targetProperty);
                            }
                            if (options.sham || targetProperty && targetProperty.sham) {
                                createNonEnumerableProperty(sourceProperty, 'sham', true);
                            }
                            redefine(target, key, sourceProperty, options);
                        }
                };

                /***/
            }),
            /* 10 */
            /***/ ((module) => {

                var check = function(it) {
                    return it && it.Math == Math && it;
                };
                module.exports = check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || check(typeof self == 'object' && self) || check(typeof global == 'object' && global) || function() {
                    return this;
                }() || Function('return this')();

                /***/
            }),
            /* 11 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                var DESCRIPTORS = __w_pdfjs_require__(12);
                var propertyIsEnumerableModule = __w_pdfjs_require__(14);
                var createPropertyDescriptor = __w_pdfjs_require__(15);
                var toIndexedObject = __w_pdfjs_require__(16);
                var toPrimitive = __w_pdfjs_require__(20);
                var has = __w_pdfjs_require__(22);
                var IE8_DOM_DEFINE = __w_pdfjs_require__(23);
                var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
                exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
                    O = toIndexedObject(O);
                    P = toPrimitive(P, true);
                    if (IE8_DOM_DEFINE)
                        try {
                            return $getOwnPropertyDescriptor(O, P);
                        } catch (error) {
                        }
                    if (has(O, P))
                        return createPropertyDescriptor(!propertyIsEnumerableModule.f.call(O, P), O[P]);
                };

                /***/
            }),
            /* 12 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var fails = __w_pdfjs_require__(13);
                module.exports = !fails(function() {
                    return Object.defineProperty({}, 1, {
                        get : function() {
                            return 7;
                        }
                    })[1] != 7;
                });

                /***/
            }),
            /* 13 */
            /***/ ((module) => {

                module.exports = function(exec) {
                    try {
                        return !!exec();
                    } catch (error) {
                        return true;
                    }
                };

                /***/
            }),
            /* 14 */
            /***/ ((__unused_webpack_module, exports) => {

                "use strict";

                var $propertyIsEnumerable = {}.propertyIsEnumerable;
                var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
                var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({1 : 2}, 1);
                exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
                    var descriptor = getOwnPropertyDescriptor(this, V);
                    return !!descriptor && descriptor.enumerable;
                } : $propertyIsEnumerable;

                /***/
            }),
            /* 15 */
            /***/ ((module) => {

                module.exports = function(bitmap, value) {
                    return {
                        enumerable   : !(bitmap & 1),
                        configurable : !(bitmap & 2),
                        writable     : !(bitmap & 4),
                        value        : value
                    };
                };

                /***/
            }),
            /* 16 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var IndexedObject = __w_pdfjs_require__(17);
                var requireObjectCoercible = __w_pdfjs_require__(19);
                module.exports = function(it) {
                    return IndexedObject(requireObjectCoercible(it));
                };

                /***/
            }),
            /* 17 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var fails = __w_pdfjs_require__(13);
                var classof = __w_pdfjs_require__(18);
                var split = ''.split;
                module.exports = fails(function() {
                    return !Object('z').propertyIsEnumerable(0);
                }) ? function(it) {
                    return classof(it) == 'String' ? split.call(it, '') : Object(it);
                } : Object;

                /***/
            }),
            /* 18 */
            /***/ ((module) => {

                var toString = {}.toString;
                module.exports = function(it) {
                    return toString.call(it).slice(8, -1);
                };

                /***/
            }),
            /* 19 */
            /***/ ((module) => {

                module.exports = function(it) {
                    if (it == undefined)
                        throw TypeError("Can't call method on " + it);
                    return it;
                };

                /***/
            }),
            /* 20 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var isObject = __w_pdfjs_require__(21);
                module.exports = function(input, PREFERRED_STRING) {
                    if (!isObject(input))
                        return input;
                    var fn, val;
                    if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input)))
                        return val;
                    if (typeof (fn = input.valueOf) == 'function' && !isObject(val = fn.call(input)))
                        return val;
                    if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input)))
                        return val;
                    throw TypeError("Can't convert object to primitive value");
                };

                /***/
            }),
            /* 21 */
            /***/ ((module) => {

                module.exports = function(it) {
                    return typeof it === 'object' ? it !== null : typeof it === 'function';
                };

                /***/
            }),
            /* 22 */
            /***/ ((module) => {

                var hasOwnProperty = {}.hasOwnProperty;
                module.exports = function(it, key) {
                    return hasOwnProperty.call(it, key);
                };

                /***/
            }),
            /* 23 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var DESCRIPTORS = __w_pdfjs_require__(12);
                var fails = __w_pdfjs_require__(13);
                var createElement = __w_pdfjs_require__(24);
                module.exports = !DESCRIPTORS && !fails(function() {
                    return Object.defineProperty(createElement('div'), 'a', {
                        get : function() {
                            return 7;
                        }
                    }).a != 7;
                });

                /***/
            }),
            /* 24 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var isObject = __w_pdfjs_require__(21);
                var document = global.document;
                var EXISTS = isObject(document) && isObject(document.createElement);
                module.exports = function(it) {
                    return EXISTS ? document.createElement(it) : {};
                };

                /***/
            }),
            /* 25 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var DESCRIPTORS = __w_pdfjs_require__(12);
                var definePropertyModule = __w_pdfjs_require__(26);
                var createPropertyDescriptor = __w_pdfjs_require__(15);
                module.exports = DESCRIPTORS ? function(object, key, value) {
                    return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
                } : function(object, key, value) {
                    object[key] = value;
                    return object;
                };

                /***/
            }),
            /* 26 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                var DESCRIPTORS = __w_pdfjs_require__(12);
                var IE8_DOM_DEFINE = __w_pdfjs_require__(23);
                var anObject = __w_pdfjs_require__(27);
                var toPrimitive = __w_pdfjs_require__(20);
                var $defineProperty = Object.defineProperty;
                exports.f = DESCRIPTORS ? $defineProperty : function defineProperty(O, P, Attributes) {
                    anObject(O);
                    P = toPrimitive(P, true);
                    anObject(Attributes);
                    if (IE8_DOM_DEFINE)
                        try {
                            return $defineProperty(O, P, Attributes);
                        } catch (error) {
                        }
                    if ('get' in Attributes || 'set' in Attributes)
                        throw TypeError('Accessors not supported');
                    if ('value' in Attributes)
                        O[P] = Attributes.value;
                    return O;
                };

                /***/
            }),
            /* 27 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var isObject = __w_pdfjs_require__(21);
                module.exports = function(it) {
                    if (!isObject(it)) {
                        throw TypeError(String(it) + ' is not an object');
                    }
                    return it;
                };

                /***/
            }),
            /* 28 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var createNonEnumerableProperty = __w_pdfjs_require__(25);
                var has = __w_pdfjs_require__(22);
                var setGlobal = __w_pdfjs_require__(29);
                var inspectSource = __w_pdfjs_require__(30);
                var InternalStateModule = __w_pdfjs_require__(32);
                var getInternalState = InternalStateModule.get;
                var enforceInternalState = InternalStateModule.enforce;
                var TEMPLATE = String(String).split('String');
                (module.exports = function(O, key, value, options) {
                    var unsafe = options ? !!options.unsafe : false;
                    var simple = options ? !!options.enumerable : false;
                    var noTargetGet = options ? !!options.noTargetGet : false;
                    var state;
                    if (typeof value == 'function') {
                        if (typeof key == 'string' && !has(value, 'name')) {
                            createNonEnumerableProperty(value, 'name', key);
                        }
                        state = enforceInternalState(value);
                        if (!state.source) {
                            state.source = TEMPLATE.join(typeof key == 'string' ? key : '');
                        }
                    }
                    if (O === global) {
                        if (simple)
                            O[key] = value;
                        else
                            setGlobal(key, value);
                        return;
                    } else if (!unsafe) {
                        delete O[key];
                    } else if (!noTargetGet && O[key]) {
                        simple = true;
                    }
                    if (simple)
                        O[key] = value;
                    else
                        createNonEnumerableProperty(O, key, value);
                })(Function.prototype, 'toString', function toString() {
                    return typeof this == 'function' && getInternalState(this).source || inspectSource(this);
                });

                /***/
            }),
            /* 29 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var createNonEnumerableProperty = __w_pdfjs_require__(25);
                module.exports = function(key, value) {
                    try {
                        createNonEnumerableProperty(global, key, value);
                    } catch (error) {
                        global[key] = value;
                    }
                    return value;
                };

                /***/
            }),
            /* 30 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var store = __w_pdfjs_require__(31);
                var functionToString = Function.toString;
                if (typeof store.inspectSource != 'function') {
                    store.inspectSource = function(it) {
                        return functionToString.call(it);
                    };
                }
                module.exports = store.inspectSource;

                /***/
            }),
            /* 31 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var setGlobal = __w_pdfjs_require__(29);
                var SHARED = '__core-js_shared__';
                var store = global[SHARED] || setGlobal(SHARED, {});
                module.exports = store;

                /***/
            }),
            /* 32 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var NATIVE_WEAK_MAP = __w_pdfjs_require__(33);
                var global = __w_pdfjs_require__(10);
                var isObject = __w_pdfjs_require__(21);
                var createNonEnumerableProperty = __w_pdfjs_require__(25);
                var objectHas = __w_pdfjs_require__(22);
                var shared = __w_pdfjs_require__(31);
                var sharedKey = __w_pdfjs_require__(34);
                var hiddenKeys = __w_pdfjs_require__(38);
                var WeakMap = global.WeakMap;
                var set, get, has;
                var enforce = function(it) {
                    return has(it) ? get(it) : set(it, {});
                };
                var getterFor = function(TYPE) {
                    return function(it) {
                        var state;
                        if (!isObject(it) || (state = get(it)).type !== TYPE) {
                            throw TypeError('Incompatible receiver, ' + TYPE + ' required');
                        }
                        return state;
                    };
                };
                if (NATIVE_WEAK_MAP) {
                    var store = shared.state || (shared.state = new WeakMap());
                    var wmget = store.get;
                    var wmhas = store.has;
                    var wmset = store.set;
                    set = function(it, metadata) {
                        metadata.facade = it;
                        wmset.call(store, it, metadata);
                        return metadata;
                    };
                    get = function(it) {
                        return wmget.call(store, it) || {};
                    };
                    has = function(it) {
                        return wmhas.call(store, it);
                    };
                } else {
                    var STATE = sharedKey('state');
                    hiddenKeys[STATE] = true;
                    set = function(it, metadata) {
                        metadata.facade = it;
                        createNonEnumerableProperty(it, STATE, metadata);
                        return metadata;
                    };
                    get = function(it) {
                        return objectHas(it, STATE) ? it[STATE] : {};
                    };
                    has = function(it) {
                        return objectHas(it, STATE);
                    };
                }
                module.exports = {
                    set       : set,
                    get       : get,
                    has       : has,
                    enforce   : enforce,
                    getterFor : getterFor
                };

                /***/
            }),
            /* 33 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var inspectSource = __w_pdfjs_require__(30);
                var WeakMap = global.WeakMap;
                module.exports = typeof WeakMap === 'function' && /native code/.test(inspectSource(WeakMap));

                /***/
            }),
            /* 34 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var shared = __w_pdfjs_require__(35);
                var uid = __w_pdfjs_require__(37);
                var keys = shared('keys');
                module.exports = function(key) {
                    return keys[key] || (keys[key] = uid(key));
                };

                /***/
            }),
            /* 35 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var IS_PURE = __w_pdfjs_require__(36);
                var store = __w_pdfjs_require__(31);
                (module.exports = function(key, value) {
                    return store[key] || (store[key] = value !== undefined ? value : {});
                })('versions', []).push({
                    version   : '3.10.0',
                    mode      : IS_PURE ? 'pure' : 'global',
                    copyright : '© 2021 Denis Pushkarev (zloirock.ru)'
                });

                /***/
            }),
            /* 36 */
            /***/ ((module) => {

                module.exports = false;

                /***/
            }),
            /* 37 */
            /***/ ((module) => {

                var id = 0;
                var postfix = Math.random();
                module.exports = function(key) {
                    return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
                };

                /***/
            }),
            /* 38 */
            /***/ ((module) => {

                module.exports = {};

                /***/
            }),
            /* 39 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var has = __w_pdfjs_require__(22);
                var ownKeys = __w_pdfjs_require__(40);
                var getOwnPropertyDescriptorModule = __w_pdfjs_require__(11);
                var definePropertyModule = __w_pdfjs_require__(26);
                module.exports = function(target, source) {
                    var keys = ownKeys(source);
                    var defineProperty = definePropertyModule.f;
                    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
                    for (var i = 0; i < keys.length; i++) {
                        var key = keys[i];
                        if (!has(target, key))
                            defineProperty(target, key, getOwnPropertyDescriptor(source, key));
                    }
                };

                /***/
            }),
            /* 40 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var getBuiltIn = __w_pdfjs_require__(41);
                var getOwnPropertyNamesModule = __w_pdfjs_require__(43);
                var getOwnPropertySymbolsModule = __w_pdfjs_require__(50);
                var anObject = __w_pdfjs_require__(27);
                module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
                    var keys = getOwnPropertyNamesModule.f(anObject(it));
                    var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
                    return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
                };

                /***/
            }),
            /* 41 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var path = __w_pdfjs_require__(42);
                var global = __w_pdfjs_require__(10);
                var aFunction = function(variable) {
                    return typeof variable == 'function' ? variable : undefined;
                };
                module.exports = function(namespace, method) {
                    return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global[namespace]) : path[namespace] && path[namespace][method] || global[namespace] && global[namespace][method];
                };

                /***/
            }),
            /* 42 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                module.exports = global;

                /***/
            }),
            /* 43 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                var internalObjectKeys = __w_pdfjs_require__(44);
                var enumBugKeys = __w_pdfjs_require__(49);
                var hiddenKeys = enumBugKeys.concat('length', 'prototype');
                exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
                    return internalObjectKeys(O, hiddenKeys);
                };

                /***/
            }),
            /* 44 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var has = __w_pdfjs_require__(22);
                var toIndexedObject = __w_pdfjs_require__(16);
                var indexOf = __w_pdfjs_require__(45).indexOf;
                var hiddenKeys = __w_pdfjs_require__(38);
                module.exports = function(object, names) {
                    var O = toIndexedObject(object);
                    var i = 0;
                    var result = [];
                    var key;
                    for (key in O)
                        !has(hiddenKeys, key) && has(O, key) && result.push(key);
                    while (names.length > i)
                        if (has(O, key = names[i++])) {
                            ~indexOf(result, key) || result.push(key);
                        }
                    return result;
                };

                /***/
            }),
            /* 45 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var toIndexedObject = __w_pdfjs_require__(16);
                var toLength = __w_pdfjs_require__(46);
                var toAbsoluteIndex = __w_pdfjs_require__(48);
                var createMethod = function(IS_INCLUDES) {
                    return function($this, el, fromIndex) {
                        var O = toIndexedObject($this);
                        var length = toLength(O.length);
                        var index = toAbsoluteIndex(fromIndex, length);
                        var value;
                        if (IS_INCLUDES && el != el)
                            while (length > index) {
                                value = O[index++];
                                if (value != value)
                                    return true;
                            }
                        else
                            for (; length > index; index++) {
                                if ((IS_INCLUDES || index in O) && O[index] === el)
                                    return IS_INCLUDES || index || 0;
                            }
                        return !IS_INCLUDES && -1;
                    };
                };
                module.exports = {
                    includes : createMethod(true),
                    indexOf  : createMethod(false)
                };

                /***/
            }),
            /* 46 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var toInteger = __w_pdfjs_require__(47);
                var min = Math.min;
                module.exports = function(argument) {
                    return argument > 0 ? min(toInteger(argument), 0x1FFFFFFFFFFFFF) : 0;
                };

                /***/
            }),
            /* 47 */
            /***/ ((module) => {

                var ceil = Math.ceil;
                var floor = Math.floor;
                module.exports = function(argument) {
                    return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
                };

                /***/
            }),
            /* 48 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var toInteger = __w_pdfjs_require__(47);
                var max = Math.max;
                var min = Math.min;
                module.exports = function(index, length) {
                    var integer = toInteger(index);
                    return integer < 0 ? max(integer + length, 0) : min(integer, length);
                };

                /***/
            }),
            /* 49 */
            /***/ ((module) => {

                module.exports = [
                    'constructor',
                    'hasOwnProperty',
                    'isPrototypeOf',
                    'propertyIsEnumerable',
                    'toLocaleString',
                    'toString',
                    'valueOf'
                ];

                /***/
            }),
            /* 50 */
            /***/ ((__unused_webpack_module, exports) => {

                exports.f = Object.getOwnPropertySymbols;

                /***/
            }),
            /* 51 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var fails = __w_pdfjs_require__(13);
                var replacement = /#|\.prototype\./;
                var isForced = function(feature, detection) {
                    var value = data[normalize(feature)];
                    return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == 'function' ? fails(detection) : !!detection;
                };
                var normalize = isForced.normalize = function(string) {
                    return String(string).replace(replacement, '.').toLowerCase();
                };
                var data = isForced.data = {};
                var NATIVE = isForced.NATIVE = 'N';
                var POLYFILL = isForced.POLYFILL = 'P';
                module.exports = isForced;

                /***/
            }),
            /* 52 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                __w_pdfjs_require__(53);
                __w_pdfjs_require__(75);
                var path = __w_pdfjs_require__(42);
                module.exports = path.Object.fromEntries;

                /***/
            }),
            /* 53 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var toIndexedObject = __w_pdfjs_require__(16);
                var addToUnscopables = __w_pdfjs_require__(54);
                var Iterators = __w_pdfjs_require__(65);
                var InternalStateModule = __w_pdfjs_require__(32);
                var defineIterator = __w_pdfjs_require__(66);
                var ARRAY_ITERATOR = 'Array Iterator';
                var setInternalState = InternalStateModule.set;
                var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);
                module.exports = defineIterator(Array, 'Array', function(iterated, kind) {
                    setInternalState(this, {
                        type   : ARRAY_ITERATOR,
                        target : toIndexedObject(iterated),
                        index  : 0,
                        kind   : kind
                    });
                }, function() {
                    var state = getInternalState(this);
                    var target = state.target;
                    var kind = state.kind;
                    var index = state.index++;
                    if (!target || index >= target.length) {
                        state.target = undefined;
                        return {
                            value : undefined,
                            done  : true
                        };
                    }
                    if (kind == 'keys')
                        return {
                            value : index,
                            done  : false
                        };
                    if (kind == 'values')
                        return {
                            value : target[index],
                            done  : false
                        };
                    return {
                        value : [
                            index,
                            target[index]
                        ],
                        done  : false
                    };
                }, 'values');
                Iterators.Arguments = Iterators.Array;
                addToUnscopables('keys');
                addToUnscopables('values');
                addToUnscopables('entries');

                /***/
            }),
            /* 54 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var wellKnownSymbol = __w_pdfjs_require__(55);
                var create = __w_pdfjs_require__(61);
                var definePropertyModule = __w_pdfjs_require__(26);
                var UNSCOPABLES = wellKnownSymbol('unscopables');
                var ArrayPrototype = Array.prototype;
                if (ArrayPrototype[UNSCOPABLES] == undefined) {
                    definePropertyModule.f(ArrayPrototype, UNSCOPABLES, {
                        configurable : true,
                        value        : create(null)
                    });
                }
                module.exports = function(key) {
                    ArrayPrototype[UNSCOPABLES][key] = true;
                };

                /***/
            }),
            /* 55 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var shared = __w_pdfjs_require__(35);
                var has = __w_pdfjs_require__(22);
                var uid = __w_pdfjs_require__(37);
                var NATIVE_SYMBOL = __w_pdfjs_require__(56);
                var USE_SYMBOL_AS_UID = __w_pdfjs_require__(60);
                var WellKnownSymbolsStore = shared('wks');
                var Symbol = global.Symbol;
                var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol : Symbol && Symbol.withoutSetter || uid;
                module.exports = function(name) {
                    if (!has(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == 'string')) {
                        if (NATIVE_SYMBOL && has(Symbol, name)) {
                            WellKnownSymbolsStore[name] = Symbol[name];
                        } else {
                            WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
                        }
                    }
                    return WellKnownSymbolsStore[name];
                };

                /***/
            }),
            /* 56 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var IS_NODE = __w_pdfjs_require__(57);
                var V8_VERSION = __w_pdfjs_require__(58);
                var fails = __w_pdfjs_require__(13);
                module.exports = !!Object.getOwnPropertySymbols && !fails(function() {
                    return !Symbol.sham && (IS_NODE ? V8_VERSION === 38 : V8_VERSION > 37 && V8_VERSION < 41);
                });

                /***/
            }),
            /* 57 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var classof = __w_pdfjs_require__(18);
                var global = __w_pdfjs_require__(10);
                module.exports = classof(global.process) == 'process';

                /***/
            }),
            /* 58 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var userAgent = __w_pdfjs_require__(59);
                var process = global.process;
                var versions = process && process.versions;
                var v8 = versions && versions.v8;
                var match, version;
                if (v8) {
                    match = v8.split('.');
                    version = match[0] + match[1];
                } else if (userAgent) {
                    match = userAgent.match(/Edge\/(\d+)/);
                    if (!match || match[1] >= 74) {
                        match = userAgent.match(/Chrome\/(\d+)/);
                        if (match)
                            version = match[1];
                    }
                }
                module.exports = version && +version;

                /***/
            }),
            /* 59 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var getBuiltIn = __w_pdfjs_require__(41);
                module.exports = getBuiltIn('navigator', 'userAgent') || '';

                /***/
            }),
            /* 60 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var NATIVE_SYMBOL = __w_pdfjs_require__(56);
                module.exports = NATIVE_SYMBOL && !Symbol.sham && typeof Symbol.iterator == 'symbol';

                /***/
            }),
            /* 61 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var anObject = __w_pdfjs_require__(27);
                var defineProperties = __w_pdfjs_require__(62);
                var enumBugKeys = __w_pdfjs_require__(49);
                var hiddenKeys = __w_pdfjs_require__(38);
                var html = __w_pdfjs_require__(64);
                var documentCreateElement = __w_pdfjs_require__(24);
                var sharedKey = __w_pdfjs_require__(34);
                var GT = '>';
                var LT = '<';
                var PROTOTYPE = 'prototype';
                var SCRIPT = 'script';
                var IE_PROTO = sharedKey('IE_PROTO');
                var EmptyConstructor = function() {
                };
                var scriptTag = function(content) {
                    return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
                };
                var NullProtoObjectViaActiveX = function(activeXDocument) {
                    activeXDocument.write(scriptTag(''));
                    activeXDocument.close();
                    var temp = activeXDocument.parentWindow.Object;
                    activeXDocument = null;
                    return temp;
                };
                var NullProtoObjectViaIFrame = function() {
                    var iframe = documentCreateElement('iframe');
                    var JS = 'java' + SCRIPT + ':';
                    var iframeDocument;
                    iframe.style.display = 'none';
                    html.appendChild(iframe);
                    iframe.src = String(JS);
                    iframeDocument = iframe.contentWindow.document;
                    iframeDocument.open();
                    iframeDocument.write(scriptTag('document.F=Object'));
                    iframeDocument.close();
                    return iframeDocument.F;
                };
                var activeXDocument;
                var NullProtoObject = function() {
                    try {
                        activeXDocument = document.domain && new ActiveXObject('htmlfile');
                    } catch (error) {
                    }
                    NullProtoObject = activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame();
                    var length = enumBugKeys.length;
                    while (length--)
                        delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
                    return NullProtoObject();
                };
                hiddenKeys[IE_PROTO] = true;
                module.exports = Object.create || function create(O, Properties) {
                    var result;
                    if (O !== null) {
                        EmptyConstructor[PROTOTYPE] = anObject(O);
                        result = new EmptyConstructor();
                        EmptyConstructor[PROTOTYPE] = null;
                        result[IE_PROTO] = O;
                    } else
                        result = NullProtoObject();
                    return Properties === undefined ? result : defineProperties(result, Properties);
                };

                /***/
            }),
            /* 62 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var DESCRIPTORS = __w_pdfjs_require__(12);
                var definePropertyModule = __w_pdfjs_require__(26);
                var anObject = __w_pdfjs_require__(27);
                var objectKeys = __w_pdfjs_require__(63);
                module.exports = DESCRIPTORS ? Object.defineProperties : function defineProperties(O, Properties) {
                    anObject(O);
                    var keys = objectKeys(Properties);
                    var length = keys.length;
                    var index = 0;
                    var key;
                    while (length > index)
                        definePropertyModule.f(O, key = keys[index++], Properties[key]);
                    return O;
                };

                /***/
            }),
            /* 63 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var internalObjectKeys = __w_pdfjs_require__(44);
                var enumBugKeys = __w_pdfjs_require__(49);
                module.exports = Object.keys || function keys(O) {
                    return internalObjectKeys(O, enumBugKeys);
                };

                /***/
            }),
            /* 64 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var getBuiltIn = __w_pdfjs_require__(41);
                module.exports = getBuiltIn('document', 'documentElement');

                /***/
            }),
            /* 65 */
            /***/ ((module) => {

                module.exports = {};

                /***/
            }),
            /* 66 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var $ = __w_pdfjs_require__(9);
                var createIteratorConstructor = __w_pdfjs_require__(67);
                var getPrototypeOf = __w_pdfjs_require__(69);
                var setPrototypeOf = __w_pdfjs_require__(73);
                var setToStringTag = __w_pdfjs_require__(72);
                var createNonEnumerableProperty = __w_pdfjs_require__(25);
                var redefine = __w_pdfjs_require__(28);
                var wellKnownSymbol = __w_pdfjs_require__(55);
                var IS_PURE = __w_pdfjs_require__(36);
                var Iterators = __w_pdfjs_require__(65);
                var IteratorsCore = __w_pdfjs_require__(68);
                var IteratorPrototype = IteratorsCore.IteratorPrototype;
                var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
                var ITERATOR = wellKnownSymbol('iterator');
                var KEYS = 'keys';
                var VALUES = 'values';
                var ENTRIES = 'entries';
                var returnThis = function() {
                    return this;
                };
                module.exports = function(Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
                    createIteratorConstructor(IteratorConstructor, NAME, next);
                    var getIterationMethod = function(KIND) {
                        if (KIND === DEFAULT && defaultIterator)
                            return defaultIterator;
                        if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype)
                            return IterablePrototype[KIND];
                        switch (KIND) {
                            case KEYS:
                                return function keys() {
                                    return new IteratorConstructor(this, KIND);
                                };
                            case VALUES:
                                return function values() {
                                    return new IteratorConstructor(this, KIND);
                                };
                            case ENTRIES:
                                return function entries() {
                                    return new IteratorConstructor(this, KIND);
                                };
                        }
                        return function() {
                            return new IteratorConstructor(this);
                        };
                    };
                    var TO_STRING_TAG = NAME + ' Iterator';
                    var INCORRECT_VALUES_NAME = false;
                    var IterablePrototype = Iterable.prototype;
                    var nativeIterator = IterablePrototype[ITERATOR] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
                    var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
                    var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
                    var CurrentIteratorPrototype, methods, KEY;
                    if (anyNativeIterator) {
                        CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
                        if (IteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
                            if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
                                if (setPrototypeOf) {
                                    setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
                                } else if (typeof CurrentIteratorPrototype[ITERATOR] != 'function') {
                                    createNonEnumerableProperty(CurrentIteratorPrototype, ITERATOR, returnThis);
                                }
                            }
                            setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
                            if (IS_PURE)
                                Iterators[TO_STRING_TAG] = returnThis;
                        }
                    }
                    if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
                        INCORRECT_VALUES_NAME = true;
                        defaultIterator = function values() {
                            return nativeIterator.call(this);
                        };
                    }
                    if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
                        createNonEnumerableProperty(IterablePrototype, ITERATOR, defaultIterator);
                    }
                    Iterators[NAME] = defaultIterator;
                    if (DEFAULT) {
                        methods = {
                            values  : getIterationMethod(VALUES),
                            keys    : IS_SET ? defaultIterator : getIterationMethod(KEYS),
                            entries : getIterationMethod(ENTRIES)
                        };
                        if (FORCED)
                            for (KEY in methods) {
                                if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
                                    redefine(IterablePrototype, KEY, methods[KEY]);
                                }
                            }
                        else
                            $({
                                target : NAME,
                                proto  : true,
                                forced : BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME
                            }, methods);
                    }
                    return methods;
                };

                /***/
            }),
            /* 67 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var IteratorPrototype = __w_pdfjs_require__(68).IteratorPrototype;
                var create = __w_pdfjs_require__(61);
                var createPropertyDescriptor = __w_pdfjs_require__(15);
                var setToStringTag = __w_pdfjs_require__(72);
                var Iterators = __w_pdfjs_require__(65);
                var returnThis = function() {
                    return this;
                };
                module.exports = function(IteratorConstructor, NAME, next) {
                    var TO_STRING_TAG = NAME + ' Iterator';
                    IteratorConstructor.prototype = create(IteratorPrototype, {next : createPropertyDescriptor(1, next)});
                    setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
                    Iterators[TO_STRING_TAG] = returnThis;
                    return IteratorConstructor;
                };

                /***/
            }),
            /* 68 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var fails = __w_pdfjs_require__(13);
                var getPrototypeOf = __w_pdfjs_require__(69);
                var createNonEnumerableProperty = __w_pdfjs_require__(25);
                var has = __w_pdfjs_require__(22);
                var wellKnownSymbol = __w_pdfjs_require__(55);
                var IS_PURE = __w_pdfjs_require__(36);
                var ITERATOR = wellKnownSymbol('iterator');
                var BUGGY_SAFARI_ITERATORS = false;
                var returnThis = function() {
                    return this;
                };
                var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;
                if ([].keys) {
                    arrayIterator = [].keys();
                    if (!('next' in arrayIterator))
                        BUGGY_SAFARI_ITERATORS = true;
                    else {
                        PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
                        if (PrototypeOfArrayIteratorPrototype !== Object.prototype)
                            IteratorPrototype = PrototypeOfArrayIteratorPrototype;
                    }
                }
                var NEW_ITERATOR_PROTOTYPE = IteratorPrototype == undefined || fails(function() {
                    var test = {};
                    return IteratorPrototype[ITERATOR].call(test) !== test;
                });
                if (NEW_ITERATOR_PROTOTYPE)
                    IteratorPrototype = {};
                if ((!IS_PURE || NEW_ITERATOR_PROTOTYPE) && !has(IteratorPrototype, ITERATOR)) {
                    createNonEnumerableProperty(IteratorPrototype, ITERATOR, returnThis);
                }
                module.exports = {
                    IteratorPrototype      : IteratorPrototype,
                    BUGGY_SAFARI_ITERATORS : BUGGY_SAFARI_ITERATORS
                };

                /***/
            }),
            /* 69 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var has = __w_pdfjs_require__(22);
                var toObject = __w_pdfjs_require__(70);
                var sharedKey = __w_pdfjs_require__(34);
                var CORRECT_PROTOTYPE_GETTER = __w_pdfjs_require__(71);
                var IE_PROTO = sharedKey('IE_PROTO');
                var ObjectPrototype = Object.prototype;
                module.exports = CORRECT_PROTOTYPE_GETTER ? Object.getPrototypeOf : function(O) {
                    O = toObject(O);
                    if (has(O, IE_PROTO))
                        return O[IE_PROTO];
                    if (typeof O.constructor == 'function' && O instanceof O.constructor) {
                        return O.constructor.prototype;
                    }
                    return O instanceof Object ? ObjectPrototype : null;
                };

                /***/
            }),
            /* 70 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var requireObjectCoercible = __w_pdfjs_require__(19);
                module.exports = function(argument) {
                    return Object(requireObjectCoercible(argument));
                };

                /***/
            }),
            /* 71 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var fails = __w_pdfjs_require__(13);
                module.exports = !fails(function() {
                    function F() {
                    }

                    F.prototype.constructor = null;
                    return Object.getPrototypeOf(new F()) !== F.prototype;
                });

                /***/
            }),
            /* 72 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var defineProperty = __w_pdfjs_require__(26).f;
                var has = __w_pdfjs_require__(22);
                var wellKnownSymbol = __w_pdfjs_require__(55);
                var TO_STRING_TAG = wellKnownSymbol('toStringTag');
                module.exports = function(it, TAG, STATIC) {
                    if (it && !has(it = STATIC ? it : it.prototype, TO_STRING_TAG)) {
                        defineProperty(it, TO_STRING_TAG, {
                            configurable : true,
                            value        : TAG
                        });
                    }
                };

                /***/
            }),
            /* 73 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var anObject = __w_pdfjs_require__(27);
                var aPossiblePrototype = __w_pdfjs_require__(74);
                module.exports = Object.setPrototypeOf || ('__proto__' in {} ? function() {
                    var CORRECT_SETTER = false;
                    var test = {};
                    var setter;
                    try {
                        setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
                        setter.call(test, []);
                        CORRECT_SETTER = test instanceof Array;
                    } catch (error) {
                    }
                    return function setPrototypeOf(O, proto) {
                        anObject(O);
                        aPossiblePrototype(proto);
                        if (CORRECT_SETTER)
                            setter.call(O, proto);
                        else
                            O.__proto__ = proto;
                        return O;
                    };
                }() : undefined);

                /***/
            }),
            /* 74 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var isObject = __w_pdfjs_require__(21);
                module.exports = function(it) {
                    if (!isObject(it) && it !== null) {
                        throw TypeError("Can't set " + String(it) + ' as a prototype');
                    }
                    return it;
                };

                /***/
            }),
            /* 75 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var $ = __w_pdfjs_require__(9);
                var iterate = __w_pdfjs_require__(76);
                var createProperty = __w_pdfjs_require__(84);
                $({
                    target : 'Object',
                    stat   : true
                }, {
                    fromEntries : function fromEntries(iterable) {
                        var obj = {};
                        iterate(iterable, function(k, v) {
                            createProperty(obj, k, v);
                        }, {AS_ENTRIES : true});
                        return obj;
                    }
                });

                /***/
            }),
            /* 76 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var anObject = __w_pdfjs_require__(27);
                var isArrayIteratorMethod = __w_pdfjs_require__(77);
                var toLength = __w_pdfjs_require__(46);
                var bind = __w_pdfjs_require__(78);
                var getIteratorMethod = __w_pdfjs_require__(80);
                var iteratorClose = __w_pdfjs_require__(83);
                var Result = function(stopped, result) {
                    this.stopped = stopped;
                    this.result = result;
                };
                module.exports = function(iterable, unboundFunction, options) {
                    var that = options && options.that;
                    var AS_ENTRIES = !!(options && options.AS_ENTRIES);
                    var IS_ITERATOR = !!(options && options.IS_ITERATOR);
                    var INTERRUPTED = !!(options && options.INTERRUPTED);
                    var fn = bind(unboundFunction, that, 1 + AS_ENTRIES + INTERRUPTED);
                    var iterator, iterFn, index, length, result, next, step;
                    var stop = function(condition) {
                        if (iterator)
                            iteratorClose(iterator);
                        return new Result(true, condition);
                    };
                    var callFn = function(value) {
                        if (AS_ENTRIES) {
                            anObject(value);
                            return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
                        }
                        return INTERRUPTED ? fn(value, stop) : fn(value);
                    };
                    if (IS_ITERATOR) {
                        iterator = iterable;
                    } else {
                        iterFn = getIteratorMethod(iterable);
                        if (typeof iterFn != 'function')
                            throw TypeError('Target is not iterable');
                        if (isArrayIteratorMethod(iterFn)) {
                            for (index = 0, length = toLength(iterable.length); length > index; index++) {
                                result = callFn(iterable[index]);
                                if (result && result instanceof Result)
                                    return result;
                            }
                            return new Result(false);
                        }
                        iterator = iterFn.call(iterable);
                    }
                    next = iterator.next;
                    while (!(step = next.call(iterator)).done) {
                        try {
                            result = callFn(step.value);
                        } catch (error) {
                            iteratorClose(iterator);
                            throw error;
                        }
                        if (typeof result == 'object' && result && result instanceof Result)
                            return result;
                    }
                    return new Result(false);
                };

                /***/
            }),
            /* 77 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var wellKnownSymbol = __w_pdfjs_require__(55);
                var Iterators = __w_pdfjs_require__(65);
                var ITERATOR = wellKnownSymbol('iterator');
                var ArrayPrototype = Array.prototype;
                module.exports = function(it) {
                    return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
                };

                /***/
            }),
            /* 78 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var aFunction = __w_pdfjs_require__(79);
                module.exports = function(fn, that, length) {
                    aFunction(fn);
                    if (that === undefined)
                        return fn;
                    switch (length) {
                        case 0:
                            return function() {
                                return fn.call(that);
                            };
                        case 1:
                            return function(a) {
                                return fn.call(that, a);
                            };
                        case 2:
                            return function(a, b) {
                                return fn.call(that, a, b);
                            };
                        case 3:
                            return function(a, b, c) {
                                return fn.call(that, a, b, c);
                            };
                    }
                    return function() {
                        return fn.apply(that, arguments);
                    };
                };

                /***/
            }),
            /* 79 */
            /***/ ((module) => {

                module.exports = function(it) {
                    if (typeof it != 'function') {
                        throw TypeError(String(it) + ' is not a function');
                    }
                    return it;
                };

                /***/
            }),
            /* 80 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var classof = __w_pdfjs_require__(81);
                var Iterators = __w_pdfjs_require__(65);
                var wellKnownSymbol = __w_pdfjs_require__(55);
                var ITERATOR = wellKnownSymbol('iterator');
                module.exports = function(it) {
                    if (it != undefined)
                        return it[ITERATOR] || it['@@iterator'] || Iterators[classof(it)];
                };

                /***/
            }),
            /* 81 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(82);
                var classofRaw = __w_pdfjs_require__(18);
                var wellKnownSymbol = __w_pdfjs_require__(55);
                var TO_STRING_TAG = wellKnownSymbol('toStringTag');
                var CORRECT_ARGUMENTS = classofRaw(function() {
                    return arguments;
                }()) == 'Arguments';
                var tryGet = function(it, key) {
                    try {
                        return it[key];
                    } catch (error) {
                    }
                };
                module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function(it) {
                    var O, tag, result;
                    return it === undefined ? 'Undefined' : it === null ? 'Null' : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG)) == 'string' ? tag : CORRECT_ARGUMENTS ? classofRaw(O) : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
                };

                /***/
            }),
            /* 82 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var wellKnownSymbol = __w_pdfjs_require__(55);
                var TO_STRING_TAG = wellKnownSymbol('toStringTag');
                var test = {};
                test[TO_STRING_TAG] = 'z';
                module.exports = String(test) === '[object z]';

                /***/
            }),
            /* 83 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var anObject = __w_pdfjs_require__(27);
                module.exports = function(iterator) {
                    var returnMethod = iterator['return'];
                    if (returnMethod !== undefined) {
                        return anObject(returnMethod.call(iterator)).value;
                    }
                };

                /***/
            }),
            /* 84 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var toPrimitive = __w_pdfjs_require__(20);
                var definePropertyModule = __w_pdfjs_require__(26);
                var createPropertyDescriptor = __w_pdfjs_require__(15);
                module.exports = function(object, key, value) {
                    var propertyKey = toPrimitive(key);
                    if (propertyKey in object)
                        definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
                    else
                        object[propertyKey] = value;
                };

                /***/
            }),
            /* 85 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                __w_pdfjs_require__(86);
                __w_pdfjs_require__(87);
                __w_pdfjs_require__(89);
                __w_pdfjs_require__(104);
                __w_pdfjs_require__(105);
                __w_pdfjs_require__(106);
                __w_pdfjs_require__(107);
                __w_pdfjs_require__(109);
                var path = __w_pdfjs_require__(42);
                module.exports = path.Promise;

                /***/
            }),
            /* 86 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var $ = __w_pdfjs_require__(9);
                var getPrototypeOf = __w_pdfjs_require__(69);
                var setPrototypeOf = __w_pdfjs_require__(73);
                var create = __w_pdfjs_require__(61);
                var createNonEnumerableProperty = __w_pdfjs_require__(25);
                var createPropertyDescriptor = __w_pdfjs_require__(15);
                var iterate = __w_pdfjs_require__(76);
                var $AggregateError = function AggregateError(errors, message) {
                    var that = this;
                    if (!(that instanceof $AggregateError))
                        return new $AggregateError(errors, message);
                    if (setPrototypeOf) {
                        that = setPrototypeOf(new Error(undefined), getPrototypeOf(that));
                    }
                    if (message !== undefined)
                        createNonEnumerableProperty(that, 'message', String(message));
                    var errorsArray = [];
                    iterate(errors, errorsArray.push, {that : errorsArray});
                    createNonEnumerableProperty(that, 'errors', errorsArray);
                    return that;
                };
                $AggregateError.prototype = create(Error.prototype, {
                    constructor : createPropertyDescriptor(5, $AggregateError),
                    message     : createPropertyDescriptor(5, ''),
                    name        : createPropertyDescriptor(5, 'AggregateError')
                });
                $({global : true}, {AggregateError : $AggregateError});

                /***/
            }),
            /* 87 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(82);
                var redefine = __w_pdfjs_require__(28);
                var toString = __w_pdfjs_require__(88);
                if (!TO_STRING_TAG_SUPPORT) {
                    redefine(Object.prototype, 'toString', toString, {unsafe : true});
                }

                /***/
            }),
            /* 88 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(82);
                var classof = __w_pdfjs_require__(81);
                module.exports = TO_STRING_TAG_SUPPORT ? {}.toString : function toString() {
                    return '[object ' + classof(this) + ']';
                };

                /***/
            }),
            /* 89 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var $ = __w_pdfjs_require__(9);
                var IS_PURE = __w_pdfjs_require__(36);
                var global = __w_pdfjs_require__(10);
                var getBuiltIn = __w_pdfjs_require__(41);
                var NativePromise = __w_pdfjs_require__(90);
                var redefine = __w_pdfjs_require__(28);
                var redefineAll = __w_pdfjs_require__(91);
                var setToStringTag = __w_pdfjs_require__(72);
                var setSpecies = __w_pdfjs_require__(92);
                var isObject = __w_pdfjs_require__(21);
                var aFunction = __w_pdfjs_require__(79);
                var anInstance = __w_pdfjs_require__(93);
                var inspectSource = __w_pdfjs_require__(30);
                var iterate = __w_pdfjs_require__(76);
                var checkCorrectnessOfIteration = __w_pdfjs_require__(94);
                var speciesConstructor = __w_pdfjs_require__(95);
                var task = __w_pdfjs_require__(96).set;
                var microtask = __w_pdfjs_require__(98);
                var promiseResolve = __w_pdfjs_require__(100);
                var hostReportErrors = __w_pdfjs_require__(102);
                var newPromiseCapabilityModule = __w_pdfjs_require__(101);
                var perform = __w_pdfjs_require__(103);
                var InternalStateModule = __w_pdfjs_require__(32);
                var isForced = __w_pdfjs_require__(51);
                var wellKnownSymbol = __w_pdfjs_require__(55);
                var IS_NODE = __w_pdfjs_require__(57);
                var V8_VERSION = __w_pdfjs_require__(58);
                var SPECIES = wellKnownSymbol('species');
                var PROMISE = 'Promise';
                var getInternalState = InternalStateModule.get;
                var setInternalState = InternalStateModule.set;
                var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
                var PromiseConstructor = NativePromise;
                var TypeError = global.TypeError;
                var document = global.document;
                var process = global.process;
                var $fetch = getBuiltIn('fetch');
                var newPromiseCapability = newPromiseCapabilityModule.f;
                var newGenericPromiseCapability = newPromiseCapability;
                var DISPATCH_EVENT = !!(document && document.createEvent && global.dispatchEvent);
                var NATIVE_REJECTION_EVENT = typeof PromiseRejectionEvent == 'function';
                var UNHANDLED_REJECTION = 'unhandledrejection';
                var REJECTION_HANDLED = 'rejectionhandled';
                var PENDING = 0;
                var FULFILLED = 1;
                var REJECTED = 2;
                var HANDLED = 1;
                var UNHANDLED = 2;
                var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;
                var FORCED = isForced(PROMISE, function() {
                    var GLOBAL_CORE_JS_PROMISE = inspectSource(PromiseConstructor) !== String(PromiseConstructor);
                    if (!GLOBAL_CORE_JS_PROMISE) {
                        if (V8_VERSION === 66)
                            return true;
                        if (!IS_NODE && !NATIVE_REJECTION_EVENT)
                            return true;
                    }
                    if (IS_PURE && !PromiseConstructor.prototype['finally'])
                        return true;
                    if (V8_VERSION >= 51 && /native code/.test(PromiseConstructor))
                        return false;
                    var promise = PromiseConstructor.resolve(1);
                    var FakePromise = function(exec) {
                        exec(function() {
                        }, function() {
                        });
                    };
                    var constructor = promise.constructor = {};
                    constructor[SPECIES] = FakePromise;
                    return !(promise.then(function() {
                    }) instanceof FakePromise);
                });
                var INCORRECT_ITERATION = FORCED || !checkCorrectnessOfIteration(function(iterable) {
                    PromiseConstructor.all(iterable)['catch'](function() {
                    });
                });
                var isThenable = function(it) {
                    var then;
                    return isObject(it) && typeof (then = it.then) == 'function' ? then : false;
                };
                var notify = function(state, isReject) {
                    if (state.notified)
                        return;
                    state.notified = true;
                    var chain = state.reactions;
                    microtask(function() {
                        var value = state.value;
                        var ok = state.state == FULFILLED;
                        var index = 0;
                        while (chain.length > index) {
                            var reaction = chain[index++];
                            var handler = ok ? reaction.ok : reaction.fail;
                            var resolve = reaction.resolve;
                            var reject = reaction.reject;
                            var domain = reaction.domain;
                            var result, then, exited;
                            try {
                                if (handler) {
                                    if (!ok) {
                                        if (state.rejection === UNHANDLED)
                                            onHandleUnhandled(state);
                                        state.rejection = HANDLED;
                                    }
                                    if (handler === true)
                                        result = value;
                                    else {
                                        if (domain)
                                            domain.enter();
                                        result = handler(value);
                                        if (domain) {
                                            domain.exit();
                                            exited = true;
                                        }
                                    }
                                    if (result === reaction.promise) {
                                        reject(TypeError('Promise-chain cycle'));
                                    } else if (then = isThenable(result)) {
                                        then.call(result, resolve, reject);
                                    } else
                                        resolve(result);
                                } else
                                    reject(value);
                            } catch (error) {
                                if (domain && !exited)
                                    domain.exit();
                                reject(error);
                            }
                        }
                        state.reactions = [];
                        state.notified = false;
                        if (isReject && !state.rejection)
                            onUnhandled(state);
                    });
                };
                var dispatchEvent = function(name, promise, reason) {
                    var event, handler;
                    if (DISPATCH_EVENT) {
                        event = document.createEvent('Event');
                        event.promise = promise;
                        event.reason = reason;
                        event.initEvent(name, false, true);
                        global.dispatchEvent(event);
                    } else
                        event = {
                            promise : promise,
                            reason  : reason
                        };
                    if (!NATIVE_REJECTION_EVENT && (handler = global['on' + name]))
                        handler(event);
                    else if (name === UNHANDLED_REJECTION)
                        hostReportErrors('Unhandled promise rejection', reason);
                };
                var onUnhandled = function(state) {
                    task.call(global, function() {
                        var promise = state.facade;
                        var value = state.value;
                        var IS_UNHANDLED = isUnhandled(state);
                        var result;
                        if (IS_UNHANDLED) {
                            result = perform(function() {
                                if (IS_NODE) {
                                    process.emit('unhandledRejection', value, promise);
                                } else
                                    dispatchEvent(UNHANDLED_REJECTION, promise, value);
                            });
                            state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
                            if (result.error)
                                throw result.value;
                        }
                    });
                };
                var isUnhandled = function(state) {
                    return state.rejection !== HANDLED && !state.parent;
                };
                var onHandleUnhandled = function(state) {
                    task.call(global, function() {
                        var promise = state.facade;
                        if (IS_NODE) {
                            process.emit('rejectionHandled', promise);
                        } else
                            dispatchEvent(REJECTION_HANDLED, promise, state.value);
                    });
                };
                var bind = function(fn, state, unwrap) {
                    return function(value) {
                        fn(state, value, unwrap);
                    };
                };
                var internalReject = function(state, value, unwrap) {
                    if (state.done)
                        return;
                    state.done = true;
                    if (unwrap)
                        state = unwrap;
                    state.value = value;
                    state.state = REJECTED;
                    notify(state, true);
                };
                var internalResolve = function(state, value, unwrap) {
                    if (state.done)
                        return;
                    state.done = true;
                    if (unwrap)
                        state = unwrap;
                    try {
                        if (state.facade === value)
                            throw TypeError("Promise can't be resolved itself");
                        var then = isThenable(value);
                        if (then) {
                            microtask(function() {
                                var wrapper = {done : false};
                                try {
                                    then.call(value, bind(internalResolve, wrapper, state), bind(internalReject, wrapper, state));
                                } catch (error) {
                                    internalReject(wrapper, error, state);
                                }
                            });
                        } else {
                            state.value = value;
                            state.state = FULFILLED;
                            notify(state, false);
                        }
                    } catch (error) {
                        internalReject({done : false}, error, state);
                    }
                };
                if (FORCED) {
                    PromiseConstructor = function Promise(executor) {
                        anInstance(this, PromiseConstructor, PROMISE);
                        aFunction(executor);
                        Internal.call(this);
                        var state = getInternalState(this);
                        try {
                            executor(bind(internalResolve, state), bind(internalReject, state));
                        } catch (error) {
                            internalReject(state, error);
                        }
                    };
                    Internal = function Promise(executor) {
                        setInternalState(this, {
                            type      : PROMISE,
                            done      : false,
                            notified  : false,
                            parent    : false,
                            reactions : [],
                            rejection : false,
                            state     : PENDING,
                            value     : undefined
                        });
                    };
                    Internal.prototype = redefineAll(PromiseConstructor.prototype, {
                        then    : function then(onFulfilled, onRejected) {
                            var state = getInternalPromiseState(this);
                            var reaction = newPromiseCapability(speciesConstructor(this, PromiseConstructor));
                            reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
                            reaction.fail = typeof onRejected == 'function' && onRejected;
                            reaction.domain = IS_NODE ? process.domain : undefined;
                            state.parent = true;
                            state.reactions.push(reaction);
                            if (state.state != PENDING)
                                notify(state, false);
                            return reaction.promise;
                        },
                        'catch' : function(onRejected) {
                            return this.then(undefined, onRejected);
                        }
                    });
                    OwnPromiseCapability = function() {
                        var promise = new Internal();
                        var state = getInternalState(promise);
                        this.promise = promise;
                        this.resolve = bind(internalResolve, state);
                        this.reject = bind(internalReject, state);
                    };
                    newPromiseCapabilityModule.f = newPromiseCapability = function(C) {
                        return C === PromiseConstructor || C === PromiseWrapper ? new OwnPromiseCapability(C) : newGenericPromiseCapability(C);
                    };
                    if (!IS_PURE && typeof NativePromise == 'function') {
                        nativeThen = NativePromise.prototype.then;
                        redefine(NativePromise.prototype, 'then', function then(onFulfilled, onRejected) {
                            var that = this;
                            return new PromiseConstructor(function(resolve, reject) {
                                nativeThen.call(that, resolve, reject);
                            }).then(onFulfilled, onRejected);
                        }, {unsafe : true});
                        if (typeof $fetch == 'function')
                            $({
                                global     : true,
                                enumerable : true,
                                forced     : true
                            }, {
                                fetch : function fetch(input) {
                                    return promiseResolve(PromiseConstructor, $fetch.apply(global, arguments));
                                }
                            });
                    }
                }
                $({
                    global : true,
                    wrap   : true,
                    forced : FORCED
                }, {Promise : PromiseConstructor});
                setToStringTag(PromiseConstructor, PROMISE, false, true);
                setSpecies(PROMISE);
                PromiseWrapper = getBuiltIn(PROMISE);
                $({
                    target : PROMISE,
                    stat   : true,
                    forced : FORCED
                }, {
                    reject : function reject(r) {
                        var capability = newPromiseCapability(this);
                        capability.reject.call(undefined, r);
                        return capability.promise;
                    }
                });
                $({
                    target : PROMISE,
                    stat   : true,
                    forced : IS_PURE || FORCED
                }, {
                    resolve : function resolve(x) {
                        return promiseResolve(IS_PURE && this === PromiseWrapper ? PromiseConstructor : this, x);
                    }
                });
                $({
                    target : PROMISE,
                    stat   : true,
                    forced : INCORRECT_ITERATION
                }, {
                    all  : function all(iterable) {
                        var C = this;
                        var capability = newPromiseCapability(C);
                        var resolve = capability.resolve;
                        var reject = capability.reject;
                        var result = perform(function() {
                            var $promiseResolve = aFunction(C.resolve);
                            var values = [];
                            var counter = 0;
                            var remaining = 1;
                            iterate(iterable, function(promise) {
                                var index = counter++;
                                var alreadyCalled = false;
                                values.push(undefined);
                                remaining++;
                                $promiseResolve.call(C, promise).then(function(value) {
                                    if (alreadyCalled)
                                        return;
                                    alreadyCalled = true;
                                    values[index] = value;
                                    --remaining || resolve(values);
                                }, reject);
                            });
                            --remaining || resolve(values);
                        });
                        if (result.error)
                            reject(result.value);
                        return capability.promise;
                    },
                    race : function race(iterable) {
                        var C = this;
                        var capability = newPromiseCapability(C);
                        var reject = capability.reject;
                        var result = perform(function() {
                            var $promiseResolve = aFunction(C.resolve);
                            iterate(iterable, function(promise) {
                                $promiseResolve.call(C, promise).then(capability.resolve, reject);
                            });
                        });
                        if (result.error)
                            reject(result.value);
                        return capability.promise;
                    }
                });

                /***/
            }),
            /* 90 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                module.exports = global.Promise;

                /***/
            }),
            /* 91 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var redefine = __w_pdfjs_require__(28);
                module.exports = function(target, src, options) {
                    for (var key in src)
                        redefine(target, key, src[key], options);
                    return target;
                };

                /***/
            }),
            /* 92 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var getBuiltIn = __w_pdfjs_require__(41);
                var definePropertyModule = __w_pdfjs_require__(26);
                var wellKnownSymbol = __w_pdfjs_require__(55);
                var DESCRIPTORS = __w_pdfjs_require__(12);
                var SPECIES = wellKnownSymbol('species');
                module.exports = function(CONSTRUCTOR_NAME) {
                    var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
                    var defineProperty = definePropertyModule.f;
                    if (DESCRIPTORS && Constructor && !Constructor[SPECIES]) {
                        defineProperty(Constructor, SPECIES, {
                            configurable : true,
                            get          : function() {
                                return this;
                            }
                        });
                    }
                };

                /***/
            }),
            /* 93 */
            /***/ ((module) => {

                module.exports = function(it, Constructor, name) {
                    if (!(it instanceof Constructor)) {
                        throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
                    }
                    return it;
                };

                /***/
            }),
            /* 94 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var wellKnownSymbol = __w_pdfjs_require__(55);
                var ITERATOR = wellKnownSymbol('iterator');
                var SAFE_CLOSING = false;
                try {
                    var called = 0;
                    var iteratorWithReturn = {
                        next     : function() {
                            return {done : !!called++};
                        },
                        'return' : function() {
                            SAFE_CLOSING = true;
                        }
                    };
                    iteratorWithReturn[ITERATOR] = function() {
                        return this;
                    };
                    Array.from(iteratorWithReturn, function() {
                        throw 2;
                    });
                } catch (error) {
                }
                module.exports = function(exec, SKIP_CLOSING) {
                    if (!SKIP_CLOSING && !SAFE_CLOSING)
                        return false;
                    var ITERATION_SUPPORT = false;
                    try {
                        var object = {};
                        object[ITERATOR] = function() {
                            return {
                                next : function() {
                                    return {done : ITERATION_SUPPORT = true};
                                }
                            };
                        };
                        exec(object);
                    } catch (error) {
                    }
                    return ITERATION_SUPPORT;
                };

                /***/
            }),
            /* 95 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var anObject = __w_pdfjs_require__(27);
                var aFunction = __w_pdfjs_require__(79);
                var wellKnownSymbol = __w_pdfjs_require__(55);
                var SPECIES = wellKnownSymbol('species');
                module.exports = function(O, defaultConstructor) {
                    var C = anObject(O).constructor;
                    var S;
                    return C === undefined || (S = anObject(C)[SPECIES]) == undefined ? defaultConstructor : aFunction(S);
                };

                /***/
            }),
            /* 96 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var fails = __w_pdfjs_require__(13);
                var bind = __w_pdfjs_require__(78);
                var html = __w_pdfjs_require__(64);
                var createElement = __w_pdfjs_require__(24);
                var IS_IOS = __w_pdfjs_require__(97);
                var IS_NODE = __w_pdfjs_require__(57);
                var location = global.location;
                var set = global.setImmediate;
                var clear = global.clearImmediate;
                var process = global.process;
                var MessageChannel = global.MessageChannel;
                var Dispatch = global.Dispatch;
                var counter = 0;
                var queue = {};
                var ONREADYSTATECHANGE = 'onreadystatechange';
                var defer, channel, port;
                var run = function(id) {
                    if (queue.hasOwnProperty(id)) {
                        var fn = queue[id];
                        delete queue[id];
                        fn();
                    }
                };
                var runner = function(id) {
                    return function() {
                        run(id);
                    };
                };
                var listener = function(event) {
                    run(event.data);
                };
                var post = function(id) {
                    global.postMessage(id + '', location.protocol + '//' + location.host);
                };
                if (!set || !clear) {
                    set = function setImmediate(fn) {
                        var args = [];
                        var i = 1;
                        while (arguments.length > i)
                            args.push(arguments[i++]);
                        queue[++counter] = function() {
                            (typeof fn == 'function' ? fn : Function(fn)).apply(undefined, args);
                        };
                        defer(counter);
                        return counter;
                    };
                    clear = function clearImmediate(id) {
                        delete queue[id];
                    };
                    if (IS_NODE) {
                        defer = function(id) {
                            process.nextTick(runner(id));
                        };
                    } else if (Dispatch && Dispatch.now) {
                        defer = function(id) {
                            Dispatch.now(runner(id));
                        };
                    } else if (MessageChannel && !IS_IOS) {
                        channel = new MessageChannel();
                        port = channel.port2;
                        channel.port1.onmessage = listener;
                        defer = bind(port.postMessage, port, 1);
                    } else if (global.addEventListener && typeof postMessage == 'function' && !global.importScripts && location && location.protocol !== 'file:' && !fails(post)) {
                        defer = post;
                        global.addEventListener('message', listener, false);
                    } else if (ONREADYSTATECHANGE in createElement('script')) {
                        defer = function(id) {
                            html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function() {
                                html.removeChild(this);
                                run(id);
                            };
                        };
                    } else {
                        defer = function(id) {
                            setTimeout(runner(id), 0);
                        };
                    }
                }
                module.exports = {
                    set   : set,
                    clear : clear
                };

                /***/
            }),
            /* 97 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var userAgent = __w_pdfjs_require__(59);
                module.exports = /(iphone|ipod|ipad).*applewebkit/i.test(userAgent);

                /***/
            }),
            /* 98 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var getOwnPropertyDescriptor = __w_pdfjs_require__(11).f;
                var macrotask = __w_pdfjs_require__(96).set;
                var IS_IOS = __w_pdfjs_require__(97);
                var IS_WEBOS_WEBKIT = __w_pdfjs_require__(99);
                var IS_NODE = __w_pdfjs_require__(57);
                var MutationObserver = global.MutationObserver || global.WebKitMutationObserver;
                var document = global.document;
                var process = global.process;
                var Promise = global.Promise;
                var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global, 'queueMicrotask');
                var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
                var flush, head, last, notify, toggle, node, promise, then;
                if (!queueMicrotask) {
                    flush = function() {
                        var parent, fn;
                        if (IS_NODE && (parent = process.domain))
                            parent.exit();
                        while (head) {
                            fn = head.fn;
                            head = head.next;
                            try {
                                fn();
                            } catch (error) {
                                if (head)
                                    notify();
                                else
                                    last = undefined;
                                throw error;
                            }
                        }
                        last = undefined;
                        if (parent)
                            parent.enter();
                    };
                    if (!IS_IOS && !IS_NODE && !IS_WEBOS_WEBKIT && MutationObserver && document) {
                        toggle = true;
                        node = document.createTextNode('');
                        new MutationObserver(flush).observe(node, {characterData : true});
                        notify = function() {
                            node.data = toggle = !toggle;
                        };
                    } else if (Promise && Promise.resolve) {
                        promise = Promise.resolve(undefined);
                        then = promise.then;
                        notify = function() {
                            then.call(promise, flush);
                        };
                    } else if (IS_NODE) {
                        notify = function() {
                            process.nextTick(flush);
                        };
                    } else {
                        notify = function() {
                            macrotask.call(global, flush);
                        };
                    }
                }
                module.exports = queueMicrotask || function(fn) {
                    var task = {
                        fn   : fn,
                        next : undefined
                    };
                    if (last)
                        last.next = task;
                    if (!head) {
                        head = task;
                        notify();
                    }
                    last = task;
                };

                /***/
            }),
            /* 99 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var userAgent = __w_pdfjs_require__(59);
                module.exports = /web0s(?!.*chrome)/i.test(userAgent);

                /***/
            }),
            /* 100 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var anObject = __w_pdfjs_require__(27);
                var isObject = __w_pdfjs_require__(21);
                var newPromiseCapability = __w_pdfjs_require__(101);
                module.exports = function(C, x) {
                    anObject(C);
                    if (isObject(x) && x.constructor === C)
                        return x;
                    var promiseCapability = newPromiseCapability.f(C);
                    var resolve = promiseCapability.resolve;
                    resolve(x);
                    return promiseCapability.promise;
                };

                /***/
            }),
            /* 101 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var aFunction = __w_pdfjs_require__(79);
                var PromiseCapability = function(C) {
                    var resolve, reject;
                    this.promise = new C(function($$resolve, $$reject) {
                        if (resolve !== undefined || reject !== undefined)
                            throw TypeError('Bad Promise constructor');
                        resolve = $$resolve;
                        reject = $$reject;
                    });
                    this.resolve = aFunction(resolve);
                    this.reject = aFunction(reject);
                };
                module.exports.f = function(C) {
                    return new PromiseCapability(C);
                };

                /***/
            }),
            /* 102 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                module.exports = function(a, b) {
                    var console = global.console;
                    if (console && console.error) {
                        arguments.length === 1 ? console.error(a) : console.error(a, b);
                    }
                };

                /***/
            }),
            /* 103 */
            /***/ ((module) => {

                module.exports = function(exec) {
                    try {
                        return {
                            error : false,
                            value : exec()
                        };
                    } catch (error) {
                        return {
                            error : true,
                            value : error
                        };
                    }
                };

                /***/
            }),
            /* 104 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var $ = __w_pdfjs_require__(9);
                var aFunction = __w_pdfjs_require__(79);
                var newPromiseCapabilityModule = __w_pdfjs_require__(101);
                var perform = __w_pdfjs_require__(103);
                var iterate = __w_pdfjs_require__(76);
                $({
                    target : 'Promise',
                    stat   : true
                }, {
                    allSettled : function allSettled(iterable) {
                        var C = this;
                        var capability = newPromiseCapabilityModule.f(C);
                        var resolve = capability.resolve;
                        var reject = capability.reject;
                        var result = perform(function() {
                            var promiseResolve = aFunction(C.resolve);
                            var values = [];
                            var counter = 0;
                            var remaining = 1;
                            iterate(iterable, function(promise) {
                                var index = counter++;
                                var alreadyCalled = false;
                                values.push(undefined);
                                remaining++;
                                promiseResolve.call(C, promise).then(function(value) {
                                    if (alreadyCalled)
                                        return;
                                    alreadyCalled = true;
                                    values[index] = {
                                        status : 'fulfilled',
                                        value  : value
                                    };
                                    --remaining || resolve(values);
                                }, function(error) {
                                    if (alreadyCalled)
                                        return;
                                    alreadyCalled = true;
                                    values[index] = {
                                        status : 'rejected',
                                        reason : error
                                    };
                                    --remaining || resolve(values);
                                });
                            });
                            --remaining || resolve(values);
                        });
                        if (result.error)
                            reject(result.value);
                        return capability.promise;
                    }
                });

                /***/
            }),
            /* 105 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var $ = __w_pdfjs_require__(9);
                var aFunction = __w_pdfjs_require__(79);
                var getBuiltIn = __w_pdfjs_require__(41);
                var newPromiseCapabilityModule = __w_pdfjs_require__(101);
                var perform = __w_pdfjs_require__(103);
                var iterate = __w_pdfjs_require__(76);
                var PROMISE_ANY_ERROR = 'No one promise resolved';
                $({
                    target : 'Promise',
                    stat   : true
                }, {
                    any : function any(iterable) {
                        var C = this;
                        var capability = newPromiseCapabilityModule.f(C);
                        var resolve = capability.resolve;
                        var reject = capability.reject;
                        var result = perform(function() {
                            var promiseResolve = aFunction(C.resolve);
                            var errors = [];
                            var counter = 0;
                            var remaining = 1;
                            var alreadyResolved = false;
                            iterate(iterable, function(promise) {
                                var index = counter++;
                                var alreadyRejected = false;
                                errors.push(undefined);
                                remaining++;
                                promiseResolve.call(C, promise).then(function(value) {
                                    if (alreadyRejected || alreadyResolved)
                                        return;
                                    alreadyResolved = true;
                                    resolve(value);
                                }, function(error) {
                                    if (alreadyRejected || alreadyResolved)
                                        return;
                                    alreadyRejected = true;
                                    errors[index] = error;
                                    --remaining || reject(new (getBuiltIn('AggregateError'))(errors, PROMISE_ANY_ERROR));
                                });
                            });
                            --remaining || reject(new (getBuiltIn('AggregateError'))(errors, PROMISE_ANY_ERROR));
                        });
                        if (result.error)
                            reject(result.value);
                        return capability.promise;
                    }
                });

                /***/
            }),
            /* 106 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var $ = __w_pdfjs_require__(9);
                var IS_PURE = __w_pdfjs_require__(36);
                var NativePromise = __w_pdfjs_require__(90);
                var fails = __w_pdfjs_require__(13);
                var getBuiltIn = __w_pdfjs_require__(41);
                var speciesConstructor = __w_pdfjs_require__(95);
                var promiseResolve = __w_pdfjs_require__(100);
                var redefine = __w_pdfjs_require__(28);
                var NON_GENERIC = !!NativePromise && fails(function() {
                    NativePromise.prototype['finally'].call({
                        then : function() {
                        }
                    }, function() {
                    });
                });
                $({
                    target : 'Promise',
                    proto  : true,
                    real   : true,
                    forced : NON_GENERIC
                }, {
                    'finally' : function(onFinally) {
                        var C = speciesConstructor(this, getBuiltIn('Promise'));
                        var isFunction = typeof onFinally == 'function';
                        return this.then(isFunction ? function(x) {
                            return promiseResolve(C, onFinally()).then(function() {
                                return x;
                            });
                        } : onFinally, isFunction ? function(e) {
                            return promiseResolve(C, onFinally()).then(function() {
                                throw e;
                            });
                        } : onFinally);
                    }
                });
                if (!IS_PURE && typeof NativePromise == 'function' && !NativePromise.prototype['finally']) {
                    redefine(NativePromise.prototype, 'finally', getBuiltIn('Promise').prototype['finally']);
                }

                /***/
            }),
            /* 107 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var charAt = __w_pdfjs_require__(108).charAt;
                var InternalStateModule = __w_pdfjs_require__(32);
                var defineIterator = __w_pdfjs_require__(66);
                var STRING_ITERATOR = 'String Iterator';
                var setInternalState = InternalStateModule.set;
                var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);
                defineIterator(String, 'String', function(iterated) {
                    setInternalState(this, {
                        type   : STRING_ITERATOR,
                        string : String(iterated),
                        index  : 0
                    });
                }, function next() {
                    var state = getInternalState(this);
                    var string = state.string;
                    var index = state.index;
                    var point;
                    if (index >= string.length)
                        return {
                            value : undefined,
                            done  : true
                        };
                    point = charAt(string, index);
                    state.index += point.length;
                    return {
                        value : point,
                        done  : false
                    };
                });

                /***/
            }),
            /* 108 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var toInteger = __w_pdfjs_require__(47);
                var requireObjectCoercible = __w_pdfjs_require__(19);
                var createMethod = function(CONVERT_TO_STRING) {
                    return function($this, pos) {
                        var S = String(requireObjectCoercible($this));
                        var position = toInteger(pos);
                        var size = S.length;
                        var first, second;
                        if (position < 0 || position >= size)
                            return CONVERT_TO_STRING ? '' : undefined;
                        first = S.charCodeAt(position);
                        return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = S.charCodeAt(position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? S.charAt(position) : first : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
                    };
                };
                module.exports = {
                    codeAt : createMethod(false),
                    charAt : createMethod(true)
                };

                /***/
            }),
            /* 109 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var DOMIterables = __w_pdfjs_require__(110);
                var ArrayIteratorMethods = __w_pdfjs_require__(53);
                var createNonEnumerableProperty = __w_pdfjs_require__(25);
                var wellKnownSymbol = __w_pdfjs_require__(55);
                var ITERATOR = wellKnownSymbol('iterator');
                var TO_STRING_TAG = wellKnownSymbol('toStringTag');
                var ArrayValues = ArrayIteratorMethods.values;
                for (var COLLECTION_NAME in DOMIterables) {
                    var Collection = global[COLLECTION_NAME];
                    var CollectionPrototype = Collection && Collection.prototype;
                    if (CollectionPrototype) {
                        if (CollectionPrototype[ITERATOR] !== ArrayValues)
                            try {
                                createNonEnumerableProperty(CollectionPrototype, ITERATOR, ArrayValues);
                            } catch (error) {
                                CollectionPrototype[ITERATOR] = ArrayValues;
                            }
                        if (!CollectionPrototype[TO_STRING_TAG]) {
                            createNonEnumerableProperty(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
                        }
                        if (DOMIterables[COLLECTION_NAME])
                            for (var METHOD_NAME in ArrayIteratorMethods) {
                                if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME])
                                    try {
                                        createNonEnumerableProperty(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
                                    } catch (error) {
                                        CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
                                    }
                            }
                    }
                }

                /***/
            }),
            /* 110 */
            /***/ ((module) => {

                module.exports = {
                    CSSRuleList          : 0,
                    CSSStyleDeclaration  : 0,
                    CSSValueList         : 0,
                    ClientRectList       : 0,
                    DOMRectList          : 0,
                    DOMStringList        : 0,
                    DOMTokenList         : 1,
                    DataTransferItemList : 0,
                    FileList             : 0,
                    HTMLAllCollection    : 0,
                    HTMLCollection       : 0,
                    HTMLFormElement      : 0,
                    HTMLSelectElement    : 0,
                    MediaList            : 0,
                    MimeTypeArray        : 0,
                    NamedNodeMap         : 0,
                    NodeList             : 1,
                    PaintRequestList     : 0,
                    Plugin               : 0,
                    PluginArray          : 0,
                    SVGLengthList        : 0,
                    SVGNumberList        : 0,
                    SVGPathSegList       : 0,
                    SVGPointList         : 0,
                    SVGStringList        : 0,
                    SVGTransformList     : 0,
                    SourceBufferList     : 0,
                    StyleSheetList       : 0,
                    TextTrackCueList     : 0,
                    TextTrackList        : 0,
                    TouchList            : 0
                };

                /***/
            }),
            /* 111 */
            /***/ (function(__unused_webpack_module, exports) {

                (function(global, factory) {
                    true ? factory(exports) : 0;
                }(this, function(exports) {
                    'use strict';
                    var SymbolPolyfill = typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol' ? Symbol : function(description) {
                        return "Symbol(" + description + ")";
                    };

                    function noop() {
                    }

                    function getGlobals() {
                        if (typeof self !== 'undefined') {
                            return self;
                        } else if (typeof window !== 'undefined') {
                            return window;
                        } else if (typeof global !== 'undefined') {
                            return global;
                        }
                        return undefined;
                    }

                    var globals = getGlobals();

                    function typeIsObject(x) {
                        return typeof x === 'object' && x !== null || typeof x === 'function';
                    }

                    var rethrowAssertionErrorRejection = noop;
                    var originalPromise = Promise;
                    var originalPromiseThen = Promise.prototype.then;
                    var originalPromiseResolve = Promise.resolve.bind(originalPromise);
                    var originalPromiseReject = Promise.reject.bind(originalPromise);

                    function newPromise(executor) {
                        return new originalPromise(executor);
                    }

                    function promiseResolvedWith(value) {
                        return originalPromiseResolve(value);
                    }

                    function promiseRejectedWith(reason) {
                        return originalPromiseReject(reason);
                    }

                    function PerformPromiseThen(promise, onFulfilled, onRejected) {
                        return originalPromiseThen.call(promise, onFulfilled, onRejected);
                    }

                    function uponPromise(promise, onFulfilled, onRejected) {
                        PerformPromiseThen(PerformPromiseThen(promise, onFulfilled, onRejected), undefined, rethrowAssertionErrorRejection);
                    }

                    function uponFulfillment(promise, onFulfilled) {
                        uponPromise(promise, onFulfilled);
                    }

                    function uponRejection(promise, onRejected) {
                        uponPromise(promise, undefined, onRejected);
                    }

                    function transformPromiseWith(promise, fulfillmentHandler, rejectionHandler) {
                        return PerformPromiseThen(promise, fulfillmentHandler, rejectionHandler);
                    }

                    function setPromiseIsHandledToTrue(promise) {
                        PerformPromiseThen(promise, undefined, rethrowAssertionErrorRejection);
                    }

                    var queueMicrotask = function() {
                        var globalQueueMicrotask = globals && globals.queueMicrotask;
                        if (typeof globalQueueMicrotask === 'function') {
                            return globalQueueMicrotask;
                        }
                        var resolvedPromise = promiseResolvedWith(undefined);
                        return function(fn) {
                            return PerformPromiseThen(resolvedPromise, fn);
                        };
                    }();

                    function reflectCall(F, V, args) {
                        if (typeof F !== 'function') {
                            throw new TypeError('Argument is not a function');
                        }
                        return Function.prototype.apply.call(F, V, args);
                    }

                    function promiseCall(F, V, args) {
                        try {
                            return promiseResolvedWith(reflectCall(F, V, args));
                        } catch (value) {
                            return promiseRejectedWith(value);
                        }
                    }

                    var QUEUE_MAX_ARRAY_SIZE = 16384;
                    var SimpleQueue = function() {
                        function SimpleQueue() {
                            this._cursor = 0;
                            this._size = 0;
                            this._front = {
                                _elements : [],
                                _next     : undefined
                            };
                            this._back = this._front;
                            this._cursor = 0;
                            this._size = 0;
                        }

                        Object.defineProperty(SimpleQueue.prototype, "length", {
                            get          : function() {
                                return this._size;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        SimpleQueue.prototype.push = function(element) {
                            var oldBack = this._back;
                            var newBack = oldBack;
                            if (oldBack._elements.length === QUEUE_MAX_ARRAY_SIZE - 1) {
                                newBack = {
                                    _elements : [],
                                    _next     : undefined
                                };
                            }
                            oldBack._elements.push(element);
                            if (newBack !== oldBack) {
                                this._back = newBack;
                                oldBack._next = newBack;
                            }
                            ++this._size;
                        };
                        SimpleQueue.prototype.shift = function() {
                            var oldFront = this._front;
                            var newFront = oldFront;
                            var oldCursor = this._cursor;
                            var newCursor = oldCursor + 1;
                            var elements = oldFront._elements;
                            var element = elements[oldCursor];
                            if (newCursor === QUEUE_MAX_ARRAY_SIZE) {
                                newFront = oldFront._next;
                                newCursor = 0;
                            }
                            --this._size;
                            this._cursor = newCursor;
                            if (oldFront !== newFront) {
                                this._front = newFront;
                            }
                            elements[oldCursor] = undefined;
                            return element;
                        };
                        SimpleQueue.prototype.forEach = function(callback) {
                            var i = this._cursor;
                            var node = this._front;
                            var elements = node._elements;
                            while (i !== elements.length || node._next !== undefined) {
                                if (i === elements.length) {
                                    node = node._next;
                                    elements = node._elements;
                                    i = 0;
                                    if (elements.length === 0) {
                                        break;
                                    }
                                }
                                callback(elements[i]);
                                ++i;
                            }
                        };
                        SimpleQueue.prototype.peek = function() {
                            var front = this._front;
                            var cursor = this._cursor;
                            return front._elements[cursor];
                        };
                        return SimpleQueue;
                    }();

                    function ReadableStreamReaderGenericInitialize(reader, stream) {
                        reader._ownerReadableStream = stream;
                        stream._reader = reader;
                        if (stream._state === 'readable') {
                            defaultReaderClosedPromiseInitialize(reader);
                        } else if (stream._state === 'closed') {
                            defaultReaderClosedPromiseInitializeAsResolved(reader);
                        } else {
                            defaultReaderClosedPromiseInitializeAsRejected(reader, stream._storedError);
                        }
                    }

                    function ReadableStreamReaderGenericCancel(reader, reason) {
                        var stream = reader._ownerReadableStream;
                        return ReadableStreamCancel(stream, reason);
                    }

                    function ReadableStreamReaderGenericRelease(reader) {
                        if (reader._ownerReadableStream._state === 'readable') {
                            defaultReaderClosedPromiseReject(reader, new TypeError("Reader was released and can no longer be used to monitor the stream's closedness"));
                        } else {
                            defaultReaderClosedPromiseResetToRejected(reader, new TypeError("Reader was released and can no longer be used to monitor the stream's closedness"));
                        }
                        reader._ownerReadableStream._reader = undefined;
                        reader._ownerReadableStream = undefined;
                    }

                    function readerLockException(name) {
                        return new TypeError('Cannot ' + name + ' a stream using a released reader');
                    }

                    function defaultReaderClosedPromiseInitialize(reader) {
                        reader._closedPromise = newPromise(function(resolve, reject) {
                            reader._closedPromise_resolve = resolve;
                            reader._closedPromise_reject = reject;
                        });
                    }

                    function defaultReaderClosedPromiseInitializeAsRejected(reader, reason) {
                        defaultReaderClosedPromiseInitialize(reader);
                        defaultReaderClosedPromiseReject(reader, reason);
                    }

                    function defaultReaderClosedPromiseInitializeAsResolved(reader) {
                        defaultReaderClosedPromiseInitialize(reader);
                        defaultReaderClosedPromiseResolve(reader);
                    }

                    function defaultReaderClosedPromiseReject(reader, reason) {
                        if (reader._closedPromise_reject === undefined) {
                            return;
                        }
                        setPromiseIsHandledToTrue(reader._closedPromise);
                        reader._closedPromise_reject(reason);
                        reader._closedPromise_resolve = undefined;
                        reader._closedPromise_reject = undefined;
                    }

                    function defaultReaderClosedPromiseResetToRejected(reader, reason) {
                        defaultReaderClosedPromiseInitializeAsRejected(reader, reason);
                    }

                    function defaultReaderClosedPromiseResolve(reader) {
                        if (reader._closedPromise_resolve === undefined) {
                            return;
                        }
                        reader._closedPromise_resolve(undefined);
                        reader._closedPromise_resolve = undefined;
                        reader._closedPromise_reject = undefined;
                    }

                    var AbortSteps = SymbolPolyfill('[[AbortSteps]]');
                    var ErrorSteps = SymbolPolyfill('[[ErrorSteps]]');
                    var CancelSteps = SymbolPolyfill('[[CancelSteps]]');
                    var PullSteps = SymbolPolyfill('[[PullSteps]]');
                    var NumberIsFinite = Number.isFinite || function(x) {
                        return typeof x === 'number' && isFinite(x);
                    };
                    var MathTrunc = Math.trunc || function(v) {
                        return v < 0 ? Math.ceil(v) : Math.floor(v);
                    };

                    function isDictionary(x) {
                        return typeof x === 'object' || typeof x === 'function';
                    }

                    function assertDictionary(obj, context) {
                        if (obj !== undefined && !isDictionary(obj)) {
                            throw new TypeError(context + " is not an object.");
                        }
                    }

                    function assertFunction(x, context) {
                        if (typeof x !== 'function') {
                            throw new TypeError(context + " is not a function.");
                        }
                    }

                    function isObject(x) {
                        return typeof x === 'object' && x !== null || typeof x === 'function';
                    }

                    function assertObject(x, context) {
                        if (!isObject(x)) {
                            throw new TypeError(context + " is not an object.");
                        }
                    }

                    function assertRequiredArgument(x, position, context) {
                        if (x === undefined) {
                            throw new TypeError("Parameter " + position + " is required in '" + context + "'.");
                        }
                    }

                    function assertRequiredField(x, field, context) {
                        if (x === undefined) {
                            throw new TypeError(field + " is required in '" + context + "'.");
                        }
                    }

                    function convertUnrestrictedDouble(value) {
                        return Number(value);
                    }

                    function censorNegativeZero(x) {
                        return x === 0 ? 0 : x;
                    }

                    function integerPart(x) {
                        return censorNegativeZero(MathTrunc(x));
                    }

                    function convertUnsignedLongLongWithEnforceRange(value, context) {
                        var lowerBound = 0;
                        var upperBound = Number.MAX_SAFE_INTEGER;
                        var x = Number(value);
                        x = censorNegativeZero(x);
                        if (!NumberIsFinite(x)) {
                            throw new TypeError(context + " is not a finite number");
                        }
                        x = integerPart(x);
                        if (x < lowerBound || x > upperBound) {
                            throw new TypeError(context + " is outside the accepted range of " + lowerBound + " to " + upperBound + ", inclusive");
                        }
                        if (!NumberIsFinite(x) || x === 0) {
                            return 0;
                        }
                        return x;
                    }

                    function assertReadableStream(x, context) {
                        if (!IsReadableStream(x)) {
                            throw new TypeError(context + " is not a ReadableStream.");
                        }
                    }

                    function AcquireReadableStreamDefaultReader(stream) {
                        return new ReadableStreamDefaultReader(stream);
                    }

                    function ReadableStreamAddReadRequest(stream, readRequest) {
                        stream._reader._readRequests.push(readRequest);
                    }

                    function ReadableStreamFulfillReadRequest(stream, chunk, done) {
                        var reader = stream._reader;
                        var readRequest = reader._readRequests.shift();
                        if (done) {
                            readRequest._closeSteps();
                        } else {
                            readRequest._chunkSteps(chunk);
                        }
                    }

                    function ReadableStreamGetNumReadRequests(stream) {
                        return stream._reader._readRequests.length;
                    }

                    function ReadableStreamHasDefaultReader(stream) {
                        var reader = stream._reader;
                        if (reader === undefined) {
                            return false;
                        }
                        if (!IsReadableStreamDefaultReader(reader)) {
                            return false;
                        }
                        return true;
                    }

                    var ReadableStreamDefaultReader = function() {
                        function ReadableStreamDefaultReader(stream) {
                            assertRequiredArgument(stream, 1, 'ReadableStreamDefaultReader');
                            assertReadableStream(stream, 'First parameter');
                            if (IsReadableStreamLocked(stream)) {
                                throw new TypeError('This stream has already been locked for exclusive reading by another reader');
                            }
                            ReadableStreamReaderGenericInitialize(this, stream);
                            this._readRequests = new SimpleQueue();
                        }

                        Object.defineProperty(ReadableStreamDefaultReader.prototype, "closed", {
                            get          : function() {
                                if (!IsReadableStreamDefaultReader(this)) {
                                    return promiseRejectedWith(defaultReaderBrandCheckException('closed'));
                                }
                                return this._closedPromise;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        ReadableStreamDefaultReader.prototype.cancel = function(reason) {
                            if (reason === void 0) {
                                reason = undefined;
                            }
                            if (!IsReadableStreamDefaultReader(this)) {
                                return promiseRejectedWith(defaultReaderBrandCheckException('cancel'));
                            }
                            if (this._ownerReadableStream === undefined) {
                                return promiseRejectedWith(readerLockException('cancel'));
                            }
                            return ReadableStreamReaderGenericCancel(this, reason);
                        };
                        ReadableStreamDefaultReader.prototype.read = function() {
                            if (!IsReadableStreamDefaultReader(this)) {
                                return promiseRejectedWith(defaultReaderBrandCheckException('read'));
                            }
                            if (this._ownerReadableStream === undefined) {
                                return promiseRejectedWith(readerLockException('read from'));
                            }
                            var resolvePromise;
                            var rejectPromise;
                            var promise = newPromise(function(resolve, reject) {
                                resolvePromise = resolve;
                                rejectPromise = reject;
                            });
                            var readRequest = {
                                _chunkSteps : function(chunk) {
                                    return resolvePromise({
                                        value : chunk,
                                        done  : false
                                    });
                                },
                                _closeSteps : function() {
                                    return resolvePromise({
                                        value : undefined,
                                        done  : true
                                    });
                                },
                                _errorSteps : function(e) {
                                    return rejectPromise(e);
                                }
                            };
                            ReadableStreamDefaultReaderRead(this, readRequest);
                            return promise;
                        };
                        ReadableStreamDefaultReader.prototype.releaseLock = function() {
                            if (!IsReadableStreamDefaultReader(this)) {
                                throw defaultReaderBrandCheckException('releaseLock');
                            }
                            if (this._ownerReadableStream === undefined) {
                                return;
                            }
                            if (this._readRequests.length > 0) {
                                throw new TypeError('Tried to release a reader lock when that reader has pending read() calls un-settled');
                            }
                            ReadableStreamReaderGenericRelease(this);
                        };
                        return ReadableStreamDefaultReader;
                    }();
                    Object.defineProperties(ReadableStreamDefaultReader.prototype, {
                        cancel      : {enumerable : true},
                        read        : {enumerable : true},
                        releaseLock : {enumerable : true},
                        closed      : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(ReadableStreamDefaultReader.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'ReadableStreamDefaultReader',
                            configurable : true
                        });
                    }

                    function IsReadableStreamDefaultReader(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_readRequests')) {
                            return false;
                        }
                        return true;
                    }

                    function ReadableStreamDefaultReaderRead(reader, readRequest) {
                        var stream = reader._ownerReadableStream;
                        stream._disturbed = true;
                        if (stream._state === 'closed') {
                            readRequest._closeSteps();
                        } else if (stream._state === 'errored') {
                            readRequest._errorSteps(stream._storedError);
                        } else {
                            stream._readableStreamController[PullSteps](readRequest);
                        }
                    }

                    function defaultReaderBrandCheckException(name) {
                        return new TypeError("ReadableStreamDefaultReader.prototype." + name + " can only be used on a ReadableStreamDefaultReader");
                    }

                    var _a;
                    var AsyncIteratorPrototype;
                    if (typeof SymbolPolyfill.asyncIterator === 'symbol') {
                        AsyncIteratorPrototype = (_a = {}, _a[SymbolPolyfill.asyncIterator] = function() {
                            return this;
                        }, _a);
                        Object.defineProperty(AsyncIteratorPrototype, SymbolPolyfill.asyncIterator, {enumerable : false});
                    }
                    var ReadableStreamAsyncIteratorImpl = function() {
                        function ReadableStreamAsyncIteratorImpl(reader, preventCancel) {
                            this._ongoingPromise = undefined;
                            this._isFinished = false;
                            this._reader = reader;
                            this._preventCancel = preventCancel;
                        }

                        ReadableStreamAsyncIteratorImpl.prototype.next = function() {
                            var _this = this;
                            var nextSteps = function() {
                                return _this._nextSteps();
                            };
                            this._ongoingPromise = this._ongoingPromise ? transformPromiseWith(this._ongoingPromise, nextSteps, nextSteps) : nextSteps();
                            return this._ongoingPromise;
                        };
                        ReadableStreamAsyncIteratorImpl.prototype.return = function(value) {
                            var _this = this;
                            var returnSteps = function() {
                                return _this._returnSteps(value);
                            };
                            return this._ongoingPromise ? transformPromiseWith(this._ongoingPromise, returnSteps, returnSteps) : returnSteps();
                        };
                        ReadableStreamAsyncIteratorImpl.prototype._nextSteps = function() {
                            var _this = this;
                            if (this._isFinished) {
                                return Promise.resolve({
                                    value : undefined,
                                    done  : true
                                });
                            }
                            var reader = this._reader;
                            if (reader._ownerReadableStream === undefined) {
                                return promiseRejectedWith(readerLockException('iterate'));
                            }
                            var resolvePromise;
                            var rejectPromise;
                            var promise = newPromise(function(resolve, reject) {
                                resolvePromise = resolve;
                                rejectPromise = reject;
                            });
                            var readRequest = {
                                _chunkSteps : function(chunk) {
                                    _this._ongoingPromise = undefined;
                                    queueMicrotask(function() {
                                        return resolvePromise({
                                            value : chunk,
                                            done  : false
                                        });
                                    });
                                },
                                _closeSteps : function() {
                                    _this._ongoingPromise = undefined;
                                    _this._isFinished = true;
                                    ReadableStreamReaderGenericRelease(reader);
                                    resolvePromise({
                                        value : undefined,
                                        done  : true
                                    });
                                },
                                _errorSteps : function(reason) {
                                    _this._ongoingPromise = undefined;
                                    _this._isFinished = true;
                                    ReadableStreamReaderGenericRelease(reader);
                                    rejectPromise(reason);
                                }
                            };
                            ReadableStreamDefaultReaderRead(reader, readRequest);
                            return promise;
                        };
                        ReadableStreamAsyncIteratorImpl.prototype._returnSteps = function(value) {
                            if (this._isFinished) {
                                return Promise.resolve({
                                    value : value,
                                    done  : true
                                });
                            }
                            this._isFinished = true;
                            var reader = this._reader;
                            if (reader._ownerReadableStream === undefined) {
                                return promiseRejectedWith(readerLockException('finish iterating'));
                            }
                            if (!this._preventCancel) {
                                var result = ReadableStreamReaderGenericCancel(reader, value);
                                ReadableStreamReaderGenericRelease(reader);
                                return transformPromiseWith(result, function() {
                                    return {
                                        value : value,
                                        done  : true
                                    };
                                });
                            }
                            ReadableStreamReaderGenericRelease(reader);
                            return promiseResolvedWith({
                                value : value,
                                done  : true
                            });
                        };
                        return ReadableStreamAsyncIteratorImpl;
                    }();
                    var ReadableStreamAsyncIteratorPrototype = {
                        next   : function() {
                            if (!IsReadableStreamAsyncIterator(this)) {
                                return promiseRejectedWith(streamAsyncIteratorBrandCheckException('next'));
                            }
                            return this._asyncIteratorImpl.next();
                        },
                        return : function(value) {
                            if (!IsReadableStreamAsyncIterator(this)) {
                                return promiseRejectedWith(streamAsyncIteratorBrandCheckException('return'));
                            }
                            return this._asyncIteratorImpl.return(value);
                        }
                    };
                    if (AsyncIteratorPrototype !== undefined) {
                        Object.setPrototypeOf(ReadableStreamAsyncIteratorPrototype, AsyncIteratorPrototype);
                    }

                    function AcquireReadableStreamAsyncIterator(stream, preventCancel) {
                        var reader = AcquireReadableStreamDefaultReader(stream);
                        var impl = new ReadableStreamAsyncIteratorImpl(reader, preventCancel);
                        var iterator = Object.create(ReadableStreamAsyncIteratorPrototype);
                        iterator._asyncIteratorImpl = impl;
                        return iterator;
                    }

                    function IsReadableStreamAsyncIterator(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_asyncIteratorImpl')) {
                            return false;
                        }
                        return true;
                    }

                    function streamAsyncIteratorBrandCheckException(name) {
                        return new TypeError("ReadableStreamAsyncIterator." + name + " can only be used on a ReadableSteamAsyncIterator");
                    }

                    var NumberIsNaN = Number.isNaN || function(x) {
                        return x !== x;
                    };

                    function IsFiniteNonNegativeNumber(v) {
                        if (!IsNonNegativeNumber(v)) {
                            return false;
                        }
                        if (v === Infinity) {
                            return false;
                        }
                        return true;
                    }

                    function IsNonNegativeNumber(v) {
                        if (typeof v !== 'number') {
                            return false;
                        }
                        if (NumberIsNaN(v)) {
                            return false;
                        }
                        if (v < 0) {
                            return false;
                        }
                        return true;
                    }

                    function DequeueValue(container) {
                        var pair = container._queue.shift();
                        container._queueTotalSize -= pair.size;
                        if (container._queueTotalSize < 0) {
                            container._queueTotalSize = 0;
                        }
                        return pair.value;
                    }

                    function EnqueueValueWithSize(container, value, size) {
                        size = Number(size);
                        if (!IsFiniteNonNegativeNumber(size)) {
                            throw new RangeError('Size must be a finite, non-NaN, non-negative number.');
                        }
                        container._queue.push({
                            value : value,
                            size  : size
                        });
                        container._queueTotalSize += size;
                    }

                    function PeekQueueValue(container) {
                        var pair = container._queue.peek();
                        return pair.value;
                    }

                    function ResetQueue(container) {
                        container._queue = new SimpleQueue();
                        container._queueTotalSize = 0;
                    }

                    function CreateArrayFromList(elements) {
                        return elements.slice();
                    }

                    function CopyDataBlockBytes(dest, destOffset, src, srcOffset, n) {
                        new Uint8Array(dest).set(new Uint8Array(src, srcOffset, n), destOffset);
                    }

                    function TransferArrayBuffer(O) {
                        return O;
                    }

                    function IsDetachedBuffer(O) {
                        return false;
                    }

                    var ReadableStreamBYOBRequest = function() {
                        function ReadableStreamBYOBRequest() {
                            throw new TypeError('Illegal constructor');
                        }

                        Object.defineProperty(ReadableStreamBYOBRequest.prototype, "view", {
                            get          : function() {
                                if (!IsReadableStreamBYOBRequest(this)) {
                                    throw byobRequestBrandCheckException('view');
                                }
                                return this._view;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        ReadableStreamBYOBRequest.prototype.respond = function(bytesWritten) {
                            if (!IsReadableStreamBYOBRequest(this)) {
                                throw byobRequestBrandCheckException('respond');
                            }
                            assertRequiredArgument(bytesWritten, 1, 'respond');
                            bytesWritten = convertUnsignedLongLongWithEnforceRange(bytesWritten, 'First parameter');
                            if (this._associatedReadableByteStreamController === undefined) {
                                throw new TypeError('This BYOB request has been invalidated');
                            }
                            if (IsDetachedBuffer(this._view.buffer)) ;
                            ReadableByteStreamControllerRespond(this._associatedReadableByteStreamController, bytesWritten);
                        };
                        ReadableStreamBYOBRequest.prototype.respondWithNewView = function(view) {
                            if (!IsReadableStreamBYOBRequest(this)) {
                                throw byobRequestBrandCheckException('respondWithNewView');
                            }
                            assertRequiredArgument(view, 1, 'respondWithNewView');
                            if (!ArrayBuffer.isView(view)) {
                                throw new TypeError('You can only respond with array buffer views');
                            }
                            if (view.byteLength === 0) {
                                throw new TypeError('chunk must have non-zero byteLength');
                            }
                            if (view.buffer.byteLength === 0) {
                                throw new TypeError("chunk's buffer must have non-zero byteLength");
                            }
                            if (this._associatedReadableByteStreamController === undefined) {
                                throw new TypeError('This BYOB request has been invalidated');
                            }
                            ReadableByteStreamControllerRespondWithNewView(this._associatedReadableByteStreamController, view);
                        };
                        return ReadableStreamBYOBRequest;
                    }();
                    Object.defineProperties(ReadableStreamBYOBRequest.prototype, {
                        respond            : {enumerable : true},
                        respondWithNewView : {enumerable : true},
                        view               : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(ReadableStreamBYOBRequest.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'ReadableStreamBYOBRequest',
                            configurable : true
                        });
                    }
                    var ReadableByteStreamController = function() {
                        function ReadableByteStreamController() {
                            throw new TypeError('Illegal constructor');
                        }

                        Object.defineProperty(ReadableByteStreamController.prototype, "byobRequest", {
                            get          : function() {
                                if (!IsReadableByteStreamController(this)) {
                                    throw byteStreamControllerBrandCheckException('byobRequest');
                                }
                                if (this._byobRequest === null && this._pendingPullIntos.length > 0) {
                                    var firstDescriptor = this._pendingPullIntos.peek();
                                    var view = new Uint8Array(firstDescriptor.buffer, firstDescriptor.byteOffset + firstDescriptor.bytesFilled, firstDescriptor.byteLength - firstDescriptor.bytesFilled);
                                    var byobRequest = Object.create(ReadableStreamBYOBRequest.prototype);
                                    SetUpReadableStreamBYOBRequest(byobRequest, this, view);
                                    this._byobRequest = byobRequest;
                                }
                                return this._byobRequest;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        Object.defineProperty(ReadableByteStreamController.prototype, "desiredSize", {
                            get          : function() {
                                if (!IsReadableByteStreamController(this)) {
                                    throw byteStreamControllerBrandCheckException('desiredSize');
                                }
                                return ReadableByteStreamControllerGetDesiredSize(this);
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        ReadableByteStreamController.prototype.close = function() {
                            if (!IsReadableByteStreamController(this)) {
                                throw byteStreamControllerBrandCheckException('close');
                            }
                            if (this._closeRequested) {
                                throw new TypeError('The stream has already been closed; do not close it again!');
                            }
                            var state = this._controlledReadableByteStream._state;
                            if (state !== 'readable') {
                                throw new TypeError("The stream (in " + state + " state) is not in the readable state and cannot be closed");
                            }
                            ReadableByteStreamControllerClose(this);
                        };
                        ReadableByteStreamController.prototype.enqueue = function(chunk) {
                            if (!IsReadableByteStreamController(this)) {
                                throw byteStreamControllerBrandCheckException('enqueue');
                            }
                            assertRequiredArgument(chunk, 1, 'enqueue');
                            if (!ArrayBuffer.isView(chunk)) {
                                throw new TypeError('chunk must be an array buffer view');
                            }
                            if (chunk.byteLength === 0) {
                                throw new TypeError('chunk must have non-zero byteLength');
                            }
                            if (chunk.buffer.byteLength === 0) {
                                throw new TypeError("chunk's buffer must have non-zero byteLength");
                            }
                            if (this._closeRequested) {
                                throw new TypeError('stream is closed or draining');
                            }
                            var state = this._controlledReadableByteStream._state;
                            if (state !== 'readable') {
                                throw new TypeError("The stream (in " + state + " state) is not in the readable state and cannot be enqueued to");
                            }
                            ReadableByteStreamControllerEnqueue(this, chunk);
                        };
                        ReadableByteStreamController.prototype.error = function(e) {
                            if (e === void 0) {
                                e = undefined;
                            }
                            if (!IsReadableByteStreamController(this)) {
                                throw byteStreamControllerBrandCheckException('error');
                            }
                            ReadableByteStreamControllerError(this, e);
                        };
                        ReadableByteStreamController.prototype[CancelSteps] = function(reason) {
                            if (this._pendingPullIntos.length > 0) {
                                var firstDescriptor = this._pendingPullIntos.peek();
                                firstDescriptor.bytesFilled = 0;
                            }
                            ResetQueue(this);
                            var result = this._cancelAlgorithm(reason);
                            ReadableByteStreamControllerClearAlgorithms(this);
                            return result;
                        };
                        ReadableByteStreamController.prototype[PullSteps] = function(readRequest) {
                            var stream = this._controlledReadableByteStream;
                            if (this._queueTotalSize > 0) {
                                var entry = this._queue.shift();
                                this._queueTotalSize -= entry.byteLength;
                                ReadableByteStreamControllerHandleQueueDrain(this);
                                var view = new Uint8Array(entry.buffer, entry.byteOffset, entry.byteLength);
                                readRequest._chunkSteps(view);
                                return;
                            }
                            var autoAllocateChunkSize = this._autoAllocateChunkSize;
                            if (autoAllocateChunkSize !== undefined) {
                                var buffer = void 0;
                                try {
                                    buffer = new ArrayBuffer(autoAllocateChunkSize);
                                } catch (bufferE) {
                                    readRequest._errorSteps(bufferE);
                                    return;
                                }
                                var pullIntoDescriptor = {
                                    buffer          : buffer,
                                    byteOffset      : 0,
                                    byteLength      : autoAllocateChunkSize,
                                    bytesFilled     : 0,
                                    elementSize     : 1,
                                    viewConstructor : Uint8Array,
                                    readerType      : 'default'
                                };
                                this._pendingPullIntos.push(pullIntoDescriptor);
                            }
                            ReadableStreamAddReadRequest(stream, readRequest);
                            ReadableByteStreamControllerCallPullIfNeeded(this);
                        };
                        return ReadableByteStreamController;
                    }();
                    Object.defineProperties(ReadableByteStreamController.prototype, {
                        close       : {enumerable : true},
                        enqueue     : {enumerable : true},
                        error       : {enumerable : true},
                        byobRequest : {enumerable : true},
                        desiredSize : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(ReadableByteStreamController.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'ReadableByteStreamController',
                            configurable : true
                        });
                    }

                    function IsReadableByteStreamController(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_controlledReadableByteStream')) {
                            return false;
                        }
                        return true;
                    }

                    function IsReadableStreamBYOBRequest(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_associatedReadableByteStreamController')) {
                            return false;
                        }
                        return true;
                    }

                    function ReadableByteStreamControllerCallPullIfNeeded(controller) {
                        var shouldPull = ReadableByteStreamControllerShouldCallPull(controller);
                        if (!shouldPull) {
                            return;
                        }
                        if (controller._pulling) {
                            controller._pullAgain = true;
                            return;
                        }
                        controller._pulling = true;
                        var pullPromise = controller._pullAlgorithm();
                        uponPromise(pullPromise, function() {
                            controller._pulling = false;
                            if (controller._pullAgain) {
                                controller._pullAgain = false;
                                ReadableByteStreamControllerCallPullIfNeeded(controller);
                            }
                        }, function(e) {
                            ReadableByteStreamControllerError(controller, e);
                        });
                    }

                    function ReadableByteStreamControllerClearPendingPullIntos(controller) {
                        ReadableByteStreamControllerInvalidateBYOBRequest(controller);
                        controller._pendingPullIntos = new SimpleQueue();
                    }

                    function ReadableByteStreamControllerCommitPullIntoDescriptor(stream, pullIntoDescriptor) {
                        var done = false;
                        if (stream._state === 'closed') {
                            done = true;
                        }
                        var filledView = ReadableByteStreamControllerConvertPullIntoDescriptor(pullIntoDescriptor);
                        if (pullIntoDescriptor.readerType === 'default') {
                            ReadableStreamFulfillReadRequest(stream, filledView, done);
                        } else {
                            ReadableStreamFulfillReadIntoRequest(stream, filledView, done);
                        }
                    }

                    function ReadableByteStreamControllerConvertPullIntoDescriptor(pullIntoDescriptor) {
                        var bytesFilled = pullIntoDescriptor.bytesFilled;
                        var elementSize = pullIntoDescriptor.elementSize;
                        return new pullIntoDescriptor.viewConstructor(pullIntoDescriptor.buffer, pullIntoDescriptor.byteOffset, bytesFilled / elementSize);
                    }

                    function ReadableByteStreamControllerEnqueueChunkToQueue(controller, buffer, byteOffset, byteLength) {
                        controller._queue.push({
                            buffer     : buffer,
                            byteOffset : byteOffset,
                            byteLength : byteLength
                        });
                        controller._queueTotalSize += byteLength;
                    }

                    function ReadableByteStreamControllerFillPullIntoDescriptorFromQueue(controller, pullIntoDescriptor) {
                        var elementSize = pullIntoDescriptor.elementSize;
                        var currentAlignedBytes = pullIntoDescriptor.bytesFilled - pullIntoDescriptor.bytesFilled % elementSize;
                        var maxBytesToCopy = Math.min(controller._queueTotalSize, pullIntoDescriptor.byteLength - pullIntoDescriptor.bytesFilled);
                        var maxBytesFilled = pullIntoDescriptor.bytesFilled + maxBytesToCopy;
                        var maxAlignedBytes = maxBytesFilled - maxBytesFilled % elementSize;
                        var totalBytesToCopyRemaining = maxBytesToCopy;
                        var ready = false;
                        if (maxAlignedBytes > currentAlignedBytes) {
                            totalBytesToCopyRemaining = maxAlignedBytes - pullIntoDescriptor.bytesFilled;
                            ready = true;
                        }
                        var queue = controller._queue;
                        while (totalBytesToCopyRemaining > 0) {
                            var headOfQueue = queue.peek();
                            var bytesToCopy = Math.min(totalBytesToCopyRemaining, headOfQueue.byteLength);
                            var destStart = pullIntoDescriptor.byteOffset + pullIntoDescriptor.bytesFilled;
                            CopyDataBlockBytes(pullIntoDescriptor.buffer, destStart, headOfQueue.buffer, headOfQueue.byteOffset, bytesToCopy);
                            if (headOfQueue.byteLength === bytesToCopy) {
                                queue.shift();
                            } else {
                                headOfQueue.byteOffset += bytesToCopy;
                                headOfQueue.byteLength -= bytesToCopy;
                            }
                            controller._queueTotalSize -= bytesToCopy;
                            ReadableByteStreamControllerFillHeadPullIntoDescriptor(controller, bytesToCopy, pullIntoDescriptor);
                            totalBytesToCopyRemaining -= bytesToCopy;
                        }
                        return ready;
                    }

                    function ReadableByteStreamControllerFillHeadPullIntoDescriptor(controller, size, pullIntoDescriptor) {
                        ReadableByteStreamControllerInvalidateBYOBRequest(controller);
                        pullIntoDescriptor.bytesFilled += size;
                    }

                    function ReadableByteStreamControllerHandleQueueDrain(controller) {
                        if (controller._queueTotalSize === 0 && controller._closeRequested) {
                            ReadableByteStreamControllerClearAlgorithms(controller);
                            ReadableStreamClose(controller._controlledReadableByteStream);
                        } else {
                            ReadableByteStreamControllerCallPullIfNeeded(controller);
                        }
                    }

                    function ReadableByteStreamControllerInvalidateBYOBRequest(controller) {
                        if (controller._byobRequest === null) {
                            return;
                        }
                        controller._byobRequest._associatedReadableByteStreamController = undefined;
                        controller._byobRequest._view = null;
                        controller._byobRequest = null;
                    }

                    function ReadableByteStreamControllerProcessPullIntoDescriptorsUsingQueue(controller) {
                        while (controller._pendingPullIntos.length > 0) {
                            if (controller._queueTotalSize === 0) {
                                return;
                            }
                            var pullIntoDescriptor = controller._pendingPullIntos.peek();
                            if (ReadableByteStreamControllerFillPullIntoDescriptorFromQueue(controller, pullIntoDescriptor)) {
                                ReadableByteStreamControllerShiftPendingPullInto(controller);
                                ReadableByteStreamControllerCommitPullIntoDescriptor(controller._controlledReadableByteStream, pullIntoDescriptor);
                            }
                        }
                    }

                    function ReadableByteStreamControllerPullInto(controller, view, readIntoRequest) {
                        var stream = controller._controlledReadableByteStream;
                        var elementSize = 1;
                        if (view.constructor !== DataView) {
                            elementSize = view.constructor.BYTES_PER_ELEMENT;
                        }
                        var ctor = view.constructor;
                        var buffer = TransferArrayBuffer(view.buffer);
                        var pullIntoDescriptor = {
                            buffer          : buffer,
                            byteOffset      : view.byteOffset,
                            byteLength      : view.byteLength,
                            bytesFilled     : 0,
                            elementSize     : elementSize,
                            viewConstructor : ctor,
                            readerType      : 'byob'
                        };
                        if (controller._pendingPullIntos.length > 0) {
                            controller._pendingPullIntos.push(pullIntoDescriptor);
                            ReadableStreamAddReadIntoRequest(stream, readIntoRequest);
                            return;
                        }
                        if (stream._state === 'closed') {
                            var emptyView = new ctor(pullIntoDescriptor.buffer, pullIntoDescriptor.byteOffset, 0);
                            readIntoRequest._closeSteps(emptyView);
                            return;
                        }
                        if (controller._queueTotalSize > 0) {
                            if (ReadableByteStreamControllerFillPullIntoDescriptorFromQueue(controller, pullIntoDescriptor)) {
                                var filledView = ReadableByteStreamControllerConvertPullIntoDescriptor(pullIntoDescriptor);
                                ReadableByteStreamControllerHandleQueueDrain(controller);
                                readIntoRequest._chunkSteps(filledView);
                                return;
                            }
                            if (controller._closeRequested) {
                                var e = new TypeError('Insufficient bytes to fill elements in the given buffer');
                                ReadableByteStreamControllerError(controller, e);
                                readIntoRequest._errorSteps(e);
                                return;
                            }
                        }
                        controller._pendingPullIntos.push(pullIntoDescriptor);
                        ReadableStreamAddReadIntoRequest(stream, readIntoRequest);
                        ReadableByteStreamControllerCallPullIfNeeded(controller);
                    }

                    function ReadableByteStreamControllerRespondInClosedState(controller, firstDescriptor) {
                        firstDescriptor.buffer = TransferArrayBuffer(firstDescriptor.buffer);
                        var stream = controller._controlledReadableByteStream;
                        if (ReadableStreamHasBYOBReader(stream)) {
                            while (ReadableStreamGetNumReadIntoRequests(stream) > 0) {
                                var pullIntoDescriptor = ReadableByteStreamControllerShiftPendingPullInto(controller);
                                ReadableByteStreamControllerCommitPullIntoDescriptor(stream, pullIntoDescriptor);
                            }
                        }
                    }

                    function ReadableByteStreamControllerRespondInReadableState(controller, bytesWritten, pullIntoDescriptor) {
                        if (pullIntoDescriptor.bytesFilled + bytesWritten > pullIntoDescriptor.byteLength) {
                            throw new RangeError('bytesWritten out of range');
                        }
                        ReadableByteStreamControllerFillHeadPullIntoDescriptor(controller, bytesWritten, pullIntoDescriptor);
                        if (pullIntoDescriptor.bytesFilled < pullIntoDescriptor.elementSize) {
                            return;
                        }
                        ReadableByteStreamControllerShiftPendingPullInto(controller);
                        var remainderSize = pullIntoDescriptor.bytesFilled % pullIntoDescriptor.elementSize;
                        if (remainderSize > 0) {
                            var end = pullIntoDescriptor.byteOffset + pullIntoDescriptor.bytesFilled;
                            var remainder = pullIntoDescriptor.buffer.slice(end - remainderSize, end);
                            ReadableByteStreamControllerEnqueueChunkToQueue(controller, remainder, 0, remainder.byteLength);
                        }
                        pullIntoDescriptor.buffer = TransferArrayBuffer(pullIntoDescriptor.buffer);
                        pullIntoDescriptor.bytesFilled -= remainderSize;
                        ReadableByteStreamControllerCommitPullIntoDescriptor(controller._controlledReadableByteStream, pullIntoDescriptor);
                        ReadableByteStreamControllerProcessPullIntoDescriptorsUsingQueue(controller);
                    }

                    function ReadableByteStreamControllerRespondInternal(controller, bytesWritten) {
                        var firstDescriptor = controller._pendingPullIntos.peek();
                        var state = controller._controlledReadableByteStream._state;
                        if (state === 'closed') {
                            if (bytesWritten !== 0) {
                                throw new TypeError('bytesWritten must be 0 when calling respond() on a closed stream');
                            }
                            ReadableByteStreamControllerRespondInClosedState(controller, firstDescriptor);
                        } else {
                            ReadableByteStreamControllerRespondInReadableState(controller, bytesWritten, firstDescriptor);
                        }
                        ReadableByteStreamControllerCallPullIfNeeded(controller);
                    }

                    function ReadableByteStreamControllerShiftPendingPullInto(controller) {
                        var descriptor = controller._pendingPullIntos.shift();
                        ReadableByteStreamControllerInvalidateBYOBRequest(controller);
                        return descriptor;
                    }

                    function ReadableByteStreamControllerShouldCallPull(controller) {
                        var stream = controller._controlledReadableByteStream;
                        if (stream._state !== 'readable') {
                            return false;
                        }
                        if (controller._closeRequested) {
                            return false;
                        }
                        if (!controller._started) {
                            return false;
                        }
                        if (ReadableStreamHasDefaultReader(stream) && ReadableStreamGetNumReadRequests(stream) > 0) {
                            return true;
                        }
                        if (ReadableStreamHasBYOBReader(stream) && ReadableStreamGetNumReadIntoRequests(stream) > 0) {
                            return true;
                        }
                        var desiredSize = ReadableByteStreamControllerGetDesiredSize(controller);
                        if (desiredSize > 0) {
                            return true;
                        }
                        return false;
                    }

                    function ReadableByteStreamControllerClearAlgorithms(controller) {
                        controller._pullAlgorithm = undefined;
                        controller._cancelAlgorithm = undefined;
                    }

                    function ReadableByteStreamControllerClose(controller) {
                        var stream = controller._controlledReadableByteStream;
                        if (controller._closeRequested || stream._state !== 'readable') {
                            return;
                        }
                        if (controller._queueTotalSize > 0) {
                            controller._closeRequested = true;
                            return;
                        }
                        if (controller._pendingPullIntos.length > 0) {
                            var firstPendingPullInto = controller._pendingPullIntos.peek();
                            if (firstPendingPullInto.bytesFilled > 0) {
                                var e = new TypeError('Insufficient bytes to fill elements in the given buffer');
                                ReadableByteStreamControllerError(controller, e);
                                throw e;
                            }
                        }
                        ReadableByteStreamControllerClearAlgorithms(controller);
                        ReadableStreamClose(stream);
                    }

                    function ReadableByteStreamControllerEnqueue(controller, chunk) {
                        var stream = controller._controlledReadableByteStream;
                        if (controller._closeRequested || stream._state !== 'readable') {
                            return;
                        }
                        var buffer = chunk.buffer;
                        var byteOffset = chunk.byteOffset;
                        var byteLength = chunk.byteLength;
                        var transferredBuffer = TransferArrayBuffer(buffer);
                        if (ReadableStreamHasDefaultReader(stream)) {
                            if (ReadableStreamGetNumReadRequests(stream) === 0) {
                                ReadableByteStreamControllerEnqueueChunkToQueue(controller, transferredBuffer, byteOffset, byteLength);
                            } else {
                                var transferredView = new Uint8Array(transferredBuffer, byteOffset, byteLength);
                                ReadableStreamFulfillReadRequest(stream, transferredView, false);
                            }
                        } else if (ReadableStreamHasBYOBReader(stream)) {
                            ReadableByteStreamControllerEnqueueChunkToQueue(controller, transferredBuffer, byteOffset, byteLength);
                            ReadableByteStreamControllerProcessPullIntoDescriptorsUsingQueue(controller);
                        } else {
                            ReadableByteStreamControllerEnqueueChunkToQueue(controller, transferredBuffer, byteOffset, byteLength);
                        }
                        ReadableByteStreamControllerCallPullIfNeeded(controller);
                    }

                    function ReadableByteStreamControllerError(controller, e) {
                        var stream = controller._controlledReadableByteStream;
                        if (stream._state !== 'readable') {
                            return;
                        }
                        ReadableByteStreamControllerClearPendingPullIntos(controller);
                        ResetQueue(controller);
                        ReadableByteStreamControllerClearAlgorithms(controller);
                        ReadableStreamError(stream, e);
                    }

                    function ReadableByteStreamControllerGetDesiredSize(controller) {
                        var state = controller._controlledReadableByteStream._state;
                        if (state === 'errored') {
                            return null;
                        }
                        if (state === 'closed') {
                            return 0;
                        }
                        return controller._strategyHWM - controller._queueTotalSize;
                    }

                    function ReadableByteStreamControllerRespond(controller, bytesWritten) {
                        bytesWritten = Number(bytesWritten);
                        if (!IsFiniteNonNegativeNumber(bytesWritten)) {
                            throw new RangeError('bytesWritten must be a finite');
                        }
                        ReadableByteStreamControllerRespondInternal(controller, bytesWritten);
                    }

                    function ReadableByteStreamControllerRespondWithNewView(controller, view) {
                        var firstDescriptor = controller._pendingPullIntos.peek();
                        if (firstDescriptor.byteOffset + firstDescriptor.bytesFilled !== view.byteOffset) {
                            throw new RangeError('The region specified by view does not match byobRequest');
                        }
                        if (firstDescriptor.byteLength !== view.byteLength) {
                            throw new RangeError('The buffer of view has different capacity than byobRequest');
                        }
                        firstDescriptor.buffer = view.buffer;
                        ReadableByteStreamControllerRespondInternal(controller, view.byteLength);
                    }

                    function SetUpReadableByteStreamController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, autoAllocateChunkSize) {
                        controller._controlledReadableByteStream = stream;
                        controller._pullAgain = false;
                        controller._pulling = false;
                        controller._byobRequest = null;
                        controller._queue = controller._queueTotalSize = undefined;
                        ResetQueue(controller);
                        controller._closeRequested = false;
                        controller._started = false;
                        controller._strategyHWM = highWaterMark;
                        controller._pullAlgorithm = pullAlgorithm;
                        controller._cancelAlgorithm = cancelAlgorithm;
                        controller._autoAllocateChunkSize = autoAllocateChunkSize;
                        controller._pendingPullIntos = new SimpleQueue();
                        stream._readableStreamController = controller;
                        var startResult = startAlgorithm();
                        uponPromise(promiseResolvedWith(startResult), function() {
                            controller._started = true;
                            ReadableByteStreamControllerCallPullIfNeeded(controller);
                        }, function(r) {
                            ReadableByteStreamControllerError(controller, r);
                        });
                    }

                    function SetUpReadableByteStreamControllerFromUnderlyingSource(stream, underlyingByteSource, highWaterMark) {
                        var controller = Object.create(ReadableByteStreamController.prototype);
                        var startAlgorithm = function() {
                            return undefined;
                        };
                        var pullAlgorithm = function() {
                            return promiseResolvedWith(undefined);
                        };
                        var cancelAlgorithm = function() {
                            return promiseResolvedWith(undefined);
                        };
                        if (underlyingByteSource.start !== undefined) {
                            startAlgorithm = function() {
                                return underlyingByteSource.start(controller);
                            };
                        }
                        if (underlyingByteSource.pull !== undefined) {
                            pullAlgorithm = function() {
                                return underlyingByteSource.pull(controller);
                            };
                        }
                        if (underlyingByteSource.cancel !== undefined) {
                            cancelAlgorithm = function(reason) {
                                return underlyingByteSource.cancel(reason);
                            };
                        }
                        var autoAllocateChunkSize = underlyingByteSource.autoAllocateChunkSize;
                        if (autoAllocateChunkSize === 0) {
                            throw new TypeError('autoAllocateChunkSize must be greater than 0');
                        }
                        SetUpReadableByteStreamController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, autoAllocateChunkSize);
                    }

                    function SetUpReadableStreamBYOBRequest(request, controller, view) {
                        request._associatedReadableByteStreamController = controller;
                        request._view = view;
                    }

                    function byobRequestBrandCheckException(name) {
                        return new TypeError("ReadableStreamBYOBRequest.prototype." + name + " can only be used on a ReadableStreamBYOBRequest");
                    }

                    function byteStreamControllerBrandCheckException(name) {
                        return new TypeError("ReadableByteStreamController.prototype." + name + " can only be used on a ReadableByteStreamController");
                    }

                    function AcquireReadableStreamBYOBReader(stream) {
                        return new ReadableStreamBYOBReader(stream);
                    }

                    function ReadableStreamAddReadIntoRequest(stream, readIntoRequest) {
                        stream._reader._readIntoRequests.push(readIntoRequest);
                    }

                    function ReadableStreamFulfillReadIntoRequest(stream, chunk, done) {
                        var reader = stream._reader;
                        var readIntoRequest = reader._readIntoRequests.shift();
                        if (done) {
                            readIntoRequest._closeSteps(chunk);
                        } else {
                            readIntoRequest._chunkSteps(chunk);
                        }
                    }

                    function ReadableStreamGetNumReadIntoRequests(stream) {
                        return stream._reader._readIntoRequests.length;
                    }

                    function ReadableStreamHasBYOBReader(stream) {
                        var reader = stream._reader;
                        if (reader === undefined) {
                            return false;
                        }
                        if (!IsReadableStreamBYOBReader(reader)) {
                            return false;
                        }
                        return true;
                    }

                    var ReadableStreamBYOBReader = function() {
                        function ReadableStreamBYOBReader(stream) {
                            assertRequiredArgument(stream, 1, 'ReadableStreamBYOBReader');
                            assertReadableStream(stream, 'First parameter');
                            if (IsReadableStreamLocked(stream)) {
                                throw new TypeError('This stream has already been locked for exclusive reading by another reader');
                            }
                            if (!IsReadableByteStreamController(stream._readableStreamController)) {
                                throw new TypeError('Cannot construct a ReadableStreamBYOBReader for a stream not constructed with a byte ' + 'source');
                            }
                            ReadableStreamReaderGenericInitialize(this, stream);
                            this._readIntoRequests = new SimpleQueue();
                        }

                        Object.defineProperty(ReadableStreamBYOBReader.prototype, "closed", {
                            get          : function() {
                                if (!IsReadableStreamBYOBReader(this)) {
                                    return promiseRejectedWith(byobReaderBrandCheckException('closed'));
                                }
                                return this._closedPromise;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        ReadableStreamBYOBReader.prototype.cancel = function(reason) {
                            if (reason === void 0) {
                                reason = undefined;
                            }
                            if (!IsReadableStreamBYOBReader(this)) {
                                return promiseRejectedWith(byobReaderBrandCheckException('cancel'));
                            }
                            if (this._ownerReadableStream === undefined) {
                                return promiseRejectedWith(readerLockException('cancel'));
                            }
                            return ReadableStreamReaderGenericCancel(this, reason);
                        };
                        ReadableStreamBYOBReader.prototype.read = function(view) {
                            if (!IsReadableStreamBYOBReader(this)) {
                                return promiseRejectedWith(byobReaderBrandCheckException('read'));
                            }
                            if (!ArrayBuffer.isView(view)) {
                                return promiseRejectedWith(new TypeError('view must be an array buffer view'));
                            }
                            if (view.byteLength === 0) {
                                return promiseRejectedWith(new TypeError('view must have non-zero byteLength'));
                            }
                            if (view.buffer.byteLength === 0) {
                                return promiseRejectedWith(new TypeError("view's buffer must have non-zero byteLength"));
                            }
                            if (this._ownerReadableStream === undefined) {
                                return promiseRejectedWith(readerLockException('read from'));
                            }
                            var resolvePromise;
                            var rejectPromise;
                            var promise = newPromise(function(resolve, reject) {
                                resolvePromise = resolve;
                                rejectPromise = reject;
                            });
                            var readIntoRequest = {
                                _chunkSteps : function(chunk) {
                                    return resolvePromise({
                                        value : chunk,
                                        done  : false
                                    });
                                },
                                _closeSteps : function(chunk) {
                                    return resolvePromise({
                                        value : chunk,
                                        done  : true
                                    });
                                },
                                _errorSteps : function(e) {
                                    return rejectPromise(e);
                                }
                            };
                            ReadableStreamBYOBReaderRead(this, view, readIntoRequest);
                            return promise;
                        };
                        ReadableStreamBYOBReader.prototype.releaseLock = function() {
                            if (!IsReadableStreamBYOBReader(this)) {
                                throw byobReaderBrandCheckException('releaseLock');
                            }
                            if (this._ownerReadableStream === undefined) {
                                return;
                            }
                            if (this._readIntoRequests.length > 0) {
                                throw new TypeError('Tried to release a reader lock when that reader has pending read() calls un-settled');
                            }
                            ReadableStreamReaderGenericRelease(this);
                        };
                        return ReadableStreamBYOBReader;
                    }();
                    Object.defineProperties(ReadableStreamBYOBReader.prototype, {
                        cancel      : {enumerable : true},
                        read        : {enumerable : true},
                        releaseLock : {enumerable : true},
                        closed      : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(ReadableStreamBYOBReader.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'ReadableStreamBYOBReader',
                            configurable : true
                        });
                    }

                    function IsReadableStreamBYOBReader(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_readIntoRequests')) {
                            return false;
                        }
                        return true;
                    }

                    function ReadableStreamBYOBReaderRead(reader, view, readIntoRequest) {
                        var stream = reader._ownerReadableStream;
                        stream._disturbed = true;
                        if (stream._state === 'errored') {
                            readIntoRequest._errorSteps(stream._storedError);
                        } else {
                            ReadableByteStreamControllerPullInto(stream._readableStreamController, view, readIntoRequest);
                        }
                    }

                    function byobReaderBrandCheckException(name) {
                        return new TypeError("ReadableStreamBYOBReader.prototype." + name + " can only be used on a ReadableStreamBYOBReader");
                    }

                    function ExtractHighWaterMark(strategy, defaultHWM) {
                        var highWaterMark = strategy.highWaterMark;
                        if (highWaterMark === undefined) {
                            return defaultHWM;
                        }
                        if (NumberIsNaN(highWaterMark) || highWaterMark < 0) {
                            throw new RangeError('Invalid highWaterMark');
                        }
                        return highWaterMark;
                    }

                    function ExtractSizeAlgorithm(strategy) {
                        var size = strategy.size;
                        if (!size) {
                            return function() {
                                return 1;
                            };
                        }
                        return size;
                    }

                    function convertQueuingStrategy(init, context) {
                        assertDictionary(init, context);
                        var highWaterMark = init === null || init === void 0 ? void 0 : init.highWaterMark;
                        var size = init === null || init === void 0 ? void 0 : init.size;
                        return {
                            highWaterMark : highWaterMark === undefined ? undefined : convertUnrestrictedDouble(highWaterMark),
                            size          : size === undefined ? undefined : convertQueuingStrategySize(size, context + " has member 'size' that")
                        };
                    }

                    function convertQueuingStrategySize(fn, context) {
                        assertFunction(fn, context);
                        return function(chunk) {
                            return convertUnrestrictedDouble(fn(chunk));
                        };
                    }

                    function convertUnderlyingSink(original, context) {
                        assertDictionary(original, context);
                        var abort = original === null || original === void 0 ? void 0 : original.abort;
                        var close = original === null || original === void 0 ? void 0 : original.close;
                        var start = original === null || original === void 0 ? void 0 : original.start;
                        var type = original === null || original === void 0 ? void 0 : original.type;
                        var write = original === null || original === void 0 ? void 0 : original.write;
                        return {
                            abort : abort === undefined ? undefined : convertUnderlyingSinkAbortCallback(abort, original, context + " has member 'abort' that"),
                            close : close === undefined ? undefined : convertUnderlyingSinkCloseCallback(close, original, context + " has member 'close' that"),
                            start : start === undefined ? undefined : convertUnderlyingSinkStartCallback(start, original, context + " has member 'start' that"),
                            write : write === undefined ? undefined : convertUnderlyingSinkWriteCallback(write, original, context + " has member 'write' that"),
                            type  : type
                        };
                    }

                    function convertUnderlyingSinkAbortCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function(reason) {
                            return promiseCall(fn, original, [reason]);
                        };
                    }

                    function convertUnderlyingSinkCloseCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function() {
                            return promiseCall(fn, original, []);
                        };
                    }

                    function convertUnderlyingSinkStartCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function(controller) {
                            return reflectCall(fn, original, [controller]);
                        };
                    }

                    function convertUnderlyingSinkWriteCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function(chunk, controller) {
                            return promiseCall(fn, original, [
                                chunk,
                                controller
                            ]);
                        };
                    }

                    function assertWritableStream(x, context) {
                        if (!IsWritableStream(x)) {
                            throw new TypeError(context + " is not a WritableStream.");
                        }
                    }

                    var WritableStream = function() {
                        function WritableStream(rawUnderlyingSink, rawStrategy) {
                            if (rawUnderlyingSink === void 0) {
                                rawUnderlyingSink = {};
                            }
                            if (rawStrategy === void 0) {
                                rawStrategy = {};
                            }
                            if (rawUnderlyingSink === undefined) {
                                rawUnderlyingSink = null;
                            } else {
                                assertObject(rawUnderlyingSink, 'First parameter');
                            }
                            var strategy = convertQueuingStrategy(rawStrategy, 'Second parameter');
                            var underlyingSink = convertUnderlyingSink(rawUnderlyingSink, 'First parameter');
                            InitializeWritableStream(this);
                            var type = underlyingSink.type;
                            if (type !== undefined) {
                                throw new RangeError('Invalid type is specified');
                            }
                            var sizeAlgorithm = ExtractSizeAlgorithm(strategy);
                            var highWaterMark = ExtractHighWaterMark(strategy, 1);
                            SetUpWritableStreamDefaultControllerFromUnderlyingSink(this, underlyingSink, highWaterMark, sizeAlgorithm);
                        }

                        Object.defineProperty(WritableStream.prototype, "locked", {
                            get          : function() {
                                if (!IsWritableStream(this)) {
                                    throw streamBrandCheckException('locked');
                                }
                                return IsWritableStreamLocked(this);
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        WritableStream.prototype.abort = function(reason) {
                            if (reason === void 0) {
                                reason = undefined;
                            }
                            if (!IsWritableStream(this)) {
                                return promiseRejectedWith(streamBrandCheckException('abort'));
                            }
                            if (IsWritableStreamLocked(this)) {
                                return promiseRejectedWith(new TypeError('Cannot abort a stream that already has a writer'));
                            }
                            return WritableStreamAbort(this, reason);
                        };
                        WritableStream.prototype.close = function() {
                            if (!IsWritableStream(this)) {
                                return promiseRejectedWith(streamBrandCheckException('close'));
                            }
                            if (IsWritableStreamLocked(this)) {
                                return promiseRejectedWith(new TypeError('Cannot close a stream that already has a writer'));
                            }
                            if (WritableStreamCloseQueuedOrInFlight(this)) {
                                return promiseRejectedWith(new TypeError('Cannot close an already-closing stream'));
                            }
                            return WritableStreamClose(this);
                        };
                        WritableStream.prototype.getWriter = function() {
                            if (!IsWritableStream(this)) {
                                throw streamBrandCheckException('getWriter');
                            }
                            return AcquireWritableStreamDefaultWriter(this);
                        };
                        return WritableStream;
                    }();
                    Object.defineProperties(WritableStream.prototype, {
                        abort     : {enumerable : true},
                        close     : {enumerable : true},
                        getWriter : {enumerable : true},
                        locked    : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(WritableStream.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'WritableStream',
                            configurable : true
                        });
                    }

                    function AcquireWritableStreamDefaultWriter(stream) {
                        return new WritableStreamDefaultWriter(stream);
                    }

                    function CreateWritableStream(startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm) {
                        if (highWaterMark === void 0) {
                            highWaterMark = 1;
                        }
                        if (sizeAlgorithm === void 0) {
                            sizeAlgorithm = function() {
                                return 1;
                            };
                        }
                        var stream = Object.create(WritableStream.prototype);
                        InitializeWritableStream(stream);
                        var controller = Object.create(WritableStreamDefaultController.prototype);
                        SetUpWritableStreamDefaultController(stream, controller, startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm);
                        return stream;
                    }

                    function InitializeWritableStream(stream) {
                        stream._state = 'writable';
                        stream._storedError = undefined;
                        stream._writer = undefined;
                        stream._writableStreamController = undefined;
                        stream._writeRequests = new SimpleQueue();
                        stream._inFlightWriteRequest = undefined;
                        stream._closeRequest = undefined;
                        stream._inFlightCloseRequest = undefined;
                        stream._pendingAbortRequest = undefined;
                        stream._backpressure = false;
                    }

                    function IsWritableStream(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_writableStreamController')) {
                            return false;
                        }
                        return true;
                    }

                    function IsWritableStreamLocked(stream) {
                        if (stream._writer === undefined) {
                            return false;
                        }
                        return true;
                    }

                    function WritableStreamAbort(stream, reason) {
                        var state = stream._state;
                        if (state === 'closed' || state === 'errored') {
                            return promiseResolvedWith(undefined);
                        }
                        if (stream._pendingAbortRequest !== undefined) {
                            return stream._pendingAbortRequest._promise;
                        }
                        var wasAlreadyErroring = false;
                        if (state === 'erroring') {
                            wasAlreadyErroring = true;
                            reason = undefined;
                        }
                        var promise = newPromise(function(resolve, reject) {
                            stream._pendingAbortRequest = {
                                _promise            : undefined,
                                _resolve            : resolve,
                                _reject             : reject,
                                _reason             : reason,
                                _wasAlreadyErroring : wasAlreadyErroring
                            };
                        });
                        stream._pendingAbortRequest._promise = promise;
                        if (!wasAlreadyErroring) {
                            WritableStreamStartErroring(stream, reason);
                        }
                        return promise;
                    }

                    function WritableStreamClose(stream) {
                        var state = stream._state;
                        if (state === 'closed' || state === 'errored') {
                            return promiseRejectedWith(new TypeError("The stream (in " + state + " state) is not in the writable state and cannot be closed"));
                        }
                        var promise = newPromise(function(resolve, reject) {
                            var closeRequest = {
                                _resolve : resolve,
                                _reject  : reject
                            };
                            stream._closeRequest = closeRequest;
                        });
                        var writer = stream._writer;
                        if (writer !== undefined && stream._backpressure && state === 'writable') {
                            defaultWriterReadyPromiseResolve(writer);
                        }
                        WritableStreamDefaultControllerClose(stream._writableStreamController);
                        return promise;
                    }

                    function WritableStreamAddWriteRequest(stream) {
                        var promise = newPromise(function(resolve, reject) {
                            var writeRequest = {
                                _resolve : resolve,
                                _reject  : reject
                            };
                            stream._writeRequests.push(writeRequest);
                        });
                        return promise;
                    }

                    function WritableStreamDealWithRejection(stream, error) {
                        var state = stream._state;
                        if (state === 'writable') {
                            WritableStreamStartErroring(stream, error);
                            return;
                        }
                        WritableStreamFinishErroring(stream);
                    }

                    function WritableStreamStartErroring(stream, reason) {
                        var controller = stream._writableStreamController;
                        stream._state = 'erroring';
                        stream._storedError = reason;
                        var writer = stream._writer;
                        if (writer !== undefined) {
                            WritableStreamDefaultWriterEnsureReadyPromiseRejected(writer, reason);
                        }
                        if (!WritableStreamHasOperationMarkedInFlight(stream) && controller._started) {
                            WritableStreamFinishErroring(stream);
                        }
                    }

                    function WritableStreamFinishErroring(stream) {
                        stream._state = 'errored';
                        stream._writableStreamController[ErrorSteps]();
                        var storedError = stream._storedError;
                        stream._writeRequests.forEach(function(writeRequest) {
                            writeRequest._reject(storedError);
                        });
                        stream._writeRequests = new SimpleQueue();
                        if (stream._pendingAbortRequest === undefined) {
                            WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream);
                            return;
                        }
                        var abortRequest = stream._pendingAbortRequest;
                        stream._pendingAbortRequest = undefined;
                        if (abortRequest._wasAlreadyErroring) {
                            abortRequest._reject(storedError);
                            WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream);
                            return;
                        }
                        var promise = stream._writableStreamController[AbortSteps](abortRequest._reason);
                        uponPromise(promise, function() {
                            abortRequest._resolve();
                            WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream);
                        }, function(reason) {
                            abortRequest._reject(reason);
                            WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream);
                        });
                    }

                    function WritableStreamFinishInFlightWrite(stream) {
                        stream._inFlightWriteRequest._resolve(undefined);
                        stream._inFlightWriteRequest = undefined;
                    }

                    function WritableStreamFinishInFlightWriteWithError(stream, error) {
                        stream._inFlightWriteRequest._reject(error);
                        stream._inFlightWriteRequest = undefined;
                        WritableStreamDealWithRejection(stream, error);
                    }

                    function WritableStreamFinishInFlightClose(stream) {
                        stream._inFlightCloseRequest._resolve(undefined);
                        stream._inFlightCloseRequest = undefined;
                        var state = stream._state;
                        if (state === 'erroring') {
                            stream._storedError = undefined;
                            if (stream._pendingAbortRequest !== undefined) {
                                stream._pendingAbortRequest._resolve();
                                stream._pendingAbortRequest = undefined;
                            }
                        }
                        stream._state = 'closed';
                        var writer = stream._writer;
                        if (writer !== undefined) {
                            defaultWriterClosedPromiseResolve(writer);
                        }
                    }

                    function WritableStreamFinishInFlightCloseWithError(stream, error) {
                        stream._inFlightCloseRequest._reject(error);
                        stream._inFlightCloseRequest = undefined;
                        if (stream._pendingAbortRequest !== undefined) {
                            stream._pendingAbortRequest._reject(error);
                            stream._pendingAbortRequest = undefined;
                        }
                        WritableStreamDealWithRejection(stream, error);
                    }

                    function WritableStreamCloseQueuedOrInFlight(stream) {
                        if (stream._closeRequest === undefined && stream._inFlightCloseRequest === undefined) {
                            return false;
                        }
                        return true;
                    }

                    function WritableStreamHasOperationMarkedInFlight(stream) {
                        if (stream._inFlightWriteRequest === undefined && stream._inFlightCloseRequest === undefined) {
                            return false;
                        }
                        return true;
                    }

                    function WritableStreamMarkCloseRequestInFlight(stream) {
                        stream._inFlightCloseRequest = stream._closeRequest;
                        stream._closeRequest = undefined;
                    }

                    function WritableStreamMarkFirstWriteRequestInFlight(stream) {
                        stream._inFlightWriteRequest = stream._writeRequests.shift();
                    }

                    function WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream) {
                        if (stream._closeRequest !== undefined) {
                            stream._closeRequest._reject(stream._storedError);
                            stream._closeRequest = undefined;
                        }
                        var writer = stream._writer;
                        if (writer !== undefined) {
                            defaultWriterClosedPromiseReject(writer, stream._storedError);
                        }
                    }

                    function WritableStreamUpdateBackpressure(stream, backpressure) {
                        var writer = stream._writer;
                        if (writer !== undefined && backpressure !== stream._backpressure) {
                            if (backpressure) {
                                defaultWriterReadyPromiseReset(writer);
                            } else {
                                defaultWriterReadyPromiseResolve(writer);
                            }
                        }
                        stream._backpressure = backpressure;
                    }

                    var WritableStreamDefaultWriter = function() {
                        function WritableStreamDefaultWriter(stream) {
                            assertRequiredArgument(stream, 1, 'WritableStreamDefaultWriter');
                            assertWritableStream(stream, 'First parameter');
                            if (IsWritableStreamLocked(stream)) {
                                throw new TypeError('This stream has already been locked for exclusive writing by another writer');
                            }
                            this._ownerWritableStream = stream;
                            stream._writer = this;
                            var state = stream._state;
                            if (state === 'writable') {
                                if (!WritableStreamCloseQueuedOrInFlight(stream) && stream._backpressure) {
                                    defaultWriterReadyPromiseInitialize(this);
                                } else {
                                    defaultWriterReadyPromiseInitializeAsResolved(this);
                                }
                                defaultWriterClosedPromiseInitialize(this);
                            } else if (state === 'erroring') {
                                defaultWriterReadyPromiseInitializeAsRejected(this, stream._storedError);
                                defaultWriterClosedPromiseInitialize(this);
                            } else if (state === 'closed') {
                                defaultWriterReadyPromiseInitializeAsResolved(this);
                                defaultWriterClosedPromiseInitializeAsResolved(this);
                            } else {
                                var storedError = stream._storedError;
                                defaultWriterReadyPromiseInitializeAsRejected(this, storedError);
                                defaultWriterClosedPromiseInitializeAsRejected(this, storedError);
                            }
                        }

                        Object.defineProperty(WritableStreamDefaultWriter.prototype, "closed", {
                            get          : function() {
                                if (!IsWritableStreamDefaultWriter(this)) {
                                    return promiseRejectedWith(defaultWriterBrandCheckException('closed'));
                                }
                                return this._closedPromise;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        Object.defineProperty(WritableStreamDefaultWriter.prototype, "desiredSize", {
                            get          : function() {
                                if (!IsWritableStreamDefaultWriter(this)) {
                                    throw defaultWriterBrandCheckException('desiredSize');
                                }
                                if (this._ownerWritableStream === undefined) {
                                    throw defaultWriterLockException('desiredSize');
                                }
                                return WritableStreamDefaultWriterGetDesiredSize(this);
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        Object.defineProperty(WritableStreamDefaultWriter.prototype, "ready", {
                            get          : function() {
                                if (!IsWritableStreamDefaultWriter(this)) {
                                    return promiseRejectedWith(defaultWriterBrandCheckException('ready'));
                                }
                                return this._readyPromise;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        WritableStreamDefaultWriter.prototype.abort = function(reason) {
                            if (reason === void 0) {
                                reason = undefined;
                            }
                            if (!IsWritableStreamDefaultWriter(this)) {
                                return promiseRejectedWith(defaultWriterBrandCheckException('abort'));
                            }
                            if (this._ownerWritableStream === undefined) {
                                return promiseRejectedWith(defaultWriterLockException('abort'));
                            }
                            return WritableStreamDefaultWriterAbort(this, reason);
                        };
                        WritableStreamDefaultWriter.prototype.close = function() {
                            if (!IsWritableStreamDefaultWriter(this)) {
                                return promiseRejectedWith(defaultWriterBrandCheckException('close'));
                            }
                            var stream = this._ownerWritableStream;
                            if (stream === undefined) {
                                return promiseRejectedWith(defaultWriterLockException('close'));
                            }
                            if (WritableStreamCloseQueuedOrInFlight(stream)) {
                                return promiseRejectedWith(new TypeError('Cannot close an already-closing stream'));
                            }
                            return WritableStreamDefaultWriterClose(this);
                        };
                        WritableStreamDefaultWriter.prototype.releaseLock = function() {
                            if (!IsWritableStreamDefaultWriter(this)) {
                                throw defaultWriterBrandCheckException('releaseLock');
                            }
                            var stream = this._ownerWritableStream;
                            if (stream === undefined) {
                                return;
                            }
                            WritableStreamDefaultWriterRelease(this);
                        };
                        WritableStreamDefaultWriter.prototype.write = function(chunk) {
                            if (chunk === void 0) {
                                chunk = undefined;
                            }
                            if (!IsWritableStreamDefaultWriter(this)) {
                                return promiseRejectedWith(defaultWriterBrandCheckException('write'));
                            }
                            if (this._ownerWritableStream === undefined) {
                                return promiseRejectedWith(defaultWriterLockException('write to'));
                            }
                            return WritableStreamDefaultWriterWrite(this, chunk);
                        };
                        return WritableStreamDefaultWriter;
                    }();
                    Object.defineProperties(WritableStreamDefaultWriter.prototype, {
                        abort       : {enumerable : true},
                        close       : {enumerable : true},
                        releaseLock : {enumerable : true},
                        write       : {enumerable : true},
                        closed      : {enumerable : true},
                        desiredSize : {enumerable : true},
                        ready       : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(WritableStreamDefaultWriter.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'WritableStreamDefaultWriter',
                            configurable : true
                        });
                    }

                    function IsWritableStreamDefaultWriter(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_ownerWritableStream')) {
                            return false;
                        }
                        return true;
                    }

                    function WritableStreamDefaultWriterAbort(writer, reason) {
                        var stream = writer._ownerWritableStream;
                        return WritableStreamAbort(stream, reason);
                    }

                    function WritableStreamDefaultWriterClose(writer) {
                        var stream = writer._ownerWritableStream;
                        return WritableStreamClose(stream);
                    }

                    function WritableStreamDefaultWriterCloseWithErrorPropagation(writer) {
                        var stream = writer._ownerWritableStream;
                        var state = stream._state;
                        if (WritableStreamCloseQueuedOrInFlight(stream) || state === 'closed') {
                            return promiseResolvedWith(undefined);
                        }
                        if (state === 'errored') {
                            return promiseRejectedWith(stream._storedError);
                        }
                        return WritableStreamDefaultWriterClose(writer);
                    }

                    function WritableStreamDefaultWriterEnsureClosedPromiseRejected(writer, error) {
                        if (writer._closedPromiseState === 'pending') {
                            defaultWriterClosedPromiseReject(writer, error);
                        } else {
                            defaultWriterClosedPromiseResetToRejected(writer, error);
                        }
                    }

                    function WritableStreamDefaultWriterEnsureReadyPromiseRejected(writer, error) {
                        if (writer._readyPromiseState === 'pending') {
                            defaultWriterReadyPromiseReject(writer, error);
                        } else {
                            defaultWriterReadyPromiseResetToRejected(writer, error);
                        }
                    }

                    function WritableStreamDefaultWriterGetDesiredSize(writer) {
                        var stream = writer._ownerWritableStream;
                        var state = stream._state;
                        if (state === 'errored' || state === 'erroring') {
                            return null;
                        }
                        if (state === 'closed') {
                            return 0;
                        }
                        return WritableStreamDefaultControllerGetDesiredSize(stream._writableStreamController);
                    }

                    function WritableStreamDefaultWriterRelease(writer) {
                        var stream = writer._ownerWritableStream;
                        var releasedError = new TypeError("Writer was released and can no longer be used to monitor the stream's closedness");
                        WritableStreamDefaultWriterEnsureReadyPromiseRejected(writer, releasedError);
                        WritableStreamDefaultWriterEnsureClosedPromiseRejected(writer, releasedError);
                        stream._writer = undefined;
                        writer._ownerWritableStream = undefined;
                    }

                    function WritableStreamDefaultWriterWrite(writer, chunk) {
                        var stream = writer._ownerWritableStream;
                        var controller = stream._writableStreamController;
                        var chunkSize = WritableStreamDefaultControllerGetChunkSize(controller, chunk);
                        if (stream !== writer._ownerWritableStream) {
                            return promiseRejectedWith(defaultWriterLockException('write to'));
                        }
                        var state = stream._state;
                        if (state === 'errored') {
                            return promiseRejectedWith(stream._storedError);
                        }
                        if (WritableStreamCloseQueuedOrInFlight(stream) || state === 'closed') {
                            return promiseRejectedWith(new TypeError('The stream is closing or closed and cannot be written to'));
                        }
                        if (state === 'erroring') {
                            return promiseRejectedWith(stream._storedError);
                        }
                        var promise = WritableStreamAddWriteRequest(stream);
                        WritableStreamDefaultControllerWrite(controller, chunk, chunkSize);
                        return promise;
                    }

                    var closeSentinel = {};
                    var WritableStreamDefaultController = function() {
                        function WritableStreamDefaultController() {
                            throw new TypeError('Illegal constructor');
                        }

                        WritableStreamDefaultController.prototype.error = function(e) {
                            if (e === void 0) {
                                e = undefined;
                            }
                            if (!IsWritableStreamDefaultController(this)) {
                                throw new TypeError('WritableStreamDefaultController.prototype.error can only be used on a WritableStreamDefaultController');
                            }
                            var state = this._controlledWritableStream._state;
                            if (state !== 'writable') {
                                return;
                            }
                            WritableStreamDefaultControllerError(this, e);
                        };
                        WritableStreamDefaultController.prototype[AbortSteps] = function(reason) {
                            var result = this._abortAlgorithm(reason);
                            WritableStreamDefaultControllerClearAlgorithms(this);
                            return result;
                        };
                        WritableStreamDefaultController.prototype[ErrorSteps] = function() {
                            ResetQueue(this);
                        };
                        return WritableStreamDefaultController;
                    }();
                    Object.defineProperties(WritableStreamDefaultController.prototype, {error : {enumerable : true}});
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(WritableStreamDefaultController.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'WritableStreamDefaultController',
                            configurable : true
                        });
                    }

                    function IsWritableStreamDefaultController(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_controlledWritableStream')) {
                            return false;
                        }
                        return true;
                    }

                    function SetUpWritableStreamDefaultController(stream, controller, startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm) {
                        controller._controlledWritableStream = stream;
                        stream._writableStreamController = controller;
                        controller._queue = undefined;
                        controller._queueTotalSize = undefined;
                        ResetQueue(controller);
                        controller._started = false;
                        controller._strategySizeAlgorithm = sizeAlgorithm;
                        controller._strategyHWM = highWaterMark;
                        controller._writeAlgorithm = writeAlgorithm;
                        controller._closeAlgorithm = closeAlgorithm;
                        controller._abortAlgorithm = abortAlgorithm;
                        var backpressure = WritableStreamDefaultControllerGetBackpressure(controller);
                        WritableStreamUpdateBackpressure(stream, backpressure);
                        var startResult = startAlgorithm();
                        var startPromise = promiseResolvedWith(startResult);
                        uponPromise(startPromise, function() {
                            controller._started = true;
                            WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller);
                        }, function(r) {
                            controller._started = true;
                            WritableStreamDealWithRejection(stream, r);
                        });
                    }

                    function SetUpWritableStreamDefaultControllerFromUnderlyingSink(stream, underlyingSink, highWaterMark, sizeAlgorithm) {
                        var controller = Object.create(WritableStreamDefaultController.prototype);
                        var startAlgorithm = function() {
                            return undefined;
                        };
                        var writeAlgorithm = function() {
                            return promiseResolvedWith(undefined);
                        };
                        var closeAlgorithm = function() {
                            return promiseResolvedWith(undefined);
                        };
                        var abortAlgorithm = function() {
                            return promiseResolvedWith(undefined);
                        };
                        if (underlyingSink.start !== undefined) {
                            startAlgorithm = function() {
                                return underlyingSink.start(controller);
                            };
                        }
                        if (underlyingSink.write !== undefined) {
                            writeAlgorithm = function(chunk) {
                                return underlyingSink.write(chunk, controller);
                            };
                        }
                        if (underlyingSink.close !== undefined) {
                            closeAlgorithm = function() {
                                return underlyingSink.close();
                            };
                        }
                        if (underlyingSink.abort !== undefined) {
                            abortAlgorithm = function(reason) {
                                return underlyingSink.abort(reason);
                            };
                        }
                        SetUpWritableStreamDefaultController(stream, controller, startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm);
                    }

                    function WritableStreamDefaultControllerClearAlgorithms(controller) {
                        controller._writeAlgorithm = undefined;
                        controller._closeAlgorithm = undefined;
                        controller._abortAlgorithm = undefined;
                        controller._strategySizeAlgorithm = undefined;
                    }

                    function WritableStreamDefaultControllerClose(controller) {
                        EnqueueValueWithSize(controller, closeSentinel, 0);
                        WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller);
                    }

                    function WritableStreamDefaultControllerGetChunkSize(controller, chunk) {
                        try {
                            return controller._strategySizeAlgorithm(chunk);
                        } catch (chunkSizeE) {
                            WritableStreamDefaultControllerErrorIfNeeded(controller, chunkSizeE);
                            return 1;
                        }
                    }

                    function WritableStreamDefaultControllerGetDesiredSize(controller) {
                        return controller._strategyHWM - controller._queueTotalSize;
                    }

                    function WritableStreamDefaultControllerWrite(controller, chunk, chunkSize) {
                        try {
                            EnqueueValueWithSize(controller, chunk, chunkSize);
                        } catch (enqueueE) {
                            WritableStreamDefaultControllerErrorIfNeeded(controller, enqueueE);
                            return;
                        }
                        var stream = controller._controlledWritableStream;
                        if (!WritableStreamCloseQueuedOrInFlight(stream) && stream._state === 'writable') {
                            var backpressure = WritableStreamDefaultControllerGetBackpressure(controller);
                            WritableStreamUpdateBackpressure(stream, backpressure);
                        }
                        WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller);
                    }

                    function WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller) {
                        var stream = controller._controlledWritableStream;
                        if (!controller._started) {
                            return;
                        }
                        if (stream._inFlightWriteRequest !== undefined) {
                            return;
                        }
                        var state = stream._state;
                        if (state === 'erroring') {
                            WritableStreamFinishErroring(stream);
                            return;
                        }
                        if (controller._queue.length === 0) {
                            return;
                        }
                        var value = PeekQueueValue(controller);
                        if (value === closeSentinel) {
                            WritableStreamDefaultControllerProcessClose(controller);
                        } else {
                            WritableStreamDefaultControllerProcessWrite(controller, value);
                        }
                    }

                    function WritableStreamDefaultControllerErrorIfNeeded(controller, error) {
                        if (controller._controlledWritableStream._state === 'writable') {
                            WritableStreamDefaultControllerError(controller, error);
                        }
                    }

                    function WritableStreamDefaultControllerProcessClose(controller) {
                        var stream = controller._controlledWritableStream;
                        WritableStreamMarkCloseRequestInFlight(stream);
                        DequeueValue(controller);
                        var sinkClosePromise = controller._closeAlgorithm();
                        WritableStreamDefaultControllerClearAlgorithms(controller);
                        uponPromise(sinkClosePromise, function() {
                            WritableStreamFinishInFlightClose(stream);
                        }, function(reason) {
                            WritableStreamFinishInFlightCloseWithError(stream, reason);
                        });
                    }

                    function WritableStreamDefaultControllerProcessWrite(controller, chunk) {
                        var stream = controller._controlledWritableStream;
                        WritableStreamMarkFirstWriteRequestInFlight(stream);
                        var sinkWritePromise = controller._writeAlgorithm(chunk);
                        uponPromise(sinkWritePromise, function() {
                            WritableStreamFinishInFlightWrite(stream);
                            var state = stream._state;
                            DequeueValue(controller);
                            if (!WritableStreamCloseQueuedOrInFlight(stream) && state === 'writable') {
                                var backpressure = WritableStreamDefaultControllerGetBackpressure(controller);
                                WritableStreamUpdateBackpressure(stream, backpressure);
                            }
                            WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller);
                        }, function(reason) {
                            if (stream._state === 'writable') {
                                WritableStreamDefaultControllerClearAlgorithms(controller);
                            }
                            WritableStreamFinishInFlightWriteWithError(stream, reason);
                        });
                    }

                    function WritableStreamDefaultControllerGetBackpressure(controller) {
                        var desiredSize = WritableStreamDefaultControllerGetDesiredSize(controller);
                        return desiredSize <= 0;
                    }

                    function WritableStreamDefaultControllerError(controller, error) {
                        var stream = controller._controlledWritableStream;
                        WritableStreamDefaultControllerClearAlgorithms(controller);
                        WritableStreamStartErroring(stream, error);
                    }

                    function streamBrandCheckException(name) {
                        return new TypeError("WritableStream.prototype." + name + " can only be used on a WritableStream");
                    }

                    function defaultWriterBrandCheckException(name) {
                        return new TypeError("WritableStreamDefaultWriter.prototype." + name + " can only be used on a WritableStreamDefaultWriter");
                    }

                    function defaultWriterLockException(name) {
                        return new TypeError('Cannot ' + name + ' a stream using a released writer');
                    }

                    function defaultWriterClosedPromiseInitialize(writer) {
                        writer._closedPromise = newPromise(function(resolve, reject) {
                            writer._closedPromise_resolve = resolve;
                            writer._closedPromise_reject = reject;
                            writer._closedPromiseState = 'pending';
                        });
                    }

                    function defaultWriterClosedPromiseInitializeAsRejected(writer, reason) {
                        defaultWriterClosedPromiseInitialize(writer);
                        defaultWriterClosedPromiseReject(writer, reason);
                    }

                    function defaultWriterClosedPromiseInitializeAsResolved(writer) {
                        defaultWriterClosedPromiseInitialize(writer);
                        defaultWriterClosedPromiseResolve(writer);
                    }

                    function defaultWriterClosedPromiseReject(writer, reason) {
                        if (writer._closedPromise_reject === undefined) {
                            return;
                        }
                        setPromiseIsHandledToTrue(writer._closedPromise);
                        writer._closedPromise_reject(reason);
                        writer._closedPromise_resolve = undefined;
                        writer._closedPromise_reject = undefined;
                        writer._closedPromiseState = 'rejected';
                    }

                    function defaultWriterClosedPromiseResetToRejected(writer, reason) {
                        defaultWriterClosedPromiseInitializeAsRejected(writer, reason);
                    }

                    function defaultWriterClosedPromiseResolve(writer) {
                        if (writer._closedPromise_resolve === undefined) {
                            return;
                        }
                        writer._closedPromise_resolve(undefined);
                        writer._closedPromise_resolve = undefined;
                        writer._closedPromise_reject = undefined;
                        writer._closedPromiseState = 'resolved';
                    }

                    function defaultWriterReadyPromiseInitialize(writer) {
                        writer._readyPromise = newPromise(function(resolve, reject) {
                            writer._readyPromise_resolve = resolve;
                            writer._readyPromise_reject = reject;
                        });
                        writer._readyPromiseState = 'pending';
                    }

                    function defaultWriterReadyPromiseInitializeAsRejected(writer, reason) {
                        defaultWriterReadyPromiseInitialize(writer);
                        defaultWriterReadyPromiseReject(writer, reason);
                    }

                    function defaultWriterReadyPromiseInitializeAsResolved(writer) {
                        defaultWriterReadyPromiseInitialize(writer);
                        defaultWriterReadyPromiseResolve(writer);
                    }

                    function defaultWriterReadyPromiseReject(writer, reason) {
                        if (writer._readyPromise_reject === undefined) {
                            return;
                        }
                        setPromiseIsHandledToTrue(writer._readyPromise);
                        writer._readyPromise_reject(reason);
                        writer._readyPromise_resolve = undefined;
                        writer._readyPromise_reject = undefined;
                        writer._readyPromiseState = 'rejected';
                    }

                    function defaultWriterReadyPromiseReset(writer) {
                        defaultWriterReadyPromiseInitialize(writer);
                    }

                    function defaultWriterReadyPromiseResetToRejected(writer, reason) {
                        defaultWriterReadyPromiseInitializeAsRejected(writer, reason);
                    }

                    function defaultWriterReadyPromiseResolve(writer) {
                        if (writer._readyPromise_resolve === undefined) {
                            return;
                        }
                        writer._readyPromise_resolve(undefined);
                        writer._readyPromise_resolve = undefined;
                        writer._readyPromise_reject = undefined;
                        writer._readyPromiseState = 'fulfilled';
                    }

                    function isAbortSignal(value) {
                        if (typeof value !== 'object' || value === null) {
                            return false;
                        }
                        try {
                            return typeof value.aborted === 'boolean';
                        } catch (_a) {
                            return false;
                        }
                    }

                    var NativeDOMException = typeof DOMException !== 'undefined' ? DOMException : undefined;

                    function isDOMExceptionConstructor(ctor) {
                        if (!(typeof ctor === 'function' || typeof ctor === 'object')) {
                            return false;
                        }
                        try {
                            new ctor();
                            return true;
                        } catch (_a) {
                            return false;
                        }
                    }

                    function createDOMExceptionPolyfill() {
                        var ctor = function DOMException(message, name) {
                            this.message = message || '';
                            this.name = name || 'Error';
                            if (Error.captureStackTrace) {
                                Error.captureStackTrace(this, this.constructor);
                            }
                        };
                        ctor.prototype = Object.create(Error.prototype);
                        Object.defineProperty(ctor.prototype, 'constructor', {
                            value        : ctor,
                            writable     : true,
                            configurable : true
                        });
                        return ctor;
                    }

                    var DOMException$1 = isDOMExceptionConstructor(NativeDOMException) ? NativeDOMException : createDOMExceptionPolyfill();

                    function ReadableStreamPipeTo(source, dest, preventClose, preventAbort, preventCancel, signal) {
                        var reader = AcquireReadableStreamDefaultReader(source);
                        var writer = AcquireWritableStreamDefaultWriter(dest);
                        source._disturbed = true;
                        var shuttingDown = false;
                        var currentWrite = promiseResolvedWith(undefined);
                        return newPromise(function(resolve, reject) {
                            var abortAlgorithm;
                            if (signal !== undefined) {
                                abortAlgorithm = function() {
                                    var error = new DOMException$1('Aborted', 'AbortError');
                                    var actions = [];
                                    if (!preventAbort) {
                                        actions.push(function() {
                                            if (dest._state === 'writable') {
                                                return WritableStreamAbort(dest, error);
                                            }
                                            return promiseResolvedWith(undefined);
                                        });
                                    }
                                    if (!preventCancel) {
                                        actions.push(function() {
                                            if (source._state === 'readable') {
                                                return ReadableStreamCancel(source, error);
                                            }
                                            return promiseResolvedWith(undefined);
                                        });
                                    }
                                    shutdownWithAction(function() {
                                        return Promise.all(actions.map(function(action) {
                                            return action();
                                        }));
                                    }, true, error);
                                };
                                if (signal.aborted) {
                                    abortAlgorithm();
                                    return;
                                }
                                signal.addEventListener('abort', abortAlgorithm);
                            }

                            function pipeLoop() {
                                return newPromise(function(resolveLoop, rejectLoop) {
                                    function next(done) {
                                        if (done) {
                                            resolveLoop();
                                        } else {
                                            PerformPromiseThen(pipeStep(), next, rejectLoop);
                                        }
                                    }

                                    next(false);
                                });
                            }

                            function pipeStep() {
                                if (shuttingDown) {
                                    return promiseResolvedWith(true);
                                }
                                return PerformPromiseThen(writer._readyPromise, function() {
                                    return newPromise(function(resolveRead, rejectRead) {
                                        ReadableStreamDefaultReaderRead(reader, {
                                            _chunkSteps : function(chunk) {
                                                currentWrite = PerformPromiseThen(WritableStreamDefaultWriterWrite(writer, chunk), undefined, noop);
                                                resolveRead(false);
                                            },
                                            _closeSteps : function() {
                                                return resolveRead(true);
                                            },
                                            _errorSteps : rejectRead
                                        });
                                    });
                                });
                            }

                            isOrBecomesErrored(source, reader._closedPromise, function(storedError) {
                                if (!preventAbort) {
                                    shutdownWithAction(function() {
                                        return WritableStreamAbort(dest, storedError);
                                    }, true, storedError);
                                } else {
                                    shutdown(true, storedError);
                                }
                            });
                            isOrBecomesErrored(dest, writer._closedPromise, function(storedError) {
                                if (!preventCancel) {
                                    shutdownWithAction(function() {
                                        return ReadableStreamCancel(source, storedError);
                                    }, true, storedError);
                                } else {
                                    shutdown(true, storedError);
                                }
                            });
                            isOrBecomesClosed(source, reader._closedPromise, function() {
                                if (!preventClose) {
                                    shutdownWithAction(function() {
                                        return WritableStreamDefaultWriterCloseWithErrorPropagation(writer);
                                    });
                                } else {
                                    shutdown();
                                }
                            });
                            if (WritableStreamCloseQueuedOrInFlight(dest) || dest._state === 'closed') {
                                var destClosed_1 = new TypeError('the destination writable stream closed before all data could be piped to it');
                                if (!preventCancel) {
                                    shutdownWithAction(function() {
                                        return ReadableStreamCancel(source, destClosed_1);
                                    }, true, destClosed_1);
                                } else {
                                    shutdown(true, destClosed_1);
                                }
                            }
                            setPromiseIsHandledToTrue(pipeLoop());

                            function waitForWritesToFinish() {
                                var oldCurrentWrite = currentWrite;
                                return PerformPromiseThen(currentWrite, function() {
                                    return oldCurrentWrite !== currentWrite ? waitForWritesToFinish() : undefined;
                                });
                            }

                            function isOrBecomesErrored(stream, promise, action) {
                                if (stream._state === 'errored') {
                                    action(stream._storedError);
                                } else {
                                    uponRejection(promise, action);
                                }
                            }

                            function isOrBecomesClosed(stream, promise, action) {
                                if (stream._state === 'closed') {
                                    action();
                                } else {
                                    uponFulfillment(promise, action);
                                }
                            }

                            function shutdownWithAction(action, originalIsError, originalError) {
                                if (shuttingDown) {
                                    return;
                                }
                                shuttingDown = true;
                                if (dest._state === 'writable' && !WritableStreamCloseQueuedOrInFlight(dest)) {
                                    uponFulfillment(waitForWritesToFinish(), doTheRest);
                                } else {
                                    doTheRest();
                                }

                                function doTheRest() {
                                    uponPromise(action(), function() {
                                        return finalize(originalIsError, originalError);
                                    }, function(newError) {
                                        return finalize(true, newError);
                                    });
                                }
                            }

                            function shutdown(isError, error) {
                                if (shuttingDown) {
                                    return;
                                }
                                shuttingDown = true;
                                if (dest._state === 'writable' && !WritableStreamCloseQueuedOrInFlight(dest)) {
                                    uponFulfillment(waitForWritesToFinish(), function() {
                                        return finalize(isError, error);
                                    });
                                } else {
                                    finalize(isError, error);
                                }
                            }

                            function finalize(isError, error) {
                                WritableStreamDefaultWriterRelease(writer);
                                ReadableStreamReaderGenericRelease(reader);
                                if (signal !== undefined) {
                                    signal.removeEventListener('abort', abortAlgorithm);
                                }
                                if (isError) {
                                    reject(error);
                                } else {
                                    resolve(undefined);
                                }
                            }
                        });
                    }

                    var ReadableStreamDefaultController = function() {
                        function ReadableStreamDefaultController() {
                            throw new TypeError('Illegal constructor');
                        }

                        Object.defineProperty(ReadableStreamDefaultController.prototype, "desiredSize", {
                            get          : function() {
                                if (!IsReadableStreamDefaultController(this)) {
                                    throw defaultControllerBrandCheckException('desiredSize');
                                }
                                return ReadableStreamDefaultControllerGetDesiredSize(this);
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        ReadableStreamDefaultController.prototype.close = function() {
                            if (!IsReadableStreamDefaultController(this)) {
                                throw defaultControllerBrandCheckException('close');
                            }
                            if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(this)) {
                                throw new TypeError('The stream is not in a state that permits close');
                            }
                            ReadableStreamDefaultControllerClose(this);
                        };
                        ReadableStreamDefaultController.prototype.enqueue = function(chunk) {
                            if (chunk === void 0) {
                                chunk = undefined;
                            }
                            if (!IsReadableStreamDefaultController(this)) {
                                throw defaultControllerBrandCheckException('enqueue');
                            }
                            if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(this)) {
                                throw new TypeError('The stream is not in a state that permits enqueue');
                            }
                            return ReadableStreamDefaultControllerEnqueue(this, chunk);
                        };
                        ReadableStreamDefaultController.prototype.error = function(e) {
                            if (e === void 0) {
                                e = undefined;
                            }
                            if (!IsReadableStreamDefaultController(this)) {
                                throw defaultControllerBrandCheckException('error');
                            }
                            ReadableStreamDefaultControllerError(this, e);
                        };
                        ReadableStreamDefaultController.prototype[CancelSteps] = function(reason) {
                            ResetQueue(this);
                            var result = this._cancelAlgorithm(reason);
                            ReadableStreamDefaultControllerClearAlgorithms(this);
                            return result;
                        };
                        ReadableStreamDefaultController.prototype[PullSteps] = function(readRequest) {
                            var stream = this._controlledReadableStream;
                            if (this._queue.length > 0) {
                                var chunk = DequeueValue(this);
                                if (this._closeRequested && this._queue.length === 0) {
                                    ReadableStreamDefaultControllerClearAlgorithms(this);
                                    ReadableStreamClose(stream);
                                } else {
                                    ReadableStreamDefaultControllerCallPullIfNeeded(this);
                                }
                                readRequest._chunkSteps(chunk);
                            } else {
                                ReadableStreamAddReadRequest(stream, readRequest);
                                ReadableStreamDefaultControllerCallPullIfNeeded(this);
                            }
                        };
                        return ReadableStreamDefaultController;
                    }();
                    Object.defineProperties(ReadableStreamDefaultController.prototype, {
                        close       : {enumerable : true},
                        enqueue     : {enumerable : true},
                        error       : {enumerable : true},
                        desiredSize : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(ReadableStreamDefaultController.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'ReadableStreamDefaultController',
                            configurable : true
                        });
                    }

                    function IsReadableStreamDefaultController(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_controlledReadableStream')) {
                            return false;
                        }
                        return true;
                    }

                    function ReadableStreamDefaultControllerCallPullIfNeeded(controller) {
                        var shouldPull = ReadableStreamDefaultControllerShouldCallPull(controller);
                        if (!shouldPull) {
                            return;
                        }
                        if (controller._pulling) {
                            controller._pullAgain = true;
                            return;
                        }
                        controller._pulling = true;
                        var pullPromise = controller._pullAlgorithm();
                        uponPromise(pullPromise, function() {
                            controller._pulling = false;
                            if (controller._pullAgain) {
                                controller._pullAgain = false;
                                ReadableStreamDefaultControllerCallPullIfNeeded(controller);
                            }
                        }, function(e) {
                            ReadableStreamDefaultControllerError(controller, e);
                        });
                    }

                    function ReadableStreamDefaultControllerShouldCallPull(controller) {
                        var stream = controller._controlledReadableStream;
                        if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(controller)) {
                            return false;
                        }
                        if (!controller._started) {
                            return false;
                        }
                        if (IsReadableStreamLocked(stream) && ReadableStreamGetNumReadRequests(stream) > 0) {
                            return true;
                        }
                        var desiredSize = ReadableStreamDefaultControllerGetDesiredSize(controller);
                        if (desiredSize > 0) {
                            return true;
                        }
                        return false;
                    }

                    function ReadableStreamDefaultControllerClearAlgorithms(controller) {
                        controller._pullAlgorithm = undefined;
                        controller._cancelAlgorithm = undefined;
                        controller._strategySizeAlgorithm = undefined;
                    }

                    function ReadableStreamDefaultControllerClose(controller) {
                        if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(controller)) {
                            return;
                        }
                        var stream = controller._controlledReadableStream;
                        controller._closeRequested = true;
                        if (controller._queue.length === 0) {
                            ReadableStreamDefaultControllerClearAlgorithms(controller);
                            ReadableStreamClose(stream);
                        }
                    }

                    function ReadableStreamDefaultControllerEnqueue(controller, chunk) {
                        if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(controller)) {
                            return;
                        }
                        var stream = controller._controlledReadableStream;
                        if (IsReadableStreamLocked(stream) && ReadableStreamGetNumReadRequests(stream) > 0) {
                            ReadableStreamFulfillReadRequest(stream, chunk, false);
                        } else {
                            var chunkSize = void 0;
                            try {
                                chunkSize = controller._strategySizeAlgorithm(chunk);
                            } catch (chunkSizeE) {
                                ReadableStreamDefaultControllerError(controller, chunkSizeE);
                                throw chunkSizeE;
                            }
                            try {
                                EnqueueValueWithSize(controller, chunk, chunkSize);
                            } catch (enqueueE) {
                                ReadableStreamDefaultControllerError(controller, enqueueE);
                                throw enqueueE;
                            }
                        }
                        ReadableStreamDefaultControllerCallPullIfNeeded(controller);
                    }

                    function ReadableStreamDefaultControllerError(controller, e) {
                        var stream = controller._controlledReadableStream;
                        if (stream._state !== 'readable') {
                            return;
                        }
                        ResetQueue(controller);
                        ReadableStreamDefaultControllerClearAlgorithms(controller);
                        ReadableStreamError(stream, e);
                    }

                    function ReadableStreamDefaultControllerGetDesiredSize(controller) {
                        var state = controller._controlledReadableStream._state;
                        if (state === 'errored') {
                            return null;
                        }
                        if (state === 'closed') {
                            return 0;
                        }
                        return controller._strategyHWM - controller._queueTotalSize;
                    }

                    function ReadableStreamDefaultControllerHasBackpressure(controller) {
                        if (ReadableStreamDefaultControllerShouldCallPull(controller)) {
                            return false;
                        }
                        return true;
                    }

                    function ReadableStreamDefaultControllerCanCloseOrEnqueue(controller) {
                        var state = controller._controlledReadableStream._state;
                        if (!controller._closeRequested && state === 'readable') {
                            return true;
                        }
                        return false;
                    }

                    function SetUpReadableStreamDefaultController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, sizeAlgorithm) {
                        controller._controlledReadableStream = stream;
                        controller._queue = undefined;
                        controller._queueTotalSize = undefined;
                        ResetQueue(controller);
                        controller._started = false;
                        controller._closeRequested = false;
                        controller._pullAgain = false;
                        controller._pulling = false;
                        controller._strategySizeAlgorithm = sizeAlgorithm;
                        controller._strategyHWM = highWaterMark;
                        controller._pullAlgorithm = pullAlgorithm;
                        controller._cancelAlgorithm = cancelAlgorithm;
                        stream._readableStreamController = controller;
                        var startResult = startAlgorithm();
                        uponPromise(promiseResolvedWith(startResult), function() {
                            controller._started = true;
                            ReadableStreamDefaultControllerCallPullIfNeeded(controller);
                        }, function(r) {
                            ReadableStreamDefaultControllerError(controller, r);
                        });
                    }

                    function SetUpReadableStreamDefaultControllerFromUnderlyingSource(stream, underlyingSource, highWaterMark, sizeAlgorithm) {
                        var controller = Object.create(ReadableStreamDefaultController.prototype);
                        var startAlgorithm = function() {
                            return undefined;
                        };
                        var pullAlgorithm = function() {
                            return promiseResolvedWith(undefined);
                        };
                        var cancelAlgorithm = function() {
                            return promiseResolvedWith(undefined);
                        };
                        if (underlyingSource.start !== undefined) {
                            startAlgorithm = function() {
                                return underlyingSource.start(controller);
                            };
                        }
                        if (underlyingSource.pull !== undefined) {
                            pullAlgorithm = function() {
                                return underlyingSource.pull(controller);
                            };
                        }
                        if (underlyingSource.cancel !== undefined) {
                            cancelAlgorithm = function(reason) {
                                return underlyingSource.cancel(reason);
                            };
                        }
                        SetUpReadableStreamDefaultController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, sizeAlgorithm);
                    }

                    function defaultControllerBrandCheckException(name) {
                        return new TypeError("ReadableStreamDefaultController.prototype." + name + " can only be used on a ReadableStreamDefaultController");
                    }

                    function ReadableStreamTee(stream, cloneForBranch2) {
                        var reader = AcquireReadableStreamDefaultReader(stream);
                        var reading = false;
                        var canceled1 = false;
                        var canceled2 = false;
                        var reason1;
                        var reason2;
                        var branch1;
                        var branch2;
                        var resolveCancelPromise;
                        var cancelPromise = newPromise(function(resolve) {
                            resolveCancelPromise = resolve;
                        });

                        function pullAlgorithm() {
                            if (reading) {
                                return promiseResolvedWith(undefined);
                            }
                            reading = true;
                            var readRequest = {
                                _chunkSteps : function(value) {
                                    queueMicrotask(function() {
                                        reading = false;
                                        var value1 = value;
                                        var value2 = value;
                                        if (!canceled1) {
                                            ReadableStreamDefaultControllerEnqueue(branch1._readableStreamController, value1);
                                        }
                                        if (!canceled2) {
                                            ReadableStreamDefaultControllerEnqueue(branch2._readableStreamController, value2);
                                        }
                                        resolveCancelPromise(undefined);
                                    });
                                },
                                _closeSteps : function() {
                                    reading = false;
                                    if (!canceled1) {
                                        ReadableStreamDefaultControllerClose(branch1._readableStreamController);
                                    }
                                    if (!canceled2) {
                                        ReadableStreamDefaultControllerClose(branch2._readableStreamController);
                                    }
                                },
                                _errorSteps : function() {
                                    reading = false;
                                }
                            };
                            ReadableStreamDefaultReaderRead(reader, readRequest);
                            return promiseResolvedWith(undefined);
                        }

                        function cancel1Algorithm(reason) {
                            canceled1 = true;
                            reason1 = reason;
                            if (canceled2) {
                                var compositeReason = CreateArrayFromList([
                                    reason1,
                                    reason2
                                ]);
                                var cancelResult = ReadableStreamCancel(stream, compositeReason);
                                resolveCancelPromise(cancelResult);
                            }
                            return cancelPromise;
                        }

                        function cancel2Algorithm(reason) {
                            canceled2 = true;
                            reason2 = reason;
                            if (canceled1) {
                                var compositeReason = CreateArrayFromList([
                                    reason1,
                                    reason2
                                ]);
                                var cancelResult = ReadableStreamCancel(stream, compositeReason);
                                resolveCancelPromise(cancelResult);
                            }
                            return cancelPromise;
                        }

                        function startAlgorithm() {
                        }

                        branch1 = CreateReadableStream(startAlgorithm, pullAlgorithm, cancel1Algorithm);
                        branch2 = CreateReadableStream(startAlgorithm, pullAlgorithm, cancel2Algorithm);
                        uponRejection(reader._closedPromise, function(r) {
                            ReadableStreamDefaultControllerError(branch1._readableStreamController, r);
                            ReadableStreamDefaultControllerError(branch2._readableStreamController, r);
                            resolveCancelPromise(undefined);
                        });
                        return [
                            branch1,
                            branch2
                        ];
                    }

                    function convertUnderlyingDefaultOrByteSource(source, context) {
                        assertDictionary(source, context);
                        var original = source;
                        var autoAllocateChunkSize = original === null || original === void 0 ? void 0 : original.autoAllocateChunkSize;
                        var cancel = original === null || original === void 0 ? void 0 : original.cancel;
                        var pull = original === null || original === void 0 ? void 0 : original.pull;
                        var start = original === null || original === void 0 ? void 0 : original.start;
                        var type = original === null || original === void 0 ? void 0 : original.type;
                        return {
                            autoAllocateChunkSize : autoAllocateChunkSize === undefined ? undefined : convertUnsignedLongLongWithEnforceRange(autoAllocateChunkSize, context + " has member 'autoAllocateChunkSize' that"),
                            cancel                : cancel === undefined ? undefined : convertUnderlyingSourceCancelCallback(cancel, original, context + " has member 'cancel' that"),
                            pull                  : pull === undefined ? undefined : convertUnderlyingSourcePullCallback(pull, original, context + " has member 'pull' that"),
                            start                 : start === undefined ? undefined : convertUnderlyingSourceStartCallback(start, original, context + " has member 'start' that"),
                            type                  : type === undefined ? undefined : convertReadableStreamType(type, context + " has member 'type' that")
                        };
                    }

                    function convertUnderlyingSourceCancelCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function(reason) {
                            return promiseCall(fn, original, [reason]);
                        };
                    }

                    function convertUnderlyingSourcePullCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function(controller) {
                            return promiseCall(fn, original, [controller]);
                        };
                    }

                    function convertUnderlyingSourceStartCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function(controller) {
                            return reflectCall(fn, original, [controller]);
                        };
                    }

                    function convertReadableStreamType(type, context) {
                        type = "" + type;
                        if (type !== 'bytes') {
                            throw new TypeError(context + " '" + type + "' is not a valid enumeration value for ReadableStreamType");
                        }
                        return type;
                    }

                    function convertReaderOptions(options, context) {
                        assertDictionary(options, context);
                        var mode = options === null || options === void 0 ? void 0 : options.mode;
                        return {mode : mode === undefined ? undefined : convertReadableStreamReaderMode(mode, context + " has member 'mode' that")};
                    }

                    function convertReadableStreamReaderMode(mode, context) {
                        mode = "" + mode;
                        if (mode !== 'byob') {
                            throw new TypeError(context + " '" + mode + "' is not a valid enumeration value for ReadableStreamReaderMode");
                        }
                        return mode;
                    }

                    function convertIteratorOptions(options, context) {
                        assertDictionary(options, context);
                        var preventCancel = options === null || options === void 0 ? void 0 : options.preventCancel;
                        return {preventCancel : Boolean(preventCancel)};
                    }

                    function convertPipeOptions(options, context) {
                        assertDictionary(options, context);
                        var preventAbort = options === null || options === void 0 ? void 0 : options.preventAbort;
                        var preventCancel = options === null || options === void 0 ? void 0 : options.preventCancel;
                        var preventClose = options === null || options === void 0 ? void 0 : options.preventClose;
                        var signal = options === null || options === void 0 ? void 0 : options.signal;
                        if (signal !== undefined) {
                            assertAbortSignal(signal, context + " has member 'signal' that");
                        }
                        return {
                            preventAbort  : Boolean(preventAbort),
                            preventCancel : Boolean(preventCancel),
                            preventClose  : Boolean(preventClose),
                            signal        : signal
                        };
                    }

                    function assertAbortSignal(signal, context) {
                        if (!isAbortSignal(signal)) {
                            throw new TypeError(context + " is not an AbortSignal.");
                        }
                    }

                    function convertReadableWritablePair(pair, context) {
                        assertDictionary(pair, context);
                        var readable = pair === null || pair === void 0 ? void 0 : pair.readable;
                        assertRequiredField(readable, 'readable', 'ReadableWritablePair');
                        assertReadableStream(readable, context + " has member 'readable' that");
                        var writable = pair === null || pair === void 0 ? void 0 : pair.writable;
                        assertRequiredField(writable, 'writable', 'ReadableWritablePair');
                        assertWritableStream(writable, context + " has member 'writable' that");
                        return {
                            readable : readable,
                            writable : writable
                        };
                    }

                    var ReadableStream = function() {
                        function ReadableStream(rawUnderlyingSource, rawStrategy) {
                            if (rawUnderlyingSource === void 0) {
                                rawUnderlyingSource = {};
                            }
                            if (rawStrategy === void 0) {
                                rawStrategy = {};
                            }
                            if (rawUnderlyingSource === undefined) {
                                rawUnderlyingSource = null;
                            } else {
                                assertObject(rawUnderlyingSource, 'First parameter');
                            }
                            var strategy = convertQueuingStrategy(rawStrategy, 'Second parameter');
                            var underlyingSource = convertUnderlyingDefaultOrByteSource(rawUnderlyingSource, 'First parameter');
                            InitializeReadableStream(this);
                            if (underlyingSource.type === 'bytes') {
                                if (strategy.size !== undefined) {
                                    throw new RangeError('The strategy for a byte stream cannot have a size function');
                                }
                                var highWaterMark = ExtractHighWaterMark(strategy, 0);
                                SetUpReadableByteStreamControllerFromUnderlyingSource(this, underlyingSource, highWaterMark);
                            } else {
                                var sizeAlgorithm = ExtractSizeAlgorithm(strategy);
                                var highWaterMark = ExtractHighWaterMark(strategy, 1);
                                SetUpReadableStreamDefaultControllerFromUnderlyingSource(this, underlyingSource, highWaterMark, sizeAlgorithm);
                            }
                        }

                        Object.defineProperty(ReadableStream.prototype, "locked", {
                            get          : function() {
                                if (!IsReadableStream(this)) {
                                    throw streamBrandCheckException$1('locked');
                                }
                                return IsReadableStreamLocked(this);
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        ReadableStream.prototype.cancel = function(reason) {
                            if (reason === void 0) {
                                reason = undefined;
                            }
                            if (!IsReadableStream(this)) {
                                return promiseRejectedWith(streamBrandCheckException$1('cancel'));
                            }
                            if (IsReadableStreamLocked(this)) {
                                return promiseRejectedWith(new TypeError('Cannot cancel a stream that already has a reader'));
                            }
                            return ReadableStreamCancel(this, reason);
                        };
                        ReadableStream.prototype.getReader = function(rawOptions) {
                            if (rawOptions === void 0) {
                                rawOptions = undefined;
                            }
                            if (!IsReadableStream(this)) {
                                throw streamBrandCheckException$1('getReader');
                            }
                            var options = convertReaderOptions(rawOptions, 'First parameter');
                            if (options.mode === undefined) {
                                return AcquireReadableStreamDefaultReader(this);
                            }
                            return AcquireReadableStreamBYOBReader(this);
                        };
                        ReadableStream.prototype.pipeThrough = function(rawTransform, rawOptions) {
                            if (rawOptions === void 0) {
                                rawOptions = {};
                            }
                            if (!IsReadableStream(this)) {
                                throw streamBrandCheckException$1('pipeThrough');
                            }
                            assertRequiredArgument(rawTransform, 1, 'pipeThrough');
                            var transform = convertReadableWritablePair(rawTransform, 'First parameter');
                            var options = convertPipeOptions(rawOptions, 'Second parameter');
                            if (IsReadableStreamLocked(this)) {
                                throw new TypeError('ReadableStream.prototype.pipeThrough cannot be used on a locked ReadableStream');
                            }
                            if (IsWritableStreamLocked(transform.writable)) {
                                throw new TypeError('ReadableStream.prototype.pipeThrough cannot be used on a locked WritableStream');
                            }
                            var promise = ReadableStreamPipeTo(this, transform.writable, options.preventClose, options.preventAbort, options.preventCancel, options.signal);
                            setPromiseIsHandledToTrue(promise);
                            return transform.readable;
                        };
                        ReadableStream.prototype.pipeTo = function(destination, rawOptions) {
                            if (rawOptions === void 0) {
                                rawOptions = {};
                            }
                            if (!IsReadableStream(this)) {
                                return promiseRejectedWith(streamBrandCheckException$1('pipeTo'));
                            }
                            if (destination === undefined) {
                                return promiseRejectedWith("Parameter 1 is required in 'pipeTo'.");
                            }
                            if (!IsWritableStream(destination)) {
                                return promiseRejectedWith(new TypeError("ReadableStream.prototype.pipeTo's first argument must be a WritableStream"));
                            }
                            var options;
                            try {
                                options = convertPipeOptions(rawOptions, 'Second parameter');
                            } catch (e) {
                                return promiseRejectedWith(e);
                            }
                            if (IsReadableStreamLocked(this)) {
                                return promiseRejectedWith(new TypeError('ReadableStream.prototype.pipeTo cannot be used on a locked ReadableStream'));
                            }
                            if (IsWritableStreamLocked(destination)) {
                                return promiseRejectedWith(new TypeError('ReadableStream.prototype.pipeTo cannot be used on a locked WritableStream'));
                            }
                            return ReadableStreamPipeTo(this, destination, options.preventClose, options.preventAbort, options.preventCancel, options.signal);
                        };
                        ReadableStream.prototype.tee = function() {
                            if (!IsReadableStream(this)) {
                                throw streamBrandCheckException$1('tee');
                            }
                            var branches = ReadableStreamTee(this);
                            return CreateArrayFromList(branches);
                        };
                        ReadableStream.prototype.values = function(rawOptions) {
                            if (rawOptions === void 0) {
                                rawOptions = undefined;
                            }
                            if (!IsReadableStream(this)) {
                                throw streamBrandCheckException$1('values');
                            }
                            var options = convertIteratorOptions(rawOptions, 'First parameter');
                            return AcquireReadableStreamAsyncIterator(this, options.preventCancel);
                        };
                        return ReadableStream;
                    }();
                    Object.defineProperties(ReadableStream.prototype, {
                        cancel      : {enumerable : true},
                        getReader   : {enumerable : true},
                        pipeThrough : {enumerable : true},
                        pipeTo      : {enumerable : true},
                        tee         : {enumerable : true},
                        values      : {enumerable : true},
                        locked      : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(ReadableStream.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'ReadableStream',
                            configurable : true
                        });
                    }
                    if (typeof SymbolPolyfill.asyncIterator === 'symbol') {
                        Object.defineProperty(ReadableStream.prototype, SymbolPolyfill.asyncIterator, {
                            value        : ReadableStream.prototype.values,
                            writable     : true,
                            configurable : true
                        });
                    }

                    function CreateReadableStream(startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, sizeAlgorithm) {
                        if (highWaterMark === void 0) {
                            highWaterMark = 1;
                        }
                        if (sizeAlgorithm === void 0) {
                            sizeAlgorithm = function() {
                                return 1;
                            };
                        }
                        var stream = Object.create(ReadableStream.prototype);
                        InitializeReadableStream(stream);
                        var controller = Object.create(ReadableStreamDefaultController.prototype);
                        SetUpReadableStreamDefaultController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, sizeAlgorithm);
                        return stream;
                    }

                    function InitializeReadableStream(stream) {
                        stream._state = 'readable';
                        stream._reader = undefined;
                        stream._storedError = undefined;
                        stream._disturbed = false;
                    }

                    function IsReadableStream(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_readableStreamController')) {
                            return false;
                        }
                        return true;
                    }

                    function IsReadableStreamLocked(stream) {
                        if (stream._reader === undefined) {
                            return false;
                        }
                        return true;
                    }

                    function ReadableStreamCancel(stream, reason) {
                        stream._disturbed = true;
                        if (stream._state === 'closed') {
                            return promiseResolvedWith(undefined);
                        }
                        if (stream._state === 'errored') {
                            return promiseRejectedWith(stream._storedError);
                        }
                        ReadableStreamClose(stream);
                        var sourceCancelPromise = stream._readableStreamController[CancelSteps](reason);
                        return transformPromiseWith(sourceCancelPromise, noop);
                    }

                    function ReadableStreamClose(stream) {
                        stream._state = 'closed';
                        var reader = stream._reader;
                        if (reader === undefined) {
                            return;
                        }
                        defaultReaderClosedPromiseResolve(reader);
                        if (IsReadableStreamDefaultReader(reader)) {
                            reader._readRequests.forEach(function(readRequest) {
                                readRequest._closeSteps();
                            });
                            reader._readRequests = new SimpleQueue();
                        }
                    }

                    function ReadableStreamError(stream, e) {
                        stream._state = 'errored';
                        stream._storedError = e;
                        var reader = stream._reader;
                        if (reader === undefined) {
                            return;
                        }
                        defaultReaderClosedPromiseReject(reader, e);
                        if (IsReadableStreamDefaultReader(reader)) {
                            reader._readRequests.forEach(function(readRequest) {
                                readRequest._errorSteps(e);
                            });
                            reader._readRequests = new SimpleQueue();
                        } else {
                            reader._readIntoRequests.forEach(function(readIntoRequest) {
                                readIntoRequest._errorSteps(e);
                            });
                            reader._readIntoRequests = new SimpleQueue();
                        }
                    }

                    function streamBrandCheckException$1(name) {
                        return new TypeError("ReadableStream.prototype." + name + " can only be used on a ReadableStream");
                    }

                    function convertQueuingStrategyInit(init, context) {
                        assertDictionary(init, context);
                        var highWaterMark = init === null || init === void 0 ? void 0 : init.highWaterMark;
                        assertRequiredField(highWaterMark, 'highWaterMark', 'QueuingStrategyInit');
                        return {highWaterMark : convertUnrestrictedDouble(highWaterMark)};
                    }

                    var byteLengthSizeFunction = function size(chunk) {
                        return chunk.byteLength;
                    };
                    var ByteLengthQueuingStrategy = function() {
                        function ByteLengthQueuingStrategy(options) {
                            assertRequiredArgument(options, 1, 'ByteLengthQueuingStrategy');
                            options = convertQueuingStrategyInit(options, 'First parameter');
                            this._byteLengthQueuingStrategyHighWaterMark = options.highWaterMark;
                        }

                        Object.defineProperty(ByteLengthQueuingStrategy.prototype, "highWaterMark", {
                            get          : function() {
                                if (!IsByteLengthQueuingStrategy(this)) {
                                    throw byteLengthBrandCheckException('highWaterMark');
                                }
                                return this._byteLengthQueuingStrategyHighWaterMark;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        Object.defineProperty(ByteLengthQueuingStrategy.prototype, "size", {
                            get          : function() {
                                if (!IsByteLengthQueuingStrategy(this)) {
                                    throw byteLengthBrandCheckException('size');
                                }
                                return byteLengthSizeFunction;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        return ByteLengthQueuingStrategy;
                    }();
                    Object.defineProperties(ByteLengthQueuingStrategy.prototype, {
                        highWaterMark : {enumerable : true},
                        size          : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(ByteLengthQueuingStrategy.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'ByteLengthQueuingStrategy',
                            configurable : true
                        });
                    }

                    function byteLengthBrandCheckException(name) {
                        return new TypeError("ByteLengthQueuingStrategy.prototype." + name + " can only be used on a ByteLengthQueuingStrategy");
                    }

                    function IsByteLengthQueuingStrategy(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_byteLengthQueuingStrategyHighWaterMark')) {
                            return false;
                        }
                        return true;
                    }

                    var countSizeFunction = function size() {
                        return 1;
                    };
                    var CountQueuingStrategy = function() {
                        function CountQueuingStrategy(options) {
                            assertRequiredArgument(options, 1, 'CountQueuingStrategy');
                            options = convertQueuingStrategyInit(options, 'First parameter');
                            this._countQueuingStrategyHighWaterMark = options.highWaterMark;
                        }

                        Object.defineProperty(CountQueuingStrategy.prototype, "highWaterMark", {
                            get          : function() {
                                if (!IsCountQueuingStrategy(this)) {
                                    throw countBrandCheckException('highWaterMark');
                                }
                                return this._countQueuingStrategyHighWaterMark;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        Object.defineProperty(CountQueuingStrategy.prototype, "size", {
                            get          : function() {
                                if (!IsCountQueuingStrategy(this)) {
                                    throw countBrandCheckException('size');
                                }
                                return countSizeFunction;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        return CountQueuingStrategy;
                    }();
                    Object.defineProperties(CountQueuingStrategy.prototype, {
                        highWaterMark : {enumerable : true},
                        size          : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(CountQueuingStrategy.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'CountQueuingStrategy',
                            configurable : true
                        });
                    }

                    function countBrandCheckException(name) {
                        return new TypeError("CountQueuingStrategy.prototype." + name + " can only be used on a CountQueuingStrategy");
                    }

                    function IsCountQueuingStrategy(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_countQueuingStrategyHighWaterMark')) {
                            return false;
                        }
                        return true;
                    }

                    function convertTransformer(original, context) {
                        assertDictionary(original, context);
                        var flush = original === null || original === void 0 ? void 0 : original.flush;
                        var readableType = original === null || original === void 0 ? void 0 : original.readableType;
                        var start = original === null || original === void 0 ? void 0 : original.start;
                        var transform = original === null || original === void 0 ? void 0 : original.transform;
                        var writableType = original === null || original === void 0 ? void 0 : original.writableType;
                        return {
                            flush        : flush === undefined ? undefined : convertTransformerFlushCallback(flush, original, context + " has member 'flush' that"),
                            readableType : readableType,
                            start        : start === undefined ? undefined : convertTransformerStartCallback(start, original, context + " has member 'start' that"),
                            transform    : transform === undefined ? undefined : convertTransformerTransformCallback(transform, original, context + " has member 'transform' that"),
                            writableType : writableType
                        };
                    }

                    function convertTransformerFlushCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function(controller) {
                            return promiseCall(fn, original, [controller]);
                        };
                    }

                    function convertTransformerStartCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function(controller) {
                            return reflectCall(fn, original, [controller]);
                        };
                    }

                    function convertTransformerTransformCallback(fn, original, context) {
                        assertFunction(fn, context);
                        return function(chunk, controller) {
                            return promiseCall(fn, original, [
                                chunk,
                                controller
                            ]);
                        };
                    }

                    var TransformStream = function() {
                        function TransformStream(rawTransformer, rawWritableStrategy, rawReadableStrategy) {
                            if (rawTransformer === void 0) {
                                rawTransformer = {};
                            }
                            if (rawWritableStrategy === void 0) {
                                rawWritableStrategy = {};
                            }
                            if (rawReadableStrategy === void 0) {
                                rawReadableStrategy = {};
                            }
                            if (rawTransformer === undefined) {
                                rawTransformer = null;
                            }
                            var writableStrategy = convertQueuingStrategy(rawWritableStrategy, 'Second parameter');
                            var readableStrategy = convertQueuingStrategy(rawReadableStrategy, 'Third parameter');
                            var transformer = convertTransformer(rawTransformer, 'First parameter');
                            if (transformer.readableType !== undefined) {
                                throw new RangeError('Invalid readableType specified');
                            }
                            if (transformer.writableType !== undefined) {
                                throw new RangeError('Invalid writableType specified');
                            }
                            var readableHighWaterMark = ExtractHighWaterMark(readableStrategy, 0);
                            var readableSizeAlgorithm = ExtractSizeAlgorithm(readableStrategy);
                            var writableHighWaterMark = ExtractHighWaterMark(writableStrategy, 1);
                            var writableSizeAlgorithm = ExtractSizeAlgorithm(writableStrategy);
                            var startPromise_resolve;
                            var startPromise = newPromise(function(resolve) {
                                startPromise_resolve = resolve;
                            });
                            InitializeTransformStream(this, startPromise, writableHighWaterMark, writableSizeAlgorithm, readableHighWaterMark, readableSizeAlgorithm);
                            SetUpTransformStreamDefaultControllerFromTransformer(this, transformer);
                            if (transformer.start !== undefined) {
                                startPromise_resolve(transformer.start(this._transformStreamController));
                            } else {
                                startPromise_resolve(undefined);
                            }
                        }

                        Object.defineProperty(TransformStream.prototype, "readable", {
                            get          : function() {
                                if (!IsTransformStream(this)) {
                                    throw streamBrandCheckException$2('readable');
                                }
                                return this._readable;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        Object.defineProperty(TransformStream.prototype, "writable", {
                            get          : function() {
                                if (!IsTransformStream(this)) {
                                    throw streamBrandCheckException$2('writable');
                                }
                                return this._writable;
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        return TransformStream;
                    }();
                    Object.defineProperties(TransformStream.prototype, {
                        readable : {enumerable : true},
                        writable : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(TransformStream.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'TransformStream',
                            configurable : true
                        });
                    }

                    function InitializeTransformStream(stream, startPromise, writableHighWaterMark, writableSizeAlgorithm, readableHighWaterMark, readableSizeAlgorithm) {
                        function startAlgorithm() {
                            return startPromise;
                        }

                        function writeAlgorithm(chunk) {
                            return TransformStreamDefaultSinkWriteAlgorithm(stream, chunk);
                        }

                        function abortAlgorithm(reason) {
                            return TransformStreamDefaultSinkAbortAlgorithm(stream, reason);
                        }

                        function closeAlgorithm() {
                            return TransformStreamDefaultSinkCloseAlgorithm(stream);
                        }

                        stream._writable = CreateWritableStream(startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, writableHighWaterMark, writableSizeAlgorithm);

                        function pullAlgorithm() {
                            return TransformStreamDefaultSourcePullAlgorithm(stream);
                        }

                        function cancelAlgorithm(reason) {
                            TransformStreamErrorWritableAndUnblockWrite(stream, reason);
                            return promiseResolvedWith(undefined);
                        }

                        stream._readable = CreateReadableStream(startAlgorithm, pullAlgorithm, cancelAlgorithm, readableHighWaterMark, readableSizeAlgorithm);
                        stream._backpressure = undefined;
                        stream._backpressureChangePromise = undefined;
                        stream._backpressureChangePromise_resolve = undefined;
                        TransformStreamSetBackpressure(stream, true);
                        stream._transformStreamController = undefined;
                    }

                    function IsTransformStream(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_transformStreamController')) {
                            return false;
                        }
                        return true;
                    }

                    function TransformStreamError(stream, e) {
                        ReadableStreamDefaultControllerError(stream._readable._readableStreamController, e);
                        TransformStreamErrorWritableAndUnblockWrite(stream, e);
                    }

                    function TransformStreamErrorWritableAndUnblockWrite(stream, e) {
                        TransformStreamDefaultControllerClearAlgorithms(stream._transformStreamController);
                        WritableStreamDefaultControllerErrorIfNeeded(stream._writable._writableStreamController, e);
                        if (stream._backpressure) {
                            TransformStreamSetBackpressure(stream, false);
                        }
                    }

                    function TransformStreamSetBackpressure(stream, backpressure) {
                        if (stream._backpressureChangePromise !== undefined) {
                            stream._backpressureChangePromise_resolve();
                        }
                        stream._backpressureChangePromise = newPromise(function(resolve) {
                            stream._backpressureChangePromise_resolve = resolve;
                        });
                        stream._backpressure = backpressure;
                    }

                    var TransformStreamDefaultController = function() {
                        function TransformStreamDefaultController() {
                            throw new TypeError('Illegal constructor');
                        }

                        Object.defineProperty(TransformStreamDefaultController.prototype, "desiredSize", {
                            get          : function() {
                                if (!IsTransformStreamDefaultController(this)) {
                                    throw defaultControllerBrandCheckException$1('desiredSize');
                                }
                                var readableController = this._controlledTransformStream._readable._readableStreamController;
                                return ReadableStreamDefaultControllerGetDesiredSize(readableController);
                            },
                            enumerable   : false,
                            configurable : true
                        });
                        TransformStreamDefaultController.prototype.enqueue = function(chunk) {
                            if (chunk === void 0) {
                                chunk = undefined;
                            }
                            if (!IsTransformStreamDefaultController(this)) {
                                throw defaultControllerBrandCheckException$1('enqueue');
                            }
                            TransformStreamDefaultControllerEnqueue(this, chunk);
                        };
                        TransformStreamDefaultController.prototype.error = function(reason) {
                            if (reason === void 0) {
                                reason = undefined;
                            }
                            if (!IsTransformStreamDefaultController(this)) {
                                throw defaultControllerBrandCheckException$1('error');
                            }
                            TransformStreamDefaultControllerError(this, reason);
                        };
                        TransformStreamDefaultController.prototype.terminate = function() {
                            if (!IsTransformStreamDefaultController(this)) {
                                throw defaultControllerBrandCheckException$1('terminate');
                            }
                            TransformStreamDefaultControllerTerminate(this);
                        };
                        return TransformStreamDefaultController;
                    }();
                    Object.defineProperties(TransformStreamDefaultController.prototype, {
                        enqueue     : {enumerable : true},
                        error       : {enumerable : true},
                        terminate   : {enumerable : true},
                        desiredSize : {enumerable : true}
                    });
                    if (typeof SymbolPolyfill.toStringTag === 'symbol') {
                        Object.defineProperty(TransformStreamDefaultController.prototype, SymbolPolyfill.toStringTag, {
                            value        : 'TransformStreamDefaultController',
                            configurable : true
                        });
                    }

                    function IsTransformStreamDefaultController(x) {
                        if (!typeIsObject(x)) {
                            return false;
                        }
                        if (!Object.prototype.hasOwnProperty.call(x, '_controlledTransformStream')) {
                            return false;
                        }
                        return true;
                    }

                    function SetUpTransformStreamDefaultController(stream, controller, transformAlgorithm, flushAlgorithm) {
                        controller._controlledTransformStream = stream;
                        stream._transformStreamController = controller;
                        controller._transformAlgorithm = transformAlgorithm;
                        controller._flushAlgorithm = flushAlgorithm;
                    }

                    function SetUpTransformStreamDefaultControllerFromTransformer(stream, transformer) {
                        var controller = Object.create(TransformStreamDefaultController.prototype);
                        var transformAlgorithm = function(chunk) {
                            try {
                                TransformStreamDefaultControllerEnqueue(controller, chunk);
                                return promiseResolvedWith(undefined);
                            } catch (transformResultE) {
                                return promiseRejectedWith(transformResultE);
                            }
                        };
                        var flushAlgorithm = function() {
                            return promiseResolvedWith(undefined);
                        };
                        if (transformer.transform !== undefined) {
                            transformAlgorithm = function(chunk) {
                                return transformer.transform(chunk, controller);
                            };
                        }
                        if (transformer.flush !== undefined) {
                            flushAlgorithm = function() {
                                return transformer.flush(controller);
                            };
                        }
                        SetUpTransformStreamDefaultController(stream, controller, transformAlgorithm, flushAlgorithm);
                    }

                    function TransformStreamDefaultControllerClearAlgorithms(controller) {
                        controller._transformAlgorithm = undefined;
                        controller._flushAlgorithm = undefined;
                    }

                    function TransformStreamDefaultControllerEnqueue(controller, chunk) {
                        var stream = controller._controlledTransformStream;
                        var readableController = stream._readable._readableStreamController;
                        if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(readableController)) {
                            throw new TypeError('Readable side is not in a state that permits enqueue');
                        }
                        try {
                            ReadableStreamDefaultControllerEnqueue(readableController, chunk);
                        } catch (e) {
                            TransformStreamErrorWritableAndUnblockWrite(stream, e);
                            throw stream._readable._storedError;
                        }
                        var backpressure = ReadableStreamDefaultControllerHasBackpressure(readableController);
                        if (backpressure !== stream._backpressure) {
                            TransformStreamSetBackpressure(stream, true);
                        }
                    }

                    function TransformStreamDefaultControllerError(controller, e) {
                        TransformStreamError(controller._controlledTransformStream, e);
                    }

                    function TransformStreamDefaultControllerPerformTransform(controller, chunk) {
                        var transformPromise = controller._transformAlgorithm(chunk);
                        return transformPromiseWith(transformPromise, undefined, function(r) {
                            TransformStreamError(controller._controlledTransformStream, r);
                            throw r;
                        });
                    }

                    function TransformStreamDefaultControllerTerminate(controller) {
                        var stream = controller._controlledTransformStream;
                        var readableController = stream._readable._readableStreamController;
                        ReadableStreamDefaultControllerClose(readableController);
                        var error = new TypeError('TransformStream terminated');
                        TransformStreamErrorWritableAndUnblockWrite(stream, error);
                    }

                    function TransformStreamDefaultSinkWriteAlgorithm(stream, chunk) {
                        var controller = stream._transformStreamController;
                        if (stream._backpressure) {
                            var backpressureChangePromise = stream._backpressureChangePromise;
                            return transformPromiseWith(backpressureChangePromise, function() {
                                var writable = stream._writable;
                                var state = writable._state;
                                if (state === 'erroring') {
                                    throw writable._storedError;
                                }
                                return TransformStreamDefaultControllerPerformTransform(controller, chunk);
                            });
                        }
                        return TransformStreamDefaultControllerPerformTransform(controller, chunk);
                    }

                    function TransformStreamDefaultSinkAbortAlgorithm(stream, reason) {
                        TransformStreamError(stream, reason);
                        return promiseResolvedWith(undefined);
                    }

                    function TransformStreamDefaultSinkCloseAlgorithm(stream) {
                        var readable = stream._readable;
                        var controller = stream._transformStreamController;
                        var flushPromise = controller._flushAlgorithm();
                        TransformStreamDefaultControllerClearAlgorithms(controller);
                        return transformPromiseWith(flushPromise, function() {
                            if (readable._state === 'errored') {
                                throw readable._storedError;
                            }
                            ReadableStreamDefaultControllerClose(readable._readableStreamController);
                        }, function(r) {
                            TransformStreamError(stream, r);
                            throw readable._storedError;
                        });
                    }

                    function TransformStreamDefaultSourcePullAlgorithm(stream) {
                        TransformStreamSetBackpressure(stream, false);
                        return stream._backpressureChangePromise;
                    }

                    function defaultControllerBrandCheckException$1(name) {
                        return new TypeError("TransformStreamDefaultController.prototype." + name + " can only be used on a TransformStreamDefaultController");
                    }

                    function streamBrandCheckException$2(name) {
                        return new TypeError("TransformStream.prototype." + name + " can only be used on a TransformStream");
                    }

                    exports.ByteLengthQueuingStrategy = ByteLengthQueuingStrategy;
                    exports.CountQueuingStrategy = CountQueuingStrategy;
                    exports.ReadableByteStreamController = ReadableByteStreamController;
                    exports.ReadableStream = ReadableStream;
                    exports.ReadableStreamBYOBReader = ReadableStreamBYOBReader;
                    exports.ReadableStreamBYOBRequest = ReadableStreamBYOBRequest;
                    exports.ReadableStreamDefaultController = ReadableStreamDefaultController;
                    exports.ReadableStreamDefaultReader = ReadableStreamDefaultReader;
                    exports.TransformStream = TransformStream;
                    exports.TransformStreamDefaultController = TransformStreamDefaultController;
                    exports.WritableStream = WritableStream;
                    exports.WritableStreamDefaultController = WritableStreamDefaultController;
                    exports.WritableStreamDefaultWriter = WritableStreamDefaultWriter;
                    Object.defineProperty(exports, '__esModule', {value : true});
                }));

                /***/
            }),
            /* 112 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                __w_pdfjs_require__(113);
                var entryUnbind = __w_pdfjs_require__(117);
                module.exports = entryUnbind('String', 'padStart');

                /***/
            }),
            /* 113 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var $ = __w_pdfjs_require__(9);
                var $padStart = __w_pdfjs_require__(114).start;
                var WEBKIT_BUG = __w_pdfjs_require__(116);
                $({
                    target : 'String',
                    proto  : true,
                    forced : WEBKIT_BUG
                }, {
                    padStart : function padStart(maxLength) {
                        return $padStart(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
                    }
                });

                /***/
            }),
            /* 114 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var toLength = __w_pdfjs_require__(46);
                var repeat = __w_pdfjs_require__(115);
                var requireObjectCoercible = __w_pdfjs_require__(19);
                var ceil = Math.ceil;
                var createMethod = function(IS_END) {
                    return function($this, maxLength, fillString) {
                        var S = String(requireObjectCoercible($this));
                        var stringLength = S.length;
                        var fillStr = fillString === undefined ? ' ' : String(fillString);
                        var intMaxLength = toLength(maxLength);
                        var fillLen, stringFiller;
                        if (intMaxLength <= stringLength || fillStr == '')
                            return S;
                        fillLen = intMaxLength - stringLength;
                        stringFiller = repeat.call(fillStr, ceil(fillLen / fillStr.length));
                        if (stringFiller.length > fillLen)
                            stringFiller = stringFiller.slice(0, fillLen);
                        return IS_END ? S + stringFiller : stringFiller + S;
                    };
                };
                module.exports = {
                    start : createMethod(false),
                    end   : createMethod(true)
                };

                /***/
            }),
            /* 115 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var toInteger = __w_pdfjs_require__(47);
                var requireObjectCoercible = __w_pdfjs_require__(19);
                module.exports = function repeat(count) {
                    var str = String(requireObjectCoercible(this));
                    var result = '';
                    var n = toInteger(count);
                    if (n < 0 || n == Infinity)
                        throw RangeError('Wrong number of repetitions');
                    for (; n > 0; (n >>>= 1) && (str += str))
                        if (n & 1)
                            result += str;
                    return result;
                };

                /***/
            }),
            /* 116 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var userAgent = __w_pdfjs_require__(59);
                module.exports = /Version\/10\.\d+(\.\d+)?( Mobile\/\w+)? Safari\//.test(userAgent);

                /***/
            }),
            /* 117 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var global = __w_pdfjs_require__(10);
                var bind = __w_pdfjs_require__(78);
                var call = Function.call;
                module.exports = function(CONSTRUCTOR, METHOD, length) {
                    return bind(call, global[CONSTRUCTOR].prototype[METHOD], length);
                };

                /***/
            }),
            /* 118 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                __w_pdfjs_require__(119);
                var entryUnbind = __w_pdfjs_require__(117);
                module.exports = entryUnbind('String', 'padEnd');

                /***/
            }),
            /* 119 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                "use strict";

                var $ = __w_pdfjs_require__(9);
                var $padEnd = __w_pdfjs_require__(114).end;
                var WEBKIT_BUG = __w_pdfjs_require__(116);
                $({
                    target : 'String',
                    proto  : true,
                    forced : WEBKIT_BUG
                }, {
                    padEnd : function padEnd(maxLength) {
                        return $padEnd(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
                    }
                });

                /***/
            }),
            /* 120 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                __w_pdfjs_require__(121);
                var path = __w_pdfjs_require__(42);
                module.exports = path.Object.values;

                /***/
            }),
            /* 121 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var $ = __w_pdfjs_require__(9);
                var $values = __w_pdfjs_require__(122).values;
                $({
                    target : 'Object',
                    stat   : true
                }, {
                    values : function values(O) {
                        return $values(O);
                    }
                });

                /***/
            }),
            /* 122 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var DESCRIPTORS = __w_pdfjs_require__(12);
                var objectKeys = __w_pdfjs_require__(63);
                var toIndexedObject = __w_pdfjs_require__(16);
                var propertyIsEnumerable = __w_pdfjs_require__(14).f;
                var createMethod = function(TO_ENTRIES) {
                    return function(it) {
                        var O = toIndexedObject(it);
                        var keys = objectKeys(O);
                        var length = keys.length;
                        var i = 0;
                        var result = [];
                        var key;
                        while (length > i) {
                            key = keys[i++];
                            if (!DESCRIPTORS || propertyIsEnumerable.call(O, key)) {
                                result.push(TO_ENTRIES ? [
                                    key,
                                    O[key]
                                ] : O[key]);
                            }
                        }
                        return result;
                    };
                };
                module.exports = {
                    entries : createMethod(true),
                    values  : createMethod(false)
                };

                /***/
            }),
            /* 123 */
            /***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

                __w_pdfjs_require__(124);
                var path = __w_pdfjs_require__(42);
                module.exports = path.Object.entries;

                /***/
            }),
            /* 124 */
            /***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

                var $ = __w_pdfjs_require__(9);
                var $entries = __w_pdfjs_require__(122).entries;
                $({
                    target : 'Object',
                    stat   : true
                }, {
                    entries : function entries(O) {
                        return $entries(O);
                    }
                });

                /***/
            }),
            /* 125 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.clearPrimitiveCaches = clearPrimitiveCaches;
                exports.isCmd = isCmd;
                exports.isDict = isDict;
                exports.isEOF = isEOF;
                exports.isName = isName;
                exports.isRef = isRef;
                exports.isRefsEqual = isRefsEqual;
                exports.isStream = isStream;
                exports.RefSetCache = exports.RefSet = exports.Ref = exports.Name = exports.EOF = exports.Dict = exports.Cmd = void 0;

                var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

                var _util = __w_pdfjs_require__(4);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {"default" : obj};
                }

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                function _slicedToArray(arr, i) {
                    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
                }

                function _nonIterableRest() {
                    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                }

                function _iterableToArrayLimit(arr, i) {
                    if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
                    var _arr = [];
                    var _n = true;
                    var _d = false;
                    var _e = undefined;
                    try {
                        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                            _arr.push(_s.value);
                            if (i && _arr.length === i) break;
                        }
                    } catch (err) {
                        _d = true;
                        _e = err;
                    } finally {
                        try {
                            if (!_n && _i["return"] != null) _i["return"]();
                        } finally {
                            if (_d) throw _e;
                        }
                    }
                    return _arr;
                }

                function _arrayWithHoles(arr) {
                    if (Array.isArray(arr)) return arr;
                }

                function _createForOfIteratorHelper(o, allowArrayLike) {
                    var it;
                    if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
                        if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
                            if (it) o = it;
                            var i = 0;
                            var F = function F() {
                            };
                            return {
                                s    : F, n : function n() {
                                    if (i >= o.length) return {done : true};
                                    return {done : false, value : o[i++]};
                                }, e : function e(_e2) {
                                    throw _e2;
                                }, f : F
                            };
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                    }
                    var normalCompletion = true, didErr = false, err;
                    return {
                        s    : function s() {
                            it = o[Symbol.iterator]();
                        }, n : function n() {
                            var step = it.next();
                            normalCompletion = step.done;
                            return step;
                        }, e : function e(_e3) {
                            didErr = true;
                            err = _e3;
                        }, f : function f() {
                            try {
                                if (!normalCompletion && it["return"] != null) it["return"]();
                            } finally {
                                if (didErr) throw err;
                            }
                        }
                    };
                }

                function _unsupportedIterableToArray(o, minLen) {
                    if (!o) return;
                    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
                    var n = Object.prototype.toString.call(o).slice(8, -1);
                    if (n === "Object" && o.constructor) n = o.constructor.name;
                    if (n === "Map" || n === "Set") return Array.from(o);
                    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
                }

                function _arrayLikeToArray(arr, len) {
                    if (len == null || len > arr.length) len = arr.length;
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i];
                    }
                    return arr2;
                }

                function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
                    try {
                        var info = gen[key](arg);
                        var value = info.value;
                    } catch (error) {
                        reject(error);
                        return;
                    }
                    if (info.done) {
                        resolve(value);
                    } else {
                        Promise.resolve(value).then(_next, _throw);
                    }
                }

                function _asyncToGenerator(fn) {
                    return function() {
                        var self = this, args = arguments;
                        return new Promise(function(resolve, reject) {
                            var gen = fn.apply(self, args);

                            function _next(value) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
                            }

                            function _throw(err) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
                            }

                            _next(undefined);
                        });
                    };
                }

                var EOF = {};
                exports.EOF = EOF;

                var Name = function NameClosure() {
                    var nameCache = Object.create(null);

                    function Name(name) {
                        this.name = name;
                    }

                    Name.prototype = {};

                    Name.get = function Name_get(name) {
                        var nameValue = nameCache[name];
                        return nameValue ? nameValue : nameCache[name] = new Name(name);
                    };

                    Name._clearCache = function() {
                        nameCache = Object.create(null);
                    };

                    return Name;
                }();

                exports.Name = Name;

                var Cmd = function CmdClosure() {
                    var cmdCache = Object.create(null);

                    function Cmd(cmd) {
                        this.cmd = cmd;
                    }

                    Cmd.prototype = {};

                    Cmd.get = function Cmd_get(cmd) {
                        var cmdValue = cmdCache[cmd];
                        return cmdValue ? cmdValue : cmdCache[cmd] = new Cmd(cmd);
                    };

                    Cmd._clearCache = function() {
                        cmdCache = Object.create(null);
                    };

                    return Cmd;
                }();

                exports.Cmd = Cmd;

                var Dict = function DictClosure() {
                    var nonSerializable = function nonSerializableClosure() {
                        return nonSerializable;
                    };

                    function Dict(xref) {
                        this._map = Object.create(null);
                        this.xref = xref;
                        this.objId = null;
                        this.suppressEncryption = false;
                        this.__nonSerializable__ = nonSerializable;
                    }

                    Dict.prototype = {
                        assignXref : function Dict_assignXref(newXref) {
                            this.xref = newXref;
                        },

                        get size() {
                            return Object.keys(this._map).length;
                        },

                        get          : function get(key1, key2, key3) {
                            var value = this._map[key1];

                            if (value === undefined && key2 !== undefined) {
                                value = this._map[key2];

                                if (value === undefined && key3 !== undefined) {
                                    value = this._map[key3];
                                }
                            }

                            if (value instanceof Ref && this.xref) {
                                return this.xref.fetch(value, this.suppressEncryption);
                            }

                            return value;
                        },
                        getAsync     : function getAsync(key1, key2, key3) {
                            var _this = this;

                            return _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee() {
                                var value;
                                return _regenerator["default"].wrap(function _callee$(_context) {
                                    while (1) {
                                        switch (_context.prev = _context.next) {
                                            case 0:
                                                value = _this._map[key1];

                                                if (value === undefined && key2 !== undefined) {
                                                    value = _this._map[key2];

                                                    if (value === undefined && key3 !== undefined) {
                                                        value = _this._map[key3];
                                                    }
                                                }

                                                if (!(value instanceof Ref && _this.xref)) {
                                                    _context.next = 4;
                                                    break;
                                                }

                                                return _context.abrupt("return", _this.xref.fetchAsync(value, _this.suppressEncryption));

                                            case 4:
                                                return _context.abrupt("return", value);

                                            case 5:
                                            case "end":
                                                return _context.stop();
                                        }
                                    }
                                }, _callee);
                            }))();
                        },
                        getArray     : function getArray(key1, key2, key3) {
                            var value = this.get(key1, key2, key3);

                            if (!Array.isArray(value) || !this.xref) {
                                return value;
                            }

                            value = value.slice();

                            for (var i = 0, ii = value.length; i < ii; i++) {
                                if (!(value[i] instanceof Ref)) {
                                    continue;
                                }

                                value[i] = this.xref.fetch(value[i], this.suppressEncryption);
                            }

                            return value;
                        },
                        getRaw       : function Dict_getRaw(key) {
                            return this._map[key];
                        },
                        getKeys      : function Dict_getKeys() {
                            return Object.keys(this._map);
                        },
                        getRawValues : function Dict_getRawValues() {
                            return Object.values(this._map);
                        },
                        set          : function Dict_set(key, value) {
                            this._map[key] = value;
                        },
                        has          : function Dict_has(key) {
                            return this._map[key] !== undefined;
                        },
                        forEach      : function Dict_forEach(callback) {
                            for (var key in this._map) {
                                callback(key, this.get(key));
                            }
                        }
                    };

                    Dict.empty = function() {
                        var emptyDict = new Dict(null);

                        emptyDict.set = function(key, value) {
                            (0, _util.unreachable)("Should not call `set` on the empty dictionary.");
                        };

                        return emptyDict;
                    }();

                    Dict.merge = function(_ref) {
                        var xref               = _ref.xref,
                            dictArray          = _ref.dictArray,
                            _ref$mergeSubDicts = _ref.mergeSubDicts,
                            mergeSubDicts      = _ref$mergeSubDicts === void 0 ? false : _ref$mergeSubDicts;
                        var mergedDict = new Dict(xref);

                        if (!mergeSubDicts) {
                            var _iterator = _createForOfIteratorHelper(dictArray),
                                _step;

                            try {
                                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                                    var dict = _step.value;

                                    if (!(dict instanceof Dict)) {
                                        continue;
                                    }

                                    for (var _i = 0, _Object$entries = Object.entries(dict._map); _i < _Object$entries.length; _i++) {
                                        var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
                                            key                = _Object$entries$_i[0],
                                            value              = _Object$entries$_i[1];

                                        if (mergedDict._map[key] === undefined) {
                                            mergedDict._map[key] = value;
                                        }
                                    }
                                }
                            } catch (err) {
                                _iterator.e(err);
                            } finally {
                                _iterator.f();
                            }

                            return mergedDict.size > 0 ? mergedDict : Dict.empty;
                        }

                        var properties = new Map();

                        var _iterator2 = _createForOfIteratorHelper(dictArray),
                            _step2;

                        try {
                            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                                var _dict = _step2.value;

                                if (!(_dict instanceof Dict)) {
                                    continue;
                                }

                                for (var _i2 = 0, _Object$entries2 = Object.entries(_dict._map); _i2 < _Object$entries2.length; _i2++) {
                                    var _Object$entries2$_i = _slicedToArray(_Object$entries2[_i2], 2),
                                        _key                = _Object$entries2$_i[0],
                                        _value              = _Object$entries2$_i[1];

                                    var property = properties.get(_key);

                                    if (property === undefined) {
                                        property = [];
                                        properties.set(_key, property);
                                    }

                                    property.push(_value);
                                }
                            }
                        } catch (err) {
                            _iterator2.e(err);
                        } finally {
                            _iterator2.f();
                        }

                        var _iterator3 = _createForOfIteratorHelper(properties),
                            _step3;

                        try {
                            for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                                var _step3$value = _slicedToArray(_step3.value, 2),
                                    name         = _step3$value[0],
                                    values       = _step3$value[1];

                                if (values.length === 1 || !(values[0] instanceof Dict)) {
                                    mergedDict._map[name] = values[0];
                                    continue;
                                }

                                var subDict = new Dict(xref);

                                var _iterator4 = _createForOfIteratorHelper(values),
                                    _step4;

                                try {
                                    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                                        var _dict2 = _step4.value;

                                        if (!(_dict2 instanceof Dict)) {
                                            continue;
                                        }

                                        for (var _i3 = 0, _Object$entries3 = Object.entries(_dict2._map); _i3 < _Object$entries3.length; _i3++) {
                                            var _Object$entries3$_i = _slicedToArray(_Object$entries3[_i3], 2),
                                                _key2               = _Object$entries3$_i[0],
                                                _value2             = _Object$entries3$_i[1];

                                            if (subDict._map[_key2] === undefined) {
                                                subDict._map[_key2] = _value2;
                                            }
                                        }
                                    }
                                } catch (err) {
                                    _iterator4.e(err);
                                } finally {
                                    _iterator4.f();
                                }

                                if (subDict.size > 0) {
                                    mergedDict._map[name] = subDict;
                                }
                            }
                        } catch (err) {
                            _iterator3.e(err);
                        } finally {
                            _iterator3.f();
                        }

                        properties.clear();
                        return mergedDict.size > 0 ? mergedDict : Dict.empty;
                    };

                    return Dict;
                }();

                exports.Dict = Dict;

                var Ref = function RefClosure() {
                    var refCache = Object.create(null);

                    function Ref(num, gen) {
                        this.num = num;
                        this.gen = gen;
                    }

                    Ref.prototype = {
                        toString : function Ref_toString() {
                            if (this.gen === 0) {
                                return "".concat(this.num, "R");
                            }

                            return "".concat(this.num, "R").concat(this.gen);
                        }
                    };

                    Ref.get = function(num, gen) {
                        var key = gen === 0 ? "".concat(num, "R") : "".concat(num, "R").concat(gen);
                        var refValue = refCache[key];
                        return refValue ? refValue : refCache[key] = new Ref(num, gen);
                    };

                    Ref._clearCache = function() {
                        refCache = Object.create(null);
                    };

                    return Ref;
                }();

                exports.Ref = Ref;

                var RefSet = /*#__PURE__*/function() {
                    function RefSet() {
                        var parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

                        _classCallCheck(this, RefSet);

                        this._set = new Set(parent && parent._set);
                    }

                    _createClass(RefSet, [{
                        key   : "has",
                        value : function has(ref) {
                            return this._set.has(ref.toString());
                        }
                    }, {
                        key   : "put",
                        value : function put(ref) {
                            this._set.add(ref.toString());
                        }
                    }, {
                        key   : "remove",
                        value : function remove(ref) {
                            this._set["delete"](ref.toString());
                        }
                    }, {
                        key   : "forEach",
                        value : function forEach(callback) {
                            var _iterator5 = _createForOfIteratorHelper(this._set.values()),
                                _step5;

                            try {
                                for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                                    var ref = _step5.value;
                                    callback(ref);
                                }
                            } catch (err) {
                                _iterator5.e(err);
                            } finally {
                                _iterator5.f();
                            }
                        }
                    }, {
                        key   : "clear",
                        value : function clear() {
                            this._set.clear();
                        }
                    }]);

                    return RefSet;
                }();

                exports.RefSet = RefSet;

                var RefSetCache = /*#__PURE__*/function() {
                    function RefSetCache() {
                        _classCallCheck(this, RefSetCache);

                        this._map = new Map();
                    }

                    _createClass(RefSetCache, [{
                        key : "size",
                        get : function get() {
                            return this._map.size;
                        }
                    }, {
                        key   : "get",
                        value : function get(ref) {
                            return this._map.get(ref.toString());
                        }
                    }, {
                        key   : "has",
                        value : function has(ref) {
                            return this._map.has(ref.toString());
                        }
                    }, {
                        key   : "put",
                        value : function put(ref, obj) {
                            this._map.set(ref.toString(), obj);
                        }
                    }, {
                        key   : "putAlias",
                        value : function putAlias(ref, aliasRef) {
                            this._map.set(ref.toString(), this.get(aliasRef));
                        }
                    }, {
                        key   : "forEach",
                        value : function forEach(callback) {
                            var _iterator6 = _createForOfIteratorHelper(this._map.values()),
                                _step6;

                            try {
                                for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
                                    var value = _step6.value;
                                    callback(value);
                                }
                            } catch (err) {
                                _iterator6.e(err);
                            } finally {
                                _iterator6.f();
                            }
                        }
                    }, {
                        key   : "clear",
                        value : function clear() {
                            this._map.clear();
                        }
                    }]);

                    return RefSetCache;
                }();

                exports.RefSetCache = RefSetCache;

                function isEOF(v) {
                    return v === EOF;
                }

                function isName(v, name) {
                    return v instanceof Name && (name === undefined || v.name === name);
                }

                function isCmd(v, cmd) {
                    return v instanceof Cmd && (cmd === undefined || v.cmd === cmd);
                }

                function isDict(v, type) {
                    return v instanceof Dict && (type === undefined || isName(v.get("Type"), type));
                }

                function isRef(v) {
                    return v instanceof Ref;
                }

                function isRefsEqual(v1, v2) {
                    return v1.num === v2.num && v1.gen === v2.gen;
                }

                function isStream(v) {
                    return _typeof(v) === "object" && v !== null && v.getBytes !== undefined;
                }

                function clearPrimitiveCaches() {
                    Cmd._clearCache();

                    Name._clearCache();

                    Ref._clearCache();
                }

                /***/
            }),
            /* 126 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.NetworkPdfManager = exports.LocalPdfManager = void 0;

                var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

                var _util = __w_pdfjs_require__(4);

                var _chunked_stream = __w_pdfjs_require__(127);

                var _core_utils = __w_pdfjs_require__(128);

                var _document = __w_pdfjs_require__(129);

                var _stream = __w_pdfjs_require__(132);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {"default" : obj};
                }

                function _inherits(subClass, superClass) {
                    if (typeof superClass !== "function" && superClass !== null) {
                        throw new TypeError("Super expression must either be null or a function");
                    }
                    subClass.prototype = Object.create(superClass && superClass.prototype, {
                        constructor : {
                            value        : subClass,
                            writable     : true,
                            configurable : true
                        }
                    });
                    if (superClass) _setPrototypeOf(subClass, superClass);
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
                        o.__proto__ = p;
                        return o;
                    };
                    return _setPrototypeOf(o, p);
                }

                function _createSuper(Derived) {
                    var hasNativeReflectConstruct = _isNativeReflectConstruct();
                    return function _createSuperInternal() {
                        var Super = _getPrototypeOf(Derived), result;
                        if (hasNativeReflectConstruct) {
                            var NewTarget = _getPrototypeOf(this).constructor;
                            result = Reflect.construct(Super, arguments, NewTarget);
                        } else {
                            result = Super.apply(this, arguments);
                        }
                        return _possibleConstructorReturn(this, result);
                    };
                }

                function _possibleConstructorReturn(self, call) {
                    if (call && (_typeof(call) === "object" || typeof call === "function")) {
                        return call;
                    }
                    return _assertThisInitialized(self);
                }

                function _assertThisInitialized(self) {
                    if (self === void 0) {
                        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                    }
                    return self;
                }

                function _isNativeReflectConstruct() {
                    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
                    if (Reflect.construct.sham) return false;
                    if (typeof Proxy === "function") return true;
                    try {
                        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
                        }));
                        return true;
                    } catch (e) {
                        return false;
                    }
                }

                function _getPrototypeOf(o) {
                    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
                        return o.__proto__ || Object.getPrototypeOf(o);
                    };
                    return _getPrototypeOf(o);
                }

                function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
                    try {
                        var info = gen[key](arg);
                        var value = info.value;
                    } catch (error) {
                        reject(error);
                        return;
                    }
                    if (info.done) {
                        resolve(value);
                    } else {
                        Promise.resolve(value).then(_next, _throw);
                    }
                }

                function _asyncToGenerator(fn) {
                    return function() {
                        var self = this, args = arguments;
                        return new Promise(function(resolve, reject) {
                            var gen = fn.apply(self, args);

                            function _next(value) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
                            }

                            function _throw(err) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
                            }

                            _next(undefined);
                        });
                    };
                }

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                function parseDocBaseUrl(url) {
                    if (url) {
                        var absoluteUrl = (0, _util.createValidAbsoluteUrl)(url);

                        if (absoluteUrl) {
                            return absoluteUrl.href;
                        }

                        (0, _util.warn)("Invalid absolute docBaseUrl: \"".concat(url, "\"."));
                    }

                    return null;
                }

                var BasePdfManager = /*#__PURE__*/function() {
                    function BasePdfManager() {
                        _classCallCheck(this, BasePdfManager);

                        if (this.constructor === BasePdfManager) {
                            (0, _util.unreachable)("Cannot initialize BasePdfManager.");
                        }
                    }

                    _createClass(BasePdfManager, [{
                        key : "docId",
                        get : function get() {
                            return this._docId;
                        }
                    }, {
                        key : "password",
                        get : function get() {
                            return this._password;
                        }
                    }, {
                        key : "docBaseUrl",
                        get : function get() {
                            return this._docBaseUrl;
                        }
                    }, {
                        key   : "onLoadedStream",
                        value : function onLoadedStream() {
                            (0, _util.unreachable)("Abstract method `onLoadedStream` called");
                        }
                    }, {
                        key   : "ensureDoc",
                        value : function ensureDoc(prop, args) {
                            return this.ensure(this.pdfDocument, prop, args);
                        }
                    }, {
                        key   : "ensureXRef",
                        value : function ensureXRef(prop, args) {
                            return this.ensure(this.pdfDocument.xref, prop, args);
                        }
                    }, {
                        key   : "ensureCatalog",
                        value : function ensureCatalog(prop, args) {
                            return this.ensure(this.pdfDocument.catalog, prop, args);
                        }
                    }, {
                        key   : "getPage",
                        value : function getPage(pageIndex) {
                            return this.pdfDocument.getPage(pageIndex);
                        }
                    }, {
                        key   : "fontFallback",
                        value : function fontFallback(id, handler) {
                            return this.pdfDocument.fontFallback(id, handler);
                        }
                    }, {
                        key   : "cleanup",
                        value : function cleanup() {
                            var manuallyTriggered = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                            return this.pdfDocument.cleanup(manuallyTriggered);
                        }
                    }, {
                        key   : "ensure",
                        value : function() {
                            var _ensure = _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee(obj, prop, args) {
                                return _regenerator["default"].wrap(function _callee$(_context) {
                                    while (1) {
                                        switch (_context.prev = _context.next) {
                                            case 0:
                                                (0, _util.unreachable)("Abstract method `ensure` called");

                                            case 1:
                                            case "end":
                                                return _context.stop();
                                        }
                                    }
                                }, _callee);
                            }));

                            function ensure(_x, _x2, _x3) {
                                return _ensure.apply(this, arguments);
                            }

                            return ensure;
                        }()
                    }, {
                        key   : "requestRange",
                        value : function requestRange(begin, end) {
                            (0, _util.unreachable)("Abstract method `requestRange` called");
                        }
                    }, {
                        key   : "requestLoadedStream",
                        value : function requestLoadedStream() {
                            (0, _util.unreachable)("Abstract method `requestLoadedStream` called");
                        }
                    }, {
                        key   : "sendProgressiveData",
                        value : function sendProgressiveData(chunk) {
                            (0, _util.unreachable)("Abstract method `sendProgressiveData` called");
                        }
                    }, {
                        key   : "updatePassword",
                        value : function updatePassword(password) {
                            this._password = password;
                        }
                    }, {
                        key   : "terminate",
                        value : function terminate(reason) {
                            (0, _util.unreachable)("Abstract method `terminate` called");
                        }
                    }]);

                    return BasePdfManager;
                }();

                var LocalPdfManager = /*#__PURE__*/function(_BasePdfManager) {
                    _inherits(LocalPdfManager, _BasePdfManager);

                    var _super = _createSuper(LocalPdfManager);

                    function LocalPdfManager(docId, data, password, evaluatorOptions, enableXfa, docBaseUrl) {
                        var _this;

                        _classCallCheck(this, LocalPdfManager);

                        _this = _super.call(this);
                        _this._docId = docId;
                        _this._password = password;
                        _this._docBaseUrl = parseDocBaseUrl(docBaseUrl);
                        _this.evaluatorOptions = evaluatorOptions;
                        _this.enableXfa = enableXfa;
                        var stream = new _stream.Stream(data);
                        _this.pdfDocument = new _document.PDFDocument(_assertThisInitialized(_this), stream);
                        _this._loadedStreamPromise = Promise.resolve(stream);
                        return _this;
                    }

                    _createClass(LocalPdfManager, [{
                        key   : "ensure",
                        value : function() {
                            var _ensure2 = _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee2(obj, prop, args) {
                                var value;
                                return _regenerator["default"].wrap(function _callee2$(_context2) {
                                    while (1) {
                                        switch (_context2.prev = _context2.next) {
                                            case 0:
                                                value = obj[prop];

                                                if (!(typeof value === "function")) {
                                                    _context2.next = 3;
                                                    break;
                                                }

                                                return _context2.abrupt("return", value.apply(obj, args));

                                            case 3:
                                                return _context2.abrupt("return", value);

                                            case 4:
                                            case "end":
                                                return _context2.stop();
                                        }
                                    }
                                }, _callee2);
                            }));

                            function ensure(_x4, _x5, _x6) {
                                return _ensure2.apply(this, arguments);
                            }

                            return ensure;
                        }()
                    }, {
                        key   : "requestRange",
                        value : function requestRange(begin, end) {
                            return Promise.resolve();
                        }
                    }, {
                        key   : "requestLoadedStream",
                        value : function requestLoadedStream() {
                        }
                    }, {
                        key   : "onLoadedStream",
                        value : function onLoadedStream() {
                            return this._loadedStreamPromise;
                        }
                    }, {
                        key   : "terminate",
                        value : function terminate(reason) {
                        }
                    }]);

                    return LocalPdfManager;
                }(BasePdfManager);

                exports.LocalPdfManager = LocalPdfManager;

                var NetworkPdfManager = /*#__PURE__*/function(_BasePdfManager2) {
                    _inherits(NetworkPdfManager, _BasePdfManager2);

                    var _super2 = _createSuper(NetworkPdfManager);

                    function NetworkPdfManager(docId, pdfNetworkStream, args, evaluatorOptions, enableXfa, docBaseUrl) {
                        var _this2;

                        _classCallCheck(this, NetworkPdfManager);

                        _this2 = _super2.call(this);
                        _this2._docId = docId;
                        _this2._password = args.password;
                        _this2._docBaseUrl = parseDocBaseUrl(docBaseUrl);
                        _this2.msgHandler = args.msgHandler;
                        _this2.evaluatorOptions = evaluatorOptions;
                        _this2.enableXfa = enableXfa;
                        _this2.streamManager = new _chunked_stream.ChunkedStreamManager(pdfNetworkStream, {
                            msgHandler       : args.msgHandler,
                            length           : args.length,
                            disableAutoFetch : args.disableAutoFetch,
                            rangeChunkSize   : args.rangeChunkSize
                        });
                        _this2.pdfDocument = new _document.PDFDocument(_assertThisInitialized(_this2), _this2.streamManager.getStream());
                        return _this2;
                    }

                    _createClass(NetworkPdfManager, [{
                        key   : "ensure",
                        value : function() {
                            var _ensure3 = _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee3(obj, prop, args) {
                                var value;
                                return _regenerator["default"].wrap(function _callee3$(_context3) {
                                    while (1) {
                                        switch (_context3.prev = _context3.next) {
                                            case 0:
                                                _context3.prev = 0;
                                                value = obj[prop];

                                                if (!(typeof value === "function")) {
                                                    _context3.next = 4;
                                                    break;
                                                }

                                                return _context3.abrupt("return", value.apply(obj, args));

                                            case 4:
                                                return _context3.abrupt("return", value);

                                            case 7:
                                                _context3.prev = 7;
                                                _context3.t0 = _context3["catch"](0);

                                                if (_context3.t0 instanceof _core_utils.MissingDataException) {
                                                    _context3.next = 11;
                                                    break;
                                                }

                                                throw _context3.t0;

                                            case 11:
                                                _context3.next = 13;
                                                return this.requestRange(_context3.t0.begin, _context3.t0.end);

                                            case 13:
                                                return _context3.abrupt("return", this.ensure(obj, prop, args));

                                            case 14:
                                            case "end":
                                                return _context3.stop();
                                        }
                                    }
                                }, _callee3, this, [[0, 7]]);
                            }));

                            function ensure(_x7, _x8, _x9) {
                                return _ensure3.apply(this, arguments);
                            }

                            return ensure;
                        }()
                    }, {
                        key   : "requestRange",
                        value : function requestRange(begin, end) {
                            return this.streamManager.requestRange(begin, end);
                        }
                    }, {
                        key   : "requestLoadedStream",
                        value : function requestLoadedStream() {
                            this.streamManager.requestAllChunks();
                        }
                    }, {
                        key   : "sendProgressiveData",
                        value : function sendProgressiveData(chunk) {
                            this.streamManager.onReceiveData({
                                chunk : chunk
                            });
                        }
                    }, {
                        key   : "onLoadedStream",
                        value : function onLoadedStream() {
                            return this.streamManager.onLoadedStream();
                        }
                    }, {
                        key   : "terminate",
                        value : function terminate(reason) {
                            this.streamManager.abort(reason);
                        }
                    }]);

                    return NetworkPdfManager;
                }(BasePdfManager);

                exports.NetworkPdfManager = NetworkPdfManager;

                /***/
            }),
            /* 127 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.ChunkedStreamManager = exports.ChunkedStream = void 0;

                var _util = __w_pdfjs_require__(4);

                var _core_utils = __w_pdfjs_require__(128);

                function _createForOfIteratorHelper(o, allowArrayLike) {
                    var it;
                    if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
                        if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
                            if (it) o = it;
                            var i = 0;
                            var F = function F() {
                            };
                            return {
                                s    : F, n : function n() {
                                    if (i >= o.length) return {done : true};
                                    return {done : false, value : o[i++]};
                                }, e : function e(_e) {
                                    throw _e;
                                }, f : F
                            };
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                    }
                    var normalCompletion = true, didErr = false, err;
                    return {
                        s    : function s() {
                            it = o[Symbol.iterator]();
                        }, n : function n() {
                            var step = it.next();
                            normalCompletion = step.done;
                            return step;
                        }, e : function e(_e2) {
                            didErr = true;
                            err = _e2;
                        }, f : function f() {
                            try {
                                if (!normalCompletion && it["return"] != null) it["return"]();
                            } finally {
                                if (didErr) throw err;
                            }
                        }
                    };
                }

                function _unsupportedIterableToArray(o, minLen) {
                    if (!o) return;
                    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
                    var n = Object.prototype.toString.call(o).slice(8, -1);
                    if (n === "Object" && o.constructor) n = o.constructor.name;
                    if (n === "Map" || n === "Set") return Array.from(o);
                    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
                }

                function _arrayLikeToArray(arr, len) {
                    if (len == null || len > arr.length) len = arr.length;
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i];
                    }
                    return arr2;
                }

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                var ChunkedStream = /*#__PURE__*/function() {
                    function ChunkedStream(length, chunkSize, manager) {
                        _classCallCheck(this, ChunkedStream);

                        this.bytes = new Uint8Array(length);
                        this.start = 0;
                        this.pos = 0;
                        this.end = length;
                        this.chunkSize = chunkSize;
                        this._loadedChunks = new Set();
                        this.numChunks = Math.ceil(length / chunkSize);
                        this.manager = manager;
                        this.progressiveDataLength = 0;
                        this.lastSuccessfulEnsureByteChunk = -1;
                    }

                    _createClass(ChunkedStream, [{
                        key   : "getMissingChunks",
                        value : function getMissingChunks() {
                            var chunks = [];

                            for (var chunk = 0, n = this.numChunks; chunk < n; ++chunk) {
                                if (!this._loadedChunks.has(chunk)) {
                                    chunks.push(chunk);
                                }
                            }

                            return chunks;
                        }
                    }, {
                        key   : "getBaseStreams",
                        value : function getBaseStreams() {
                            return [this];
                        }
                    }, {
                        key : "numChunksLoaded",
                        get : function get() {
                            return this._loadedChunks.size;
                        }
                    }, {
                        key   : "allChunksLoaded",
                        value : function allChunksLoaded() {
                            return this.numChunksLoaded === this.numChunks;
                        }
                    }, {
                        key   : "onReceiveData",
                        value : function onReceiveData(begin, chunk) {
                            var chunkSize = this.chunkSize;

                            if (begin % chunkSize !== 0) {
                                throw new Error("Bad begin offset: ".concat(begin));
                            }

                            var end = begin + chunk.byteLength;

                            if (end % chunkSize !== 0 && end !== this.bytes.length) {
                                throw new Error("Bad end offset: ".concat(end));
                            }

                            this.bytes.set(new Uint8Array(chunk), begin);
                            var beginChunk = Math.floor(begin / chunkSize);
                            var endChunk = Math.floor((end - 1) / chunkSize) + 1;

                            for (var curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
                                this._loadedChunks.add(curChunk);
                            }
                        }
                    }, {
                        key   : "onReceiveProgressiveData",
                        value : function onReceiveProgressiveData(data) {
                            var position = this.progressiveDataLength;
                            var beginChunk = Math.floor(position / this.chunkSize);
                            this.bytes.set(new Uint8Array(data), position);
                            position += data.byteLength;
                            this.progressiveDataLength = position;
                            var endChunk = position >= this.end ? this.numChunks : Math.floor(position / this.chunkSize);

                            for (var curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
                                this._loadedChunks.add(curChunk);
                            }
                        }
                    }, {
                        key   : "ensureByte",
                        value : function ensureByte(pos) {
                            if (pos < this.progressiveDataLength) {
                                return;
                            }

                            var chunk = Math.floor(pos / this.chunkSize);

                            if (chunk === this.lastSuccessfulEnsureByteChunk) {
                                return;
                            }

                            if (!this._loadedChunks.has(chunk)) {
                                throw new _core_utils.MissingDataException(pos, pos + 1);
                            }

                            this.lastSuccessfulEnsureByteChunk = chunk;
                        }
                    }, {
                        key   : "ensureRange",
                        value : function ensureRange(begin, end) {
                            if (begin >= end) {
                                return;
                            }

                            if (end <= this.progressiveDataLength) {
                                return;
                            }

                            var chunkSize = this.chunkSize;
                            var beginChunk = Math.floor(begin / chunkSize);
                            var endChunk = Math.floor((end - 1) / chunkSize) + 1;

                            for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
                                if (!this._loadedChunks.has(chunk)) {
                                    throw new _core_utils.MissingDataException(begin, end);
                                }
                            }
                        }
                    }, {
                        key   : "nextEmptyChunk",
                        value : function nextEmptyChunk(beginChunk) {
                            var numChunks = this.numChunks;

                            for (var i = 0; i < numChunks; ++i) {
                                var chunk = (beginChunk + i) % numChunks;

                                if (!this._loadedChunks.has(chunk)) {
                                    return chunk;
                                }
                            }

                            return null;
                        }
                    }, {
                        key   : "hasChunk",
                        value : function hasChunk(chunk) {
                            return this._loadedChunks.has(chunk);
                        }
                    }, {
                        key : "length",
                        get : function get() {
                            return this.end - this.start;
                        }
                    }, {
                        key : "isEmpty",
                        get : function get() {
                            return this.length === 0;
                        }
                    }, {
                        key   : "getByte",
                        value : function getByte() {
                            var pos = this.pos;

                            if (pos >= this.end) {
                                return -1;
                            }

                            if (pos >= this.progressiveDataLength) {
                                this.ensureByte(pos);
                            }

                            return this.bytes[this.pos++];
                        }
                    }, {
                        key   : "getUint16",
                        value : function getUint16() {
                            var b0 = this.getByte();
                            var b1 = this.getByte();

                            if (b0 === -1 || b1 === -1) {
                                return -1;
                            }

                            return (b0 << 8) + b1;
                        }
                    }, {
                        key   : "getInt32",
                        value : function getInt32() {
                            var b0 = this.getByte();
                            var b1 = this.getByte();
                            var b2 = this.getByte();
                            var b3 = this.getByte();
                            return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
                        }
                    }, {
                        key   : "getBytes",
                        value : function getBytes(length) {
                            var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                            var bytes = this.bytes;
                            var pos = this.pos;
                            var strEnd = this.end;

                            if (!length) {
                                if (strEnd > this.progressiveDataLength) {
                                    this.ensureRange(pos, strEnd);
                                }

                                var _subarray = bytes.subarray(pos, strEnd);

                                return forceClamped ? new Uint8ClampedArray(_subarray) : _subarray;
                            }

                            var end = pos + length;

                            if (end > strEnd) {
                                end = strEnd;
                            }

                            if (end > this.progressiveDataLength) {
                                this.ensureRange(pos, end);
                            }

                            this.pos = end;
                            var subarray = bytes.subarray(pos, end);
                            return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
                        }
                    }, {
                        key   : "peekByte",
                        value : function peekByte() {
                            var peekedByte = this.getByte();

                            if (peekedByte !== -1) {
                                this.pos--;
                            }

                            return peekedByte;
                        }
                    }, {
                        key   : "peekBytes",
                        value : function peekBytes(length) {
                            var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                            var bytes = this.getBytes(length, forceClamped);
                            this.pos -= bytes.length;
                            return bytes;
                        }
                    }, {
                        key   : "getByteRange",
                        value : function getByteRange(begin, end) {
                            if (begin < 0) {
                                begin = 0;
                            }

                            if (end > this.end) {
                                end = this.end;
                            }

                            if (end > this.progressiveDataLength) {
                                this.ensureRange(begin, end);
                            }

                            return this.bytes.subarray(begin, end);
                        }
                    }, {
                        key   : "skip",
                        value : function skip(n) {
                            if (!n) {
                                n = 1;
                            }

                            this.pos += n;
                        }
                    }, {
                        key   : "reset",
                        value : function reset() {
                            this.pos = this.start;
                        }
                    }, {
                        key   : "moveStart",
                        value : function moveStart() {
                            this.start = this.pos;
                        }
                    }, {
                        key   : "makeSubStream",
                        value : function makeSubStream(start, length, dict) {
                            if (length) {
                                if (start + length > this.progressiveDataLength) {
                                    this.ensureRange(start, start + length);
                                }
                            } else {
                                if (start >= this.progressiveDataLength) {
                                    this.ensureByte(start);
                                }
                            }

                            function ChunkedStreamSubstream() {
                            }

                            ChunkedStreamSubstream.prototype = Object.create(this);

                            ChunkedStreamSubstream.prototype.getMissingChunks = function() {
                                var chunkSize = this.chunkSize;
                                var beginChunk = Math.floor(this.start / chunkSize);
                                var endChunk = Math.floor((this.end - 1) / chunkSize) + 1;
                                var missingChunks = [];

                                for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
                                    if (!this._loadedChunks.has(chunk)) {
                                        missingChunks.push(chunk);
                                    }
                                }

                                return missingChunks;
                            };

                            ChunkedStreamSubstream.prototype.allChunksLoaded = function() {
                                if (this.numChunksLoaded === this.numChunks) {
                                    return true;
                                }

                                return this.getMissingChunks().length === 0;
                            };

                            var subStream = new ChunkedStreamSubstream();
                            subStream.pos = subStream.start = start;
                            subStream.end = start + length || this.end;
                            subStream.dict = dict;
                            return subStream;
                        }
                    }]);

                    return ChunkedStream;
                }();

                exports.ChunkedStream = ChunkedStream;

                var ChunkedStreamManager = /*#__PURE__*/function() {
                    function ChunkedStreamManager(pdfNetworkStream, args) {
                        _classCallCheck(this, ChunkedStreamManager);

                        this.length = args.length;
                        this.chunkSize = args.rangeChunkSize;
                        this.stream = new ChunkedStream(this.length, this.chunkSize, this);
                        this.pdfNetworkStream = pdfNetworkStream;
                        this.disableAutoFetch = args.disableAutoFetch;
                        this.msgHandler = args.msgHandler;
                        this.currRequestId = 0;
                        this._chunksNeededByRequest = new Map();
                        this._requestsByChunk = new Map();
                        this._promisesByRequest = new Map();
                        this.progressiveDataLength = 0;
                        this.aborted = false;
                        this._loadedStreamCapability = (0, _util.createPromiseCapability)();
                    }

                    _createClass(ChunkedStreamManager, [{
                        key   : "onLoadedStream",
                        value : function onLoadedStream() {
                            return this._loadedStreamCapability.promise;
                        }
                    }, {
                        key   : "sendRequest",
                        value : function sendRequest(begin, end) {
                            var _this = this;

                            var rangeReader = this.pdfNetworkStream.getRangeReader(begin, end);

                            if (!rangeReader.isStreamingSupported) {
                                rangeReader.onProgress = this.onProgress.bind(this);
                            }

                            var chunks = [],
                                loaded = 0;
                            var promise = new Promise(function(resolve, reject) {
                                var readChunk = function readChunk(chunk) {
                                    try {
                                        if (!chunk.done) {
                                            var data = chunk.value;
                                            chunks.push(data);
                                            loaded += (0, _util.arrayByteLength)(data);

                                            if (rangeReader.isStreamingSupported) {
                                                _this.onProgress({
                                                    loaded : loaded
                                                });
                                            }

                                            rangeReader.read().then(readChunk, reject);
                                            return;
                                        }

                                        var chunkData = (0, _util.arraysToBytes)(chunks);
                                        chunks = null;
                                        resolve(chunkData);
                                    } catch (e) {
                                        reject(e);
                                    }
                                };

                                rangeReader.read().then(readChunk, reject);
                            });
                            promise.then(function(data) {
                                if (_this.aborted) {
                                    return;
                                }

                                _this.onReceiveData({
                                    chunk : data,
                                    begin : begin
                                });
                            });
                        }
                    }, {
                        key   : "requestAllChunks",
                        value : function requestAllChunks() {
                            var missingChunks = this.stream.getMissingChunks();

                            this._requestChunks(missingChunks);

                            return this._loadedStreamCapability.promise;
                        }
                    }, {
                        key   : "_requestChunks",
                        value : function _requestChunks(chunks) {
                            var _this2 = this;

                            var requestId = this.currRequestId++;
                            var chunksNeeded = new Set();

                            this._chunksNeededByRequest.set(requestId, chunksNeeded);

                            var _iterator = _createForOfIteratorHelper(chunks),
                                _step;

                            try {
                                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                                    var chunk = _step.value;

                                    if (!this.stream.hasChunk(chunk)) {
                                        chunksNeeded.add(chunk);
                                    }
                                }
                            } catch (err) {
                                _iterator.e(err);
                            } finally {
                                _iterator.f();
                            }

                            if (chunksNeeded.size === 0) {
                                return Promise.resolve();
                            }

                            var capability = (0, _util.createPromiseCapability)();

                            this._promisesByRequest.set(requestId, capability);

                            var chunksToRequest = [];

                            var _iterator2 = _createForOfIteratorHelper(chunksNeeded),
                                _step2;

                            try {
                                for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                                    var _chunk = _step2.value;

                                    var requestIds = this._requestsByChunk.get(_chunk);

                                    if (!requestIds) {
                                        requestIds = [];

                                        this._requestsByChunk.set(_chunk, requestIds);

                                        chunksToRequest.push(_chunk);
                                    }

                                    requestIds.push(requestId);
                                }
                            } catch (err) {
                                _iterator2.e(err);
                            } finally {
                                _iterator2.f();
                            }

                            if (chunksToRequest.length > 0) {
                                var groupedChunksToRequest = this.groupChunks(chunksToRequest);

                                var _iterator3 = _createForOfIteratorHelper(groupedChunksToRequest),
                                    _step3;

                                try {
                                    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                                        var groupedChunk = _step3.value;
                                        var begin = groupedChunk.beginChunk * this.chunkSize;
                                        var end = Math.min(groupedChunk.endChunk * this.chunkSize, this.length);
                                        this.sendRequest(begin, end);
                                    }
                                } catch (err) {
                                    _iterator3.e(err);
                                } finally {
                                    _iterator3.f();
                                }
                            }

                            return capability.promise["catch"](function(reason) {
                                if (_this2.aborted) {
                                    return;
                                }

                                throw reason;
                            });
                        }
                    }, {
                        key   : "getStream",
                        value : function getStream() {
                            return this.stream;
                        }
                    }, {
                        key   : "requestRange",
                        value : function requestRange(begin, end) {
                            end = Math.min(end, this.length);
                            var beginChunk = this.getBeginChunk(begin);
                            var endChunk = this.getEndChunk(end);
                            var chunks = [];

                            for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
                                chunks.push(chunk);
                            }

                            return this._requestChunks(chunks);
                        }
                    }, {
                        key   : "requestRanges",
                        value : function requestRanges() {
                            var ranges = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
                            var chunksToRequest = [];

                            var _iterator4 = _createForOfIteratorHelper(ranges),
                                _step4;

                            try {
                                for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                                    var range = _step4.value;
                                    var beginChunk = this.getBeginChunk(range.begin);
                                    var endChunk = this.getEndChunk(range.end);

                                    for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
                                        if (!chunksToRequest.includes(chunk)) {
                                            chunksToRequest.push(chunk);
                                        }
                                    }
                                }
                            } catch (err) {
                                _iterator4.e(err);
                            } finally {
                                _iterator4.f();
                            }

                            chunksToRequest.sort(function(a, b) {
                                return a - b;
                            });
                            return this._requestChunks(chunksToRequest);
                        }
                    }, {
                        key   : "groupChunks",
                        value : function groupChunks(chunks) {
                            var groupedChunks = [];
                            var beginChunk = -1;
                            var prevChunk = -1;

                            for (var i = 0, ii = chunks.length; i < ii; ++i) {
                                var chunk = chunks[i];

                                if (beginChunk < 0) {
                                    beginChunk = chunk;
                                }

                                if (prevChunk >= 0 && prevChunk + 1 !== chunk) {
                                    groupedChunks.push({
                                        beginChunk : beginChunk,
                                        endChunk   : prevChunk + 1
                                    });
                                    beginChunk = chunk;
                                }

                                if (i + 1 === chunks.length) {
                                    groupedChunks.push({
                                        beginChunk : beginChunk,
                                        endChunk   : chunk + 1
                                    });
                                }

                                prevChunk = chunk;
                            }

                            return groupedChunks;
                        }
                    }, {
                        key   : "onProgress",
                        value : function onProgress(args) {
                            this.msgHandler.send("DocProgress", {
                                loaded : this.stream.numChunksLoaded * this.chunkSize + args.loaded,
                                total  : this.length
                            });
                        }
                    }, {
                        key   : "onReceiveData",
                        value : function onReceiveData(args) {
                            var chunk = args.chunk;
                            var isProgressive = args.begin === undefined;
                            var begin = isProgressive ? this.progressiveDataLength : args.begin;
                            var end = begin + chunk.byteLength;
                            var beginChunk = Math.floor(begin / this.chunkSize);
                            var endChunk = end < this.length ? Math.floor(end / this.chunkSize) : Math.ceil(end / this.chunkSize);

                            if (isProgressive) {
                                this.stream.onReceiveProgressiveData(chunk);
                                this.progressiveDataLength = end;
                            } else {
                                this.stream.onReceiveData(begin, chunk);
                            }

                            if (this.stream.allChunksLoaded()) {
                                this._loadedStreamCapability.resolve(this.stream);
                            }

                            var loadedRequests = [];

                            for (var curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
                                var requestIds = this._requestsByChunk.get(curChunk);

                                if (!requestIds) {
                                    continue;
                                }

                                this._requestsByChunk["delete"](curChunk);

                                var _iterator5 = _createForOfIteratorHelper(requestIds),
                                    _step5;

                                try {
                                    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                                        var requestId = _step5.value;

                                        var chunksNeeded = this._chunksNeededByRequest.get(requestId);

                                        if (chunksNeeded.has(curChunk)) {
                                            chunksNeeded["delete"](curChunk);
                                        }

                                        if (chunksNeeded.size > 0) {
                                            continue;
                                        }

                                        loadedRequests.push(requestId);
                                    }
                                } catch (err) {
                                    _iterator5.e(err);
                                } finally {
                                    _iterator5.f();
                                }
                            }

                            if (!this.disableAutoFetch && this._requestsByChunk.size === 0) {
                                var nextEmptyChunk;

                                if (this.stream.numChunksLoaded === 1) {
                                    var lastChunk = this.stream.numChunks - 1;

                                    if (!this.stream.hasChunk(lastChunk)) {
                                        nextEmptyChunk = lastChunk;
                                    }
                                } else {
                                    nextEmptyChunk = this.stream.nextEmptyChunk(endChunk);
                                }

                                if (Number.isInteger(nextEmptyChunk)) {
                                    this._requestChunks([nextEmptyChunk]);
                                }
                            }

                            for (var _i = 0, _loadedRequests = loadedRequests; _i < _loadedRequests.length; _i++) {
                                var _requestId = _loadedRequests[_i];

                                var capability = this._promisesByRequest.get(_requestId);

                                this._promisesByRequest["delete"](_requestId);

                                capability.resolve();
                            }

                            this.msgHandler.send("DocProgress", {
                                loaded : this.stream.numChunksLoaded * this.chunkSize,
                                total  : this.length
                            });
                        }
                    }, {
                        key   : "onError",
                        value : function onError(err) {
                            this._loadedStreamCapability.reject(err);
                        }
                    }, {
                        key   : "getBeginChunk",
                        value : function getBeginChunk(begin) {
                            return Math.floor(begin / this.chunkSize);
                        }
                    }, {
                        key   : "getEndChunk",
                        value : function getEndChunk(end) {
                            return Math.floor((end - 1) / this.chunkSize) + 1;
                        }
                    }, {
                        key   : "abort",
                        value : function abort(reason) {
                            this.aborted = true;

                            if (this.pdfNetworkStream) {
                                this.pdfNetworkStream.cancelAllRequests(reason);
                            }

                            var _iterator6 = _createForOfIteratorHelper(this._promisesByRequest.values()),
                                _step6;

                            try {
                                for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
                                    var capability = _step6.value;
                                    capability.reject(reason);
                                }
                            } catch (err) {
                                _iterator6.e(err);
                            } finally {
                                _iterator6.f();
                            }
                        }
                    }]);

                    return ChunkedStreamManager;
                }();

                exports.ChunkedStreamManager = ChunkedStreamManager;

                /***/
            }),
            /* 128 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.collectActions = collectActions;
                exports.encodeToXmlString = encodeToXmlString;
                exports.escapePDFName = escapePDFName;
                exports.getArrayLookupTableFactory = getArrayLookupTableFactory;
                exports.getInheritableProperty = getInheritableProperty;
                exports.getLookupTableFactory = getLookupTableFactory;
                exports.isWhiteSpace = isWhiteSpace;
                exports.log2 = log2;
                exports.parseXFAPath = parseXFAPath;
                exports.readInt8 = readInt8;
                exports.readUint16 = readUint16;
                exports.readUint32 = readUint32;
                exports.toRomanNumerals = toRomanNumerals;
                exports.XRefParseException = exports.XRefEntryException = exports.MissingDataException = void 0;

                var _util = __w_pdfjs_require__(4);

                var _primitives = __w_pdfjs_require__(125);

                function _createForOfIteratorHelper(o, allowArrayLike) {
                    var it;
                    if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
                        if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
                            if (it) o = it;
                            var i = 0;
                            var F = function F() {
                            };
                            return {
                                s    : F, n : function n() {
                                    if (i >= o.length) return {done : true};
                                    return {done : false, value : o[i++]};
                                }, e : function e(_e) {
                                    throw _e;
                                }, f : F
                            };
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                    }
                    var normalCompletion = true, didErr = false, err;
                    return {
                        s    : function s() {
                            it = o[Symbol.iterator]();
                        }, n : function n() {
                            var step = it.next();
                            normalCompletion = step.done;
                            return step;
                        }, e : function e(_e2) {
                            didErr = true;
                            err = _e2;
                        }, f : function f() {
                            try {
                                if (!normalCompletion && it["return"] != null) it["return"]();
                            } finally {
                                if (didErr) throw err;
                            }
                        }
                    };
                }

                function _unsupportedIterableToArray(o, minLen) {
                    if (!o) return;
                    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
                    var n = Object.prototype.toString.call(o).slice(8, -1);
                    if (n === "Object" && o.constructor) n = o.constructor.name;
                    if (n === "Map" || n === "Set") return Array.from(o);
                    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
                }

                function _arrayLikeToArray(arr, len) {
                    if (len == null || len > arr.length) len = arr.length;
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i];
                    }
                    return arr2;
                }

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _inherits(subClass, superClass) {
                    if (typeof superClass !== "function" && superClass !== null) {
                        throw new TypeError("Super expression must either be null or a function");
                    }
                    subClass.prototype = Object.create(superClass && superClass.prototype, {
                        constructor : {
                            value        : subClass,
                            writable     : true,
                            configurable : true
                        }
                    });
                    if (superClass) _setPrototypeOf(subClass, superClass);
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
                        o.__proto__ = p;
                        return o;
                    };
                    return _setPrototypeOf(o, p);
                }

                function _createSuper(Derived) {
                    var hasNativeReflectConstruct = _isNativeReflectConstruct();
                    return function _createSuperInternal() {
                        var Super = _getPrototypeOf(Derived), result;
                        if (hasNativeReflectConstruct) {
                            var NewTarget = _getPrototypeOf(this).constructor;
                            result = Reflect.construct(Super, arguments, NewTarget);
                        } else {
                            result = Super.apply(this, arguments);
                        }
                        return _possibleConstructorReturn(this, result);
                    };
                }

                function _possibleConstructorReturn(self, call) {
                    if (call && (_typeof(call) === "object" || typeof call === "function")) {
                        return call;
                    }
                    return _assertThisInitialized(self);
                }

                function _assertThisInitialized(self) {
                    if (self === void 0) {
                        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                    }
                    return self;
                }

                function _isNativeReflectConstruct() {
                    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
                    if (Reflect.construct.sham) return false;
                    if (typeof Proxy === "function") return true;
                    try {
                        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
                        }));
                        return true;
                    } catch (e) {
                        return false;
                    }
                }

                function _getPrototypeOf(o) {
                    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
                        return o.__proto__ || Object.getPrototypeOf(o);
                    };
                    return _getPrototypeOf(o);
                }

                function getLookupTableFactory(initializer) {
                    var lookup;
                    return function() {
                        if (initializer) {
                            lookup = Object.create(null);
                            initializer(lookup);
                            initializer = null;
                        }

                        return lookup;
                    };
                }

                function getArrayLookupTableFactory(initializer) {
                    var lookup;
                    return function() {
                        if (initializer) {
                            var arr = initializer();
                            initializer = null;
                            lookup = Object.create(null);

                            for (var i = 0, ii = arr.length; i < ii; i += 2) {
                                lookup[arr[i]] = arr[i + 1];
                            }

                            arr = null;
                        }

                        return lookup;
                    };
                }

                var MissingDataException = /*#__PURE__*/function(_BaseException) {
                    _inherits(MissingDataException, _BaseException);

                    var _super = _createSuper(MissingDataException);

                    function MissingDataException(begin, end) {
                        var _this;

                        _classCallCheck(this, MissingDataException);

                        _this = _super.call(this, "Missing data [".concat(begin, ", ").concat(end, ")"));
                        _this.begin = begin;
                        _this.end = end;
                        return _this;
                    }

                    return MissingDataException;
                }(_util.BaseException);

                exports.MissingDataException = MissingDataException;

                var XRefEntryException = /*#__PURE__*/function(_BaseException2) {
                    _inherits(XRefEntryException, _BaseException2);

                    var _super2 = _createSuper(XRefEntryException);

                    function XRefEntryException() {
                        _classCallCheck(this, XRefEntryException);

                        return _super2.apply(this, arguments);
                    }

                    return XRefEntryException;
                }(_util.BaseException);

                exports.XRefEntryException = XRefEntryException;

                var XRefParseException = /*#__PURE__*/function(_BaseException3) {
                    _inherits(XRefParseException, _BaseException3);

                    var _super3 = _createSuper(XRefParseException);

                    function XRefParseException() {
                        _classCallCheck(this, XRefParseException);

                        return _super3.apply(this, arguments);
                    }

                    return XRefParseException;
                }(_util.BaseException);

                exports.XRefParseException = XRefParseException;

                function getInheritableProperty(_ref) {
                    var dict               = _ref.dict,
                        key                = _ref.key,
                        _ref$getArray      = _ref.getArray,
                        getArray           = _ref$getArray === void 0 ? false : _ref$getArray,
                        _ref$stopWhenFound = _ref.stopWhenFound,
                        stopWhenFound      = _ref$stopWhenFound === void 0 ? true : _ref$stopWhenFound;
                    var values;
                    var visited = new _primitives.RefSet();

                    while (dict instanceof _primitives.Dict && !(dict.objId && visited.has(dict.objId))) {
                        if (dict.objId) {
                            visited.put(dict.objId);
                        }

                        var value = getArray ? dict.getArray(key) : dict.get(key);

                        if (value !== undefined) {
                            if (stopWhenFound) {
                                return value;
                            }

                            if (!values) {
                                values = [];
                            }

                            values.push(value);
                        }

                        dict = dict.get("Parent");
                    }

                    return values;
                }

                var ROMAN_NUMBER_MAP = ["", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM", "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC", "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"];

                function toRomanNumerals(number) {
                    var lowerCase = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                    (0, _util.assert)(Number.isInteger(number) && number > 0, "The number should be a positive integer.");
                    var romanBuf = [];
                    var pos;

                    while (number >= 1000) {
                        number -= 1000;
                        romanBuf.push("M");
                    }

                    pos = number / 100 | 0;
                    number %= 100;
                    romanBuf.push(ROMAN_NUMBER_MAP[pos]);
                    pos = number / 10 | 0;
                    number %= 10;
                    romanBuf.push(ROMAN_NUMBER_MAP[10 + pos]);
                    romanBuf.push(ROMAN_NUMBER_MAP[20 + number]);
                    var romanStr = romanBuf.join("");
                    return lowerCase ? romanStr.toLowerCase() : romanStr;
                }

                function log2(x) {
                    if (x <= 0) {
                        return 0;
                    }

                    return Math.ceil(Math.log2(x));
                }

                function readInt8(data, offset) {
                    return data[offset] << 24 >> 24;
                }

                function readUint16(data, offset) {
                    return data[offset] << 8 | data[offset + 1];
                }

                function readUint32(data, offset) {
                    return (data[offset] << 24 | data[offset + 1] << 16 | data[offset + 2] << 8 | data[offset + 3]) >>> 0;
                }

                function isWhiteSpace(ch) {
                    return ch === 0x20 || ch === 0x09 || ch === 0x0d || ch === 0x0a;
                }

                function parseXFAPath(path) {
                    var positionPattern = /(.+)\[([0-9]+)\]$/;
                    return path.split(".").map(function(component) {
                        var m = component.match(positionPattern);

                        if (m) {
                            return {
                                name : m[1],
                                pos  : parseInt(m[2], 10)
                            };
                        }

                        return {
                            name : component,
                            pos  : 0
                        };
                    });
                }

                function escapePDFName(str) {
                    var buffer = [];
                    var start = 0;

                    for (var i = 0, ii = str.length; i < ii; i++) {
                        var _char = str.charCodeAt(i);

                        if (_char < 0x21 || _char > 0x7e || _char === 0x23 || _char === 0x28 || _char === 0x29 || _char === 0x3c || _char === 0x3e || _char === 0x5b || _char === 0x5d || _char === 0x7b || _char === 0x7d || _char === 0x2f || _char === 0x25) {
                            if (start < i) {
                                buffer.push(str.substring(start, i));
                            }

                            buffer.push("#".concat(_char.toString(16)));
                            start = i + 1;
                        }
                    }

                    if (buffer.length === 0) {
                        return str;
                    }

                    if (start < str.length) {
                        buffer.push(str.substring(start, str.length));
                    }

                    return buffer.join("");
                }

                function _collectJS(entry, xref, list, parents) {
                    if (!entry) {
                        return;
                    }

                    var parent = null;

                    if ((0, _primitives.isRef)(entry)) {
                        if (parents.has(entry)) {
                            return;
                        }

                        parent = entry;
                        parents.put(parent);
                        entry = xref.fetch(entry);
                    }

                    if (Array.isArray(entry)) {
                        var _iterator = _createForOfIteratorHelper(entry),
                            _step;

                        try {
                            for (_iterator.s(); !(_step = _iterator.n()).done;) {
                                var element = _step.value;

                                _collectJS(element, xref, list, parents);
                            }
                        } catch (err) {
                            _iterator.e(err);
                        } finally {
                            _iterator.f();
                        }
                    } else if (entry instanceof _primitives.Dict) {
                        if ((0, _primitives.isName)(entry.get("S"), "JavaScript") && entry.has("JS")) {
                            var js = entry.get("JS");
                            var code;

                            if ((0, _primitives.isStream)(js)) {
                                code = (0, _util.bytesToString)(js.getBytes());
                            } else {
                                code = js;
                            }

                            code = (0, _util.stringToPDFString)(code);

                            if (code) {
                                list.push(code);
                            }
                        }

                        _collectJS(entry.getRaw("Next"), xref, list, parents);
                    }

                    if (parent) {
                        parents.remove(parent);
                    }
                }

                function collectActions(xref, dict, eventType) {
                    var actions = Object.create(null);
                    var additionalActionsDicts = getInheritableProperty({
                        dict          : dict,
                        key           : "AA",
                        stopWhenFound : false
                    });

                    if (additionalActionsDicts) {
                        for (var i = additionalActionsDicts.length - 1; i >= 0; i--) {
                            var additionalActions = additionalActionsDicts[i];

                            if (!(additionalActions instanceof _primitives.Dict)) {
                                continue;
                            }

                            var _iterator2 = _createForOfIteratorHelper(additionalActions.getKeys()),
                                _step2;

                            try {
                                for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                                    var key = _step2.value;
                                    var action = eventType[key];

                                    if (!action) {
                                        continue;
                                    }

                                    var actionDict = additionalActions.getRaw(key);
                                    var parents = new _primitives.RefSet();
                                    var list = [];

                                    _collectJS(actionDict, xref, list, parents);

                                    if (list.length > 0) {
                                        actions[action] = list;
                                    }
                                }
                            } catch (err) {
                                _iterator2.e(err);
                            } finally {
                                _iterator2.f();
                            }
                        }
                    }

                    if (dict.has("A")) {
                        var _actionDict = dict.get("A");

                        var _parents = new _primitives.RefSet();

                        var _list = [];

                        _collectJS(_actionDict, xref, _list, _parents);

                        if (_list.length > 0) {
                            actions.Action = _list;
                        }
                    }

                    return (0, _util.objectSize)(actions) > 0 ? actions : null;
                }

                var XMLEntities = {
                    0x3c : "&lt;",
                    0x3e : "&gt;",
                    0x26 : "&amp;",
                    0x22 : "&quot;",
                    0x27 : "&apos;"
                };

                function encodeToXmlString(str) {
                    var buffer = [];
                    var start = 0;

                    for (var i = 0, ii = str.length; i < ii; i++) {
                        var _char2 = str.codePointAt(i);

                        if (0x20 <= _char2 && _char2 <= 0x7e) {
                            var entity = XMLEntities[_char2];

                            if (entity) {
                                if (start < i) {
                                    buffer.push(str.substring(start, i));
                                }

                                buffer.push(entity);
                                start = i + 1;
                            }
                        } else {
                            if (start < i) {
                                buffer.push(str.substring(start, i));
                            }

                            buffer.push("&#x".concat(_char2.toString(16).toUpperCase(), ";"));

                            if (_char2 > 0xd7ff && (_char2 < 0xe000 || _char2 > 0xfffd)) {
                                i++;
                            }

                            start = i + 1;
                        }
                    }

                    if (buffer.length === 0) {
                        return str;
                    }

                    if (start < str.length) {
                        buffer.push(str.substring(start, str.length));
                    }

                    return buffer.join("");
                }

                /***/
            }),
            /* 129 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.PDFDocument = exports.Page = void 0;

                var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

                var _util = __w_pdfjs_require__(4);

                var _obj = __w_pdfjs_require__(130);

                var _primitives = __w_pdfjs_require__(125);

                var _core_utils = __w_pdfjs_require__(128);

                var _stream = __w_pdfjs_require__(132);

                var _annotation = __w_pdfjs_require__(147);

                var _crypto = __w_pdfjs_require__(142);

                var _parser = __w_pdfjs_require__(131);

                var _operator_list = __w_pdfjs_require__(166);

                var _evaluator = __w_pdfjs_require__(149);

                var _factory = __w_pdfjs_require__(169);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {"default" : obj};
                }

                function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
                    try {
                        var info = gen[key](arg);
                        var value = info.value;
                    } catch (error) {
                        reject(error);
                        return;
                    }
                    if (info.done) {
                        resolve(value);
                    } else {
                        Promise.resolve(value).then(_next, _throw);
                    }
                }

                function _asyncToGenerator(fn) {
                    return function() {
                        var self = this, args = arguments;
                        return new Promise(function(resolve, reject) {
                            var gen = fn.apply(self, args);

                            function _next(value) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
                            }

                            function _throw(err) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
                            }

                            _next(undefined);
                        });
                    };
                }

                function _slicedToArray(arr, i) {
                    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
                }

                function _nonIterableRest() {
                    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                }

                function _iterableToArrayLimit(arr, i) {
                    if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
                    var _arr = [];
                    var _n = true;
                    var _d = false;
                    var _e = undefined;
                    try {
                        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                            _arr.push(_s.value);
                            if (i && _arr.length === i) break;
                        }
                    } catch (err) {
                        _d = true;
                        _e = err;
                    } finally {
                        try {
                            if (!_n && _i["return"] != null) _i["return"]();
                        } finally {
                            if (_d) throw _e;
                        }
                    }
                    return _arr;
                }

                function _arrayWithHoles(arr) {
                    if (Array.isArray(arr)) return arr;
                }

                function _createForOfIteratorHelper(o, allowArrayLike) {
                    var it;
                    if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
                        if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
                            if (it) o = it;
                            var i = 0;
                            var F = function F() {
                            };
                            return {
                                s    : F, n : function n() {
                                    if (i >= o.length) return {done : true};
                                    return {done : false, value : o[i++]};
                                }, e : function e(_e2) {
                                    throw _e2;
                                }, f : F
                            };
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                    }
                    var normalCompletion = true, didErr = false, err;
                    return {
                        s    : function s() {
                            it = o[Symbol.iterator]();
                        }, n : function n() {
                            var step = it.next();
                            normalCompletion = step.done;
                            return step;
                        }, e : function e(_e3) {
                            didErr = true;
                            err = _e3;
                        }, f : function f() {
                            try {
                                if (!normalCompletion && it["return"] != null) it["return"]();
                            } finally {
                                if (didErr) throw err;
                            }
                        }
                    };
                }

                function _unsupportedIterableToArray(o, minLen) {
                    if (!o) return;
                    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
                    var n = Object.prototype.toString.call(o).slice(8, -1);
                    if (n === "Object" && o.constructor) n = o.constructor.name;
                    if (n === "Map" || n === "Set") return Array.from(o);
                    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
                }

                function _arrayLikeToArray(arr, len) {
                    if (len == null || len > arr.length) len = arr.length;
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i];
                    }
                    return arr2;
                }

                function _inherits(subClass, superClass) {
                    if (typeof superClass !== "function" && superClass !== null) {
                        throw new TypeError("Super expression must either be null or a function");
                    }
                    subClass.prototype = Object.create(superClass && superClass.prototype, {
                        constructor : {
                            value        : subClass,
                            writable     : true,
                            configurable : true
                        }
                    });
                    if (superClass) _setPrototypeOf(subClass, superClass);
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
                        o.__proto__ = p;
                        return o;
                    };
                    return _setPrototypeOf(o, p);
                }

                function _createSuper(Derived) {
                    var hasNativeReflectConstruct = _isNativeReflectConstruct();
                    return function _createSuperInternal() {
                        var Super = _getPrototypeOf(Derived), result;
                        if (hasNativeReflectConstruct) {
                            var NewTarget = _getPrototypeOf(this).constructor;
                            result = Reflect.construct(Super, arguments, NewTarget);
                        } else {
                            result = Super.apply(this, arguments);
                        }
                        return _possibleConstructorReturn(this, result);
                    };
                }

                function _possibleConstructorReturn(self, call) {
                    if (call && (_typeof(call) === "object" || typeof call === "function")) {
                        return call;
                    }
                    return _assertThisInitialized(self);
                }

                function _assertThisInitialized(self) {
                    if (self === void 0) {
                        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                    }
                    return self;
                }

                function _isNativeReflectConstruct() {
                    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
                    if (Reflect.construct.sham) return false;
                    if (typeof Proxy === "function") return true;
                    try {
                        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
                        }));
                        return true;
                    } catch (e) {
                        return false;
                    }
                }

                function _getPrototypeOf(o) {
                    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
                        return o.__proto__ || Object.getPrototypeOf(o);
                    };
                    return _getPrototypeOf(o);
                }

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                var DEFAULT_USER_UNIT = 1.0;
                var LETTER_SIZE_MEDIABOX = [0, 0, 612, 792];

                function isAnnotationRenderable(annotation, intent) {
                    return intent === "display" && annotation.viewable || intent === "print" && annotation.printable;
                }

                var Page = /*#__PURE__*/function() {
                    function Page(_ref) {
                        var pdfManager       = _ref.pdfManager,
                            xref             = _ref.xref,
                            pageIndex        = _ref.pageIndex,
                            pageDict         = _ref.pageDict,
                            ref              = _ref.ref,
                            globalIdFactory  = _ref.globalIdFactory,
                            fontCache        = _ref.fontCache,
                            builtInCMapCache = _ref.builtInCMapCache,
                            globalImageCache = _ref.globalImageCache,
                            nonBlendModesSet = _ref.nonBlendModesSet,
                            xfaFactory       = _ref.xfaFactory;

                        _classCallCheck(this, Page);

                        this.pdfManager = pdfManager;
                        this.pageIndex = pageIndex;
                        this.pageDict = pageDict;
                        this.xref = xref;
                        this.ref = ref;
                        this.fontCache = fontCache;
                        this.builtInCMapCache = builtInCMapCache;
                        this.globalImageCache = globalImageCache;
                        this.nonBlendModesSet = nonBlendModesSet;
                        this.evaluatorOptions = pdfManager.evaluatorOptions;
                        this.resourcesPromise = null;
                        this.xfaFactory = xfaFactory;
                        var idCounters = {
                            obj : 0
                        };

                        this._localIdFactory = /*#__PURE__*/function(_globalIdFactory) {
                            _inherits(_class, _globalIdFactory);

                            var _super = _createSuper(_class);

                            function _class() {
                                _classCallCheck(this, _class);

                                return _super.apply(this, arguments);
                            }

                            _createClass(_class, null, [{
                                key   : "createObjId",
                                value : function createObjId() {
                                    return "p".concat(pageIndex, "_").concat(++idCounters.obj);
                                }
                            }]);

                            return _class;
                        }(globalIdFactory);
                    }

                    _createClass(Page, [{
                        key   : "_getInheritableProperty",
                        value : function _getInheritableProperty(key) {
                            var getArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                            var value = (0, _core_utils.getInheritableProperty)({
                                dict          : this.pageDict,
                                key           : key,
                                getArray      : getArray,
                                stopWhenFound : false
                            });

                            if (!Array.isArray(value)) {
                                return value;
                            }

                            if (value.length === 1 || !(0, _primitives.isDict)(value[0])) {
                                return value[0];
                            }

                            return _primitives.Dict.merge({
                                xref      : this.xref,
                                dictArray : value
                            });
                        }
                    }, {
                        key : "content",
                        get : function get() {
                            return this.pageDict.get("Contents");
                        }
                    }, {
                        key : "resources",
                        get : function get() {
                            return (0, _util.shadow)(this, "resources", this._getInheritableProperty("Resources") || _primitives.Dict.empty);
                        }
                    }, {
                        key   : "_getBoundingBox",
                        value : function _getBoundingBox(name) {
                            if (this.xfaData) {
                                var _this$xfaData$attribu = this.xfaData.attributes.style,
                                    width                 = _this$xfaData$attribu.width,
                                    height                = _this$xfaData$attribu.height;
                                return [0, 0, parseInt(width), parseInt(height)];
                            }

                            var box = this._getInheritableProperty(name, true);

                            if (Array.isArray(box) && box.length === 4) {
                                if (box[2] - box[0] !== 0 && box[3] - box[1] !== 0) {
                                    return box;
                                }

                                (0, _util.warn)("Empty /".concat(name, " entry."));
                            }

                            return null;
                        }
                    }, {
                        key : "mediaBox",
                        get : function get() {
                            return (0, _util.shadow)(this, "mediaBox", this._getBoundingBox("MediaBox") || LETTER_SIZE_MEDIABOX);
                        }
                    }, {
                        key : "cropBox",
                        get : function get() {
                            return (0, _util.shadow)(this, "cropBox", this._getBoundingBox("CropBox") || this.mediaBox);
                        }
                    }, {
                        key : "userUnit",
                        get : function get() {
                            var obj = this.pageDict.get("UserUnit");

                            if (!(0, _util.isNum)(obj) || obj <= 0) {
                                obj = DEFAULT_USER_UNIT;
                            }

                            return (0, _util.shadow)(this, "userUnit", obj);
                        }
                    }, {
                        key : "view",
                        get : function get() {
                            var cropBox  = this.cropBox,
                                mediaBox = this.mediaBox;
                            var view;

                            if (cropBox === mediaBox || (0, _util.isArrayEqual)(cropBox, mediaBox)) {
                                view = mediaBox;
                            } else {
                                var box = _util.Util.intersect(cropBox, mediaBox);

                                if (box && box[2] - box[0] !== 0 && box[3] - box[1] !== 0) {
                                    view = box;
                                } else {
                                    (0, _util.warn)("Empty /CropBox and /MediaBox intersection.");
                                }
                            }

                            return (0, _util.shadow)(this, "view", view || mediaBox);
                        }
                    }, {
                        key : "rotate",
                        get : function get() {
                            var rotate = this._getInheritableProperty("Rotate") || 0;

                            if (rotate % 90 !== 0) {
                                rotate = 0;
                            } else if (rotate >= 360) {
                                rotate = rotate % 360;
                            } else if (rotate < 0) {
                                rotate = (rotate % 360 + 360) % 360;
                            }

                            return (0, _util.shadow)(this, "rotate", rotate);
                        }
                    }, {
                        key   : "getContentStream",
                        value : function getContentStream() {
                            var content = this.content;
                            var stream;

                            if (Array.isArray(content)) {
                                var xref = this.xref;
                                var streams = [];

                                var _iterator = _createForOfIteratorHelper(content),
                                    _step;

                                try {
                                    for (_iterator.s(); !(_step = _iterator.n()).done;) {
                                        var subStream = _step.value;
                                        streams.push(xref.fetchIfRef(subStream));
                                    }
                                } catch (err) {
                                    _iterator.e(err);
                                } finally {
                                    _iterator.f();
                                }

                                stream = new _stream.StreamsSequenceStream(streams);
                            } else if ((0, _primitives.isStream)(content)) {
                                stream = content;
                            } else {
                                stream = new _stream.NullStream();
                            }

                            return stream;
                        }
                    }, {
                        key : "xfaData",
                        get : function get() {
                            if (this.xfaFactory) {
                                return (0, _util.shadow)(this, "xfaData", this.xfaFactory.getPage(this.pageIndex));
                            }

                            return (0, _util.shadow)(this, "xfaData", null);
                        }
                    }, {
                        key   : "save",
                        value : function save(handler, task, annotationStorage) {
                            var partialEvaluator = new _evaluator.PartialEvaluator({
                                xref             : this.xref,
                                handler          : handler,
                                pageIndex        : this.pageIndex,
                                idFactory        : this._localIdFactory,
                                fontCache        : this.fontCache,
                                builtInCMapCache : this.builtInCMapCache,
                                globalImageCache : this.globalImageCache,
                                options          : this.evaluatorOptions
                            });
                            return this._parsedAnnotations.then(function(annotations) {
                                var newRefsPromises = [];

                                var _iterator2 = _createForOfIteratorHelper(annotations),
                                    _step2;

                                try {
                                    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                                        var annotation = _step2.value;

                                        if (!isAnnotationRenderable(annotation, "print")) {
                                            continue;
                                        }

                                        newRefsPromises.push(annotation.save(partialEvaluator, task, annotationStorage)["catch"](function(reason) {
                                            (0, _util.warn)("save - ignoring annotation data during " + "\"".concat(task.name, "\" task: \"").concat(reason, "\"."));
                                            return null;
                                        }));
                                    }
                                } catch (err) {
                                    _iterator2.e(err);
                                } finally {
                                    _iterator2.f();
                                }

                                return Promise.all(newRefsPromises);
                            });
                        }
                    }, {
                        key   : "loadResources",
                        value : function loadResources(keys) {
                            var _this = this;

                            if (!this.resourcesPromise) {
                                this.resourcesPromise = this.pdfManager.ensure(this, "resources");
                            }

                            return this.resourcesPromise.then(function() {
                                var objectLoader = new _obj.ObjectLoader(_this.resources, keys, _this.xref);
                                return objectLoader.load();
                            });
                        }
                    }, {
                        key   : "getOperatorList",
                        value : function getOperatorList(_ref2) {
                            var _this2 = this;

                            var handler                = _ref2.handler,
                                sink                   = _ref2.sink,
                                task                   = _ref2.task,
                                intent                 = _ref2.intent,
                                renderInteractiveForms = _ref2.renderInteractiveForms,
                                annotationStorage      = _ref2.annotationStorage;
                            var contentStreamPromise = this.pdfManager.ensure(this, "getContentStream");
                            var resourcesPromise = this.loadResources(["ExtGState", "ColorSpace", "Pattern", "Shading", "XObject", "Font"]);
                            var partialEvaluator = new _evaluator.PartialEvaluator({
                                xref             : this.xref,
                                handler          : handler,
                                pageIndex        : this.pageIndex,
                                idFactory        : this._localIdFactory,
                                fontCache        : this.fontCache,
                                builtInCMapCache : this.builtInCMapCache,
                                globalImageCache : this.globalImageCache,
                                options          : this.evaluatorOptions
                            });
                            var dataPromises = Promise.all([contentStreamPromise, resourcesPromise]);
                            var pageListPromise = dataPromises.then(function(_ref3) {
                                var _ref4         = _slicedToArray(_ref3, 1),
                                    contentStream = _ref4[0];

                                var opList = new _operator_list.OperatorList(intent, sink);
                                handler.send("StartRenderPage", {
                                    transparency : partialEvaluator.hasBlendModes(_this2.resources, _this2.nonBlendModesSet),
                                    pageIndex    : _this2.pageIndex,
                                    intent       : intent
                                });
                                return partialEvaluator.getOperatorList({
                                    stream       : contentStream,
                                    task         : task,
                                    resources    : _this2.resources,
                                    operatorList : opList
                                }).then(function() {
                                    return opList;
                                });
                            });
                            return Promise.all([pageListPromise, this._parsedAnnotations]).then(function(_ref5) {
                                var _ref6       = _slicedToArray(_ref5, 2),
                                    pageOpList  = _ref6[0],
                                    annotations = _ref6[1];

                                if (annotations.length === 0) {
                                    pageOpList.flush(true);
                                    return {
                                        length : pageOpList.totalLength
                                    };
                                }

                                var opListPromises = [];

                                var _iterator3 = _createForOfIteratorHelper(annotations),
                                    _step3;

                                try {
                                    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                                        var annotation = _step3.value;

                                        if (isAnnotationRenderable(annotation, intent) && !annotation.isHidden(annotationStorage)) {
                                            opListPromises.push(annotation.getOperatorList(partialEvaluator, task, renderInteractiveForms, annotationStorage)["catch"](function(reason) {
                                                (0, _util.warn)("getOperatorList - ignoring annotation data during " + "\"".concat(task.name, "\" task: \"").concat(reason, "\"."));
                                                return null;
                                            }));
                                        }
                                    }
                                } catch (err) {
                                    _iterator3.e(err);
                                } finally {
                                    _iterator3.f();
                                }

                                return Promise.all(opListPromises).then(function(opLists) {
                                    pageOpList.addOp(_util.OPS.beginAnnotations, []);

                                    var _iterator4 = _createForOfIteratorHelper(opLists),
                                        _step4;

                                    try {
                                        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                                            var opList = _step4.value;
                                            pageOpList.addOpList(opList);
                                        }
                                    } catch (err) {
                                        _iterator4.e(err);
                                    } finally {
                                        _iterator4.f();
                                    }

                                    pageOpList.addOp(_util.OPS.endAnnotations, []);
                                    pageOpList.flush(true);
                                    return {
                                        length : pageOpList.totalLength
                                    };
                                });
                            });
                        }
                    }, {
                        key   : "extractTextContent",
                        value : function extractTextContent(_ref7) {
                            var _this3 = this;

                            var handler             = _ref7.handler,
                                task                = _ref7.task,
                                normalizeWhitespace = _ref7.normalizeWhitespace,
                                sink                = _ref7.sink,
                                combineTextItems    = _ref7.combineTextItems;
                            var contentStreamPromise = this.pdfManager.ensure(this, "getContentStream");
                            var resourcesPromise = this.loadResources(["ExtGState", "XObject", "Font"]);
                            var dataPromises = Promise.all([contentStreamPromise, resourcesPromise]);
                            return dataPromises.then(function(_ref8) {
                                var _ref9         = _slicedToArray(_ref8, 1),
                                    contentStream = _ref9[0];

                                var partialEvaluator = new _evaluator.PartialEvaluator({
                                    xref             : _this3.xref,
                                    handler          : handler,
                                    pageIndex        : _this3.pageIndex,
                                    idFactory        : _this3._localIdFactory,
                                    fontCache        : _this3.fontCache,
                                    builtInCMapCache : _this3.builtInCMapCache,
                                    globalImageCache : _this3.globalImageCache,
                                    options          : _this3.evaluatorOptions
                                });
                                return partialEvaluator.getTextContent({
                                    stream              : contentStream,
                                    task                : task,
                                    resources           : _this3.resources,
                                    normalizeWhitespace : normalizeWhitespace,
                                    combineTextItems    : combineTextItems,
                                    sink                : sink
                                });
                            });
                        }
                    }, {
                        key   : "getAnnotationsData",
                        value : function getAnnotationsData(intent) {
                            return this._parsedAnnotations.then(function(annotations) {
                                var annotationsData = [];

                                for (var i = 0, ii = annotations.length; i < ii; i++) {
                                    if (!intent || isAnnotationRenderable(annotations[i], intent)) {
                                        annotationsData.push(annotations[i].data);
                                    }
                                }

                                return annotationsData;
                            });
                        }
                    }, {
                        key : "annotations",
                        get : function get() {
                            var annots = this._getInheritableProperty("Annots");

                            return (0, _util.shadow)(this, "annotations", Array.isArray(annots) ? annots : []);
                        }
                    }, {
                        key : "_parsedAnnotations",
                        get : function get() {
                            var _this4 = this;

                            var parsedAnnotations = this.pdfManager.ensure(this, "annotations").then(function() {
                                var annotationPromises = [];

                                var _iterator5 = _createForOfIteratorHelper(_this4.annotations),
                                    _step5;

                                try {
                                    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                                        var annotationRef = _step5.value;
                                        annotationPromises.push(_annotation.AnnotationFactory.create(_this4.xref, annotationRef, _this4.pdfManager, _this4._localIdFactory, false)["catch"](function(reason) {
                                            (0, _util.warn)("_parsedAnnotations: \"".concat(reason, "\"."));
                                            return null;
                                        }));
                                    }
                                } catch (err) {
                                    _iterator5.e(err);
                                } finally {
                                    _iterator5.f();
                                }

                                return Promise.all(annotationPromises).then(function(annotations) {
                                    return annotations.filter(function(annotation) {
                                        return !!annotation;
                                    });
                                });
                            });
                            return (0, _util.shadow)(this, "_parsedAnnotations", parsedAnnotations);
                        }
                    }, {
                        key : "jsActions",
                        get : function get() {
                            var actions = (0, _core_utils.collectActions)(this.xref, this.pageDict, _util.PageActionEventType);
                            return (0, _util.shadow)(this, "jsActions", actions);
                        }
                    }]);

                    return Page;
                }();

                exports.Page = Page;
                var PDF_HEADER_SIGNATURE = new Uint8Array([0x25, 0x50, 0x44, 0x46, 0x2d]);
                var STARTXREF_SIGNATURE = new Uint8Array([0x73, 0x74, 0x61, 0x72, 0x74, 0x78, 0x72, 0x65, 0x66]);
                var ENDOBJ_SIGNATURE = new Uint8Array([0x65, 0x6e, 0x64, 0x6f, 0x62, 0x6a]);
                var FINGERPRINT_FIRST_BYTES = 1024;
                var EMPTY_FINGERPRINT = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
                var PDF_HEADER_VERSION_REGEXP = /^[1-9]\.[0-9]$/;

                function find(stream, signature) {
                    var limit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1024;
                    var backwards = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
                    var signatureLength = signature.length;
                    var scanBytes = stream.peekBytes(limit);
                    var scanLength = scanBytes.length - signatureLength;

                    if (scanLength <= 0) {
                        return false;
                    }

                    if (backwards) {
                        var signatureEnd = signatureLength - 1;
                        var pos = scanBytes.length - 1;

                        while (pos >= signatureEnd) {
                            var j = 0;

                            while (j < signatureLength && scanBytes[pos - j] === signature[signatureEnd - j]) {
                                j++;
                            }

                            if (j >= signatureLength) {
                                stream.pos += pos - signatureEnd;
                                return true;
                            }

                            pos--;
                        }
                    } else {
                        var _pos = 0;

                        while (_pos <= scanLength) {
                            var _j = 0;

                            while (_j < signatureLength && scanBytes[_pos + _j] === signature[_j]) {
                                _j++;
                            }

                            if (_j >= signatureLength) {
                                stream.pos += _pos;
                                return true;
                            }

                            _pos++;
                        }
                    }

                    return false;
                }

                var PDFDocument = /*#__PURE__*/function() {
                    function PDFDocument(pdfManager, arg) {
                        _classCallCheck(this, PDFDocument);

                        var stream;

                        if ((0, _primitives.isStream)(arg)) {
                            stream = arg;
                        } else if ((0, _util.isArrayBuffer)(arg)) {
                            stream = new _stream.Stream(arg);
                        } else {
                            throw new Error("PDFDocument: Unknown argument type");
                        }

                        if (stream.length <= 0) {
                            throw new _util.InvalidPDFException("The PDF file is empty, i.e. its size is zero bytes.");
                        }

                        this.pdfManager = pdfManager;
                        this.stream = stream;
                        this.xref = new _obj.XRef(stream, pdfManager);
                        this._pagePromises = [];
                        this._version = null;
                        var idCounters = {
                            font : 0
                        };

                        this._globalIdFactory = /*#__PURE__*/function() {
                            function _class2() {
                                _classCallCheck(this, _class2);
                            }

                            _createClass(_class2, null, [{
                                key   : "getDocId",
                                value : function getDocId() {
                                    return "g_".concat(pdfManager.docId);
                                }
                            }, {
                                key   : "createFontId",
                                value : function createFontId() {
                                    return "f".concat(++idCounters.font);
                                }
                            }, {
                                key   : "createObjId",
                                value : function createObjId() {
                                    (0, _util.unreachable)("Abstract method `createObjId` called.");
                                }
                            }]);

                            return _class2;
                        }();
                    }

                    _createClass(PDFDocument, [{
                        key   : "parse",
                        value : function parse(recoveryMode) {
                            this.xref.parse(recoveryMode);
                            this.catalog = new _obj.Catalog(this.pdfManager, this.xref);

                            if (this.catalog.version) {
                                this._version = this.catalog.version;
                            }
                        }
                    }, {
                        key : "linearization",
                        get : function get() {
                            var linearization = null;

                            try {
                                linearization = _parser.Linearization.create(this.stream);
                            } catch (err) {
                                if (err instanceof _core_utils.MissingDataException) {
                                    throw err;
                                }

                                (0, _util.info)(err);
                            }

                            return (0, _util.shadow)(this, "linearization", linearization);
                        }
                    }, {
                        key : "startXRef",
                        get : function get() {
                            var stream = this.stream;
                            var startXRef = 0;

                            if (this.linearization) {
                                stream.reset();

                                if (find(stream, ENDOBJ_SIGNATURE)) {
                                    startXRef = stream.pos + 6 - stream.start;
                                }
                            } else {
                                var step = 1024;
                                var startXRefLength = STARTXREF_SIGNATURE.length;
                                var found = false,
                                    pos   = stream.end;

                                while (!found && pos > 0) {
                                    pos -= step - startXRefLength;

                                    if (pos < 0) {
                                        pos = 0;
                                    }

                                    stream.pos = pos;
                                    found = find(stream, STARTXREF_SIGNATURE, step, true);
                                }

                                if (found) {
                                    stream.skip(9);
                                    var ch;

                                    do {
                                        ch = stream.getByte();
                                    } while ((0, _core_utils.isWhiteSpace)(ch));

                                    var str = "";

                                    while (ch >= 0x20 && ch <= 0x39) {
                                        str += String.fromCharCode(ch);
                                        ch = stream.getByte();
                                    }

                                    startXRef = parseInt(str, 10);

                                    if (isNaN(startXRef)) {
                                        startXRef = 0;
                                    }
                                }
                            }

                            return (0, _util.shadow)(this, "startXRef", startXRef);
                        }
                    }, {
                        key   : "checkHeader",
                        value : function checkHeader() {
                            var stream = this.stream;
                            stream.reset();

                            if (!find(stream, PDF_HEADER_SIGNATURE)) {
                                return;
                            }

                            stream.moveStart();
                            var MAX_PDF_VERSION_LENGTH = 12;
                            var version = "",
                                ch;

                            while ((ch = stream.getByte()) > 0x20) {
                                if (version.length >= MAX_PDF_VERSION_LENGTH) {
                                    break;
                                }

                                version += String.fromCharCode(ch);
                            }

                            if (!this._version) {
                                this._version = version.substring(5);
                            }
                        }
                    }, {
                        key   : "parseStartXRef",
                        value : function parseStartXRef() {
                            this.xref.setStartXRef(this.startXRef);
                        }
                    }, {
                        key : "numPages",
                        get : function get() {
                            if (this.xfaFactory) {
                                return (0, _util.shadow)(this, "numPages", this.xfaFactory.numberPages);
                            }

                            var linearization = this.linearization;
                            var num = linearization ? linearization.numPages : this.catalog.numPages;
                            return (0, _util.shadow)(this, "numPages", num);
                        }
                    }, {
                        key   : "_hasOnlyDocumentSignatures",
                        value : function _hasOnlyDocumentSignatures(fields) {
                            var _this5 = this;

                            var recursionDepth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                            var RECURSION_LIMIT = 10;

                            if (!Array.isArray(fields)) {
                                return false;
                            }

                            return fields.every(function(field) {
                                field = _this5.xref.fetchIfRef(field);

                                if (!(field instanceof _primitives.Dict)) {
                                    return false;
                                }

                                if (field.has("Kids")) {
                                    if (++recursionDepth > RECURSION_LIMIT) {
                                        (0, _util.warn)("_hasOnlyDocumentSignatures: maximum recursion depth reached");
                                        return false;
                                    }

                                    return _this5._hasOnlyDocumentSignatures(field.get("Kids"), recursionDepth);
                                }

                                var isSignature = (0, _primitives.isName)(field.get("FT"), "Sig");
                                var rectangle = field.get("Rect");
                                var isInvisible = Array.isArray(rectangle) && rectangle.every(function(value) {
                                    return value === 0;
                                });
                                return isSignature && isInvisible;
                            });
                        }
                    }, {
                        key : "xfaData",
                        get : function get() {
                            var acroForm = this.catalog.acroForm;

                            if (!acroForm) {
                                return null;
                            }

                            var xfa = acroForm.get("XFA");
                            var entries = {
                                "xdp:xdp"     : "",
                                template      : "",
                                datasets      : "",
                                config        : "",
                                connectionSet : "",
                                localeSet     : "",
                                stylesheet    : "",
                                "/xdp:xdp"    : ""
                            };

                            if ((0, _primitives.isStream)(xfa) && !xfa.isEmpty) {
                                try {
                                    entries["xdp:xdp"] = (0, _util.stringToUTF8String)((0, _util.bytesToString)(xfa.getBytes()));
                                    return entries;
                                } catch (_) {
                                    (0, _util.warn)("XFA - Invalid utf-8 string.");
                                    return null;
                                }
                            }

                            if (!Array.isArray(xfa) || xfa.length === 0) {
                                return null;
                            }

                            for (var i = 0, ii = xfa.length; i < ii; i += 2) {
                                var name = void 0;

                                if (i === 0) {
                                    name = "xdp:xdp";
                                } else if (i === ii - 2) {
                                    name = "/xdp:xdp";
                                } else {
                                    name = xfa[i];
                                }

                                if (!entries.hasOwnProperty(name)) {
                                    continue;
                                }

                                var data = this.xref.fetchIfRef(xfa[i + 1]);

                                if (!(0, _primitives.isStream)(data) || data.isEmpty) {
                                    continue;
                                }

                                try {
                                    entries[name] = (0, _util.stringToUTF8String)((0, _util.bytesToString)(data.getBytes()));
                                } catch (_) {
                                    (0, _util.warn)("XFA - Invalid utf-8 string.");
                                    return null;
                                }
                            }

                            return entries;
                        }
                    }, {
                        key : "xfaFactory",
                        get : function get() {
                            if (this.pdfManager.enableXfa && this.formInfo.hasXfa && !this.formInfo.hasAcroForm) {
                                var data = this.xfaData;
                                return (0, _util.shadow)(this, "xfaFactory", data ? new _factory.XFAFactory(data) : null);
                            }

                            return (0, _util.shadow)(this, "xfaFaxtory", null);
                        }
                    }, {
                        key : "isPureXfa",
                        get : function get() {
                            return this.xfaFactory !== null;
                        }
                    }, {
                        key : "formInfo",
                        get : function get() {
                            var formInfo = {
                                hasFields   : false,
                                hasAcroForm : false,
                                hasXfa      : false
                            };
                            var acroForm = this.catalog.acroForm;

                            if (!acroForm) {
                                return (0, _util.shadow)(this, "formInfo", formInfo);
                            }

                            try {
                                var fields = acroForm.get("Fields");
                                var hasFields = Array.isArray(fields) && fields.length > 0;
                                formInfo.hasFields = hasFields;
                                var xfa = acroForm.get("XFA");
                                formInfo.hasXfa = Array.isArray(xfa) && xfa.length > 0 || (0, _primitives.isStream)(xfa) && !xfa.isEmpty;
                                var sigFlags = acroForm.get("SigFlags");

                                var hasOnlyDocumentSignatures = !!(sigFlags & 0x1) && this._hasOnlyDocumentSignatures(fields);

                                formInfo.hasAcroForm = hasFields && !hasOnlyDocumentSignatures;
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("Cannot fetch form information: \"".concat(ex, "\"."));
                            }

                            return (0, _util.shadow)(this, "formInfo", formInfo);
                        }
                    }, {
                        key : "documentInfo",
                        get : function get() {
                            var DocumentInfoValidators = {
                                Title        : _util.isString,
                                Author       : _util.isString,
                                Subject      : _util.isString,
                                Keywords     : _util.isString,
                                Creator      : _util.isString,
                                Producer     : _util.isString,
                                CreationDate : _util.isString,
                                ModDate      : _util.isString,
                                Trapped      : _primitives.isName
                            };
                            var version = this._version;

                            if (typeof version !== "string" || !PDF_HEADER_VERSION_REGEXP.test(version)) {
                                (0, _util.warn)("Invalid PDF header version number: ".concat(version));
                                version = null;
                            }

                            var docInfo = {
                                PDFFormatVersion    : version,
                                IsLinearized        : !!this.linearization,
                                IsAcroFormPresent   : this.formInfo.hasAcroForm,
                                IsXFAPresent        : this.formInfo.hasXfa,
                                IsCollectionPresent : !!this.catalog.collection
                            };
                            var infoDict;

                            try {
                                infoDict = this.xref.trailer.get("Info");
                            } catch (err) {
                                if (err instanceof _core_utils.MissingDataException) {
                                    throw err;
                                }

                                (0, _util.info)("The document information dictionary is invalid.");
                            }

                            if ((0, _primitives.isDict)(infoDict)) {
                                var _iterator6 = _createForOfIteratorHelper(infoDict.getKeys()),
                                    _step6;

                                try {
                                    for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
                                        var key = _step6.value;
                                        var value = infoDict.get(key);

                                        if (DocumentInfoValidators[key]) {
                                            if (DocumentInfoValidators[key](value)) {
                                                docInfo[key] = typeof value !== "string" ? value : (0, _util.stringToPDFString)(value);
                                            } else {
                                                (0, _util.info)("Bad value in document info for \"".concat(key, "\"."));
                                            }
                                        } else if (typeof key === "string") {
                                            var customValue = void 0;

                                            if ((0, _util.isString)(value)) {
                                                customValue = (0, _util.stringToPDFString)(value);
                                            } else if ((0, _primitives.isName)(value) || (0, _util.isNum)(value) || (0, _util.isBool)(value)) {
                                                customValue = value;
                                            } else {
                                                (0, _util.info)("Unsupported value in document info for (custom) \"".concat(key, "\"."));
                                                continue;
                                            }

                                            if (!docInfo.Custom) {
                                                docInfo.Custom = Object.create(null);
                                            }

                                            docInfo.Custom[key] = customValue;
                                        }
                                    }
                                } catch (err) {
                                    _iterator6.e(err);
                                } finally {
                                    _iterator6.f();
                                }
                            }

                            return (0, _util.shadow)(this, "documentInfo", docInfo);
                        }
                    }, {
                        key : "fingerprint",
                        get : function get() {
                            var hash;
                            var idArray = this.xref.trailer.get("ID");

                            if (Array.isArray(idArray) && idArray[0] && (0, _util.isString)(idArray[0]) && idArray[0] !== EMPTY_FINGERPRINT) {
                                hash = (0, _util.stringToBytes)(idArray[0]);
                            } else {
                                hash = (0, _crypto.calculateMD5)(this.stream.getByteRange(0, FINGERPRINT_FIRST_BYTES), 0, FINGERPRINT_FIRST_BYTES);
                            }

                            var fingerprintBuf = [];

                            for (var i = 0, ii = hash.length; i < ii; i++) {
                                var hex = hash[i].toString(16);
                                fingerprintBuf.push(hex.padStart(2, "0"));
                            }

                            return (0, _util.shadow)(this, "fingerprint", fingerprintBuf.join(""));
                        }
                    }, {
                        key   : "_getLinearizationPage",
                        value : function _getLinearizationPage(pageIndex) {
                            var catalog       = this.catalog,
                                linearization = this.linearization;

                            var ref = _primitives.Ref.get(linearization.objectNumberFirst, 0);

                            return this.xref.fetchAsync(ref).then(function(obj) {
                                if ((0, _primitives.isDict)(obj, "Page") || (0, _primitives.isDict)(obj) && !obj.has("Type") && obj.has("Contents")) {
                                    if (ref && !catalog.pageKidsCountCache.has(ref)) {
                                        catalog.pageKidsCountCache.put(ref, 1);
                                    }

                                    return [obj, ref];
                                }

                                throw new _util.FormatError("The Linearization dictionary doesn't point " + "to a valid Page dictionary.");
                            })["catch"](function(reason) {
                                (0, _util.info)(reason);
                                return catalog.getPageDict(pageIndex);
                            });
                        }
                    }, {
                        key   : "getPage",
                        value : function getPage(pageIndex) {
                            var _this6 = this;

                            if (this._pagePromises[pageIndex] !== undefined) {
                                return this._pagePromises[pageIndex];
                            }

                            var catalog       = this.catalog,
                                linearization = this.linearization;

                            if (this.xfaFactory) {
                                return Promise.resolve(new Page({
                                    pdfManager       : this.pdfManager,
                                    xref             : this.xref,
                                    pageIndex        : pageIndex,
                                    pageDict         : _primitives.Dict.empty,
                                    ref              : null,
                                    globalIdFactory  : this._globalIdFactory,
                                    fontCache        : catalog.fontCache,
                                    builtInCMapCache : catalog.builtInCMapCache,
                                    globalImageCache : catalog.globalImageCache,
                                    nonBlendModesSet : catalog.nonBlendModesSet,
                                    xfaFactory       : this.xfaFactory
                                }));
                            }

                            var promise = linearization && linearization.pageFirst === pageIndex ? this._getLinearizationPage(pageIndex) : catalog.getPageDict(pageIndex);
                            return this._pagePromises[pageIndex] = promise.then(function(_ref10) {
                                var _ref11   = _slicedToArray(_ref10, 2),
                                    pageDict = _ref11[0],
                                    ref      = _ref11[1];

                                return new Page({
                                    pdfManager       : _this6.pdfManager,
                                    xref             : _this6.xref,
                                    pageIndex        : pageIndex,
                                    pageDict         : pageDict,
                                    ref              : ref,
                                    globalIdFactory  : _this6._globalIdFactory,
                                    fontCache        : catalog.fontCache,
                                    builtInCMapCache : catalog.builtInCMapCache,
                                    globalImageCache : catalog.globalImageCache,
                                    nonBlendModesSet : catalog.nonBlendModesSet,
                                    xfaFactory       : null
                                });
                            });
                        }
                    }, {
                        key   : "checkFirstPage",
                        value : function checkFirstPage() {
                            var _this7 = this;

                            return this.getPage(0)["catch"](/*#__PURE__*/function() {
                                var _ref12 = _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee(reason) {
                                    return _regenerator["default"].wrap(function _callee$(_context) {
                                        while (1) {
                                            switch (_context.prev = _context.next) {
                                                case 0:
                                                    if (!(reason instanceof _core_utils.XRefEntryException)) {
                                                        _context.next = 5;
                                                        break;
                                                    }

                                                    _this7._pagePromises.length = 0;
                                                    _context.next = 4;
                                                    return _this7.cleanup();

                                                case 4:
                                                    throw new _core_utils.XRefParseException();

                                                case 5:
                                                case "end":
                                                    return _context.stop();
                                            }
                                        }
                                    }, _callee);
                                }));

                                return function(_x) {
                                    return _ref12.apply(this, arguments);
                                };
                            }());
                        }
                    }, {
                        key   : "fontFallback",
                        value : function fontFallback(id, handler) {
                            return this.catalog.fontFallback(id, handler);
                        }
                    }, {
                        key   : "cleanup",
                        value : function() {
                            var _cleanup = _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee2() {
                                var manuallyTriggered,
                                    _args2 = arguments;
                                return _regenerator["default"].wrap(function _callee2$(_context2) {
                                    while (1) {
                                        switch (_context2.prev = _context2.next) {
                                            case 0:
                                                manuallyTriggered = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : false;
                                                return _context2.abrupt("return", this.catalog ? this.catalog.cleanup(manuallyTriggered) : (0, _primitives.clearPrimitiveCaches)());

                                            case 2:
                                            case "end":
                                                return _context2.stop();
                                        }
                                    }
                                }, _callee2, this);
                            }));

                            function cleanup() {
                                return _cleanup.apply(this, arguments);
                            }

                            return cleanup;
                        }()
                    }, {
                        key   : "_collectFieldObjects",
                        value : function _collectFieldObjects(name, fieldRef, promises) {
                            var field = this.xref.fetchIfRef(fieldRef);

                            if (field.has("T")) {
                                var partName = (0, _util.stringToPDFString)(field.get("T"));

                                if (name === "") {
                                    name = partName;
                                } else {
                                    name = "".concat(name, ".").concat(partName);
                                }
                            }

                            if (!promises.has(name)) {
                                promises.set(name, []);
                            }

                            promises.get(name).push(_annotation.AnnotationFactory.create(this.xref, fieldRef, this.pdfManager, this._localIdFactory, true).then(function(annotation) {
                                return annotation && annotation.getFieldObject();
                            })["catch"](function(reason) {
                                (0, _util.warn)("_collectFieldObjects: \"".concat(reason, "\"."));
                                return null;
                            }));

                            if (field.has("Kids")) {
                                var kids = field.get("Kids");

                                var _iterator7 = _createForOfIteratorHelper(kids),
                                    _step7;

                                try {
                                    for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
                                        var kid = _step7.value;

                                        this._collectFieldObjects(name, kid, promises);
                                    }
                                } catch (err) {
                                    _iterator7.e(err);
                                } finally {
                                    _iterator7.f();
                                }
                            }
                        }
                    }, {
                        key : "fieldObjects",
                        get : function get() {
                            if (!this.formInfo.hasFields) {
                                return (0, _util.shadow)(this, "fieldObjects", Promise.resolve(null));
                            }

                            var allFields = Object.create(null);
                            var fieldPromises = new Map();

                            var _iterator8 = _createForOfIteratorHelper(this.catalog.acroForm.get("Fields")),
                                _step8;

                            try {
                                for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
                                    var fieldRef = _step8.value;

                                    this._collectFieldObjects("", fieldRef, fieldPromises);
                                }
                            } catch (err) {
                                _iterator8.e(err);
                            } finally {
                                _iterator8.f();
                            }

                            var allPromises = [];

                            var _iterator9 = _createForOfIteratorHelper(fieldPromises),
                                _step9;

                            try {
                                var _loop = function _loop() {
                                    var _step9$value = _slicedToArray(_step9.value, 2),
                                        name         = _step9$value[0],
                                        promises     = _step9$value[1];

                                    allPromises.push(Promise.all(promises).then(function(fields) {
                                        fields = fields.filter(function(field) {
                                            return !!field;
                                        });

                                        if (fields.length > 0) {
                                            allFields[name] = fields;
                                        }
                                    }));
                                };

                                for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
                                    _loop();
                                }
                            } catch (err) {
                                _iterator9.e(err);
                            } finally {
                                _iterator9.f();
                            }

                            return (0, _util.shadow)(this, "fieldObjects", Promise.all(allPromises).then(function() {
                                return allFields;
                            }));
                        }
                    }, {
                        key : "hasJSActions",
                        get : function get() {
                            var _this8 = this;

                            return (0, _util.shadow)(this, "hasJSActions", this.fieldObjects.then(function(fieldObjects) {
                                return fieldObjects !== null && Object.values(fieldObjects).some(function(fieldObject) {
                                    return fieldObject.some(function(object) {
                                        return object.actions !== null;
                                    });
                                }) || !!_this8.catalog.jsActions;
                            }));
                        }
                    }, {
                        key : "calculationOrderIds",
                        get : function get() {
                            var acroForm = this.catalog.acroForm;

                            if (!acroForm || !acroForm.has("CO")) {
                                return (0, _util.shadow)(this, "calculationOrderIds", null);
                            }

                            var calculationOrder = acroForm.get("CO");

                            if (!Array.isArray(calculationOrder) || calculationOrder.length === 0) {
                                return (0, _util.shadow)(this, "calculationOrderIds", null);
                            }

                            var ids = calculationOrder.filter(_primitives.isRef).map(function(ref) {
                                return ref.toString();
                            });

                            if (ids.length === 0) {
                                return (0, _util.shadow)(this, "calculationOrderIds", null);
                            }

                            return (0, _util.shadow)(this, "calculationOrderIds", ids);
                        }
                    }]);

                    return PDFDocument;
                }();

                exports.PDFDocument = PDFDocument;

                /***/
            }),
            /* 130 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.XRef = exports.ObjectLoader = exports.FileSpec = exports.Catalog = void 0;

                var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

                var _util = __w_pdfjs_require__(4);

                var _primitives = __w_pdfjs_require__(125);

                var _core_utils = __w_pdfjs_require__(128);

                var _parser = __w_pdfjs_require__(131);

                var _crypto = __w_pdfjs_require__(142);

                var _colorspace = __w_pdfjs_require__(143);

                var _image_utils = __w_pdfjs_require__(144);

                var _metadata_parser = __w_pdfjs_require__(145);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {"default" : obj};
                }

                function _inherits(subClass, superClass) {
                    if (typeof superClass !== "function" && superClass !== null) {
                        throw new TypeError("Super expression must either be null or a function");
                    }
                    subClass.prototype = Object.create(superClass && superClass.prototype, {
                        constructor : {
                            value        : subClass,
                            writable     : true,
                            configurable : true
                        }
                    });
                    if (superClass) _setPrototypeOf(subClass, superClass);
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
                        o.__proto__ = p;
                        return o;
                    };
                    return _setPrototypeOf(o, p);
                }

                function _createSuper(Derived) {
                    var hasNativeReflectConstruct = _isNativeReflectConstruct();
                    return function _createSuperInternal() {
                        var Super = _getPrototypeOf(Derived), result;
                        if (hasNativeReflectConstruct) {
                            var NewTarget = _getPrototypeOf(this).constructor;
                            result = Reflect.construct(Super, arguments, NewTarget);
                        } else {
                            result = Super.apply(this, arguments);
                        }
                        return _possibleConstructorReturn(this, result);
                    };
                }

                function _possibleConstructorReturn(self, call) {
                    if (call && (_typeof(call) === "object" || typeof call === "function")) {
                        return call;
                    }
                    return _assertThisInitialized(self);
                }

                function _assertThisInitialized(self) {
                    if (self === void 0) {
                        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                    }
                    return self;
                }

                function _isNativeReflectConstruct() {
                    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
                    if (Reflect.construct.sham) return false;
                    if (typeof Proxy === "function") return true;
                    try {
                        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
                        }));
                        return true;
                    } catch (e) {
                        return false;
                    }
                }

                function _getPrototypeOf(o) {
                    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
                        return o.__proto__ || Object.getPrototypeOf(o);
                    };
                    return _getPrototypeOf(o);
                }

                function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
                    try {
                        var info = gen[key](arg);
                        var value = info.value;
                    } catch (error) {
                        reject(error);
                        return;
                    }
                    if (info.done) {
                        resolve(value);
                    } else {
                        Promise.resolve(value).then(_next, _throw);
                    }
                }

                function _asyncToGenerator(fn) {
                    return function() {
                        var self = this, args = arguments;
                        return new Promise(function(resolve, reject) {
                            var gen = fn.apply(self, args);

                            function _next(value) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
                            }

                            function _throw(err) {
                                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
                            }

                            _next(undefined);
                        });
                    };
                }

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                function _slicedToArray(arr, i) {
                    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
                }

                function _nonIterableRest() {
                    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                }

                function _iterableToArrayLimit(arr, i) {
                    if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
                    var _arr = [];
                    var _n = true;
                    var _d = false;
                    var _e = undefined;
                    try {
                        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                            _arr.push(_s.value);
                            if (i && _arr.length === i) break;
                        }
                    } catch (err) {
                        _d = true;
                        _e = err;
                    } finally {
                        try {
                            if (!_n && _i["return"] != null) _i["return"]();
                        } finally {
                            if (_d) throw _e;
                        }
                    }
                    return _arr;
                }

                function _arrayWithHoles(arr) {
                    if (Array.isArray(arr)) return arr;
                }

                function _createForOfIteratorHelper(o, allowArrayLike) {
                    var it;
                    if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
                        if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
                            if (it) o = it;
                            var i = 0;
                            var F = function F() {
                            };
                            return {
                                s    : F, n : function n() {
                                    if (i >= o.length) return {done : true};
                                    return {done : false, value : o[i++]};
                                }, e : function e(_e2) {
                                    throw _e2;
                                }, f : F
                            };
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                    }
                    var normalCompletion = true, didErr = false, err;
                    return {
                        s    : function s() {
                            it = o[Symbol.iterator]();
                        }, n : function n() {
                            var step = it.next();
                            normalCompletion = step.done;
                            return step;
                        }, e : function e(_e3) {
                            didErr = true;
                            err = _e3;
                        }, f : function f() {
                            try {
                                if (!normalCompletion && it["return"] != null) it["return"]();
                            } finally {
                                if (didErr) throw err;
                            }
                        }
                    };
                }

                function _unsupportedIterableToArray(o, minLen) {
                    if (!o) return;
                    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
                    var n = Object.prototype.toString.call(o).slice(8, -1);
                    if (n === "Object" && o.constructor) n = o.constructor.name;
                    if (n === "Map" || n === "Set") return Array.from(o);
                    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
                }

                function _arrayLikeToArray(arr, len) {
                    if (len == null || len > arr.length) len = arr.length;
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i];
                    }
                    return arr2;
                }

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                function fetchDestination(dest) {
                    return (0, _primitives.isDict)(dest) ? dest.get("D") : dest;
                }

                var Catalog = /*#__PURE__*/function() {
                    function Catalog(pdfManager, xref) {
                        _classCallCheck(this, Catalog);

                        this.pdfManager = pdfManager;
                        this.xref = xref;
                        this._catDict = xref.getCatalogObj();

                        if (!(0, _primitives.isDict)(this._catDict)) {
                            throw new _util.FormatError("Catalog object is not a dictionary.");
                        }

                        this.fontCache = new _primitives.RefSetCache();
                        this.builtInCMapCache = new Map();
                        this.globalImageCache = new _image_utils.GlobalImageCache();
                        this.pageKidsCountCache = new _primitives.RefSetCache();
                        this.nonBlendModesSet = new _primitives.RefSet();
                    }

                    _createClass(Catalog, [{
                        key : "version",
                        get : function get() {
                            var version = this._catDict.get("Version");

                            if (!(0, _primitives.isName)(version)) {
                                return (0, _util.shadow)(this, "version", null);
                            }

                            return (0, _util.shadow)(this, "version", version.name);
                        }
                    }, {
                        key : "collection",
                        get : function get() {
                            var collection = null;

                            try {
                                var obj = this._catDict.get("Collection");

                                if ((0, _primitives.isDict)(obj) && obj.size > 0) {
                                    collection = obj;
                                }
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.info)("Cannot fetch Collection entry; assuming no collection is present.");
                            }

                            return (0, _util.shadow)(this, "collection", collection);
                        }
                    }, {
                        key : "acroForm",
                        get : function get() {
                            var acroForm = null;

                            try {
                                var obj = this._catDict.get("AcroForm");

                                if ((0, _primitives.isDict)(obj) && obj.size > 0) {
                                    acroForm = obj;
                                }
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.info)("Cannot fetch AcroForm entry; assuming no forms are present.");
                            }

                            return (0, _util.shadow)(this, "acroForm", acroForm);
                        }
                    }, {
                        key : "metadata",
                        get : function get() {
                            var streamRef = this._catDict.getRaw("Metadata");

                            if (!(0, _primitives.isRef)(streamRef)) {
                                return (0, _util.shadow)(this, "metadata", null);
                            }

                            var suppressEncryption = !(this.xref.encrypt && this.xref.encrypt.encryptMetadata);
                            var stream = this.xref.fetch(streamRef, suppressEncryption);
                            var metadata = null;

                            if ((0, _primitives.isStream)(stream) && (0, _primitives.isDict)(stream.dict)) {
                                var type = stream.dict.get("Type");
                                var subtype = stream.dict.get("Subtype");

                                if ((0, _primitives.isName)(type, "Metadata") && (0, _primitives.isName)(subtype, "XML")) {
                                    try {
                                        var data = (0, _util.stringToUTF8String)((0, _util.bytesToString)(stream.getBytes()));

                                        if (data) {
                                            metadata = new _metadata_parser.MetadataParser(data).serializable;
                                        }
                                    } catch (e) {
                                        if (e instanceof _core_utils.MissingDataException) {
                                            throw e;
                                        }

                                        (0, _util.info)("Skipping invalid metadata.");
                                    }
                                }
                            }

                            return (0, _util.shadow)(this, "metadata", metadata);
                        }
                    }, {
                        key : "markInfo",
                        get : function get() {
                            var markInfo = null;

                            try {
                                markInfo = this._readMarkInfo();
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("Unable to read mark info.");
                            }

                            return (0, _util.shadow)(this, "markInfo", markInfo);
                        }
                    }, {
                        key   : "_readMarkInfo",
                        value : function _readMarkInfo() {
                            var obj = this._catDict.get("MarkInfo");

                            if (!(0, _primitives.isDict)(obj)) {
                                return null;
                            }

                            var markInfo = Object.assign(Object.create(null), {
                                Marked         : false,
                                UserProperties : false,
                                Suspects       : false
                            });

                            for (var key in markInfo) {
                                if (!obj.has(key)) {
                                    continue;
                                }

                                var value = obj.get(key);

                                if (!(0, _util.isBool)(value)) {
                                    continue;
                                }

                                markInfo[key] = value;
                            }

                            return markInfo;
                        }
                    }, {
                        key : "toplevelPagesDict",
                        get : function get() {
                            var pagesObj = this._catDict.get("Pages");

                            if (!(0, _primitives.isDict)(pagesObj)) {
                                throw new _util.FormatError("Invalid top-level pages dictionary.");
                            }

                            return (0, _util.shadow)(this, "toplevelPagesDict", pagesObj);
                        }
                    }, {
                        key : "documentOutline",
                        get : function get() {
                            var obj = null;

                            try {
                                obj = this._readDocumentOutline();
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("Unable to read document outline.");
                            }

                            return (0, _util.shadow)(this, "documentOutline", obj);
                        }
                    }, {
                        key   : "_readDocumentOutline",
                        value : function _readDocumentOutline() {
                            var obj = this._catDict.get("Outlines");

                            if (!(0, _primitives.isDict)(obj)) {
                                return null;
                            }

                            obj = obj.getRaw("First");

                            if (!(0, _primitives.isRef)(obj)) {
                                return null;
                            }

                            var root = {
                                items : []
                            };
                            var queue = [{
                                obj    : obj,
                                parent : root
                            }];
                            var processed = new _primitives.RefSet();
                            processed.put(obj);
                            var xref       = this.xref,
                                blackColor = new Uint8ClampedArray(3);

                            while (queue.length > 0) {
                                var i = queue.shift();
                                var outlineDict = xref.fetchIfRef(i.obj);

                                if (outlineDict === null) {
                                    continue;
                                }

                                if (!outlineDict.has("Title")) {
                                    throw new _util.FormatError("Invalid outline item encountered.");
                                }

                                var data = {
                                    url  : null,
                                    dest : null
                                };
                                Catalog.parseDestDictionary({
                                    destDict   : outlineDict,
                                    resultObj  : data,
                                    docBaseUrl : this.pdfManager.docBaseUrl
                                });
                                var title = outlineDict.get("Title");
                                var flags = outlineDict.get("F") || 0;
                                var color = outlineDict.getArray("C");
                                var count = outlineDict.get("Count");
                                var rgbColor = blackColor;

                                if (Array.isArray(color) && color.length === 3 && (color[0] !== 0 || color[1] !== 0 || color[2] !== 0)) {
                                    rgbColor = _colorspace.ColorSpace.singletons.rgb.getRgb(color, 0);
                                }

                                var outlineItem = {
                                    dest      : data.dest,
                                    url       : data.url,
                                    unsafeUrl : data.unsafeUrl,
                                    newWindow : data.newWindow,
                                    title     : (0, _util.stringToPDFString)(title),
                                    color     : rgbColor,
                                    count     : Number.isInteger(count) ? count : undefined,
                                    bold      : !!(flags & 2),
                                    italic    : !!(flags & 1),
                                    items     : []
                                };
                                i.parent.items.push(outlineItem);
                                obj = outlineDict.getRaw("First");

                                if ((0, _primitives.isRef)(obj) && !processed.has(obj)) {
                                    queue.push({
                                        obj    : obj,
                                        parent : outlineItem
                                    });
                                    processed.put(obj);
                                }

                                obj = outlineDict.getRaw("Next");

                                if ((0, _primitives.isRef)(obj) && !processed.has(obj)) {
                                    queue.push({
                                        obj    : obj,
                                        parent : i.parent
                                    });
                                    processed.put(obj);
                                }
                            }

                            return root.items.length > 0 ? root.items : null;
                        }
                    }, {
                        key : "permissions",
                        get : function get() {
                            var permissions = null;

                            try {
                                permissions = this._readPermissions();
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("Unable to read permissions.");
                            }

                            return (0, _util.shadow)(this, "permissions", permissions);
                        }
                    }, {
                        key   : "_readPermissions",
                        value : function _readPermissions() {
                            var encrypt = this.xref.trailer.get("Encrypt");

                            if (!(0, _primitives.isDict)(encrypt)) {
                                return null;
                            }

                            var flags = encrypt.get("P");

                            if (!(0, _util.isNum)(flags)) {
                                return null;
                            }

                            flags += Math.pow(2, 32);
                            var permissions = [];

                            for (var key in _util.PermissionFlag) {
                                var value = _util.PermissionFlag[key];

                                if (flags & value) {
                                    permissions.push(value);
                                }
                            }

                            return permissions;
                        }
                    }, {
                        key : "optionalContentConfig",
                        get : function get() {
                            var config = null;

                            try {
                                var properties = this._catDict.get("OCProperties");

                                if (!properties) {
                                    return (0, _util.shadow)(this, "optionalContentConfig", null);
                                }

                                var defaultConfig = properties.get("D");

                                if (!defaultConfig) {
                                    return (0, _util.shadow)(this, "optionalContentConfig", null);
                                }

                                var groupsData = properties.get("OCGs");

                                if (!Array.isArray(groupsData)) {
                                    return (0, _util.shadow)(this, "optionalContentConfig", null);
                                }

                                var groups = [];
                                var groupRefs = [];

                                var _iterator = _createForOfIteratorHelper(groupsData),
                                    _step;

                                try {
                                    for (_iterator.s(); !(_step = _iterator.n()).done;) {
                                        var groupRef = _step.value;

                                        if (!(0, _primitives.isRef)(groupRef)) {
                                            continue;
                                        }

                                        groupRefs.push(groupRef);
                                        var group = this.xref.fetchIfRef(groupRef);
                                        groups.push({
                                            id     : groupRef.toString(),
                                            name   : (0, _util.isString)(group.get("Name")) ? (0, _util.stringToPDFString)(group.get("Name")) : null,
                                            intent : (0, _util.isString)(group.get("Intent")) ? (0, _util.stringToPDFString)(group.get("Intent")) : null
                                        });
                                    }
                                } catch (err) {
                                    _iterator.e(err);
                                } finally {
                                    _iterator.f();
                                }

                                config = this._readOptionalContentConfig(defaultConfig, groupRefs);
                                config.groups = groups;
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("Unable to read optional content config: ".concat(ex));
                            }

                            return (0, _util.shadow)(this, "optionalContentConfig", config);
                        }
                    }, {
                        key   : "_readOptionalContentConfig",
                        value : function _readOptionalContentConfig(config, contentGroupRefs) {
                            function parseOnOff(refs) {
                                var onParsed = [];

                                if (Array.isArray(refs)) {
                                    var _iterator2 = _createForOfIteratorHelper(refs),
                                        _step2;

                                    try {
                                        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                                            var value = _step2.value;

                                            if (!(0, _primitives.isRef)(value)) {
                                                continue;
                                            }

                                            if (contentGroupRefs.includes(value)) {
                                                onParsed.push(value.toString());
                                            }
                                        }
                                    } catch (err) {
                                        _iterator2.e(err);
                                    } finally {
                                        _iterator2.f();
                                    }
                                }

                                return onParsed;
                            }

                            function parseOrder(refs) {
                                var nestedLevels = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

                                if (!Array.isArray(refs)) {
                                    return null;
                                }

                                var order = [];

                                var _iterator3 = _createForOfIteratorHelper(refs),
                                    _step3;

                                try {
                                    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                                        var value = _step3.value;

                                        if ((0, _primitives.isRef)(value) && contentGroupRefs.includes(value)) {
                                            parsedOrderRefs.put(value);
                                            order.push(value.toString());
                                            continue;
                                        }

                                        var nestedOrder = parseNestedOrder(value, nestedLevels);

                                        if (nestedOrder) {
                                            order.push(nestedOrder);
                                        }
                                    }
                                } catch (err) {
                                    _iterator3.e(err);
                                } finally {
                                    _iterator3.f();
                                }

                                if (nestedLevels > 0) {
                                    return order;
                                }

                                var hiddenGroups = [];

                                var _iterator4 = _createForOfIteratorHelper(contentGroupRefs),
                                    _step4;

                                try {
                                    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                                        var groupRef = _step4.value;

                                        if (parsedOrderRefs.has(groupRef)) {
                                            continue;
                                        }

                                        hiddenGroups.push(groupRef.toString());
                                    }
                                } catch (err) {
                                    _iterator4.e(err);
                                } finally {
                                    _iterator4.f();
                                }

                                if (hiddenGroups.length) {
                                    order.push({
                                        name  : null,
                                        order : hiddenGroups
                                    });
                                }

                                return order;
                            }

                            function parseNestedOrder(ref, nestedLevels) {
                                if (++nestedLevels > MAX_NESTED_LEVELS) {
                                    (0, _util.warn)("parseNestedOrder - reached MAX_NESTED_LEVELS.");
                                    return null;
                                }

                                var value = xref.fetchIfRef(ref);

                                if (!Array.isArray(value)) {
                                    return null;
                                }

                                var nestedName = xref.fetchIfRef(value[0]);

                                if (typeof nestedName !== "string") {
                                    return null;
                                }

                                var nestedOrder = parseOrder(value.slice(1), nestedLevels);

                                if (!nestedOrder || !nestedOrder.length) {
                                    return null;
                                }

                                return {
                                    name  : (0, _util.stringToPDFString)(nestedName),
                                    order : nestedOrder
                                };
                            }

                            var xref              = this.xref,
                                parsedOrderRefs   = new _primitives.RefSet(),
                                MAX_NESTED_LEVELS = 10;
                            return {
                                name      : (0, _util.isString)(config.get("Name")) ? (0, _util.stringToPDFString)(config.get("Name")) : null,
                                creator   : (0, _util.isString)(config.get("Creator")) ? (0, _util.stringToPDFString)(config.get("Creator")) : null,
                                baseState : (0, _primitives.isName)(config.get("BaseState")) ? config.get("BaseState").name : null,
                                on        : parseOnOff(config.get("ON")),
                                off       : parseOnOff(config.get("OFF")),
                                order     : parseOrder(config.get("Order")),
                                groups    : null
                            };
                        }
                    }, {
                        key : "numPages",
                        get : function get() {
                            var obj = this.toplevelPagesDict.get("Count");

                            if (!Number.isInteger(obj)) {
                                throw new _util.FormatError("Page count in top-level pages dictionary is not an integer.");
                            }

                            return (0, _util.shadow)(this, "numPages", obj);
                        }
                    }, {
                        key : "destinations",
                        get : function get() {
                            var obj   = this._readDests(),
                                dests = Object.create(null);

                            if (obj instanceof NameTree) {
                                var names = obj.getAll();

                                for (var name in names) {
                                    dests[name] = fetchDestination(names[name]);
                                }
                            } else if (obj instanceof _primitives.Dict) {
                                obj.forEach(function(key, value) {
                                    if (value) {
                                        dests[key] = fetchDestination(value);
                                    }
                                });
                            }

                            return (0, _util.shadow)(this, "destinations", dests);
                        }
                    }, {
                        key   : "getDestination",
                        value : function getDestination(destinationId) {
                            var obj = this._readDests();

                            if (obj instanceof NameTree || obj instanceof _primitives.Dict) {
                                return fetchDestination(obj.get(destinationId) || null);
                            }

                            return null;
                        }
                    }, {
                        key   : "_readDests",
                        value : function _readDests() {
                            var obj = this._catDict.get("Names");

                            if (obj && obj.has("Dests")) {
                                return new NameTree(obj.getRaw("Dests"), this.xref);
                            } else if (this._catDict.has("Dests")) {
                                return this._catDict.get("Dests");
                            }

                            return undefined;
                        }
                    }, {
                        key : "pageLabels",
                        get : function get() {
                            var obj = null;

                            try {
                                obj = this._readPageLabels();
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("Unable to read page labels.");
                            }

                            return (0, _util.shadow)(this, "pageLabels", obj);
                        }
                    }, {
                        key   : "_readPageLabels",
                        value : function _readPageLabels() {
                            var obj = this._catDict.getRaw("PageLabels");

                            if (!obj) {
                                return null;
                            }

                            var pageLabels = new Array(this.numPages);
                            var style  = null,
                                prefix = "";
                            var numberTree = new NumberTree(obj, this.xref);
                            var nums = numberTree.getAll();
                            var currentLabel = "",
                                currentIndex = 1;

                            for (var i = 0, ii = this.numPages; i < ii; i++) {
                                if (i in nums) {
                                    var labelDict = nums[i];

                                    if (!(0, _primitives.isDict)(labelDict)) {
                                        throw new _util.FormatError("PageLabel is not a dictionary.");
                                    }

                                    if (labelDict.has("Type") && !(0, _primitives.isName)(labelDict.get("Type"), "PageLabel")) {
                                        throw new _util.FormatError("Invalid type in PageLabel dictionary.");
                                    }

                                    if (labelDict.has("S")) {
                                        var s = labelDict.get("S");

                                        if (!(0, _primitives.isName)(s)) {
                                            throw new _util.FormatError("Invalid style in PageLabel dictionary.");
                                        }

                                        style = s.name;
                                    } else {
                                        style = null;
                                    }

                                    if (labelDict.has("P")) {
                                        var p = labelDict.get("P");

                                        if (!(0, _util.isString)(p)) {
                                            throw new _util.FormatError("Invalid prefix in PageLabel dictionary.");
                                        }

                                        prefix = (0, _util.stringToPDFString)(p);
                                    } else {
                                        prefix = "";
                                    }

                                    if (labelDict.has("St")) {
                                        var st = labelDict.get("St");

                                        if (!(Number.isInteger(st) && st >= 1)) {
                                            throw new _util.FormatError("Invalid start in PageLabel dictionary.");
                                        }

                                        currentIndex = st;
                                    } else {
                                        currentIndex = 1;
                                    }
                                }

                                switch (style) {
                                    case "D":
                                        currentLabel = currentIndex;
                                        break;

                                    case "R":
                                    case "r":
                                        currentLabel = (0, _core_utils.toRomanNumerals)(currentIndex, style === "r");
                                        break;

                                    case "A":
                                    case "a":
                                        var LIMIT = 26;
                                        var A_UPPER_CASE = 0x41,
                                            A_LOWER_CASE = 0x61;
                                        var baseCharCode = style === "a" ? A_LOWER_CASE : A_UPPER_CASE;
                                        var letterIndex = currentIndex - 1;
                                        var character = String.fromCharCode(baseCharCode + letterIndex % LIMIT);
                                        var charBuf = [];

                                        for (var j = 0, jj = letterIndex / LIMIT | 0; j <= jj; j++) {
                                            charBuf.push(character);
                                        }

                                        currentLabel = charBuf.join("");
                                        break;

                                    default:
                                        if (style) {
                                            throw new _util.FormatError("Invalid style \"".concat(style, "\" in PageLabel dictionary."));
                                        }

                                        currentLabel = "";
                                }

                                pageLabels[i] = prefix + currentLabel;
                                currentIndex++;
                            }

                            return pageLabels;
                        }
                    }, {
                        key : "pageLayout",
                        get : function get() {
                            var obj = this._catDict.get("PageLayout");

                            var pageLayout = "";

                            if ((0, _primitives.isName)(obj)) {
                                switch (obj.name) {
                                    case "SinglePage":
                                    case "OneColumn":
                                    case "TwoColumnLeft":
                                    case "TwoColumnRight":
                                    case "TwoPageLeft":
                                    case "TwoPageRight":
                                        pageLayout = obj.name;
                                }
                            }

                            return (0, _util.shadow)(this, "pageLayout", pageLayout);
                        }
                    }, {
                        key : "pageMode",
                        get : function get() {
                            var obj = this._catDict.get("PageMode");

                            var pageMode = "UseNone";

                            if ((0, _primitives.isName)(obj)) {
                                switch (obj.name) {
                                    case "UseNone":
                                    case "UseOutlines":
                                    case "UseThumbs":
                                    case "FullScreen":
                                    case "UseOC":
                                    case "UseAttachments":
                                        pageMode = obj.name;
                                }
                            }

                            return (0, _util.shadow)(this, "pageMode", pageMode);
                        }
                    }, {
                        key : "viewerPreferences",
                        get : function get() {
                            var _this = this;

                            var ViewerPreferencesValidators = {
                                HideToolbar           : _util.isBool,
                                HideMenubar           : _util.isBool,
                                HideWindowUI          : _util.isBool,
                                FitWindow             : _util.isBool,
                                CenterWindow          : _util.isBool,
                                DisplayDocTitle       : _util.isBool,
                                NonFullScreenPageMode : _primitives.isName,
                                Direction             : _primitives.isName,
                                ViewArea              : _primitives.isName,
                                ViewClip              : _primitives.isName,
                                PrintArea             : _primitives.isName,
                                PrintClip             : _primitives.isName,
                                PrintScaling          : _primitives.isName,
                                Duplex                : _primitives.isName,
                                PickTrayByPDFSize     : _util.isBool,
                                PrintPageRange        : Array.isArray,
                                NumCopies             : Number.isInteger
                            };

                            var obj = this._catDict.get("ViewerPreferences");

                            var prefs = null;

                            if ((0, _primitives.isDict)(obj)) {
                                for (var key in ViewerPreferencesValidators) {
                                    if (!obj.has(key)) {
                                        continue;
                                    }

                                    var value = obj.get(key);

                                    if (!ViewerPreferencesValidators[key](value)) {
                                        (0, _util.info)("Bad value in ViewerPreferences for \"".concat(key, "\"."));
                                        continue;
                                    }

                                    var prefValue = void 0;

                                    switch (key) {
                                        case "NonFullScreenPageMode":
                                            switch (value.name) {
                                                case "UseNone":
                                                case "UseOutlines":
                                                case "UseThumbs":
                                                case "UseOC":
                                                    prefValue = value.name;
                                                    break;

                                                default:
                                                    prefValue = "UseNone";
                                            }

                                            break;

                                        case "Direction":
                                            switch (value.name) {
                                                case "L2R":
                                                case "R2L":
                                                    prefValue = value.name;
                                                    break;

                                                default:
                                                    prefValue = "L2R";
                                            }

                                            break;

                                        case "ViewArea":
                                        case "ViewClip":
                                        case "PrintArea":
                                        case "PrintClip":
                                            switch (value.name) {
                                                case "MediaBox":
                                                case "CropBox":
                                                case "BleedBox":
                                                case "TrimBox":
                                                case "ArtBox":
                                                    prefValue = value.name;
                                                    break;

                                                default:
                                                    prefValue = "CropBox";
                                            }

                                            break;

                                        case "PrintScaling":
                                            switch (value.name) {
                                                case "None":
                                                case "AppDefault":
                                                    prefValue = value.name;
                                                    break;

                                                default:
                                                    prefValue = "AppDefault";
                                            }

                                            break;

                                        case "Duplex":
                                            switch (value.name) {
                                                case "Simplex":
                                                case "DuplexFlipShortEdge":
                                                case "DuplexFlipLongEdge":
                                                    prefValue = value.name;
                                                    break;

                                                default:
                                                    prefValue = "None";
                                            }

                                            break;

                                        case "PrintPageRange":
                                            var length = value.length;

                                            if (length % 2 !== 0) {
                                                break;
                                            }

                                            var isValid = value.every(function(page, i, arr) {
                                                return Number.isInteger(page) && page > 0 && (i === 0 || page >= arr[i - 1]) && page <= _this.numPages;
                                            });

                                            if (isValid) {
                                                prefValue = value;
                                            }

                                            break;

                                        case "NumCopies":
                                            if (value > 0) {
                                                prefValue = value;
                                            }

                                            break;

                                        default:
                                            if (typeof value !== "boolean") {
                                                throw new _util.FormatError("viewerPreferences - expected a boolean value for: ".concat(key));
                                            }

                                            prefValue = value;
                                    }

                                    if (prefValue !== undefined) {
                                        if (!prefs) {
                                            prefs = Object.create(null);
                                        }

                                        prefs[key] = prefValue;
                                    } else {
                                        (0, _util.info)("Bad value in ViewerPreferences for \"".concat(key, "\"."));
                                    }
                                }
                            }

                            return (0, _util.shadow)(this, "viewerPreferences", prefs);
                        }
                    }, {
                        key : "openAction",
                        get : function get() {
                            var obj = this._catDict.get("OpenAction");

                            var openAction = Object.create(null);

                            if ((0, _primitives.isDict)(obj)) {
                                var destDict = new _primitives.Dict(this.xref);
                                destDict.set("A", obj);
                                var resultObj = {
                                    url    : null,
                                    dest   : null,
                                    action : null
                                };
                                Catalog.parseDestDictionary({
                                    destDict  : destDict,
                                    resultObj : resultObj
                                });

                                if (Array.isArray(resultObj.dest)) {
                                    openAction.dest = resultObj.dest;
                                } else if (resultObj.action) {
                                    openAction.action = resultObj.action;
                                }
                            } else if (Array.isArray(obj)) {
                                openAction.dest = obj;
                            }

                            return (0, _util.shadow)(this, "openAction", (0, _util.objectSize)(openAction) > 0 ? openAction : null);
                        }
                    }, {
                        key : "attachments",
                        get : function get() {
                            var obj = this._catDict.get("Names");

                            var attachments = null;

                            if (obj && obj.has("EmbeddedFiles")) {
                                var nameTree = new NameTree(obj.getRaw("EmbeddedFiles"), this.xref);
                                var names = nameTree.getAll();

                                for (var name in names) {
                                    var fs = new FileSpec(names[name], this.xref);

                                    if (!attachments) {
                                        attachments = Object.create(null);
                                    }

                                    attachments[(0, _util.stringToPDFString)(name)] = fs.serializable;
                                }
                            }

                            return (0, _util.shadow)(this, "attachments", attachments);
                        }
                    }, {
                        key   : "_collectJavaScript",
                        value : function _collectJavaScript() {
                            var obj = this._catDict.get("Names");

                            var javaScript = null;

                            function appendIfJavaScriptDict(name, jsDict) {
                                var type = jsDict.get("S");

                                if (!(0, _primitives.isName)(type, "JavaScript")) {
                                    return;
                                }

                                var js = jsDict.get("JS");

                                if ((0, _primitives.isStream)(js)) {
                                    js = (0, _util.bytesToString)(js.getBytes());
                                } else if (!(0, _util.isString)(js)) {
                                    return;
                                }

                                if (javaScript === null) {
                                    javaScript = Object.create(null);
                                }

                                javaScript[name] = (0, _util.stringToPDFString)(js);
                            }

                            if (obj && obj.has("JavaScript")) {
                                var nameTree = new NameTree(obj.getRaw("JavaScript"), this.xref);
                                var names = nameTree.getAll();

                                for (var name in names) {
                                    var jsDict = names[name];

                                    if ((0, _primitives.isDict)(jsDict)) {
                                        appendIfJavaScriptDict(name, jsDict);
                                    }
                                }
                            }

                            var openAction = this._catDict.get("OpenAction");

                            if ((0, _primitives.isDict)(openAction) && (0, _primitives.isName)(openAction.get("S"), "JavaScript")) {
                                appendIfJavaScriptDict("OpenAction", openAction);
                            }

                            return javaScript;
                        }
                    }, {
                        key : "javaScript",
                        get : function get() {
                            var javaScript = this._collectJavaScript();

                            return (0, _util.shadow)(this, "javaScript", javaScript ? Object.values(javaScript) : null);
                        }
                    }, {
                        key : "jsActions",
                        get : function get() {
                            var js = this._collectJavaScript();

                            var actions = (0, _core_utils.collectActions)(this.xref, this._catDict, _util.DocumentActionEventType);

                            if (!actions && js) {
                                actions = Object.create(null);
                            }

                            if (actions && js) {
                                for (var _i = 0, _Object$entries = Object.entries(js); _i < _Object$entries.length; _i++) {
                                    var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
                                        key                = _Object$entries$_i[0],
                                        val                = _Object$entries$_i[1];

                                    if (key in actions) {
                                        actions[key].push(val);
                                    } else {
                                        actions[key] = [val];
                                    }
                                }
                            }

                            return (0, _util.shadow)(this, "jsActions", actions);
                        }
                    }, {
                        key   : "fontFallback",
                        value : function fontFallback(id, handler) {
                            var promises = [];
                            this.fontCache.forEach(function(promise) {
                                promises.push(promise);
                            });
                            return Promise.all(promises).then(function(translatedFonts) {
                                var _iterator5 = _createForOfIteratorHelper(translatedFonts),
                                    _step5;

                                try {
                                    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                                        var translatedFont = _step5.value;

                                        if (translatedFont.loadedName === id) {
                                            translatedFont.fallback(handler);
                                            return;
                                        }
                                    }
                                } catch (err) {
                                    _iterator5.e(err);
                                } finally {
                                    _iterator5.f();
                                }
                            });
                        }
                    }, {
                        key   : "cleanup",
                        value : function cleanup() {
                            var _this2 = this;

                            var manuallyTriggered = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                            (0, _primitives.clearPrimitiveCaches)();
                            this.globalImageCache.clear(manuallyTriggered);
                            this.pageKidsCountCache.clear();
                            this.nonBlendModesSet.clear();
                            var promises = [];
                            this.fontCache.forEach(function(promise) {
                                promises.push(promise);
                            });
                            return Promise.all(promises).then(function(translatedFonts) {
                                var _iterator6 = _createForOfIteratorHelper(translatedFonts),
                                    _step6;

                                try {
                                    for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
                                        var dict = _step6.value.dict;
                                        delete dict.cacheKey;
                                    }
                                } catch (err) {
                                    _iterator6.e(err);
                                } finally {
                                    _iterator6.f();
                                }

                                _this2.fontCache.clear();

                                _this2.builtInCMapCache.clear();
                            });
                        }
                    }, {
                        key   : "getPageDict",
                        value : function getPageDict(pageIndex) {
                            var capability = (0, _util.createPromiseCapability)();
                            var nodesToVisit = [this._catDict.getRaw("Pages")];
                            var visitedNodes = new _primitives.RefSet();
                            var xref               = this.xref,
                                pageKidsCountCache = this.pageKidsCountCache;
                            var count,
                                currentPageIndex = 0;

                            function next() {
                                var _loop = function _loop() {
                                    var currentNode = nodesToVisit.pop();

                                    if ((0, _primitives.isRef)(currentNode)) {
                                        count = pageKidsCountCache.get(currentNode);

                                        if (count > 0 && currentPageIndex + count < pageIndex) {
                                            currentPageIndex += count;
                                            return "continue";
                                        }

                                        if (visitedNodes.has(currentNode)) {
                                            capability.reject(new _util.FormatError("Pages tree contains circular reference."));
                                            return {
                                                v : void 0
                                            };
                                        }

                                        visitedNodes.put(currentNode);
                                        xref.fetchAsync(currentNode).then(function(obj) {
                                            if ((0, _primitives.isDict)(obj, "Page") || (0, _primitives.isDict)(obj) && !obj.has("Kids")) {
                                                if (pageIndex === currentPageIndex) {
                                                    if (currentNode && !pageKidsCountCache.has(currentNode)) {
                                                        pageKidsCountCache.put(currentNode, 1);
                                                    }

                                                    capability.resolve([obj, currentNode]);
                                                } else {
                                                    currentPageIndex++;
                                                    next();
                                                }

                                                return;
                                            }

                                            nodesToVisit.push(obj);
                                            next();
                                        }, capability.reject);
                                        return {
                                            v : void 0
                                        };
                                    }

                                    if (!(0, _primitives.isDict)(currentNode)) {
                                        capability.reject(new _util.FormatError("Page dictionary kid reference points to wrong type of object."));
                                        return {
                                            v : void 0
                                        };
                                    }

                                    count = currentNode.get("Count");

                                    if (Number.isInteger(count) && count >= 0) {
                                        var objId = currentNode.objId;

                                        if (objId && !pageKidsCountCache.has(objId)) {
                                            pageKidsCountCache.put(objId, count);
                                        }

                                        if (currentPageIndex + count <= pageIndex) {
                                            currentPageIndex += count;
                                            return "continue";
                                        }
                                    }

                                    var kids = currentNode.get("Kids");

                                    if (!Array.isArray(kids)) {
                                        if ((0, _primitives.isName)(currentNode.get("Type"), "Page") || !currentNode.has("Type") && currentNode.has("Contents")) {
                                            if (currentPageIndex === pageIndex) {
                                                capability.resolve([currentNode, null]);
                                                return {
                                                    v : void 0
                                                };
                                            }

                                            currentPageIndex++;
                                            return "continue";
                                        }

                                        capability.reject(new _util.FormatError("Page dictionary kids object is not an array."));
                                        return {
                                            v : void 0
                                        };
                                    }

                                    for (var last = kids.length - 1; last >= 0; last--) {
                                        nodesToVisit.push(kids[last]);
                                    }
                                };

                                while (nodesToVisit.length) {
                                    var _ret = _loop();

                                    if (_ret === "continue") continue;
                                    if (_typeof(_ret) === "object") return _ret.v;
                                }

                                capability.reject(new Error("Page index ".concat(pageIndex, " not found.")));
                            }

                            next();
                            return capability.promise;
                        }
                    }, {
                        key   : "getPageIndex",
                        value : function getPageIndex(pageRef) {
                            var xref = this.xref;

                            function pagesBeforeRef(kidRef) {
                                var total = 0,
                                    parentRef;
                                return xref.fetchAsync(kidRef).then(function(node) {
                                    if ((0, _primitives.isRefsEqual)(kidRef, pageRef) && !(0, _primitives.isDict)(node, "Page") && !((0, _primitives.isDict)(node) && !node.has("Type") && node.has("Contents"))) {
                                        throw new _util.FormatError("The reference does not point to a /Page dictionary.");
                                    }

                                    if (!node) {
                                        return null;
                                    }

                                    if (!(0, _primitives.isDict)(node)) {
                                        throw new _util.FormatError("Node must be a dictionary.");
                                    }

                                    parentRef = node.getRaw("Parent");
                                    return node.getAsync("Parent");
                                }).then(function(parent) {
                                    if (!parent) {
                                        return null;
                                    }

                                    if (!(0, _primitives.isDict)(parent)) {
                                        throw new _util.FormatError("Parent must be a dictionary.");
                                    }

                                    return parent.getAsync("Kids");
                                }).then(function(kids) {
                                    if (!kids) {
                                        return null;
                                    }

                                    var kidPromises = [];
                                    var found = false;

                                    for (var i = 0, ii = kids.length; i < ii; i++) {
                                        var kid = kids[i];

                                        if (!(0, _primitives.isRef)(kid)) {
                                            throw new _util.FormatError("Kid must be a reference.");
                                        }

                                        if ((0, _primitives.isRefsEqual)(kid, kidRef)) {
                                            found = true;
                                            break;
                                        }

                                        kidPromises.push(xref.fetchAsync(kid).then(function(obj) {
                                            if (!(0, _primitives.isDict)(obj)) {
                                                throw new _util.FormatError("Kid node must be a dictionary.");
                                            }

                                            if (obj.has("Count")) {
                                                total += obj.get("Count");
                                            } else {
                                                total++;
                                            }
                                        }));
                                    }

                                    if (!found) {
                                        throw new _util.FormatError("Kid reference not found in parent's kids.");
                                    }

                                    return Promise.all(kidPromises).then(function() {
                                        return [total, parentRef];
                                    });
                                });
                            }

                            var total = 0;

                            function next(ref) {
                                return pagesBeforeRef(ref).then(function(args) {
                                    if (!args) {
                                        return total;
                                    }

                                    var _args     = _slicedToArray(args, 2),
                                        count     = _args[0],
                                        parentRef = _args[1];

                                    total += count;
                                    return next(parentRef);
                                });
                            }

                            return next(pageRef);
                        }
                    }], [{
                        key   : "parseDestDictionary",
                        value : function parseDestDictionary(params) {
                            function addDefaultProtocolToUrl(url) {
                                return url.startsWith("www.") ? "http://".concat(url) : url;
                            }

                            function tryConvertUrlEncoding(url) {
                                try {
                                    return (0, _util.stringToUTF8String)(url);
                                } catch (e) {
                                    return url;
                                }
                            }

                            var destDict = params.destDict;

                            if (!(0, _primitives.isDict)(destDict)) {
                                (0, _util.warn)("parseDestDictionary: `destDict` must be a dictionary.");
                                return;
                            }

                            var resultObj = params.resultObj;

                            if (_typeof(resultObj) !== "object") {
                                (0, _util.warn)("parseDestDictionary: `resultObj` must be an object.");
                                return;
                            }

                            var docBaseUrl = params.docBaseUrl || null;
                            var action = destDict.get("A"),
                                url,
                                dest;

                            if (!(0, _primitives.isDict)(action)) {
                                if (destDict.has("Dest")) {
                                    action = destDict.get("Dest");
                                } else {
                                    action = destDict.get("AA");

                                    if ((0, _primitives.isDict)(action)) {
                                        if (action.has("D")) {
                                            action = action.get("D");
                                        } else if (action.has("U")) {
                                            action = action.get("U");
                                        }
                                    }
                                }
                            }

                            if ((0, _primitives.isDict)(action)) {
                                var actionType = action.get("S");

                                if (!(0, _primitives.isName)(actionType)) {
                                    (0, _util.warn)("parseDestDictionary: Invalid type in Action dictionary.");
                                    return;
                                }

                                var actionName = actionType.name;

                                switch (actionName) {
                                    case "URI":
                                        url = action.get("URI");

                                        if ((0, _primitives.isName)(url)) {
                                            url = "/" + url.name;
                                        } else if ((0, _util.isString)(url)) {
                                            url = addDefaultProtocolToUrl(url);
                                        }

                                        break;

                                    case "GoTo":
                                        dest = action.get("D");
                                        break;

                                    case "Launch":
                                    case "GoToR":
                                        var urlDict = action.get("F");

                                        if ((0, _primitives.isDict)(urlDict)) {
                                            url = urlDict.get("F") || null;
                                        } else if ((0, _util.isString)(urlDict)) {
                                            url = urlDict;
                                        }

                                        var remoteDest = action.get("D");

                                        if (remoteDest) {
                                            if ((0, _primitives.isName)(remoteDest)) {
                                                remoteDest = remoteDest.name;
                                            }

                                            if ((0, _util.isString)(url)) {
                                                var baseUrl = url.split("#")[0];

                                                if ((0, _util.isString)(remoteDest)) {
                                                    url = baseUrl + "#" + remoteDest;
                                                } else if (Array.isArray(remoteDest)) {
                                                    url = baseUrl + "#" + JSON.stringify(remoteDest);
                                                }
                                            }
                                        }

                                        var newWindow = action.get("NewWindow");

                                        if ((0, _util.isBool)(newWindow)) {
                                            resultObj.newWindow = newWindow;
                                        }

                                        break;

                                    case "Named":
                                        var namedAction = action.get("N");

                                        if ((0, _primitives.isName)(namedAction)) {
                                            resultObj.action = namedAction.name;
                                        }

                                        break;

                                    case "JavaScript":
                                        var jsAction = action.get("JS");
                                        var js;

                                        if ((0, _primitives.isStream)(jsAction)) {
                                            js = (0, _util.bytesToString)(jsAction.getBytes());
                                        } else if ((0, _util.isString)(jsAction)) {
                                            js = jsAction;
                                        }

                                        if (js) {
                                            var URL_OPEN_METHODS = ["app.launchURL", "window.open"];
                                            var regex = new RegExp("^\\s*(" + URL_OPEN_METHODS.join("|").split(".").join("\\.") + ")\\((?:'|\")([^'\"]*)(?:'|\")(?:,\\s*(\\w+)\\)|\\))", "i");
                                            var jsUrl = regex.exec((0, _util.stringToPDFString)(js));

                                            if (jsUrl && jsUrl[2]) {
                                                url = jsUrl[2];

                                                if (jsUrl[3] === "true" && jsUrl[1] === "app.launchURL") {
                                                    resultObj.newWindow = true;
                                                }

                                                break;
                                            }
                                        }

                                    default:
                                        if (actionName === "JavaScript" || actionName === "ResetForm" || actionName === "SubmitForm") {
                                            break;
                                        }

                                        (0, _util.warn)("parseDestDictionary - unsupported action: \"".concat(actionName, "\"."));
                                        break;
                                }
                            } else if (destDict.has("Dest")) {
                                dest = destDict.get("Dest");
                            }

                            if ((0, _util.isString)(url)) {
                                url = tryConvertUrlEncoding(url);
                                var absoluteUrl = (0, _util.createValidAbsoluteUrl)(url, docBaseUrl);

                                if (absoluteUrl) {
                                    resultObj.url = absoluteUrl.href;
                                }

                                resultObj.unsafeUrl = url;
                            }

                            if (dest) {
                                if ((0, _primitives.isName)(dest)) {
                                    dest = dest.name;
                                }

                                if ((0, _util.isString)(dest) || Array.isArray(dest)) {
                                    resultObj.dest = dest;
                                }
                            }
                        }
                    }]);

                    return Catalog;
                }();

                exports.Catalog = Catalog;

                var XRef = function XRefClosure() {
                    function XRef(stream, pdfManager) {
                        this.stream = stream;
                        this.pdfManager = pdfManager;
                        this.entries = [];
                        this.xrefstms = Object.create(null);
                        this._cacheMap = new Map();
                        this.stats = {
                            streamTypes : Object.create(null),
                            fontTypes   : Object.create(null)
                        };
                        this._newRefNum = null;
                    }

                    XRef.prototype = {
                        getNewRef         : function XRef_getNewRef() {
                            if (this._newRefNum === null) {
                                this._newRefNum = this.entries.length;
                            }

                            return _primitives.Ref.get(this._newRefNum++, 0);
                        },
                        resetNewRef       : function XRef_resetNewRef() {
                            this._newRefNum = null;
                        },
                        setStartXRef      : function XRef_setStartXRef(startXRef) {
                            this.startXRefQueue = [startXRef];
                        },
                        parse             : function XRef_parse(recoveryMode) {
                            var trailerDict;

                            if (!recoveryMode) {
                                trailerDict = this.readXRef();
                            } else {
                                (0, _util.warn)("Indexing all PDF objects");
                                trailerDict = this.indexObjects();
                            }

                            trailerDict.assignXref(this);
                            this.trailer = trailerDict;
                            var encrypt;

                            try {
                                encrypt = trailerDict.get("Encrypt");
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("XRef.parse - Invalid \"Encrypt\" reference: \"".concat(ex, "\"."));
                            }

                            if ((0, _primitives.isDict)(encrypt)) {
                                var ids = trailerDict.get("ID");
                                var fileId = ids && ids.length ? ids[0] : "";
                                encrypt.suppressEncryption = true;
                                this.encrypt = new _crypto.CipherTransformFactory(encrypt, fileId, this.pdfManager.password);
                            }

                            var root;

                            try {
                                root = trailerDict.get("Root");
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("XRef.parse - Invalid \"Root\" reference: \"".concat(ex, "\"."));
                            }

                            if ((0, _primitives.isDict)(root) && root.has("Pages")) {
                                this.root = root;
                            } else {
                                if (!recoveryMode) {
                                    throw new _core_utils.XRefParseException();
                                }

                                throw new _util.FormatError("Invalid root reference");
                            }
                        },
                        processXRefTable  : function XRef_processXRefTable(parser) {
                            if (!("tableState" in this)) {
                                this.tableState = {
                                    entryNum   : 0,
                                    streamPos  : parser.lexer.stream.pos,
                                    parserBuf1 : parser.buf1,
                                    parserBuf2 : parser.buf2
                                };
                            }

                            var obj = this.readXRefTable(parser);

                            if (!(0, _primitives.isCmd)(obj, "trailer")) {
                                throw new _util.FormatError("Invalid XRef table: could not find trailer dictionary");
                            }

                            var dict = parser.getObj();

                            if (!(0, _primitives.isDict)(dict) && dict.dict) {
                                dict = dict.dict;
                            }

                            if (!(0, _primitives.isDict)(dict)) {
                                throw new _util.FormatError("Invalid XRef table: could not parse trailer dictionary");
                            }

                            delete this.tableState;
                            return dict;
                        },
                        readXRefTable     : function XRef_readXRefTable(parser) {
                            var stream = parser.lexer.stream;
                            var tableState = this.tableState;
                            stream.pos = tableState.streamPos;
                            parser.buf1 = tableState.parserBuf1;
                            parser.buf2 = tableState.parserBuf2;
                            var obj;

                            while (true) {
                                if (!("firstEntryNum" in tableState) || !("entryCount" in tableState)) {
                                    if ((0, _primitives.isCmd)(obj = parser.getObj(), "trailer")) {
                                        break;
                                    }

                                    tableState.firstEntryNum = obj;
                                    tableState.entryCount = parser.getObj();
                                }

                                var first = tableState.firstEntryNum;
                                var count = tableState.entryCount;

                                if (!Number.isInteger(first) || !Number.isInteger(count)) {
                                    throw new _util.FormatError("Invalid XRef table: wrong types in subsection header");
                                }

                                for (var i = tableState.entryNum; i < count; i++) {
                                    tableState.streamPos = stream.pos;
                                    tableState.entryNum = i;
                                    tableState.parserBuf1 = parser.buf1;
                                    tableState.parserBuf2 = parser.buf2;
                                    var entry = {};
                                    entry.offset = parser.getObj();
                                    entry.gen = parser.getObj();
                                    var type = parser.getObj();

                                    if (type instanceof _primitives.Cmd) {
                                        switch (type.cmd) {
                                            case "f":
                                                entry.free = true;
                                                break;

                                            case "n":
                                                entry.uncompressed = true;
                                                break;
                                        }
                                    }

                                    if (!Number.isInteger(entry.offset) || !Number.isInteger(entry.gen) || !(entry.free || entry.uncompressed)) {
                                        throw new _util.FormatError("Invalid entry in XRef subsection: ".concat(first, ", ").concat(count));
                                    }

                                    if (i === 0 && entry.free && first === 1) {
                                        first = 0;
                                    }

                                    if (!this.entries[i + first]) {
                                        this.entries[i + first] = entry;
                                    }
                                }

                                tableState.entryNum = 0;
                                tableState.streamPos = stream.pos;
                                tableState.parserBuf1 = parser.buf1;
                                tableState.parserBuf2 = parser.buf2;
                                delete tableState.firstEntryNum;
                                delete tableState.entryCount;
                            }

                            if (this.entries[0] && !this.entries[0].free) {
                                throw new _util.FormatError("Invalid XRef table: unexpected first object");
                            }

                            return obj;
                        },
                        processXRefStream : function XRef_processXRefStream(stream) {
                            if (!("streamState" in this)) {
                                var streamParameters = stream.dict;
                                var byteWidths = streamParameters.get("W");
                                var range = streamParameters.get("Index");

                                if (!range) {
                                    range = [0, streamParameters.get("Size")];
                                }

                                this.streamState = {
                                    entryRanges : range,
                                    byteWidths  : byteWidths,
                                    entryNum    : 0,
                                    streamPos   : stream.pos
                                };
                            }

                            this.readXRefStream(stream);
                            delete this.streamState;
                            return stream.dict;
                        },
                        readXRefStream    : function XRef_readXRefStream(stream) {
                            var i, j;
                            var streamState = this.streamState;
                            stream.pos = streamState.streamPos;
                            var byteWidths = streamState.byteWidths;
                            var typeFieldWidth = byteWidths[0];
                            var offsetFieldWidth = byteWidths[1];
                            var generationFieldWidth = byteWidths[2];
                            var entryRanges = streamState.entryRanges;

                            while (entryRanges.length > 0) {
                                var first = entryRanges[0];
                                var n = entryRanges[1];

                                if (!Number.isInteger(first) || !Number.isInteger(n)) {
                                    throw new _util.FormatError("Invalid XRef range fields: ".concat(first, ", ").concat(n));
                                }

                                if (!Number.isInteger(typeFieldWidth) || !Number.isInteger(offsetFieldWidth) || !Number.isInteger(generationFieldWidth)) {
                                    throw new _util.FormatError("Invalid XRef entry fields length: ".concat(first, ", ").concat(n));
                                }

                                for (i = streamState.entryNum; i < n; ++i) {
                                    streamState.entryNum = i;
                                    streamState.streamPos = stream.pos;
                                    var type       = 0,
                                        offset     = 0,
                                        generation = 0;

                                    for (j = 0; j < typeFieldWidth; ++j) {
                                        type = type << 8 | stream.getByte();
                                    }

                                    if (typeFieldWidth === 0) {
                                        type = 1;
                                    }

                                    for (j = 0; j < offsetFieldWidth; ++j) {
                                        offset = offset << 8 | stream.getByte();
                                    }

                                    for (j = 0; j < generationFieldWidth; ++j) {
                                        generation = generation << 8 | stream.getByte();
                                    }

                                    var entry = {};
                                    entry.offset = offset;
                                    entry.gen = generation;

                                    switch (type) {
                                        case 0:
                                            entry.free = true;
                                            break;

                                        case 1:
                                            entry.uncompressed = true;
                                            break;

                                        case 2:
                                            break;

                                        default:
                                            throw new _util.FormatError("Invalid XRef entry type: ".concat(type));
                                    }

                                    if (!this.entries[first + i]) {
                                        this.entries[first + i] = entry;
                                    }
                                }

                                streamState.entryNum = 0;
                                streamState.streamPos = stream.pos;
                                entryRanges.splice(0, 2);
                            }
                        },
                        indexObjects      : function XRef_indexObjects() {
                            var TAB   = 0x9,
                                LF    = 0xa,
                                CR    = 0xd,
                                SPACE = 0x20;
                            var PERCENT = 0x25,
                                LT      = 0x3c;

                            function readToken(data, offset) {
                                var token = "",
                                    ch    = data[offset];

                                while (ch !== LF && ch !== CR && ch !== LT) {
                                    if (++offset >= data.length) {
                                        break;
                                    }

                                    token += String.fromCharCode(ch);
                                    ch = data[offset];
                                }

                                return token;
                            }

                            function skipUntil(data, offset, what) {
                                var length     = what.length,
                                    dataLength = data.length;
                                var skipped = 0;

                                while (offset < dataLength) {
                                    var i = 0;

                                    while (i < length && data[offset + i] === what[i]) {
                                        ++i;
                                    }

                                    if (i >= length) {
                                        break;
                                    }

                                    offset++;
                                    skipped++;
                                }

                                return skipped;
                            }

                            var objRegExp = /^(\d+)\s+(\d+)\s+obj\b/;
                            var endobjRegExp = /\bendobj[\b\s]$/;
                            var nestedObjRegExp = /\s+(\d+\s+\d+\s+obj[\b\s<])$/;
                            var CHECK_CONTENT_LENGTH = 25;
                            var trailerBytes = new Uint8Array([116, 114, 97, 105, 108, 101, 114]);
                            var startxrefBytes = new Uint8Array([115, 116, 97, 114, 116, 120, 114, 101, 102]);
                            var objBytes = new Uint8Array([111, 98, 106]);
                            var xrefBytes = new Uint8Array([47, 88, 82, 101, 102]);
                            this.entries.length = 0;
                            var stream = this.stream;
                            stream.pos = 0;
                            var buffer = stream.getBytes();
                            var position = stream.start,
                                length   = buffer.length;
                            var trailers = [],
                                xrefStms = [];

                            while (position < length) {
                                var ch = buffer[position];

                                if (ch === TAB || ch === LF || ch === CR || ch === SPACE) {
                                    ++position;
                                    continue;
                                }

                                if (ch === PERCENT) {
                                    do {
                                        ++position;

                                        if (position >= length) {
                                            break;
                                        }

                                        ch = buffer[position];
                                    } while (ch !== LF && ch !== CR);

                                    continue;
                                }

                                var token = readToken(buffer, position);
                                var m;

                                if (token.startsWith("xref") && (token.length === 4 || /\s/.test(token[4]))) {
                                    position += skipUntil(buffer, position, trailerBytes);
                                    trailers.push(position);
                                    position += skipUntil(buffer, position, startxrefBytes);
                                } else if (m = objRegExp.exec(token)) {
                                    var num = m[1] | 0,
                                        gen = m[2] | 0;

                                    if (!this.entries[num] || this.entries[num].gen === gen) {
                                        this.entries[num] = {
                                            offset       : position - stream.start,
                                            gen          : gen,
                                            uncompressed : true
                                        };
                                    }

                                    var contentLength = void 0,
                                        startPos      = position + token.length;

                                    while (startPos < buffer.length) {
                                        var endPos = startPos + skipUntil(buffer, startPos, objBytes) + 4;
                                        contentLength = endPos - position;
                                        var checkPos = Math.max(endPos - CHECK_CONTENT_LENGTH, startPos);
                                        var tokenStr = (0, _util.bytesToString)(buffer.subarray(checkPos, endPos));

                                        if (endobjRegExp.test(tokenStr)) {
                                            break;
                                        } else {
                                            var objToken = nestedObjRegExp.exec(tokenStr);

                                            if (objToken && objToken[1]) {
                                                (0, _util.warn)('indexObjects: Found new "obj" inside of another "obj", ' + 'caused by missing "endobj" -- trying to recover.');
                                                contentLength -= objToken[1].length;
                                                break;
                                            }
                                        }

                                        startPos = endPos;
                                    }

                                    var content = buffer.subarray(position, position + contentLength);
                                    var xrefTagOffset = skipUntil(content, 0, xrefBytes);

                                    if (xrefTagOffset < contentLength && content[xrefTagOffset + 5] < 64) {
                                        xrefStms.push(position - stream.start);
                                        this.xrefstms[position - stream.start] = 1;
                                    }

                                    position += contentLength;
                                } else if (token.startsWith("trailer") && (token.length === 7 || /\s/.test(token[7]))) {
                                    trailers.push(position);
                                    position += skipUntil(buffer, position, startxrefBytes);
                                } else {
                                    position += token.length + 1;
                                }
                            }

                            for (var i = 0, ii = xrefStms.length; i < ii; ++i) {
                                this.startXRefQueue.push(xrefStms[i]);
                                this.readXRef(true);
                            }

                            var trailerDict;

                            for (var _i2 = 0, _ii = trailers.length; _i2 < _ii; ++_i2) {
                                stream.pos = trailers[_i2];
                                var parser = new _parser.Parser({
                                    lexer        : new _parser.Lexer(stream),
                                    xref         : this,
                                    allowStreams : true,
                                    recoveryMode : true
                                });
                                var obj = parser.getObj();

                                if (!(0, _primitives.isCmd)(obj, "trailer")) {
                                    continue;
                                }

                                var dict = parser.getObj();

                                if (!(0, _primitives.isDict)(dict)) {
                                    continue;
                                }

                                try {
                                    var rootDict = dict.get("Root");

                                    if (!(rootDict instanceof _primitives.Dict)) {
                                        continue;
                                    }

                                    var pagesDict = rootDict.get("Pages");

                                    if (!(pagesDict instanceof _primitives.Dict)) {
                                        continue;
                                    }

                                    var pagesCount = pagesDict.get("Count");

                                    if (!Number.isInteger(pagesCount)) {
                                        continue;
                                    }
                                } catch (ex) {
                                    continue;
                                }

                                if (dict.has("ID")) {
                                    return dict;
                                }

                                trailerDict = dict;
                            }

                            if (trailerDict) {
                                return trailerDict;
                            }

                            throw new _util.InvalidPDFException("Invalid PDF structure.");
                        },
                        readXRef          : function XRef_readXRef(recoveryMode) {
                            var stream = this.stream;
                            var startXRefParsedCache = Object.create(null);

                            try {
                                while (this.startXRefQueue.length) {
                                    var startXRef = this.startXRefQueue[0];

                                    if (startXRefParsedCache[startXRef]) {
                                        (0, _util.warn)("readXRef - skipping XRef table since it was already parsed.");
                                        this.startXRefQueue.shift();
                                        continue;
                                    }

                                    startXRefParsedCache[startXRef] = true;
                                    stream.pos = startXRef + stream.start;
                                    var parser = new _parser.Parser({
                                        lexer        : new _parser.Lexer(stream),
                                        xref         : this,
                                        allowStreams : true
                                    });
                                    var obj = parser.getObj();
                                    var dict;

                                    if ((0, _primitives.isCmd)(obj, "xref")) {
                                        dict = this.processXRefTable(parser);

                                        if (!this.topDict) {
                                            this.topDict = dict;
                                        }

                                        obj = dict.get("XRefStm");

                                        if (Number.isInteger(obj)) {
                                            var pos = obj;

                                            if (!(pos in this.xrefstms)) {
                                                this.xrefstms[pos] = 1;
                                                this.startXRefQueue.push(pos);
                                            }
                                        }
                                    } else if (Number.isInteger(obj)) {
                                        if (!Number.isInteger(parser.getObj()) || !(0, _primitives.isCmd)(parser.getObj(), "obj") || !(0, _primitives.isStream)(obj = parser.getObj())) {
                                            throw new _util.FormatError("Invalid XRef stream");
                                        }

                                        dict = this.processXRefStream(obj);

                                        if (!this.topDict) {
                                            this.topDict = dict;
                                        }

                                        if (!dict) {
                                            throw new _util.FormatError("Failed to read XRef stream");
                                        }
                                    } else {
                                        throw new _util.FormatError("Invalid XRef stream header");
                                    }

                                    obj = dict.get("Prev");

                                    if (Number.isInteger(obj)) {
                                        this.startXRefQueue.push(obj);
                                    } else if ((0, _primitives.isRef)(obj)) {
                                        this.startXRefQueue.push(obj.num);
                                    }

                                    this.startXRefQueue.shift();
                                }

                                return this.topDict;
                            } catch (e) {
                                if (e instanceof _core_utils.MissingDataException) {
                                    throw e;
                                }

                                (0, _util.info)("(while reading XRef): " + e);
                            }

                            if (recoveryMode) {
                                return undefined;
                            }

                            throw new _core_utils.XRefParseException();
                        },
                        getEntry          : function XRef_getEntry(i) {
                            var xrefEntry = this.entries[i];

                            if (xrefEntry && !xrefEntry.free && xrefEntry.offset) {
                                return xrefEntry;
                            }

                            return null;
                        },
                        fetchIfRef        : function XRef_fetchIfRef(obj, suppressEncryption) {
                            if (obj instanceof _primitives.Ref) {
                                return this.fetch(obj, suppressEncryption);
                            }

                            return obj;
                        },
                        fetch             : function XRef_fetch(ref, suppressEncryption) {
                            if (!(ref instanceof _primitives.Ref)) {
                                throw new Error("ref object is not a reference");
                            }

                            var num = ref.num;

                            var cacheEntry = this._cacheMap.get(num);

                            if (cacheEntry !== undefined) {
                                if (cacheEntry instanceof _primitives.Dict && !cacheEntry.objId) {
                                    cacheEntry.objId = ref.toString();
                                }

                                return cacheEntry;
                            }

                            var xrefEntry = this.getEntry(num);

                            if (xrefEntry === null) {
                                this._cacheMap.set(num, xrefEntry);

                                return xrefEntry;
                            }

                            if (xrefEntry.uncompressed) {
                                xrefEntry = this.fetchUncompressed(ref, xrefEntry, suppressEncryption);
                            } else {
                                xrefEntry = this.fetchCompressed(ref, xrefEntry, suppressEncryption);
                            }

                            if ((0, _primitives.isDict)(xrefEntry)) {
                                xrefEntry.objId = ref.toString();
                            } else if ((0, _primitives.isStream)(xrefEntry)) {
                                xrefEntry.dict.objId = ref.toString();
                            }

                            return xrefEntry;
                        },
                        fetchUncompressed : function fetchUncompressed(ref, xrefEntry) {
                            var suppressEncryption = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                            var gen = ref.gen;
                            var num = ref.num;

                            if (xrefEntry.gen !== gen) {
                                throw new _core_utils.XRefEntryException("Inconsistent generation in XRef: ".concat(ref));
                            }

                            var stream = this.stream.makeSubStream(xrefEntry.offset + this.stream.start);
                            var parser = new _parser.Parser({
                                lexer        : new _parser.Lexer(stream),
                                xref         : this,
                                allowStreams : true
                            });
                            var obj1 = parser.getObj();
                            var obj2 = parser.getObj();
                            var obj3 = parser.getObj();

                            if (obj1 !== num || obj2 !== gen || !(obj3 instanceof _primitives.Cmd)) {
                                throw new _core_utils.XRefEntryException("Bad (uncompressed) XRef entry: ".concat(ref));
                            }

                            if (obj3.cmd !== "obj") {
                                if (obj3.cmd.startsWith("obj")) {
                                    num = parseInt(obj3.cmd.substring(3), 10);

                                    if (!Number.isNaN(num)) {
                                        return num;
                                    }
                                }

                                throw new _core_utils.XRefEntryException("Bad (uncompressed) XRef entry: ".concat(ref));
                            }

                            if (this.encrypt && !suppressEncryption) {
                                xrefEntry = parser.getObj(this.encrypt.createCipherTransform(num, gen));
                            } else {
                                xrefEntry = parser.getObj();
                            }

                            if (!(0, _primitives.isStream)(xrefEntry)) {
                                this._cacheMap.set(num, xrefEntry);
                            }

                            return xrefEntry;
                        },
                        fetchCompressed   : function fetchCompressed(ref, xrefEntry) {
                            var suppressEncryption = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                            var tableOffset = xrefEntry.offset;
                            var stream = this.fetch(_primitives.Ref.get(tableOffset, 0));

                            if (!(0, _primitives.isStream)(stream)) {
                                throw new _util.FormatError("bad ObjStm stream");
                            }

                            var first = stream.dict.get("First");
                            var n = stream.dict.get("N");

                            if (!Number.isInteger(first) || !Number.isInteger(n)) {
                                throw new _util.FormatError("invalid first and n parameters for ObjStm stream");
                            }

                            var parser = new _parser.Parser({
                                lexer        : new _parser.Lexer(stream),
                                xref         : this,
                                allowStreams : true
                            });
                            var nums = new Array(n);
                            var offsets = new Array(n);

                            for (var i = 0; i < n; ++i) {
                                var num = parser.getObj();

                                if (!Number.isInteger(num)) {
                                    throw new _util.FormatError("invalid object number in the ObjStm stream: ".concat(num));
                                }

                                var offset = parser.getObj();

                                if (!Number.isInteger(offset)) {
                                    throw new _util.FormatError("invalid object offset in the ObjStm stream: ".concat(offset));
                                }

                                nums[i] = num;
                                offsets[i] = offset;
                            }

                            var start = (stream.start || 0) + first;
                            var entries = new Array(n);

                            for (var _i3 = 0; _i3 < n; ++_i3) {
                                var length = _i3 < n - 1 ? offsets[_i3 + 1] - offsets[_i3] : undefined;

                                if (length < 0) {
                                    throw new _util.FormatError("Invalid offset in the ObjStm stream.");
                                }

                                parser = new _parser.Parser({
                                    lexer        : new _parser.Lexer(stream.makeSubStream(start + offsets[_i3], length, stream.dict)),
                                    xref         : this,
                                    allowStreams : true
                                });
                                var obj = parser.getObj();
                                entries[_i3] = obj;

                                if ((0, _primitives.isStream)(obj)) {
                                    continue;
                                }

                                var _num  = nums[_i3],
                                    entry = this.entries[_num];

                                if (entry && entry.offset === tableOffset && entry.gen === _i3) {
                                    this._cacheMap.set(_num, obj);
                                }
                            }

                            xrefEntry = entries[xrefEntry.gen];

                            if (xrefEntry === undefined) {
                                throw new _core_utils.XRefEntryException("Bad (compressed) XRef entry: ".concat(ref));
                            }

                            return xrefEntry;
                        },
                        fetchIfRefAsync   : function fetchIfRefAsync(obj, suppressEncryption) {
                            var _this3 = this;

                            return _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee() {
                                return _regenerator["default"].wrap(function _callee$(_context) {
                                    while (1) {
                                        switch (_context.prev = _context.next) {
                                            case 0:
                                                if (!(obj instanceof _primitives.Ref)) {
                                                    _context.next = 2;
                                                    break;
                                                }

                                                return _context.abrupt("return", _this3.fetchAsync(obj, suppressEncryption));

                                            case 2:
                                                return _context.abrupt("return", obj);

                                            case 3:
                                            case "end":
                                                return _context.stop();
                                        }
                                    }
                                }, _callee);
                            }))();
                        },
                        fetchAsync        : function fetchAsync(ref, suppressEncryption) {
                            var _this4 = this;

                            return _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee2() {
                                return _regenerator["default"].wrap(function _callee2$(_context2) {
                                    while (1) {
                                        switch (_context2.prev = _context2.next) {
                                            case 0:
                                                _context2.prev = 0;
                                                return _context2.abrupt("return", _this4.fetch(ref, suppressEncryption));

                                            case 4:
                                                _context2.prev = 4;
                                                _context2.t0 = _context2["catch"](0);

                                                if (_context2.t0 instanceof _core_utils.MissingDataException) {
                                                    _context2.next = 8;
                                                    break;
                                                }

                                                throw _context2.t0;

                                            case 8:
                                                _context2.next = 10;
                                                return _this4.pdfManager.requestRange(_context2.t0.begin, _context2.t0.end);

                                            case 10:
                                                return _context2.abrupt("return", _this4.fetchAsync(ref, suppressEncryption));

                                            case 11:
                                            case "end":
                                                return _context2.stop();
                                        }
                                    }
                                }, _callee2, null, [[0, 4]]);
                            }))();
                        },
                        getCatalogObj     : function XRef_getCatalogObj() {
                            return this.root;
                        }
                    };
                    return XRef;
                }();

                exports.XRef = XRef;

                var NameOrNumberTree = /*#__PURE__*/function() {
                    function NameOrNumberTree(root, xref, type) {
                        _classCallCheck(this, NameOrNumberTree);

                        if (this.constructor === NameOrNumberTree) {
                            (0, _util.unreachable)("Cannot initialize NameOrNumberTree.");
                        }

                        this.root = root;
                        this.xref = xref;
                        this._type = type;
                    }

                    _createClass(NameOrNumberTree, [{
                        key   : "getAll",
                        value : function getAll() {
                            var dict = Object.create(null);

                            if (!this.root) {
                                return dict;
                            }

                            var xref = this.xref;
                            var processed = new _primitives.RefSet();
                            processed.put(this.root);
                            var queue = [this.root];

                            while (queue.length > 0) {
                                var obj = xref.fetchIfRef(queue.shift());

                                if (!(0, _primitives.isDict)(obj)) {
                                    continue;
                                }

                                if (obj.has("Kids")) {
                                    var kids = obj.get("Kids");

                                    for (var i = 0, ii = kids.length; i < ii; i++) {
                                        var kid = kids[i];

                                        if (processed.has(kid)) {
                                            throw new _util.FormatError("Duplicate entry in \"".concat(this._type, "\" tree."));
                                        }

                                        queue.push(kid);
                                        processed.put(kid);
                                    }

                                    continue;
                                }

                                var entries = obj.get(this._type);

                                if (Array.isArray(entries)) {
                                    for (var _i4 = 0, _ii2 = entries.length; _i4 < _ii2; _i4 += 2) {
                                        dict[xref.fetchIfRef(entries[_i4])] = xref.fetchIfRef(entries[_i4 + 1]);
                                    }
                                }
                            }

                            return dict;
                        }
                    }, {
                        key   : "get",
                        value : function get(key) {
                            if (!this.root) {
                                return null;
                            }

                            var xref = this.xref;
                            var kidsOrEntries = xref.fetchIfRef(this.root);
                            var loopCount = 0;
                            var MAX_LEVELS = 10;

                            while (kidsOrEntries.has("Kids")) {
                                if (++loopCount > MAX_LEVELS) {
                                    (0, _util.warn)("Search depth limit reached for \"".concat(this._type, "\" tree."));
                                    return null;
                                }

                                var kids = kidsOrEntries.get("Kids");

                                if (!Array.isArray(kids)) {
                                    return null;
                                }

                                var l = 0,
                                    r = kids.length - 1;

                                while (l <= r) {
                                    var m = l + r >> 1;
                                    var kid = xref.fetchIfRef(kids[m]);
                                    var limits = kid.get("Limits");

                                    if (key < xref.fetchIfRef(limits[0])) {
                                        r = m - 1;
                                    } else if (key > xref.fetchIfRef(limits[1])) {
                                        l = m + 1;
                                    } else {
                                        kidsOrEntries = xref.fetchIfRef(kids[m]);
                                        break;
                                    }
                                }

                                if (l > r) {
                                    return null;
                                }
                            }

                            var entries = kidsOrEntries.get(this._type);

                            if (Array.isArray(entries)) {
                                var _l = 0,
                                    _r = entries.length - 2;

                                while (_l <= _r) {
                                    var tmp = _l + _r >> 1,
                                        _m  = tmp + (tmp & 1);

                                    var currentKey = xref.fetchIfRef(entries[_m]);

                                    if (key < currentKey) {
                                        _r = _m - 2;
                                    } else if (key > currentKey) {
                                        _l = _m + 2;
                                    } else {
                                        return xref.fetchIfRef(entries[_m + 1]);
                                    }
                                }

                                (0, _util.info)("Falling back to an exhaustive search, for key \"".concat(key, "\", ") + "in \"".concat(this._type, "\" tree."));

                                for (var _m2 = 0, mm = entries.length; _m2 < mm; _m2 += 2) {
                                    var _currentKey = xref.fetchIfRef(entries[_m2]);

                                    if (_currentKey === key) {
                                        (0, _util.warn)("The \"".concat(key, "\" key was found at an incorrect, ") + "i.e. out-of-order, position in \"".concat(this._type, "\" tree."));
                                        return xref.fetchIfRef(entries[_m2 + 1]);
                                    }
                                }
                            }

                            return null;
                        }
                    }]);

                    return NameOrNumberTree;
                }();

                var NameTree = /*#__PURE__*/function(_NameOrNumberTree) {
                    _inherits(NameTree, _NameOrNumberTree);

                    var _super = _createSuper(NameTree);

                    function NameTree(root, xref) {
                        _classCallCheck(this, NameTree);

                        return _super.call(this, root, xref, "Names");
                    }

                    return NameTree;
                }(NameOrNumberTree);

                var NumberTree = /*#__PURE__*/function(_NameOrNumberTree2) {
                    _inherits(NumberTree, _NameOrNumberTree2);

                    var _super2 = _createSuper(NumberTree);

                    function NumberTree(root, xref) {
                        _classCallCheck(this, NumberTree);

                        return _super2.call(this, root, xref, "Nums");
                    }

                    return NumberTree;
                }(NameOrNumberTree);

                var FileSpec = function FileSpecClosure() {
                    function FileSpec(root, xref) {
                        if (!root || !(0, _primitives.isDict)(root)) {
                            return;
                        }

                        this.xref = xref;
                        this.root = root;

                        if (root.has("FS")) {
                            this.fs = root.get("FS");
                        }

                        this.description = root.has("Desc") ? (0, _util.stringToPDFString)(root.get("Desc")) : "";

                        if (root.has("RF")) {
                            (0, _util.warn)("Related file specifications are not supported");
                        }

                        this.contentAvailable = true;

                        if (!root.has("EF")) {
                            this.contentAvailable = false;
                            (0, _util.warn)("Non-embedded file specifications are not supported");
                        }
                    }

                    function pickPlatformItem(dict) {
                        if (dict.has("UF")) {
                            return dict.get("UF");
                        } else if (dict.has("F")) {
                            return dict.get("F");
                        } else if (dict.has("Unix")) {
                            return dict.get("Unix");
                        } else if (dict.has("Mac")) {
                            return dict.get("Mac");
                        } else if (dict.has("DOS")) {
                            return dict.get("DOS");
                        }

                        return null;
                    }

                    FileSpec.prototype = {
                        get filename() {
                            if (!this._filename && this.root) {
                                var filename = pickPlatformItem(this.root) || "unnamed";
                                this._filename = (0, _util.stringToPDFString)(filename).replace(/\\\\/g, "\\").replace(/\\\//g, "/").replace(/\\/g, "/");
                            }

                            return this._filename;
                        },

                        get content() {
                            if (!this.contentAvailable) {
                                return null;
                            }

                            if (!this.contentRef && this.root) {
                                this.contentRef = pickPlatformItem(this.root.get("EF"));
                            }

                            var content = null;

                            if (this.contentRef) {
                                var xref = this.xref;
                                var fileObj = xref.fetchIfRef(this.contentRef);

                                if (fileObj && (0, _primitives.isStream)(fileObj)) {
                                    content = fileObj.getBytes();
                                } else {
                                    (0, _util.warn)("Embedded file specification points to non-existing/invalid " + "content");
                                }
                            } else {
                                (0, _util.warn)("Embedded file specification does not have a content");
                            }

                            return content;
                        },

                        get serializable() {
                            return {
                                filename : this.filename,
                                content  : this.content
                            };
                        }

                    };
                    return FileSpec;
                }();

                exports.FileSpec = FileSpec;

                var ObjectLoader = function() {
                    function mayHaveChildren(value) {
                        return value instanceof _primitives.Ref || value instanceof _primitives.Dict || Array.isArray(value) || (0, _primitives.isStream)(value);
                    }

                    function addChildren(node, nodesToVisit) {
                        if (node instanceof _primitives.Dict) {
                            node = node.getRawValues();
                        } else if ((0, _primitives.isStream)(node)) {
                            node = node.dict.getRawValues();
                        } else if (!Array.isArray(node)) {
                            return;
                        }

                        var _iterator7 = _createForOfIteratorHelper(node),
                            _step7;

                        try {
                            for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
                                var rawValue = _step7.value;

                                if (mayHaveChildren(rawValue)) {
                                    nodesToVisit.push(rawValue);
                                }
                            }
                        } catch (err) {
                            _iterator7.e(err);
                        } finally {
                            _iterator7.f();
                        }
                    }

                    function ObjectLoader(dict, keys, xref) {
                        this.dict = dict;
                        this.keys = keys;
                        this.xref = xref;
                        this.refSet = null;
                    }

                    ObjectLoader.prototype = {
                        load  : function load() {
                            var _this5 = this;

                            return _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee3() {
                                var keys, dict, nodesToVisit, i, ii, rawValue;
                                return _regenerator["default"].wrap(function _callee3$(_context3) {
                                    while (1) {
                                        switch (_context3.prev = _context3.next) {
                                            case 0:
                                                if (!(!_this5.xref.stream.allChunksLoaded || _this5.xref.stream.allChunksLoaded())) {
                                                    _context3.next = 2;
                                                    break;
                                                }

                                                return _context3.abrupt("return", undefined);

                                            case 2:
                                                keys = _this5.keys, dict = _this5.dict;
                                                _this5.refSet = new _primitives.RefSet();
                                                nodesToVisit = [];

                                                for (i = 0, ii = keys.length; i < ii; i++) {
                                                    rawValue = dict.getRaw(keys[i]);

                                                    if (rawValue !== undefined) {
                                                        nodesToVisit.push(rawValue);
                                                    }
                                                }

                                                return _context3.abrupt("return", _this5._walk(nodesToVisit));

                                            case 7:
                                            case "end":
                                                return _context3.stop();
                                        }
                                    }
                                }, _callee3);
                            }))();
                        },
                        _walk : function _walk(nodesToVisit) {
                            var _this6 = this;

                            return _asyncToGenerator(/*#__PURE__*/_regenerator["default"].mark(function _callee4() {
                                var nodesToRevisit, pendingRequests, currentNode, manager, baseStreams,
                                    foundMissingData, i, ii, stream, _i5, _ii3, node;

                                return _regenerator["default"].wrap(function _callee4$(_context4) {
                                    while (1) {
                                        switch (_context4.prev = _context4.next) {
                                            case 0:
                                                nodesToRevisit = [];
                                                pendingRequests = [];

                                            case 2:
                                                if (!nodesToVisit.length) {
                                                    _context4.next = 25;
                                                    break;
                                                }

                                                currentNode = nodesToVisit.pop();

                                                if (!(currentNode instanceof _primitives.Ref)) {
                                                    _context4.next = 21;
                                                    break;
                                                }

                                                if (!_this6.refSet.has(currentNode)) {
                                                    _context4.next = 7;
                                                    break;
                                                }

                                                return _context4.abrupt("continue", 2);

                                            case 7:
                                                _context4.prev = 7;

                                                _this6.refSet.put(currentNode);

                                                currentNode = _this6.xref.fetch(currentNode);
                                                _context4.next = 21;
                                                break;

                                            case 12:
                                                _context4.prev = 12;
                                                _context4.t0 = _context4["catch"](7);

                                                if (_context4.t0 instanceof _core_utils.MissingDataException) {
                                                    _context4.next = 19;
                                                    break;
                                                }

                                                (0, _util.warn)("ObjectLoader._walk - requesting all data: \"".concat(_context4.t0, "\"."));
                                                _this6.refSet = null;
                                                manager = _this6.xref.stream.manager;
                                                return _context4.abrupt("return", manager.requestAllChunks());

                                            case 19:
                                                nodesToRevisit.push(currentNode);
                                                pendingRequests.push({
                                                    begin : _context4.t0.begin,
                                                    end   : _context4.t0.end
                                                });

                                            case 21:
                                                if (currentNode && currentNode.getBaseStreams) {
                                                    baseStreams = currentNode.getBaseStreams();
                                                    foundMissingData = false;

                                                    for (i = 0, ii = baseStreams.length; i < ii; i++) {
                                                        stream = baseStreams[i];

                                                        if (stream.allChunksLoaded && !stream.allChunksLoaded()) {
                                                            foundMissingData = true;
                                                            pendingRequests.push({
                                                                begin : stream.start,
                                                                end   : stream.end
                                                            });
                                                        }
                                                    }

                                                    if (foundMissingData) {
                                                        nodesToRevisit.push(currentNode);
                                                    }
                                                }

                                                addChildren(currentNode, nodesToVisit);
                                                _context4.next = 2;
                                                break;

                                            case 25:
                                                if (!pendingRequests.length) {
                                                    _context4.next = 30;
                                                    break;
                                                }

                                                _context4.next = 28;
                                                return _this6.xref.stream.manager.requestRanges(pendingRequests);

                                            case 28:
                                                for (_i5 = 0, _ii3 = nodesToRevisit.length; _i5 < _ii3; _i5++) {
                                                    node = nodesToRevisit[_i5];

                                                    if (node instanceof _primitives.Ref) {
                                                        _this6.refSet.remove(node);
                                                    }
                                                }

                                                return _context4.abrupt("return", _this6._walk(nodesToRevisit));

                                            case 30:
                                                _this6.refSet = null;
                                                return _context4.abrupt("return", undefined);

                                            case 32:
                                            case "end":
                                                return _context4.stop();
                                        }
                                    }
                                }, _callee4, null, [[7, 12]]);
                            }))();
                        }
                    };
                    return ObjectLoader;
                }();

                exports.ObjectLoader = ObjectLoader;

                /***/
            }),
            /* 131 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.Parser = exports.Linearization = exports.Lexer = void 0;

                var _stream = __w_pdfjs_require__(132);

                var _util = __w_pdfjs_require__(4);

                var _primitives = __w_pdfjs_require__(125);

                var _core_utils = __w_pdfjs_require__(128);

                var _ccitt_stream = __w_pdfjs_require__(133);

                var _jbig2_stream = __w_pdfjs_require__(135);

                var _jpeg_stream = __w_pdfjs_require__(138);

                var _jpx_stream = __w_pdfjs_require__(140);

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                function _createClass(Constructor, protoProps, staticProps) {
                    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) _defineProperties(Constructor, staticProps);
                    return Constructor;
                }

                var MAX_LENGTH_TO_CACHE = 1000;
                var MAX_ADLER32_LENGTH = 5552;

                function computeAdler32(bytes) {
                    var bytesLength = bytes.length;
                    var a = 1,
                        b = 0;

                    for (var i = 0; i < bytesLength; ++i) {
                        a += bytes[i] & 0xff;
                        b += a;
                    }

                    return b % 65521 << 16 | a % 65521;
                }

                var Parser = /*#__PURE__*/function() {
                    function Parser(_ref) {
                        var lexer             = _ref.lexer,
                            xref              = _ref.xref,
                            _ref$allowStreams = _ref.allowStreams,
                            allowStreams      = _ref$allowStreams === void 0 ? false : _ref$allowStreams,
                            _ref$recoveryMode = _ref.recoveryMode,
                            recoveryMode      = _ref$recoveryMode === void 0 ? false : _ref$recoveryMode;

                        _classCallCheck(this, Parser);

                        this.lexer = lexer;
                        this.xref = xref;
                        this.allowStreams = allowStreams;
                        this.recoveryMode = recoveryMode;
                        this.imageCache = Object.create(null);
                        this.refill();
                    }

                    _createClass(Parser, [{
                        key   : "refill",
                        value : function refill() {
                            this.buf1 = this.lexer.getObj();
                            this.buf2 = this.lexer.getObj();
                        }
                    }, {
                        key   : "shift",
                        value : function shift() {
                            if (this.buf2 instanceof _primitives.Cmd && this.buf2.cmd === "ID") {
                                this.buf1 = this.buf2;
                                this.buf2 = null;
                            } else {
                                this.buf1 = this.buf2;
                                this.buf2 = this.lexer.getObj();
                            }
                        }
                    }, {
                        key   : "tryShift",
                        value : function tryShift() {
                            try {
                                this.shift();
                                return true;
                            } catch (e) {
                                if (e instanceof _core_utils.MissingDataException) {
                                    throw e;
                                }

                                return false;
                            }
                        }
                    }, {
                        key   : "getObj",
                        value : function getObj() {
                            var cipherTransform = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                            var buf1 = this.buf1;
                            this.shift();

                            if (buf1 instanceof _primitives.Cmd) {
                                switch (buf1.cmd) {
                                    case "BI":
                                        return this.makeInlineImage(cipherTransform);

                                    case "[":
                                        var array = [];

                                        while (!(0, _primitives.isCmd)(this.buf1, "]") && !(0, _primitives.isEOF)(this.buf1)) {
                                            array.push(this.getObj(cipherTransform));
                                        }

                                        if ((0, _primitives.isEOF)(this.buf1)) {
                                            if (!this.recoveryMode) {
                                                throw new _util.FormatError("End of file inside array");
                                            }

                                            return array;
                                        }

                                        this.shift();
                                        return array;

                                    case "<<":
                                        var dict = new _primitives.Dict(this.xref);

                                        while (!(0, _primitives.isCmd)(this.buf1, ">>") && !(0, _primitives.isEOF)(this.buf1)) {
                                            if (!(0, _primitives.isName)(this.buf1)) {
                                                (0, _util.info)("Malformed dictionary: key must be a name object");
                                                this.shift();
                                                continue;
                                            }

                                            var key = this.buf1.name;
                                            this.shift();

                                            if ((0, _primitives.isEOF)(this.buf1)) {
                                                break;
                                            }

                                            dict.set(key, this.getObj(cipherTransform));
                                        }

                                        if ((0, _primitives.isEOF)(this.buf1)) {
                                            if (!this.recoveryMode) {
                                                throw new _util.FormatError("End of file inside dictionary");
                                            }

                                            return dict;
                                        }

                                        if ((0, _primitives.isCmd)(this.buf2, "stream")) {
                                            return this.allowStreams ? this.makeStream(dict, cipherTransform) : dict;
                                        }

                                        this.shift();
                                        return dict;

                                    default:
                                        return buf1;
                                }
                            }

                            if (Number.isInteger(buf1)) {
                                if (Number.isInteger(this.buf1) && (0, _primitives.isCmd)(this.buf2, "R")) {
                                    var ref = _primitives.Ref.get(buf1, this.buf1);

                                    this.shift();
                                    this.shift();
                                    return ref;
                                }

                                return buf1;
                            }

                            if (typeof buf1 === "string") {
                                if (cipherTransform) {
                                    return cipherTransform.decryptString(buf1);
                                }

                                return buf1;
                            }

                            return buf1;
                        }
                    }, {
                        key   : "findDefaultInlineStreamEnd",
                        value : function findDefaultInlineStreamEnd(stream) {
                            var E     = 0x45,
                                I     = 0x49,
                                SPACE = 0x20,
                                LF    = 0xa,
                                CR    = 0xd,
                                NUL   = 0x0;
                            var lexer    = this.lexer,
                                startPos = stream.pos,
                                n        = 10;
                            var state = 0,
                                ch,
                                maybeEIPos;

                            while ((ch = stream.getByte()) !== -1) {
                                if (state === 0) {
                                    state = ch === E ? 1 : 0;
                                } else if (state === 1) {
                                    state = ch === I ? 2 : 0;
                                } else {
                                    (0, _util.assert)(state === 2, "findDefaultInlineStreamEnd - invalid state.");

                                    if (ch === SPACE || ch === LF || ch === CR) {
                                        maybeEIPos = stream.pos;
                                        var followingBytes = stream.peekBytes(n);

                                        for (var i = 0, ii = followingBytes.length; i < ii; i++) {
                                            ch = followingBytes[i];

                                            if (ch === NUL && followingBytes[i + 1] !== NUL) {
                                                continue;
                                            }

                                            if (ch !== LF && ch !== CR && (ch < SPACE || ch > 0x7f)) {
                                                state = 0;
                                                break;
                                            }
                                        }

                                        if (state !== 2) {
                                            continue;
                                        }

                                        if (lexer.knownCommands) {
                                            var nextObj = lexer.peekObj();

                                            if (nextObj instanceof _primitives.Cmd && !lexer.knownCommands[nextObj.cmd]) {
                                                state = 0;
                                            }
                                        } else {
                                            (0, _util.warn)("findDefaultInlineStreamEnd - `lexer.knownCommands` is undefined.");
                                        }

                                        if (state === 2) {
                                            break;
                                        }
                                    } else {
                                        state = 0;
                                    }
                                }
                            }

                            if (ch === -1) {
                                (0, _util.warn)("findDefaultInlineStreamEnd: " + "Reached the end of the stream without finding a valid EI marker");

                                if (maybeEIPos) {
                                    (0, _util.warn)('... trying to recover by using the last "EI" occurrence.');
                                    stream.skip(-(stream.pos - maybeEIPos));
                                }
                            }

                            var endOffset = 4;
                            stream.skip(-endOffset);
                            ch = stream.peekByte();
                            stream.skip(endOffset);

                            if (!(0, _core_utils.isWhiteSpace)(ch)) {
                                endOffset--;
                            }

                            return stream.pos - endOffset - startPos;
                        }
                    }, {
                        key   : "findDCTDecodeInlineStreamEnd",
                        value : function findDCTDecodeInlineStreamEnd(stream) {
                            var startPos = stream.pos;
                            var foundEOI = false,
                                b,
                                markerLength;

                            while ((b = stream.getByte()) !== -1) {
                                if (b !== 0xff) {
                                    continue;
                                }

                                switch (stream.getByte()) {
                                    case 0x00:
                                        break;

                                    case 0xff:
                                        stream.skip(-1);
                                        break;

                                    case 0xd9:
                                        foundEOI = true;
                                        break;

                                    case 0xc0:
                                    case 0xc1:
                                    case 0xc2:
                                    case 0xc3:
                                    case 0xc5:
                                    case 0xc6:
                                    case 0xc7:
                                    case 0xc9:
                                    case 0xca:
                                    case 0xcb:
                                    case 0xcd:
                                    case 0xce:
                                    case 0xcf:
                                    case 0xc4:
                                    case 0xcc:
                                    case 0xda:
                                    case 0xdb:
                                    case 0xdc:
                                    case 0xdd:
                                    case 0xde:
                                    case 0xdf:
                                    case 0xe0:
                                    case 0xe1:
                                    case 0xe2:
                                    case 0xe3:
                                    case 0xe4:
                                    case 0xe5:
                                    case 0xe6:
                                    case 0xe7:
                                    case 0xe8:
                                    case 0xe9:
                                    case 0xea:
                                    case 0xeb:
                                    case 0xec:
                                    case 0xed:
                                    case 0xee:
                                    case 0xef:
                                    case 0xfe:
                                        markerLength = stream.getUint16();

                                        if (markerLength > 2) {
                                            stream.skip(markerLength - 2);
                                        } else {
                                            stream.skip(-2);
                                        }

                                        break;
                                }

                                if (foundEOI) {
                                    break;
                                }
                            }

                            var length = stream.pos - startPos;

                            if (b === -1) {
                                (0, _util.warn)("Inline DCTDecode image stream: " + "EOI marker not found, searching for /EI/ instead.");
                                stream.skip(-length);
                                return this.findDefaultInlineStreamEnd(stream);
                            }

                            this.inlineStreamSkipEI(stream);
                            return length;
                        }
                    }, {
                        key   : "findASCII85DecodeInlineStreamEnd",
                        value : function findASCII85DecodeInlineStreamEnd(stream) {
                            var TILDE = 0x7e,
                                GT    = 0x3e;
                            var startPos = stream.pos;
                            var ch;

                            while ((ch = stream.getByte()) !== -1) {
                                if (ch === TILDE) {
                                    var tildePos = stream.pos;
                                    ch = stream.peekByte();

                                    while ((0, _core_utils.isWhiteSpace)(ch)) {
                                        stream.skip();
                                        ch = stream.peekByte();
                                    }

                                    if (ch === GT) {
                                        stream.skip();
                                        break;
                                    }

                                    if (stream.pos > tildePos) {
                                        var maybeEI = stream.peekBytes(2);

                                        if (maybeEI[0] === 0x45 && maybeEI[1] === 0x49) {
                                            break;
                                        }
                                    }
                                }
                            }

                            var length = stream.pos - startPos;

                            if (ch === -1) {
                                (0, _util.warn)("Inline ASCII85Decode image stream: " + "EOD marker not found, searching for /EI/ instead.");
                                stream.skip(-length);
                                return this.findDefaultInlineStreamEnd(stream);
                            }

                            this.inlineStreamSkipEI(stream);
                            return length;
                        }
                    }, {
                        key   : "findASCIIHexDecodeInlineStreamEnd",
                        value : function findASCIIHexDecodeInlineStreamEnd(stream) {
                            var GT = 0x3e;
                            var startPos = stream.pos;
                            var ch;

                            while ((ch = stream.getByte()) !== -1) {
                                if (ch === GT) {
                                    break;
                                }
                            }

                            var length = stream.pos - startPos;

                            if (ch === -1) {
                                (0, _util.warn)("Inline ASCIIHexDecode image stream: " + "EOD marker not found, searching for /EI/ instead.");
                                stream.skip(-length);
                                return this.findDefaultInlineStreamEnd(stream);
                            }

                            this.inlineStreamSkipEI(stream);
                            return length;
                        }
                    }, {
                        key   : "inlineStreamSkipEI",
                        value : function inlineStreamSkipEI(stream) {
                            var E = 0x45,
                                I = 0x49;
                            var state = 0,
                                ch;

                            while ((ch = stream.getByte()) !== -1) {
                                if (state === 0) {
                                    state = ch === E ? 1 : 0;
                                } else if (state === 1) {
                                    state = ch === I ? 2 : 0;
                                } else if (state === 2) {
                                    break;
                                }
                            }
                        }
                    }, {
                        key   : "makeInlineImage",
                        value : function makeInlineImage(cipherTransform) {
                            var lexer = this.lexer;
                            var stream = lexer.stream;
                            var dict = new _primitives.Dict(this.xref);
                            var dictLength;

                            while (!(0, _primitives.isCmd)(this.buf1, "ID") && !(0, _primitives.isEOF)(this.buf1)) {
                                if (!(0, _primitives.isName)(this.buf1)) {
                                    throw new _util.FormatError("Dictionary key must be a name object");
                                }

                                var key = this.buf1.name;
                                this.shift();

                                if ((0, _primitives.isEOF)(this.buf1)) {
                                    break;
                                }

                                dict.set(key, this.getObj(cipherTransform));
                            }

                            if (lexer.beginInlineImagePos !== -1) {
                                dictLength = stream.pos - lexer.beginInlineImagePos;
                            }

                            var filter = dict.get("Filter", "F");
                            var filterName;

                            if ((0, _primitives.isName)(filter)) {
                                filterName = filter.name;
                            } else if (Array.isArray(filter)) {
                                var filterZero = this.xref.fetchIfRef(filter[0]);

                                if ((0, _primitives.isName)(filterZero)) {
                                    filterName = filterZero.name;
                                }
                            }

                            var startPos = stream.pos;
                            var length;

                            if (filterName === "DCTDecode" || filterName === "DCT") {
                                length = this.findDCTDecodeInlineStreamEnd(stream);
                            } else if (filterName === "ASCII85Decode" || filterName === "A85") {
                                length = this.findASCII85DecodeInlineStreamEnd(stream);
                            } else if (filterName === "ASCIIHexDecode" || filterName === "AHx") {
                                length = this.findASCIIHexDecodeInlineStreamEnd(stream);
                            } else {
                                length = this.findDefaultInlineStreamEnd(stream);
                            }

                            var imageStream = stream.makeSubStream(startPos, length, dict);
                            var cacheKey;

                            if (length < MAX_LENGTH_TO_CACHE && dictLength < MAX_ADLER32_LENGTH) {
                                var imageBytes = imageStream.getBytes();
                                imageStream.reset();
                                var initialStreamPos = stream.pos;
                                stream.pos = lexer.beginInlineImagePos;
                                var dictBytes = stream.getBytes(dictLength);
                                stream.pos = initialStreamPos;
                                cacheKey = computeAdler32(imageBytes) + "_" + computeAdler32(dictBytes);
                                var cacheEntry = this.imageCache[cacheKey];

                                if (cacheEntry !== undefined) {
                                    this.buf2 = _primitives.Cmd.get("EI");
                                    this.shift();
                                    cacheEntry.reset();
                                    return cacheEntry;
                                }
                            }

                            if (cipherTransform) {
                                imageStream = cipherTransform.createStream(imageStream, length);
                            }

                            imageStream = this.filter(imageStream, dict, length);
                            imageStream.dict = dict;

                            if (cacheKey !== undefined) {
                                imageStream.cacheKey = "inline_".concat(length, "_").concat(cacheKey);
                                this.imageCache[cacheKey] = imageStream;
                            }

                            this.buf2 = _primitives.Cmd.get("EI");
                            this.shift();
                            return imageStream;
                        }
                    }, {
                        key   : "_findStreamLength",
                        value : function _findStreamLength(startPos, signature) {
                            var stream = this.lexer.stream;
                            stream.pos = startPos;
                            var SCAN_BLOCK_LENGTH = 2048;
                            var signatureLength = signature.length;

                            while (stream.pos < stream.end) {
                                var scanBytes = stream.peekBytes(SCAN_BLOCK_LENGTH);
                                var scanLength = scanBytes.length - signatureLength;

                                if (scanLength <= 0) {
                                    break;
                                }

                                var pos = 0;

                                while (pos < scanLength) {
                                    var j = 0;

                                    while (j < signatureLength && scanBytes[pos + j] === signature[j]) {
                                        j++;
                                    }

                                    if (j >= signatureLength) {
                                        stream.pos += pos;
                                        return stream.pos - startPos;
                                    }

                                    pos++;
                                }

                                stream.pos += scanLength;
                            }

                            return -1;
                        }
                    }, {
                        key   : "makeStream",
                        value : function makeStream(dict, cipherTransform) {
                            var lexer = this.lexer;
                            var stream = lexer.stream;
                            lexer.skipToNextLine();
                            var startPos = stream.pos - 1;
                            var length = dict.get("Length");

                            if (!Number.isInteger(length)) {
                                (0, _util.info)("Bad length \"".concat(length, "\" in stream"));
                                length = 0;
                            }

                            stream.pos = startPos + length;
                            lexer.nextChar();

                            if (this.tryShift() && (0, _primitives.isCmd)(this.buf2, "endstream")) {
                                this.shift();
                            } else {
                                var ENDSTREAM_SIGNATURE = new Uint8Array([0x65, 0x6E, 0x64, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6D]);

                                var actualLength = this._findStreamLength(startPos, ENDSTREAM_SIGNATURE);

                                if (actualLength < 0) {
                                    var MAX_TRUNCATION = 1;

                                    for (var i = 1; i <= MAX_TRUNCATION; i++) {
                                        var end = ENDSTREAM_SIGNATURE.length - i;
                                        var TRUNCATED_SIGNATURE = ENDSTREAM_SIGNATURE.slice(0, end);

                                        var maybeLength = this._findStreamLength(startPos, TRUNCATED_SIGNATURE);

                                        if (maybeLength >= 0) {
                                            var lastByte = stream.peekBytes(end + 1)[end];

                                            if (!(0, _core_utils.isWhiteSpace)(lastByte)) {
                                                break;
                                            }

                                            (0, _util.info)("Found \"".concat((0, _util.bytesToString)(TRUNCATED_SIGNATURE), "\" when ") + "searching for endstream command.");
                                            actualLength = maybeLength;
                                            break;
                                        }
                                    }

                                    if (actualLength < 0) {
                                        throw new _util.FormatError("Missing endstream command.");
                                    }
                                }

                                length = actualLength;
                                lexer.nextChar();
                                this.shift();
                                this.shift();
                            }

                            this.shift();
                            stream = stream.makeSubStream(startPos, length, dict);

                            if (cipherTransform) {
                                stream = cipherTransform.createStream(stream, length);
                            }

                            stream = this.filter(stream, dict, length);
                            stream.dict = dict;
                            return stream;
                        }
                    }, {
                        key   : "filter",
                        value : function filter(stream, dict, length) {
                            var filter = dict.get("Filter", "F");
                            var params = dict.get("DecodeParms", "DP");

                            if ((0, _primitives.isName)(filter)) {
                                if (Array.isArray(params)) {
                                    (0, _util.warn)("/DecodeParms should not contain an Array, " + "when /Filter contains a Name.");
                                }

                                return this.makeFilter(stream, filter.name, length, params);
                            }

                            var maybeLength = length;

                            if (Array.isArray(filter)) {
                                var filterArray = filter;
                                var paramsArray = params;

                                for (var i = 0, ii = filterArray.length; i < ii; ++i) {
                                    filter = this.xref.fetchIfRef(filterArray[i]);

                                    if (!(0, _primitives.isName)(filter)) {
                                        throw new _util.FormatError("Bad filter name \"".concat(filter, "\""));
                                    }

                                    params = null;

                                    if (Array.isArray(paramsArray) && i in paramsArray) {
                                        params = this.xref.fetchIfRef(paramsArray[i]);
                                    }

                                    stream = this.makeFilter(stream, filter.name, maybeLength, params);
                                    maybeLength = null;
                                }
                            }

                            return stream;
                        }
                    }, {
                        key   : "makeFilter",
                        value : function makeFilter(stream, name, maybeLength, params) {
                            if (maybeLength === 0) {
                                (0, _util.warn)("Empty \"".concat(name, "\" stream."));
                                return new _stream.NullStream();
                            }

                            try {
                                var xrefStreamStats = this.xref.stats.streamTypes;

                                if (name === "FlateDecode" || name === "Fl") {
                                    xrefStreamStats[_util.StreamType.FLATE] = true;

                                    if (params) {
                                        return new _stream.PredictorStream(new _stream.FlateStream(stream, maybeLength), maybeLength, params);
                                    }

                                    return new _stream.FlateStream(stream, maybeLength);
                                }

                                if (name === "LZWDecode" || name === "LZW") {
                                    xrefStreamStats[_util.StreamType.LZW] = true;
                                    var earlyChange = 1;

                                    if (params) {
                                        if (params.has("EarlyChange")) {
                                            earlyChange = params.get("EarlyChange");
                                        }

                                        return new _stream.PredictorStream(new _stream.LZWStream(stream, maybeLength, earlyChange), maybeLength, params);
                                    }

                                    return new _stream.LZWStream(stream, maybeLength, earlyChange);
                                }

                                if (name === "DCTDecode" || name === "DCT") {
                                    xrefStreamStats[_util.StreamType.DCT] = true;
                                    return new _jpeg_stream.JpegStream(stream, maybeLength, stream.dict, params);
                                }

                                if (name === "JPXDecode" || name === "JPX") {
                                    xrefStreamStats[_util.StreamType.JPX] = true;
                                    return new _jpx_stream.JpxStream(stream, maybeLength, stream.dict, params);
                                }

                                if (name === "ASCII85Decode" || name === "A85") {
                                    xrefStreamStats[_util.StreamType.A85] = true;
                                    return new _stream.Ascii85Stream(stream, maybeLength);
                                }

                                if (name === "ASCIIHexDecode" || name === "AHx") {
                                    xrefStreamStats[_util.StreamType.AHX] = true;
                                    return new _stream.AsciiHexStream(stream, maybeLength);
                                }

                                if (name === "CCITTFaxDecode" || name === "CCF") {
                                    xrefStreamStats[_util.StreamType.CCF] = true;
                                    return new _ccitt_stream.CCITTFaxStream(stream, maybeLength, params);
                                }

                                if (name === "RunLengthDecode" || name === "RL") {
                                    xrefStreamStats[_util.StreamType.RLX] = true;
                                    return new _stream.RunLengthStream(stream, maybeLength);
                                }

                                if (name === "JBIG2Decode") {
                                    xrefStreamStats[_util.StreamType.JBIG] = true;
                                    return new _jbig2_stream.Jbig2Stream(stream, maybeLength, stream.dict, params);
                                }

                                (0, _util.warn)("Filter \"".concat(name, "\" is not supported."));
                                return stream;
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("Invalid stream: \"".concat(ex, "\""));
                                return new _stream.NullStream();
                            }
                        }
                    }]);

                    return Parser;
                }();

                exports.Parser = Parser;
                var specialChars = [1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

                function toHexDigit(ch) {
                    if (ch >= 0x30 && ch <= 0x39) {
                        return ch & 0x0f;
                    }

                    if (ch >= 0x41 && ch <= 0x46 || ch >= 0x61 && ch <= 0x66) {
                        return (ch & 0x0f) + 9;
                    }

                    return -1;
                }

                var Lexer = /*#__PURE__*/function() {
                    function Lexer(stream) {
                        var knownCommands = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

                        _classCallCheck(this, Lexer);

                        this.stream = stream;
                        this.nextChar();
                        this.strBuf = [];
                        this.knownCommands = knownCommands;
                        this._hexStringNumWarn = 0;
                        this.beginInlineImagePos = -1;
                    }

                    _createClass(Lexer, [{
                        key   : "nextChar",
                        value : function nextChar() {
                            return this.currentChar = this.stream.getByte();
                        }
                    }, {
                        key   : "peekChar",
                        value : function peekChar() {
                            return this.stream.peekByte();
                        }
                    }, {
                        key   : "getNumber",
                        value : function getNumber() {
                            var ch = this.currentChar;
                            var eNotation = false;
                            var divideBy = 0;
                            var sign = 0;

                            if (ch === 0x2d) {
                                sign = -1;
                                ch = this.nextChar();

                                if (ch === 0x2d) {
                                    ch = this.nextChar();
                                }
                            } else if (ch === 0x2b) {
                                sign = 1;
                                ch = this.nextChar();
                            }

                            if (ch === 0x0a || ch === 0x0d) {
                                do {
                                    ch = this.nextChar();
                                } while (ch === 0x0a || ch === 0x0d);
                            }

                            if (ch === 0x2e) {
                                divideBy = 10;
                                ch = this.nextChar();
                            }

                            if (ch < 0x30 || ch > 0x39) {
                                if (divideBy === 10 && sign === 0 && ((0, _core_utils.isWhiteSpace)(ch) || ch === -1)) {
                                    (0, _util.warn)("Lexer.getNumber - treating a single decimal point as zero.");
                                    return 0;
                                }

                                throw new _util.FormatError("Invalid number: ".concat(String.fromCharCode(ch), " (charCode ").concat(ch, ")"));
                            }

                            sign = sign || 1;
                            var baseValue = ch - 0x30;
                            var powerValue = 0;
                            var powerValueSign = 1;

                            while ((ch = this.nextChar()) >= 0) {
                                if (ch >= 0x30 && ch <= 0x39) {
                                    var currentDigit = ch - 0x30;

                                    if (eNotation) {
                                        powerValue = powerValue * 10 + currentDigit;
                                    } else {
                                        if (divideBy !== 0) {
                                            divideBy *= 10;
                                        }

                                        baseValue = baseValue * 10 + currentDigit;
                                    }
                                } else if (ch === 0x2e) {
                                    if (divideBy === 0) {
                                        divideBy = 1;
                                    } else {
                                        break;
                                    }
                                } else if (ch === 0x2d) {
                                    (0, _util.warn)("Badly formatted number: minus sign in the middle");
                                } else if (ch === 0x45 || ch === 0x65) {
                                    ch = this.peekChar();

                                    if (ch === 0x2b || ch === 0x2d) {
                                        powerValueSign = ch === 0x2d ? -1 : 1;
                                        this.nextChar();
                                    } else if (ch < 0x30 || ch > 0x39) {
                                        break;
                                    }

                                    eNotation = true;
                                } else {
                                    break;
                                }
                            }

                            if (divideBy !== 0) {
                                baseValue /= divideBy;
                            }

                            if (eNotation) {
                                baseValue *= Math.pow(10, powerValueSign * powerValue);
                            }

                            return sign * baseValue;
                        }
                    }, {
                        key   : "getString",
                        value : function getString() {
                            var numParen = 1;
                            var done = false;
                            var strBuf = this.strBuf;
                            strBuf.length = 0;
                            var ch = this.nextChar();

                            while (true) {
                                var charBuffered = false;

                                switch (ch | 0) {
                                    case -1:
                                        (0, _util.warn)("Unterminated string");
                                        done = true;
                                        break;

                                    case 0x28:
                                        ++numParen;
                                        strBuf.push("(");
                                        break;

                                    case 0x29:
                                        if (--numParen === 0) {
                                            this.nextChar();
                                            done = true;
                                        } else {
                                            strBuf.push(")");
                                        }

                                        break;

                                    case 0x5c:
                                        ch = this.nextChar();

                                        switch (ch) {
                                            case -1:
                                                (0, _util.warn)("Unterminated string");
                                                done = true;
                                                break;

                                            case 0x6e:
                                                strBuf.push("\n");
                                                break;

                                            case 0x72:
                                                strBuf.push("\r");
                                                break;

                                            case 0x74:
                                                strBuf.push("\t");
                                                break;

                                            case 0x62:
                                                strBuf.push("\b");
                                                break;

                                            case 0x66:
                                                strBuf.push("\f");
                                                break;

                                            case 0x5c:
                                            case 0x28:
                                            case 0x29:
                                                strBuf.push(String.fromCharCode(ch));
                                                break;

                                            case 0x30:
                                            case 0x31:
                                            case 0x32:
                                            case 0x33:
                                            case 0x34:
                                            case 0x35:
                                            case 0x36:
                                            case 0x37:
                                                var x = ch & 0x0f;
                                                ch = this.nextChar();
                                                charBuffered = true;

                                                if (ch >= 0x30 && ch <= 0x37) {
                                                    x = (x << 3) + (ch & 0x0f);
                                                    ch = this.nextChar();

                                                    if (ch >= 0x30 && ch <= 0x37) {
                                                        charBuffered = false;
                                                        x = (x << 3) + (ch & 0x0f);
                                                    }
                                                }

                                                strBuf.push(String.fromCharCode(x));
                                                break;

                                            case 0x0d:
                                                if (this.peekChar() === 0x0a) {
                                                    this.nextChar();
                                                }

                                                break;

                                            case 0x0a:
                                                break;

                                            default:
                                                strBuf.push(String.fromCharCode(ch));
                                                break;
                                        }

                                        break;

                                    default:
                                        strBuf.push(String.fromCharCode(ch));
                                        break;
                                }

                                if (done) {
                                    break;
                                }

                                if (!charBuffered) {
                                    ch = this.nextChar();
                                }
                            }

                            return strBuf.join("");
                        }
                    }, {
                        key   : "getName",
                        value : function getName() {
                            var ch, previousCh;
                            var strBuf = this.strBuf;
                            strBuf.length = 0;

                            while ((ch = this.nextChar()) >= 0 && !specialChars[ch]) {
                                if (ch === 0x23) {
                                    ch = this.nextChar();

                                    if (specialChars[ch]) {
                                        (0, _util.warn)("Lexer_getName: " + "NUMBER SIGN (#) should be followed by a hexadecimal number.");
                                        strBuf.push("#");
                                        break;
                                    }

                                    var x = toHexDigit(ch);

                                    if (x !== -1) {
                                        previousCh = ch;
                                        ch = this.nextChar();
                                        var x2 = toHexDigit(ch);

                                        if (x2 === -1) {
                                            (0, _util.warn)("Lexer_getName: Illegal digit (".concat(String.fromCharCode(ch), ") ") + "in hexadecimal number.");
                                            strBuf.push("#", String.fromCharCode(previousCh));

                                            if (specialChars[ch]) {
                                                break;
                                            }

                                            strBuf.push(String.fromCharCode(ch));
                                            continue;
                                        }

                                        strBuf.push(String.fromCharCode(x << 4 | x2));
                                    } else {
                                        strBuf.push("#", String.fromCharCode(ch));
                                    }
                                } else {
                                    strBuf.push(String.fromCharCode(ch));
                                }
                            }

                            if (strBuf.length > 127) {
                                (0, _util.warn)("Name token is longer than allowed by the spec: ".concat(strBuf.length));
                            }

                            return _primitives.Name.get(strBuf.join(""));
                        }
                    }, {
                        key   : "_hexStringWarn",
                        value : function _hexStringWarn(ch) {
                            var MAX_HEX_STRING_NUM_WARN = 5;

                            if (this._hexStringNumWarn++ === MAX_HEX_STRING_NUM_WARN) {
                                (0, _util.warn)("getHexString - ignoring additional invalid characters.");
                                return;
                            }

                            if (this._hexStringNumWarn > MAX_HEX_STRING_NUM_WARN) {
                                return;
                            }

                            (0, _util.warn)("getHexString - ignoring invalid character: ".concat(ch));
                        }
                    }, {
                        key   : "getHexString",
                        value : function getHexString() {
                            var strBuf = this.strBuf;
                            strBuf.length = 0;
                            var ch = this.currentChar;
                            var isFirstHex = true;
                            var firstDigit, secondDigit;
                            this._hexStringNumWarn = 0;

                            while (true) {
                                if (ch < 0) {
                                    (0, _util.warn)("Unterminated hex string");
                                    break;
                                } else if (ch === 0x3e) {
                                    this.nextChar();
                                    break;
                                } else if (specialChars[ch] === 1) {
                                    ch = this.nextChar();
                                    continue;
                                } else {
                                    if (isFirstHex) {
                                        firstDigit = toHexDigit(ch);

                                        if (firstDigit === -1) {
                                            this._hexStringWarn(ch);

                                            ch = this.nextChar();
                                            continue;
                                        }
                                    } else {
                                        secondDigit = toHexDigit(ch);

                                        if (secondDigit === -1) {
                                            this._hexStringWarn(ch);

                                            ch = this.nextChar();
                                            continue;
                                        }

                                        strBuf.push(String.fromCharCode(firstDigit << 4 | secondDigit));
                                    }

                                    isFirstHex = !isFirstHex;
                                    ch = this.nextChar();
                                }
                            }

                            return strBuf.join("");
                        }
                    }, {
                        key   : "getObj",
                        value : function getObj() {
                            var comment = false;
                            var ch = this.currentChar;

                            while (true) {
                                if (ch < 0) {
                                    return _primitives.EOF;
                                }

                                if (comment) {
                                    if (ch === 0x0a || ch === 0x0d) {
                                        comment = false;
                                    }
                                } else if (ch === 0x25) {
                                    comment = true;
                                } else if (specialChars[ch] !== 1) {
                                    break;
                                }

                                ch = this.nextChar();
                            }

                            switch (ch | 0) {
                                case 0x30:
                                case 0x31:
                                case 0x32:
                                case 0x33:
                                case 0x34:
                                case 0x35:
                                case 0x36:
                                case 0x37:
                                case 0x38:
                                case 0x39:
                                case 0x2b:
                                case 0x2d:
                                case 0x2e:
                                    return this.getNumber();

                                case 0x28:
                                    return this.getString();

                                case 0x2f:
                                    return this.getName();

                                case 0x5b:
                                    this.nextChar();
                                    return _primitives.Cmd.get("[");

                                case 0x5d:
                                    this.nextChar();
                                    return _primitives.Cmd.get("]");

                                case 0x3c:
                                    ch = this.nextChar();

                                    if (ch === 0x3c) {
                                        this.nextChar();
                                        return _primitives.Cmd.get("<<");
                                    }

                                    return this.getHexString();

                                case 0x3e:
                                    ch = this.nextChar();

                                    if (ch === 0x3e) {
                                        this.nextChar();
                                        return _primitives.Cmd.get(">>");
                                    }

                                    return _primitives.Cmd.get(">");

                                case 0x7b:
                                    this.nextChar();
                                    return _primitives.Cmd.get("{");

                                case 0x7d:
                                    this.nextChar();
                                    return _primitives.Cmd.get("}");

                                case 0x29:
                                    this.nextChar();
                                    throw new _util.FormatError("Illegal character: ".concat(ch));
                            }

                            var str = String.fromCharCode(ch);
                            var knownCommands = this.knownCommands;
                            var knownCommandFound = knownCommands && knownCommands[str] !== undefined;

                            while ((ch = this.nextChar()) >= 0 && !specialChars[ch]) {
                                var possibleCommand = str + String.fromCharCode(ch);

                                if (knownCommandFound && knownCommands[possibleCommand] === undefined) {
                                    break;
                                }

                                if (str.length === 128) {
                                    throw new _util.FormatError("Command token too long: ".concat(str.length));
                                }

                                str = possibleCommand;
                                knownCommandFound = knownCommands && knownCommands[str] !== undefined;
                            }

                            if (str === "true") {
                                return true;
                            }

                            if (str === "false") {
                                return false;
                            }

                            if (str === "null") {
                                return null;
                            }

                            if (str === "BI") {
                                this.beginInlineImagePos = this.stream.pos;
                            }

                            return _primitives.Cmd.get(str);
                        }
                    }, {
                        key   : "peekObj",
                        value : function peekObj() {
                            var streamPos           = this.stream.pos,
                                currentChar         = this.currentChar,
                                beginInlineImagePos = this.beginInlineImagePos;
                            var nextObj;

                            try {
                                nextObj = this.getObj();
                            } catch (ex) {
                                if (ex instanceof _core_utils.MissingDataException) {
                                    throw ex;
                                }

                                (0, _util.warn)("peekObj: ".concat(ex));
                            }

                            this.stream.pos = streamPos;
                            this.currentChar = currentChar;
                            this.beginInlineImagePos = beginInlineImagePos;
                            return nextObj;
                        }
                    }, {
                        key   : "skipToNextLine",
                        value : function skipToNextLine() {
                            var ch = this.currentChar;

                            while (ch >= 0) {
                                if (ch === 0x0d) {
                                    ch = this.nextChar();

                                    if (ch === 0x0a) {
                                        this.nextChar();
                                    }

                                    break;
                                } else if (ch === 0x0a) {
                                    this.nextChar();
                                    break;
                                }

                                ch = this.nextChar();
                            }
                        }
                    }]);

                    return Lexer;
                }();

                exports.Lexer = Lexer;

                var Linearization = /*#__PURE__*/function() {
                    function Linearization() {
                        _classCallCheck(this, Linearization);
                    }

                    _createClass(Linearization, null, [{
                        key   : "create",
                        value : function create(stream) {
                            function getInt(linDict, name) {
                                var allowZeroValue = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                                var obj = linDict.get(name);

                                if (Number.isInteger(obj) && (allowZeroValue ? obj >= 0 : obj > 0)) {
                                    return obj;
                                }

                                throw new Error("The \"".concat(name, "\" parameter in the linearization ") + "dictionary is invalid.");
                            }

                            function getHints(linDict) {
                                var hints = linDict.get("H");
                                var hintsLength;

                                if (Array.isArray(hints) && ((hintsLength = hints.length) === 2 || hintsLength === 4)) {
                                    for (var index = 0; index < hintsLength; index++) {
                                        var hint = hints[index];

                                        if (!(Number.isInteger(hint) && hint > 0)) {
                                            throw new Error("Hint (".concat(index, ") in the linearization dictionary is invalid."));
                                        }
                                    }

                                    return hints;
                                }

                                throw new Error("Hint array in the linearization dictionary is invalid.");
                            }

                            var parser = new Parser({
                                lexer : new Lexer(stream),
                                xref  : null
                            });
                            var obj1 = parser.getObj();
                            var obj2 = parser.getObj();
                            var obj3 = parser.getObj();
                            var linDict = parser.getObj();
                            var obj, length;

                            if (!(Number.isInteger(obj1) && Number.isInteger(obj2) && (0, _primitives.isCmd)(obj3, "obj") && (0, _primitives.isDict)(linDict) && (0, _util.isNum)(obj = linDict.get("Linearized")) && obj > 0)) {
                                return null;
                            } else if ((length = getInt(linDict, "L")) !== stream.length) {
                                throw new Error('The "L" parameter in the linearization dictionary ' + "does not equal the stream length.");
                            }

                            return {
                                length                : length,
                                hints                 : getHints(linDict),
                                objectNumberFirst     : getInt(linDict, "O"),
                                endFirst              : getInt(linDict, "E"),
                                numPages              : getInt(linDict, "N"),
                                mainXRefEntriesOffset : getInt(linDict, "T"),
                                pageFirst             : linDict.has("P") ? getInt(linDict, "P", true) : 0
                            };
                        }
                    }]);

                    return Linearization;
                }();

                exports.Linearization = Linearization;

                /***/
            }),
            /* 132 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.StringStream = exports.StreamsSequenceStream = exports.Stream = exports.RunLengthStream = exports.PredictorStream = exports.NullStream = exports.LZWStream = exports.FlateStream = exports.DecryptStream = exports.DecodeStream = exports.AsciiHexStream = exports.Ascii85Stream = void 0;

                var _util = __w_pdfjs_require__(4);

                var _primitives = __w_pdfjs_require__(125);

                var _core_utils = __w_pdfjs_require__(128);

                function _toConsumableArray(arr) {
                    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
                }

                function _nonIterableSpread() {
                    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                }

                function _unsupportedIterableToArray(o, minLen) {
                    if (!o) return;
                    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
                    var n = Object.prototype.toString.call(o).slice(8, -1);
                    if (n === "Object" && o.constructor) n = o.constructor.name;
                    if (n === "Map" || n === "Set") return Array.from(o);
                    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
                }

                function _iterableToArray(iter) {
                    if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
                }

                function _arrayWithoutHoles(arr) {
                    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
                }

                function _arrayLikeToArray(arr, len) {
                    if (len == null || len > arr.length) len = arr.length;
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i];
                    }
                    return arr2;
                }

                var Stream = function StreamClosure() {
                    function Stream(arrayBuffer, start, length, dict) {
                        this.bytes = arrayBuffer instanceof Uint8Array ? arrayBuffer : new Uint8Array(arrayBuffer);
                        this.start = start || 0;
                        this.pos = this.start;
                        this.end = start + length || this.bytes.length;
                        this.dict = dict;
                    }

                    Stream.prototype = {
                        get length() {
                            return this.end - this.start;
                        },

                        get isEmpty() {
                            return this.length === 0;
                        },

                        getByte       : function Stream_getByte() {
                            if (this.pos >= this.end) {
                                return -1;
                            }

                            return this.bytes[this.pos++];
                        },
                        getUint16     : function Stream_getUint16() {
                            var b0 = this.getByte();
                            var b1 = this.getByte();

                            if (b0 === -1 || b1 === -1) {
                                return -1;
                            }

                            return (b0 << 8) + b1;
                        },
                        getInt32      : function Stream_getInt32() {
                            var b0 = this.getByte();
                            var b1 = this.getByte();
                            var b2 = this.getByte();
                            var b3 = this.getByte();
                            return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
                        },
                        getBytes      : function getBytes(length) {
                            var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                            var bytes = this.bytes;
                            var pos = this.pos;
                            var strEnd = this.end;

                            if (!length) {
                                var _subarray = bytes.subarray(pos, strEnd);

                                return forceClamped ? new Uint8ClampedArray(_subarray) : _subarray;
                            }

                            var end = pos + length;

                            if (end > strEnd) {
                                end = strEnd;
                            }

                            this.pos = end;
                            var subarray = bytes.subarray(pos, end);
                            return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
                        },
                        peekByte      : function Stream_peekByte() {
                            var peekedByte = this.getByte();

                            if (peekedByte !== -1) {
                                this.pos--;
                            }

                            return peekedByte;
                        },
                        peekBytes     : function peekBytes(length) {
                            var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                            var bytes = this.getBytes(length, forceClamped);
                            this.pos -= bytes.length;
                            return bytes;
                        },
                        getByteRange  : function getByteRange(begin, end) {
                            if (begin < 0) {
                                begin = 0;
                            }

                            if (end > this.end) {
                                end = this.end;
                            }

                            return this.bytes.subarray(begin, end);
                        },
                        skip          : function Stream_skip(n) {
                            if (!n) {
                                n = 1;
                            }

                            this.pos += n;
                        },
                        reset         : function Stream_reset() {
                            this.pos = this.start;
                        },
                        moveStart     : function Stream_moveStart() {
                            this.start = this.pos;
                        },
                        makeSubStream : function Stream_makeSubStream(start, length, dict) {
                            return new Stream(this.bytes.buffer, start, length, dict);
                        }
                    };
                    return Stream;
                }();

                exports.Stream = Stream;

                var StringStream = function StringStreamClosure() {
                    function StringStream(str) {
                        var bytes = (0, _util.stringToBytes)(str);
                        Stream.call(this, bytes);
                    }

                    StringStream.prototype = Stream.prototype;
                    return StringStream;
                }();

                exports.StringStream = StringStream;

                var DecodeStream = function DecodeStreamClosure() {
                    var emptyBuffer = new Uint8Array(0);

                    function DecodeStream(maybeMinBufferLength) {
                        this._rawMinBufferLength = maybeMinBufferLength || 0;
                        this.pos = 0;
                        this.bufferLength = 0;
                        this.eof = false;
                        this.buffer = emptyBuffer;
                        this.minBufferLength = 512;

                        if (maybeMinBufferLength) {
                            while (this.minBufferLength < maybeMinBufferLength) {
                                this.minBufferLength *= 2;
                            }
                        }
                    }

                    DecodeStream.prototype = {
                        get length() {
                            (0, _util.unreachable)("Should not access DecodeStream.length");
                        },

                        get isEmpty() {
                            while (!this.eof && this.bufferLength === 0) {
                                this.readBlock();
                            }

                            return this.bufferLength === 0;
                        },

                        ensureBuffer   : function DecodeStream_ensureBuffer(requested) {
                            var buffer = this.buffer;

                            if (requested <= buffer.byteLength) {
                                return buffer;
                            }

                            var size = this.minBufferLength;

                            while (size < requested) {
                                size *= 2;
                            }

                            var buffer2 = new Uint8Array(size);
                            buffer2.set(buffer);
                            return this.buffer = buffer2;
                        },
                        getByte        : function DecodeStream_getByte() {
                            var pos = this.pos;

                            while (this.bufferLength <= pos) {
                                if (this.eof) {
                                    return -1;
                                }

                                this.readBlock();
                            }

                            return this.buffer[this.pos++];
                        },
                        getUint16      : function DecodeStream_getUint16() {
                            var b0 = this.getByte();
                            var b1 = this.getByte();

                            if (b0 === -1 || b1 === -1) {
                                return -1;
                            }

                            return (b0 << 8) + b1;
                        },
                        getInt32       : function DecodeStream_getInt32() {
                            var b0 = this.getByte();
                            var b1 = this.getByte();
                            var b2 = this.getByte();
                            var b3 = this.getByte();
                            return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
                        },
                        getBytes       : function getBytes(length) {
                            var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                            var end,
                                pos = this.pos;

                            if (length) {
                                this.ensureBuffer(pos + length);
                                end = pos + length;

                                while (!this.eof && this.bufferLength < end) {
                                    this.readBlock();
                                }

                                var bufEnd = this.bufferLength;

                                if (end > bufEnd) {
                                    end = bufEnd;
                                }
                            } else {
                                while (!this.eof) {
                                    this.readBlock();
                                }

                                end = this.bufferLength;
                            }

                            this.pos = end;
                            var subarray = this.buffer.subarray(pos, end);
                            return forceClamped && !(subarray instanceof Uint8ClampedArray) ? new Uint8ClampedArray(subarray) : subarray;
                        },
                        peekByte       : function DecodeStream_peekByte() {
                            var peekedByte = this.getByte();

                            if (peekedByte !== -1) {
                                this.pos--;
                            }

                            return peekedByte;
                        },
                        peekBytes      : function peekBytes(length) {
                            var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                            var bytes = this.getBytes(length, forceClamped);
                            this.pos -= bytes.length;
                            return bytes;
                        },
                        makeSubStream  : function DecodeStream_makeSubStream(start, length, dict) {
                            if (length === undefined) {
                                while (!this.eof) {
                                    this.readBlock();
                                }
                            } else {
                                var end = start + length;

                                while (this.bufferLength <= end && !this.eof) {
                                    this.readBlock();
                                }
                            }

                            return new Stream(this.buffer, start, length, dict);
                        },
                        getByteRange   : function getByteRange(begin, end) {
                            (0, _util.unreachable)("Should not call DecodeStream.getByteRange");
                        },
                        skip           : function DecodeStream_skip(n) {
                            if (!n) {
                                n = 1;
                            }

                            this.pos += n;
                        },
                        reset          : function DecodeStream_reset() {
                            this.pos = 0;
                        },
                        getBaseStreams : function DecodeStream_getBaseStreams() {
                            if (this.str && this.str.getBaseStreams) {
                                return this.str.getBaseStreams();
                            }

                            return [];
                        }
                    };
                    return DecodeStream;
                }();

                exports.DecodeStream = DecodeStream;

                var StreamsSequenceStream = function StreamsSequenceStreamClosure() {
                    function StreamsSequenceStream(streams) {
                        this.streams = streams;
                        var maybeLength = 0;

                        for (var i = 0, ii = streams.length; i < ii; i++) {
                            var stream = streams[i];

                            if (stream instanceof DecodeStream) {
                                maybeLength += stream._rawMinBufferLength;
                            } else {
                                maybeLength += stream.length;
                            }
                        }

                        DecodeStream.call(this, maybeLength);
                    }

                    StreamsSequenceStream.prototype = Object.create(DecodeStream.prototype);

                    StreamsSequenceStream.prototype.readBlock = function streamSequenceStreamReadBlock() {
                        var streams = this.streams;

                        if (streams.length === 0) {
                            this.eof = true;
                            return;
                        }

                        var stream = streams.shift();
                        var chunk = stream.getBytes();
                        var bufferLength = this.bufferLength;
                        var newLength = bufferLength + chunk.length;
                        var buffer = this.ensureBuffer(newLength);
                        buffer.set(chunk, bufferLength);
                        this.bufferLength = newLength;
                    };

                    StreamsSequenceStream.prototype.getBaseStreams = function StreamsSequenceStream_getBaseStreams() {
                        var baseStreams = [];

                        for (var i = 0, ii = this.streams.length; i < ii; i++) {
                            var stream = this.streams[i];

                            if (stream.getBaseStreams) {
                                baseStreams.push.apply(baseStreams, _toConsumableArray(stream.getBaseStreams()));
                            }
                        }

                        return baseStreams;
                    };

                    return StreamsSequenceStream;
                }();

                exports.StreamsSequenceStream = StreamsSequenceStream;

                var FlateStream = function FlateStreamClosure() {
                    var codeLenCodeMap = new Int32Array([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
                    var lengthDecode = new Int32Array([0x00003, 0x00004, 0x00005, 0x00006, 0x00007, 0x00008, 0x00009, 0x0000a, 0x1000b, 0x1000d, 0x1000f, 0x10011, 0x20013, 0x20017, 0x2001b, 0x2001f, 0x30023, 0x3002b, 0x30033, 0x3003b, 0x40043, 0x40053, 0x40063, 0x40073, 0x50083, 0x500a3, 0x500c3, 0x500e3, 0x00102, 0x00102, 0x00102]);
                    var distDecode = new Int32Array([0x00001, 0x00002, 0x00003, 0x00004, 0x10005, 0x10007, 0x20009, 0x2000d, 0x30011, 0x30019, 0x40021, 0x40031, 0x50041, 0x50061, 0x60081, 0x600c1, 0x70101, 0x70181, 0x80201, 0x80301, 0x90401, 0x90601, 0xa0801, 0xa0c01, 0xb1001, 0xb1801, 0xc2001, 0xc3001, 0xd4001, 0xd6001]);
                    var fixedLitCodeTab = [new Int32Array([0x70100, 0x80050, 0x80010, 0x80118, 0x70110, 0x80070, 0x80030, 0x900c0, 0x70108, 0x80060, 0x80020, 0x900a0, 0x80000, 0x80080, 0x80040, 0x900e0, 0x70104, 0x80058, 0x80018, 0x90090, 0x70114, 0x80078, 0x80038, 0x900d0, 0x7010c, 0x80068, 0x80028, 0x900b0, 0x80008, 0x80088, 0x80048, 0x900f0, 0x70102, 0x80054, 0x80014, 0x8011c, 0x70112, 0x80074, 0x80034, 0x900c8, 0x7010a, 0x80064, 0x80024, 0x900a8, 0x80004, 0x80084, 0x80044, 0x900e8, 0x70106, 0x8005c, 0x8001c, 0x90098, 0x70116, 0x8007c, 0x8003c, 0x900d8, 0x7010e, 0x8006c, 0x8002c, 0x900b8, 0x8000c, 0x8008c, 0x8004c, 0x900f8, 0x70101, 0x80052, 0x80012, 0x8011a, 0x70111, 0x80072, 0x80032, 0x900c4, 0x70109, 0x80062, 0x80022, 0x900a4, 0x80002, 0x80082, 0x80042, 0x900e4, 0x70105, 0x8005a, 0x8001a, 0x90094, 0x70115, 0x8007a, 0x8003a, 0x900d4, 0x7010d, 0x8006a, 0x8002a, 0x900b4, 0x8000a, 0x8008a, 0x8004a, 0x900f4, 0x70103, 0x80056, 0x80016, 0x8011e, 0x70113, 0x80076, 0x80036, 0x900cc, 0x7010b, 0x80066, 0x80026, 0x900ac, 0x80006, 0x80086, 0x80046, 0x900ec, 0x70107, 0x8005e, 0x8001e, 0x9009c, 0x70117, 0x8007e, 0x8003e, 0x900dc, 0x7010f, 0x8006e, 0x8002e, 0x900bc, 0x8000e, 0x8008e, 0x8004e, 0x900fc, 0x70100, 0x80051, 0x80011, 0x80119, 0x70110, 0x80071, 0x80031, 0x900c2, 0x70108, 0x80061, 0x80021, 0x900a2, 0x80001, 0x80081, 0x80041, 0x900e2, 0x70104, 0x80059, 0x80019, 0x90092, 0x70114, 0x80079, 0x80039, 0x900d2, 0x7010c, 0x80069, 0x80029, 0x900b2, 0x80009, 0x80089, 0x80049, 0x900f2, 0x70102, 0x80055, 0x80015, 0x8011d, 0x70112, 0x80075, 0x80035, 0x900ca, 0x7010a, 0x80065, 0x80025, 0x900aa, 0x80005, 0x80085, 0x80045, 0x900ea, 0x70106, 0x8005d, 0x8001d, 0x9009a, 0x70116, 0x8007d, 0x8003d, 0x900da, 0x7010e, 0x8006d, 0x8002d, 0x900ba, 0x8000d, 0x8008d, 0x8004d, 0x900fa, 0x70101, 0x80053, 0x80013, 0x8011b, 0x70111, 0x80073, 0x80033, 0x900c6, 0x70109, 0x80063, 0x80023, 0x900a6, 0x80003, 0x80083, 0x80043, 0x900e6, 0x70105, 0x8005b, 0x8001b, 0x90096, 0x70115, 0x8007b, 0x8003b, 0x900d6, 0x7010d, 0x8006b, 0x8002b, 0x900b6, 0x8000b, 0x8008b, 0x8004b, 0x900f6, 0x70103, 0x80057, 0x80017, 0x8011f, 0x70113, 0x80077, 0x80037, 0x900ce, 0x7010b, 0x80067, 0x80027, 0x900ae, 0x80007, 0x80087, 0x80047, 0x900ee, 0x70107, 0x8005f, 0x8001f, 0x9009e, 0x70117, 0x8007f, 0x8003f, 0x900de, 0x7010f, 0x8006f, 0x8002f, 0x900be, 0x8000f, 0x8008f, 0x8004f, 0x900fe, 0x70100, 0x80050, 0x80010, 0x80118, 0x70110, 0x80070, 0x80030, 0x900c1, 0x70108, 0x80060, 0x80020, 0x900a1, 0x80000, 0x80080, 0x80040, 0x900e1, 0x70104, 0x80058, 0x80018, 0x90091, 0x70114, 0x80078, 0x80038, 0x900d1, 0x7010c, 0x80068, 0x80028, 0x900b1, 0x80008, 0x80088, 0x80048, 0x900f1, 0x70102, 0x80054, 0x80014, 0x8011c, 0x70112, 0x80074, 0x80034, 0x900c9, 0x7010a, 0x80064, 0x80024, 0x900a9, 0x80004, 0x80084, 0x80044, 0x900e9, 0x70106, 0x8005c, 0x8001c, 0x90099, 0x70116, 0x8007c, 0x8003c, 0x900d9, 0x7010e, 0x8006c, 0x8002c, 0x900b9, 0x8000c, 0x8008c, 0x8004c, 0x900f9, 0x70101, 0x80052, 0x80012, 0x8011a, 0x70111, 0x80072, 0x80032, 0x900c5, 0x70109, 0x80062, 0x80022, 0x900a5, 0x80002, 0x80082, 0x80042, 0x900e5, 0x70105, 0x8005a, 0x8001a, 0x90095, 0x70115, 0x8007a, 0x8003a, 0x900d5, 0x7010d, 0x8006a, 0x8002a, 0x900b5, 0x8000a, 0x8008a, 0x8004a, 0x900f5, 0x70103, 0x80056, 0x80016, 0x8011e, 0x70113, 0x80076, 0x80036, 0x900cd, 0x7010b, 0x80066, 0x80026, 0x900ad, 0x80006, 0x80086, 0x80046, 0x900ed, 0x70107, 0x8005e, 0x8001e, 0x9009d, 0x70117, 0x8007e, 0x8003e, 0x900dd, 0x7010f, 0x8006e, 0x8002e, 0x900bd, 0x8000e, 0x8008e, 0x8004e, 0x900fd, 0x70100, 0x80051, 0x80011, 0x80119, 0x70110, 0x80071, 0x80031, 0x900c3, 0x70108, 0x80061, 0x80021, 0x900a3, 0x80001, 0x80081, 0x80041, 0x900e3, 0x70104, 0x80059, 0x80019, 0x90093, 0x70114, 0x80079, 0x80039, 0x900d3, 0x7010c, 0x80069, 0x80029, 0x900b3, 0x80009, 0x80089, 0x80049, 0x900f3, 0x70102, 0x80055, 0x80015, 0x8011d, 0x70112, 0x80075, 0x80035, 0x900cb, 0x7010a, 0x80065, 0x80025, 0x900ab, 0x80005, 0x80085, 0x80045, 0x900eb, 0x70106, 0x8005d, 0x8001d, 0x9009b, 0x70116, 0x8007d, 0x8003d, 0x900db, 0x7010e, 0x8006d, 0x8002d, 0x900bb, 0x8000d, 0x8008d, 0x8004d, 0x900fb, 0x70101, 0x80053, 0x80013, 0x8011b, 0x70111, 0x80073, 0x80033, 0x900c7, 0x70109, 0x80063, 0x80023, 0x900a7, 0x80003, 0x80083, 0x80043, 0x900e7, 0x70105, 0x8005b, 0x8001b, 0x90097, 0x70115, 0x8007b, 0x8003b, 0x900d7, 0x7010d, 0x8006b, 0x8002b, 0x900b7, 0x8000b, 0x8008b, 0x8004b, 0x900f7, 0x70103, 0x80057, 0x80017, 0x8011f, 0x70113, 0x80077, 0x80037, 0x900cf, 0x7010b, 0x80067, 0x80027, 0x900af, 0x80007, 0x80087, 0x80047, 0x900ef, 0x70107, 0x8005f, 0x8001f, 0x9009f, 0x70117, 0x8007f, 0x8003f, 0x900df, 0x7010f, 0x8006f, 0x8002f, 0x900bf, 0x8000f, 0x8008f, 0x8004f, 0x900ff]), 9];
                    var fixedDistCodeTab = [new Int32Array([0x50000, 0x50010, 0x50008, 0x50018, 0x50004, 0x50014, 0x5000c, 0x5001c, 0x50002, 0x50012, 0x5000a, 0x5001a, 0x50006, 0x50016, 0x5000e, 0x00000, 0x50001, 0x50011, 0x50009, 0x50019, 0x50005, 0x50015, 0x5000d, 0x5001d, 0x50003, 0x50013, 0x5000b, 0x5001b, 0x50007, 0x50017, 0x5000f, 0x00000]), 5];

                    function FlateStream(str, maybeLength) {
                        this.str = str;
                        this.dict = str.dict;
                        var cmf = str.getByte();
                        var flg = str.getByte();

                        if (cmf === -1 || flg === -1) {
                            throw new _util.FormatError("Invalid header in flate stream: ".concat(cmf, ", ").concat(flg));
                        }

                        if ((cmf & 0x0f) !== 0x08) {
                            throw new _util.FormatError("Unknown compression method in flate stream: ".concat(cmf, ", ").concat(flg));
                        }

                        if (((cmf << 8) + flg) % 31 !== 0) {
                            throw new _util.FormatError("Bad FCHECK in flate stream: ".concat(cmf, ", ").concat(flg));
                        }

                        if (flg & 0x20) {
                            throw new _util.FormatError("FDICT bit set in flate stream: ".concat(cmf, ", ").concat(flg));
                        }

                        this.codeSize = 0;
                        this.codeBuf = 0;
                        DecodeStream.call(this, maybeLength);
                    }

                    FlateStream.prototype = Object.create(DecodeStream.prototype);

                    FlateStream.prototype.getBits = function FlateStream_getBits(bits) {
                        var str = this.str;
                        var codeSize = this.codeSize;
                        var codeBuf = this.codeBuf;
                        var b;

                        while (codeSize < bits) {
                            if ((b = str.getByte()) === -1) {
                                throw new _util.FormatError("Bad encoding in flate stream");
                            }

                            codeBuf |= b << codeSize;
                            codeSize += 8;
                        }

                        b = codeBuf & (1 << bits) - 1;
                        this.codeBuf = codeBuf >> bits;
                        this.codeSize = codeSize -= bits;
                        return b;
                    };

                    FlateStream.prototype.getCode = function FlateStream_getCode(table) {
                        var str = this.str;
                        var codes = table[0];
                        var maxLen = table[1];
                        var codeSize = this.codeSize;
                        var codeBuf = this.codeBuf;
                        var b;

                        while (codeSize < maxLen) {
                            if ((b = str.getByte()) === -1) {
                                break;
                            }

                            codeBuf |= b << codeSize;
                            codeSize += 8;
                        }

                        var code = codes[codeBuf & (1 << maxLen) - 1];
                        var codeLen = code >> 16;
                        var codeVal = code & 0xffff;

                        if (codeLen < 1 || codeSize < codeLen) {
                            throw new _util.FormatError("Bad encoding in flate stream");
                        }

                        this.codeBuf = codeBuf >> codeLen;
                        this.codeSize = codeSize - codeLen;
                        return codeVal;
                    };

                    FlateStream.prototype.generateHuffmanTable = function flateStreamGenerateHuffmanTable(lengths) {
                        var n = lengths.length;
                        var maxLen = 0;
                        var i;

                        for (i = 0; i < n; ++i) {
                            if (lengths[i] > maxLen) {
                                maxLen = lengths[i];
                            }
                        }

                        var size = 1 << maxLen;
                        var codes = new Int32Array(size);

                        for (var len = 1, code = 0, skip = 2; len <= maxLen; ++len, code <<= 1, skip <<= 1) {
                            for (var val = 0; val < n; ++val) {
                                if (lengths[val] === len) {
                                    var code2 = 0;
                                    var t = code;

                                    for (i = 0; i < len; ++i) {
                                        code2 = code2 << 1 | t & 1;
                                        t >>= 1;
                                    }

                                    for (i = code2; i < size; i += skip) {
                                        codes[i] = len << 16 | val;
                                    }

                                    ++code;
                                }
                            }
                        }

                        return [codes, maxLen];
                    };

                    FlateStream.prototype.readBlock = function FlateStream_readBlock() {
                        var buffer, len;
                        var str = this.str;
                        var hdr = this.getBits(3);

                        if (hdr & 1) {
                            this.eof = true;
                        }

                        hdr >>= 1;

                        if (hdr === 0) {
                            var b;

                            if ((b = str.getByte()) === -1) {
                                throw new _util.FormatError("Bad block header in flate stream");
                            }

                            var blockLen = b;

                            if ((b = str.getByte()) === -1) {
                                throw new _util.FormatError("Bad block header in flate stream");
                            }

                            blockLen |= b << 8;

                            if ((b = str.getByte()) === -1) {
                                throw new _util.FormatError("Bad block header in flate stream");
                            }

                            var check = b;

                            if ((b = str.getByte()) === -1) {
                                throw new _util.FormatError("Bad block header in flate stream");
                            }

                            check |= b << 8;

                            if (check !== (~blockLen & 0xffff) && (blockLen !== 0 || check !== 0)) {
                                throw new _util.FormatError("Bad uncompressed block length in flate stream");
                            }

                            this.codeBuf = 0;
                            this.codeSize = 0;
                            var bufferLength = this.bufferLength,
                                end          = bufferLength + blockLen;
                            buffer = this.ensureBuffer(end);
                            this.bufferLength = end;

                            if (blockLen === 0) {
                                if (str.peekByte() === -1) {
                                    this.eof = true;
                                }
                            } else {
                                var block = str.getBytes(blockLen);
                                buffer.set(block, bufferLength);

                                if (block.length < blockLen) {
                                    this.eof = true;
                                }
                            }

                            return;
                        }

                        var litCodeTable;
                        var distCodeTable;

                        if (hdr === 1) {
                            litCodeTable = fixedLitCodeTab;
                            distCodeTable = fixedDistCodeTab;
                        } else if (hdr === 2) {
                            var numLitCodes = this.getBits(5) + 257;
                            var numDistCodes = this.getBits(5) + 1;
                            var numCodeLenCodes = this.getBits(4) + 4;
                            var codeLenCodeLengths = new Uint8Array(codeLenCodeMap.length);
                            var i;

                            for (i = 0; i < numCodeLenCodes; ++i) {
                                codeLenCodeLengths[codeLenCodeMap[i]] = this.getBits(3);
                            }

                            var codeLenCodeTab = this.generateHuffmanTable(codeLenCodeLengths);
                            len = 0;
                            i = 0;
                            var codes = numLitCodes + numDistCodes;
                            var codeLengths = new Uint8Array(codes);
                            var bitsLength, bitsOffset, what;

                            while (i < codes) {
                                var code = this.getCode(codeLenCodeTab);

                                if (code === 16) {
                                    bitsLength = 2;
                                    bitsOffset = 3;
                                    what = len;
                                } else if (code === 17) {
                                    bitsLength = 3;
                                    bitsOffset = 3;
                                    what = len = 0;
                                } else if (code === 18) {
                                    bitsLength = 7;
                                    bitsOffset = 11;
                                    what = len = 0;
                                } else {
                                    codeLengths[i++] = len = code;
                                    continue;
                                }

                                var repeatLength = this.getBits(bitsLength) + bitsOffset;

                                while (repeatLength-- > 0) {
                                    codeLengths[i++] = what;
                                }
                            }

                            litCodeTable = this.generateHuffmanTable(codeLengths.subarray(0, numLitCodes));
                            distCodeTable = this.generateHuffmanTable(codeLengths.subarray(numLitCodes, codes));
                        } else {
                            throw new _util.FormatError("Unknown block type in flate stream");
                        }

                        buffer = this.buffer;
                        var limit = buffer ? buffer.length : 0;
                        var pos = this.bufferLength;

                        while (true) {
                            var code1 = this.getCode(litCodeTable);

                            if (code1 < 256) {
                                if (pos + 1 >= limit) {
                                    buffer = this.ensureBuffer(pos + 1);
                                    limit = buffer.length;
                                }

                                buffer[pos++] = code1;
                                continue;
                            }

                            if (code1 === 256) {
                                this.bufferLength = pos;
                                return;
                            }

                            code1 -= 257;
                            code1 = lengthDecode[code1];
                            var code2 = code1 >> 16;

                            if (code2 > 0) {
                                code2 = this.getBits(code2);
                            }

                            len = (code1 & 0xffff) + code2;
                            code1 = this.getCode(distCodeTable);
                            code1 = distDecode[code1];
                            code2 = code1 >> 16;

                            if (code2 > 0) {
                                code2 = this.getBits(code2);
                            }

                            var dist = (code1 & 0xffff) + code2;

                            if (pos + len >= limit) {
                                buffer = this.ensureBuffer(pos + len);
                                limit = buffer.length;
                            }

                            for (var k = 0; k < len; ++k, ++pos) {
                                buffer[pos] = buffer[pos - dist];
                            }
                        }
                    };

                    return FlateStream;
                }();

                exports.FlateStream = FlateStream;

                var PredictorStream = function PredictorStreamClosure() {
                    function PredictorStream(str, maybeLength, params) {
                        if (!(0, _primitives.isDict)(params)) {
                            return str;
                        }

                        var predictor = this.predictor = params.get("Predictor") || 1;

                        if (predictor <= 1) {
                            return str;
                        }

                        if (predictor !== 2 && (predictor < 10 || predictor > 15)) {
                            throw new _util.FormatError("Unsupported predictor: ".concat(predictor));
                        }

                        if (predictor === 2) {
                            this.readBlock = this.readBlockTiff;
                        } else {
                            this.readBlock = this.readBlockPng;
                        }

                        this.str = str;
                        this.dict = str.dict;
                        var colors = this.colors = params.get("Colors") || 1;
                        var bits = this.bits = params.get("BitsPerComponent") || 8;
                        var columns = this.columns = params.get("Columns") || 1;
                        this.pixBytes = colors * bits + 7 >> 3;
                        this.rowBytes = columns * colors * bits + 7 >> 3;
                        DecodeStream.call(this, maybeLength);
                        return this;
                    }

                    PredictorStream.prototype = Object.create(DecodeStream.prototype);

                    PredictorStream.prototype.readBlockTiff = function predictorStreamReadBlockTiff() {
                        var rowBytes = this.rowBytes;
                        var bufferLength = this.bufferLength;
                        var buffer = this.ensureBuffer(bufferLength + rowBytes);
                        var bits = this.bits;
                        var colors = this.colors;
                        var rawBytes = this.str.getBytes(rowBytes);
                        this.eof = !rawBytes.length;

                        if (this.eof) {
                            return;
                        }

                        var inbuf  = 0,
                            outbuf = 0;
                        var inbits  = 0,
                            outbits = 0;
                        var pos = bufferLength;
                        var i;

                        if (bits === 1 && colors === 1) {
                            for (i = 0; i < rowBytes; ++i) {
                                var c = rawBytes[i] ^ inbuf;
                                c ^= c >> 1;
                                c ^= c >> 2;
                                c ^= c >> 4;
                                inbuf = (c & 1) << 7;
                                buffer[pos++] = c;
                            }
                        } else if (bits === 8) {
                            for (i = 0; i < colors; ++i) {
                                buffer[pos++] = rawBytes[i];
                            }

                            for (; i < rowBytes; ++i) {
                                buffer[pos] = buffer[pos - colors] + rawBytes[i];
                                pos++;
                            }
                        } else if (bits === 16) {
                            var bytesPerPixel = colors * 2;

                            for (i = 0; i < bytesPerPixel; ++i) {
                                buffer[pos++] = rawBytes[i];
                            }

                            for (; i < rowBytes; i += 2) {
                                var sum = ((rawBytes[i] & 0xff) << 8) + (rawBytes[i + 1] & 0xff) + ((buffer[pos - bytesPerPixel] & 0xff) << 8) + (buffer[pos - bytesPerPixel + 1] & 0xff);
                                buffer[pos++] = sum >> 8 & 0xff;
                                buffer[pos++] = sum & 0xff;
                            }
                        } else {
                            var compArray = new Uint8Array(colors + 1);
                            var bitMask = (1 << bits) - 1;
                            var j = 0,
                                k = bufferLength;
                            var columns = this.columns;

                            for (i = 0; i < columns; ++i) {
                                for (var kk = 0; kk < colors; ++kk) {
                                    if (inbits < bits) {
                                        inbuf = inbuf << 8 | rawBytes[j++] & 0xff;
                                        inbits += 8;
                                    }

                                    compArray[kk] = compArray[kk] + (inbuf >> inbits - bits) & bitMask;
                                    inbits -= bits;
                                    outbuf = outbuf << bits | compArray[kk];
                                    outbits += bits;

                                    if (outbits >= 8) {
                                        buffer[k++] = outbuf >> outbits - 8 & 0xff;
                                        outbits -= 8;
                                    }
                                }
                            }

                            if (outbits > 0) {
                                buffer[k++] = (outbuf << 8 - outbits) + (inbuf & (1 << 8 - outbits) - 1);
                            }
                        }

                        this.bufferLength += rowBytes;
                    };

                    PredictorStream.prototype.readBlockPng = function predictorStreamReadBlockPng() {
                        var rowBytes = this.rowBytes;
                        var pixBytes = this.pixBytes;
                        var predictor = this.str.getByte();
                        var rawBytes = this.str.getBytes(rowBytes);
                        this.eof = !rawBytes.length;

                        if (this.eof) {
                            return;
                        }

                        var bufferLength = this.bufferLength;
                        var buffer = this.ensureBuffer(bufferLength + rowBytes);
                        var prevRow = buffer.subarray(bufferLength - rowBytes, bufferLength);

                        if (prevRow.length === 0) {
                            prevRow = new Uint8Array(rowBytes);
                        }

                        var i,
                            j = bufferLength,
                            up,
                            c;

                        switch (predictor) {
                            case 0:
                                for (i = 0; i < rowBytes; ++i) {
                                    buffer[j++] = rawBytes[i];
                                }

                                break;

                            case 1:
                                for (i = 0; i < pixBytes; ++i) {
                                    buffer[j++] = rawBytes[i];
                                }

                                for (; i < rowBytes; ++i) {
                                    buffer[j] = buffer[j - pixBytes] + rawBytes[i] & 0xff;
                                    j++;
                                }

                                break;

                            case 2:
                                for (i = 0; i < rowBytes; ++i) {
                                    buffer[j++] = prevRow[i] + rawBytes[i] & 0xff;
                                }

                                break;

                            case 3:
                                for (i = 0; i < pixBytes; ++i) {
                                    buffer[j++] = (prevRow[i] >> 1) + rawBytes[i];
                                }

                                for (; i < rowBytes; ++i) {
                                    buffer[j] = (prevRow[i] + buffer[j - pixBytes] >> 1) + rawBytes[i] & 0xff;
                                    j++;
                                }

                                break;

                            case 4:
                                for (i = 0; i < pixBytes; ++i) {
                                    up = prevRow[i];
                                    c = rawBytes[i];
                                    buffer[j++] = up + c;
                                }

                                for (; i < rowBytes; ++i) {
                                    up = prevRow[i];
                                    var upLeft = prevRow[i - pixBytes];
                                    var left = buffer[j - pixBytes];
                                    var p = left + up - upLeft;
                                    var pa = p - left;

                                    if (pa < 0) {
                                        pa = -pa;
                                    }

                                    var pb = p - up;

                                    if (pb < 0) {
                                        pb = -pb;
                                    }

                                    var pc = p - upLeft;

                                    if (pc < 0) {
                                        pc = -pc;
                                    }

                                    c = rawBytes[i];

                                    if (pa <= pb && pa <= pc) {
                                        buffer[j++] = left + c;
                                    } else if (pb <= pc) {
                                        buffer[j++] = up + c;
                                    } else {
                                        buffer[j++] = upLeft + c;
                                    }
                                }

                                break;

                            default:
                                throw new _util.FormatError("Unsupported predictor: ".concat(predictor));
                        }

                        this.bufferLength += rowBytes;
                    };

                    return PredictorStream;
                }();

                exports.PredictorStream = PredictorStream;

                var DecryptStream = function DecryptStreamClosure() {
                    function DecryptStream(str, maybeLength, decrypt) {
                        this.str = str;
                        this.dict = str.dict;
                        this.decrypt = decrypt;
                        this.nextChunk = null;
                        this.initialized = false;
                        DecodeStream.call(this, maybeLength);
                    }

                    var chunkSize = 512;
                    DecryptStream.prototype = Object.create(DecodeStream.prototype);

                    DecryptStream.prototype.readBlock = function DecryptStream_readBlock() {
                        var chunk;

                        if (this.initialized) {
                            chunk = this.nextChunk;
                        } else {
                            chunk = this.str.getBytes(chunkSize);
                            this.initialized = true;
                        }

                        if (!chunk || chunk.length === 0) {
                            this.eof = true;
                            return;
                        }

                        this.nextChunk = this.str.getBytes(chunkSize);
                        var hasMoreData = this.nextChunk && this.nextChunk.length > 0;
                        var decrypt = this.decrypt;
                        chunk = decrypt(chunk, !hasMoreData);
                        var bufferLength = this.bufferLength;
                        var i,
                            n = chunk.length;
                        var buffer = this.ensureBuffer(bufferLength + n);

                        for (i = 0; i < n; i++) {
                            buffer[bufferLength++] = chunk[i];
                        }

                        this.bufferLength = bufferLength;
                    };

                    return DecryptStream;
                }();

                exports.DecryptStream = DecryptStream;

                var Ascii85Stream = function Ascii85StreamClosure() {
                    function Ascii85Stream(str, maybeLength) {
                        this.str = str;
                        this.dict = str.dict;
                        this.input = new Uint8Array(5);

                        if (maybeLength) {
                            maybeLength = 0.8 * maybeLength;
                        }

                        DecodeStream.call(this, maybeLength);
                    }

                    Ascii85Stream.prototype = Object.create(DecodeStream.prototype);

                    Ascii85Stream.prototype.readBlock = function Ascii85Stream_readBlock() {
                        var TILDA_CHAR = 0x7e;
                        var Z_LOWER_CHAR = 0x7a;
                        var EOF = -1;
                        var str = this.str;
                        var c = str.getByte();

                        while ((0, _core_utils.isWhiteSpace)(c)) {
                            c = str.getByte();
                        }

                        if (c === EOF || c === TILDA_CHAR) {
                            this.eof = true;
                            return;
                        }

                        var bufferLength = this.bufferLength,
                            buffer;
                        var i;

                        if (c === Z_LOWER_CHAR) {
                            buffer = this.ensureBuffer(bufferLength + 4);

                            for (i = 0; i < 4; ++i) {
                                buffer[bufferLength + i] = 0;
                            }

                            this.bufferLength += 4;
                        } else {
                            var input = this.input;
                            input[0] = c;

                            for (i = 1; i < 5; ++i) {
                                c = str.getByte();

                                while ((0, _core_utils.isWhiteSpace)(c)) {
                                    c = str.getByte();
                                }

                                input[i] = c;

                                if (c === EOF || c === TILDA_CHAR) {
                                    break;
                                }
                            }

                            buffer = this.ensureBuffer(bufferLength + i - 1);
                            this.bufferLength += i - 1;

                            if (i < 5) {
                                for (; i < 5; ++i) {
                                    input[i] = 0x21 + 84;
                                }

                                this.eof = true;
                            }

                            var t = 0;

                            for (i = 0; i < 5; ++i) {
                                t = t * 85 + (input[i] - 0x21);
                            }

                            for (i = 3; i >= 0; --i) {
                                buffer[bufferLength + i] = t & 0xff;
                                t >>= 8;
                            }
                        }
                    };

                    return Ascii85Stream;
                }();

                exports.Ascii85Stream = Ascii85Stream;

                var AsciiHexStream = function AsciiHexStreamClosure() {
                    function AsciiHexStream(str, maybeLength) {
                        this.str = str;
                        this.dict = str.dict;
                        this.firstDigit = -1;

                        if (maybeLength) {
                            maybeLength = 0.5 * maybeLength;
                        }

                        DecodeStream.call(this, maybeLength);
                    }

                    AsciiHexStream.prototype = Object.create(DecodeStream.prototype);

                    AsciiHexStream.prototype.readBlock = function AsciiHexStream_readBlock() {
                        var UPSTREAM_BLOCK_SIZE = 8000;
                        var bytes = this.str.getBytes(UPSTREAM_BLOCK_SIZE);

                        if (!bytes.length) {
                            this.eof = true;
                            return;
                        }

                        var maxDecodeLength = bytes.length + 1 >> 1;
                        var buffer = this.ensureBuffer(this.bufferLength + maxDecodeLength);
                        var bufferLength = this.bufferLength;
                        var firstDigit = this.firstDigit;

                        for (var i = 0, ii = bytes.length; i < ii; i++) {
                            var ch = bytes[i],
                                digit;

                            if (ch >= 0x30 && ch <= 0x39) {
                                digit = ch & 0x0f;
                            } else if (ch >= 0x41 && ch <= 0x46 || ch >= 0x61 && ch <= 0x66) {
                                digit = (ch & 0x0f) + 9;
                            } else if (ch === 0x3e) {
                                this.eof = true;
                                break;
                            } else {
                                continue;
                            }

                            if (firstDigit < 0) {
                                firstDigit = digit;
                            } else {
                                buffer[bufferLength++] = firstDigit << 4 | digit;
                                firstDigit = -1;
                            }
                        }

                        if (firstDigit >= 0 && this.eof) {
                            buffer[bufferLength++] = firstDigit << 4;
                            firstDigit = -1;
                        }

                        this.firstDigit = firstDigit;
                        this.bufferLength = bufferLength;
                    };

                    return AsciiHexStream;
                }();

                exports.AsciiHexStream = AsciiHexStream;

                var RunLengthStream = function RunLengthStreamClosure() {
                    function RunLengthStream(str, maybeLength) {
                        this.str = str;
                        this.dict = str.dict;
                        DecodeStream.call(this, maybeLength);
                    }

                    RunLengthStream.prototype = Object.create(DecodeStream.prototype);

                    RunLengthStream.prototype.readBlock = function RunLengthStream_readBlock() {
                        var repeatHeader = this.str.getBytes(2);

                        if (!repeatHeader || repeatHeader.length < 2 || repeatHeader[0] === 128) {
                            this.eof = true;
                            return;
                        }

                        var buffer;
                        var bufferLength = this.bufferLength;
                        var n = repeatHeader[0];

                        if (n < 128) {
                            buffer = this.ensureBuffer(bufferLength + n + 1);
                            buffer[bufferLength++] = repeatHeader[1];

                            if (n > 0) {
                                var source = this.str.getBytes(n);
                                buffer.set(source, bufferLength);
                                bufferLength += n;
                            }
                        } else {
                            n = 257 - n;
                            var b = repeatHeader[1];
                            buffer = this.ensureBuffer(bufferLength + n + 1);

                            for (var i = 0; i < n; i++) {
                                buffer[bufferLength++] = b;
                            }
                        }

                        this.bufferLength = bufferLength;
                    };

                    return RunLengthStream;
                }();

                exports.RunLengthStream = RunLengthStream;

                var LZWStream = function LZWStreamClosure() {
                    function LZWStream(str, maybeLength, earlyChange) {
                        this.str = str;
                        this.dict = str.dict;
                        this.cachedData = 0;
                        this.bitsCached = 0;
                        var maxLzwDictionarySize = 4096;
                        var lzwState = {
                            earlyChange           : earlyChange,
                            codeLength            : 9,
                            nextCode              : 258,
                            dictionaryValues      : new Uint8Array(maxLzwDictionarySize),
                            dictionaryLengths     : new Uint16Array(maxLzwDictionarySize),
                            dictionaryPrevCodes   : new Uint16Array(maxLzwDictionarySize),
                            currentSequence       : new Uint8Array(maxLzwDictionarySize),
                            currentSequenceLength : 0
                        };

                        for (var i = 0; i < 256; ++i) {
                            lzwState.dictionaryValues[i] = i;
                            lzwState.dictionaryLengths[i] = 1;
                        }

                        this.lzwState = lzwState;
                        DecodeStream.call(this, maybeLength);
                    }

                    LZWStream.prototype = Object.create(DecodeStream.prototype);

                    LZWStream.prototype.readBits = function LZWStream_readBits(n) {
                        var bitsCached = this.bitsCached;
                        var cachedData = this.cachedData;

                        while (bitsCached < n) {
                            var c = this.str.getByte();

                            if (c === -1) {
                                this.eof = true;
                                return null;
                            }

                            cachedData = cachedData << 8 | c;
                            bitsCached += 8;
                        }

                        this.bitsCached = bitsCached -= n;
                        this.cachedData = cachedData;
                        this.lastCode = null;
                        return cachedData >>> bitsCached & (1 << n) - 1;
                    };

                    LZWStream.prototype.readBlock = function LZWStream_readBlock() {
                        var blockSize = 512;
                        var estimatedDecodedSize = blockSize * 2,
                            decodedSizeDelta     = blockSize;
                        var i, j, q;
                        var lzwState = this.lzwState;

                        if (!lzwState) {
                            return;
                        }

                        var earlyChange = lzwState.earlyChange;
                        var nextCode = lzwState.nextCode;
                        var dictionaryValues = lzwState.dictionaryValues;
                        var dictionaryLengths = lzwState.dictionaryLengths;
                        var dictionaryPrevCodes = lzwState.dictionaryPrevCodes;
                        var codeLength = lzwState.codeLength;
                        var prevCode = lzwState.prevCode;
                        var currentSequence = lzwState.currentSequence;
                        var currentSequenceLength = lzwState.currentSequenceLength;
                        var decodedLength = 0;
                        var currentBufferLength = this.bufferLength;
                        var buffer = this.ensureBuffer(this.bufferLength + estimatedDecodedSize);

                        for (i = 0; i < blockSize; i++) {
                            var code = this.readBits(codeLength);
                            var hasPrev = currentSequenceLength > 0;

                            if (code < 256) {
                                currentSequence[0] = code;
                                currentSequenceLength = 1;
                            } else if (code >= 258) {
                                if (code < nextCode) {
                                    currentSequenceLength = dictionaryLengths[code];

                                    for (j = currentSequenceLength - 1, q = code; j >= 0; j--) {
                                        currentSequence[j] = dictionaryValues[q];
                                        q = dictionaryPrevCodes[q];
                                    }
                                } else {
                                    currentSequence[currentSequenceLength++] = currentSequence[0];
                                }
                            } else if (code === 256) {
                                codeLength = 9;
                                nextCode = 258;
                                currentSequenceLength = 0;
                                continue;
                            } else {
                                this.eof = true;
                                delete this.lzwState;
                                break;
                            }

                            if (hasPrev) {
                                dictionaryPrevCodes[nextCode] = prevCode;
                                dictionaryLengths[nextCode] = dictionaryLengths[prevCode] + 1;
                                dictionaryValues[nextCode] = currentSequence[0];
                                nextCode++;
                                codeLength = nextCode + earlyChange & nextCode + earlyChange - 1 ? codeLength : Math.min(Math.log(nextCode + earlyChange) / 0.6931471805599453 + 1, 12) | 0;
                            }

                            prevCode = code;
                            decodedLength += currentSequenceLength;

                            if (estimatedDecodedSize < decodedLength) {
                                do {
                                    estimatedDecodedSize += decodedSizeDelta;
                                } while (estimatedDecodedSize < decodedLength);

                                buffer = this.ensureBuffer(this.bufferLength + estimatedDecodedSize);
                            }

                            for (j = 0; j < currentSequenceLength; j++) {
                                buffer[currentBufferLength++] = currentSequence[j];
                            }
                        }

                        lzwState.nextCode = nextCode;
                        lzwState.codeLength = codeLength;
                        lzwState.prevCode = prevCode;
                        lzwState.currentSequenceLength = currentSequenceLength;
                        this.bufferLength = currentBufferLength;
                    };

                    return LZWStream;
                }();

                exports.LZWStream = LZWStream;

                var NullStream = function NullStreamClosure() {
                    function NullStream() {
                        Stream.call(this, new Uint8Array(0));
                    }

                    NullStream.prototype = Stream.prototype;
                    return NullStream;
                }();

                exports.NullStream = NullStream;

                /***/
            }),
            /* 133 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.CCITTFaxStream = void 0;

                var _primitives = __w_pdfjs_require__(125);

                var _ccitt = __w_pdfjs_require__(134);

                var _stream = __w_pdfjs_require__(132);

                var CCITTFaxStream = function CCITTFaxStreamClosure() {
                    function CCITTFaxStream(str, maybeLength, params) {
                        this.str = str;
                        this.dict = str.dict;

                        if (!(0, _primitives.isDict)(params)) {
                            params = _primitives.Dict.empty;
                        }

                        var source = {
                            next : function next() {
                                return str.getByte();
                            }
                        };
                        this.ccittFaxDecoder = new _ccitt.CCITTFaxDecoder(source, {
                            K                : params.get("K"),
                            EndOfLine        : params.get("EndOfLine"),
                            EncodedByteAlign : params.get("EncodedByteAlign"),
                            Columns          : params.get("Columns"),
                            Rows             : params.get("Rows"),
                            EndOfBlock       : params.get("EndOfBlock"),
                            BlackIs1         : params.get("BlackIs1")
                        });

                        _stream.DecodeStream.call(this, maybeLength);
                    }

                    CCITTFaxStream.prototype = Object.create(_stream.DecodeStream.prototype);

                    CCITTFaxStream.prototype.readBlock = function() {
                        while (!this.eof) {
                            var c = this.ccittFaxDecoder.readNextChar();

                            if (c === -1) {
                                this.eof = true;
                                return;
                            }

                            this.ensureBuffer(this.bufferLength + 1);
                            this.buffer[this.bufferLength++] = c;
                        }
                    };

                    return CCITTFaxStream;
                }();

                exports.CCITTFaxStream = CCITTFaxStream;

                /***/
            }),
            /* 134 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.CCITTFaxDecoder = void 0;

                var _util = __w_pdfjs_require__(4);

                var CCITTFaxDecoder = function CCITTFaxDecoder() {
                    var ccittEOL = -2;
                    var ccittEOF = -1;
                    var twoDimPass = 0;
                    var twoDimHoriz = 1;
                    var twoDimVert0 = 2;
                    var twoDimVertR1 = 3;
                    var twoDimVertL1 = 4;
                    var twoDimVertR2 = 5;
                    var twoDimVertL2 = 6;
                    var twoDimVertR3 = 7;
                    var twoDimVertL3 = 8;
                    var twoDimTable = [[-1, -1], [-1, -1], [7, twoDimVertL3], [7, twoDimVertR3], [6, twoDimVertL2], [6, twoDimVertL2], [6, twoDimVertR2], [6, twoDimVertR2], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0]];
                    var whiteTable1 = [[-1, -1], [12, ccittEOL], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [11, 1792], [11, 1792], [12, 1984], [12, 2048], [12, 2112], [12, 2176], [12, 2240], [12, 2304], [11, 1856], [11, 1856], [11, 1920], [11, 1920], [12, 2368], [12, 2432], [12, 2496], [12, 2560]];
                    var whiteTable2 = [[-1, -1], [-1, -1], [-1, -1], [-1, -1], [8, 29], [8, 29], [8, 30], [8, 30], [8, 45], [8, 45], [8, 46], [8, 46], [7, 22], [7, 22], [7, 22], [7, 22], [7, 23], [7, 23], [7, 23], [7, 23], [8, 47], [8, 47], [8, 48], [8, 48], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [7, 20], [7, 20], [7, 20], [7, 20], [8, 33], [8, 33], [8, 34], [8, 34], [8, 35], [8, 35], [8, 36], [8, 36], [8, 37], [8, 37], [8, 38], [8, 38], [7, 19], [7, 19], [7, 19], [7, 19], [8, 31], [8, 31], [8, 32], [8, 32], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [8, 53], [8, 53], [8, 54], [8, 54], [7, 26], [7, 26], [7, 26], [7, 26], [8, 39], [8, 39], [8, 40], [8, 40], [8, 41], [8, 41], [8, 42], [8, 42], [8, 43], [8, 43], [8, 44], [8, 44], [7, 21], [7, 21], [7, 21], [7, 21], [7, 28], [7, 28], [7, 28], [7, 28], [8, 61], [8, 61], [8, 62], [8, 62], [8, 63], [8, 63], [8, 0], [8, 0], [8, 320], [8, 320], [8, 384], [8, 384], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [7, 27], [7, 27], [7, 27], [7, 27], [8, 59], [8, 59], [8, 60], [8, 60], [9, 1472], [9, 1536], [9, 1600], [9, 1728], [7, 18], [7, 18], [7, 18], [7, 18], [7, 24], [7, 24], [7, 24], [7, 24], [8, 49], [8, 49], [8, 50], [8, 50], [8, 51], [8, 51], [8, 52], [8, 52], [7, 25], [7, 25], [7, 25], [7, 25], [8, 55], [8, 55], [8, 56], [8, 56], [8, 57], [8, 57], [8, 58], [8, 58], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [8, 448], [8, 448], [8, 512], [8, 512], [9, 704], [9, 768], [8, 640], [8, 640], [8, 576], [8, 576], [9, 832], [9, 896], [9, 960], [9, 1024], [9, 1088], [9, 1152], [9, 1216], [9, 1280], [9, 1344], [9, 1408], [7, 256], [7, 256], [7, 256], [7, 256], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7]];
                    var blackTable1 = [[-1, -1], [-1, -1], [12, ccittEOL], [12, ccittEOL], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [11, 1792], [11, 1792], [11, 1792], [11, 1792], [12, 1984], [12, 1984], [12, 2048], [12, 2048], [12, 2112], [12, 2112], [12, 2176], [12, 2176], [12, 2240], [12, 2240], [12, 2304], [12, 2304], [11, 1856], [11, 1856], [11, 1856], [11, 1856], [11, 1920], [11, 1920], [11, 1920], [11, 1920], [12, 2368], [12, 2368], [12, 2432], [12, 2432], [12, 2496], [12, 2496], [12, 2560], [12, 2560], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [12, 52], [12, 52], [13, 640], [13, 704], [13, 768], [13, 832], [12, 55], [12, 55], [12, 56], [12, 56], [13, 1280], [13, 1344], [13, 1408], [13, 1472], [12, 59], [12, 59], [12, 60], [12, 60], [13, 1536], [13, 1600], [11, 24], [11, 24], [11, 24], [11, 24], [11, 25], [11, 25], [11, 25], [11, 25], [13, 1664], [13, 1728], [12, 320], [12, 320], [12, 384], [12, 384], [12, 448], [12, 448], [13, 512], [13, 576], [12, 53], [12, 53], [12, 54], [12, 54], [13, 896], [13, 960], [13, 1024], [13, 1088], [13, 1152], [13, 1216], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64]];
                    var blackTable2 = [[8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [11, 23], [11, 23], [12, 50], [12, 51], [12, 44], [12, 45], [12, 46], [12, 47], [12, 57], [12, 58], [12, 61], [12, 256], [10, 16], [10, 16], [10, 16], [10, 16], [10, 17], [10, 17], [10, 17], [10, 17], [12, 48], [12, 49], [12, 62], [12, 63], [12, 30], [12, 31], [12, 32], [12, 33], [12, 40], [12, 41], [11, 22], [11, 22], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [12, 128], [12, 192], [12, 26], [12, 27], [12, 28], [12, 29], [11, 19], [11, 19], [11, 20], [11, 20], [12, 34], [12, 35], [12, 36], [12, 37], [12, 38], [12, 39], [11, 21], [11, 21], [12, 42], [12, 43], [10, 0], [10, 0], [10, 0], [10, 0], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12]];
                    var blackTable3 = [[-1, -1], [-1, -1], [-1, -1], [-1, -1], [6, 9], [6, 8], [5, 7], [5, 7], [4, 6], [4, 6], [4, 6], [4, 6], [4, 5], [4, 5], [4, 5], [4, 5], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2]];

                    function CCITTFaxDecoder(source) {
                        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

                        if (!source || typeof source.next !== "function") {
                            throw new Error('CCITTFaxDecoder - invalid "source" parameter.');
                        }

                        this.source = source;
                        this.eof = false;
                        this.encoding = options.K || 0;
                        this.eoline = options.EndOfLine || false;
                        this.byteAlign = options.EncodedByteAlign || false;
                        this.columns = options.Columns || 1728;
                        this.rows = options.Rows || 0;
                        var eoblock = options.EndOfBlock;

                        if (eoblock === null || eoblock === undefined) {
                            eoblock = true;
                        }

                        this.eoblock = eoblock;
                        this.black = options.BlackIs1 || false;
                        this.codingLine = new Uint32Array(this.columns + 1);
                        this.refLine = new Uint32Array(this.columns + 2);
                        this.codingLine[0] = this.columns;
                        this.codingPos = 0;
                        this.row = 0;
                        this.nextLine2D = this.encoding < 0;
                        this.inputBits = 0;
                        this.inputBuf = 0;
                        this.outputBits = 0;
                        this.rowsDone = false;
                        var code1;

                        while ((code1 = this._lookBits(12)) === 0) {
                            this._eatBits(1);
                        }

                        if (code1 === 1) {
                            this._eatBits(12);
                        }

                        if (this.encoding > 0) {
                            this.nextLine2D = !this._lookBits(1);

                            this._eatBits(1);
                        }
                    }

                    CCITTFaxDecoder.prototype = {
                        readNextChar   : function readNextChar() {
                            if (this.eof) {
                                return -1;
                            }

                            var refLine = this.refLine;
                            var codingLine = this.codingLine;
                            var columns = this.columns;
                            var refPos, blackPixels, bits, i;

                            if (this.outputBits === 0) {
                                if (this.rowsDone) {
                                    this.eof = true;
                                }

                                if (this.eof) {
                                    return -1;
                                }

                                this.err = false;
                                var code1, code2, code3;

                                if (this.nextLine2D) {
                                    for (i = 0; codingLine[i] < columns; ++i) {
                                        refLine[i] = codingLine[i];
                                    }

                                    refLine[i++] = columns;
                                    refLine[i] = columns;
                                    codingLine[0] = 0;
                                    this.codingPos = 0;
                                    refPos = 0;
                                    blackPixels = 0;

                                    while (codingLine[this.codingPos] < columns) {
                                        code1 = this._getTwoDimCode();

                                        switch (code1) {
                                            case twoDimPass:
                                                this._addPixels(refLine[refPos + 1], blackPixels);

                                                if (refLine[refPos + 1] < columns) {
                                                    refPos += 2;
                                                }

                                                break;

                                            case twoDimHoriz:
                                                code1 = code2 = 0;

                                                if (blackPixels) {
                                                    do {
                                                        code1 += code3 = this._getBlackCode();
                                                    } while (code3 >= 64);

                                                    do {
                                                        code2 += code3 = this._getWhiteCode();
                                                    } while (code3 >= 64);
                                                } else {
                                                    do {
                                                        code1 += code3 = this._getWhiteCode();
                                                    } while (code3 >= 64);

                                                    do {
                                                        code2 += code3 = this._getBlackCode();
                                                    } while (code3 >= 64);
                                                }

                                                this._addPixels(codingLine[this.codingPos] + code1, blackPixels);

                                                if (codingLine[this.codingPos] < columns) {
                                                    this._addPixels(codingLine[this.codingPos] + code2, blackPixels ^ 1);
                                                }

                                                while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                                                    refPos += 2;
                                                }

                                                break;

                                            case twoDimVertR3:
                                                this._addPixels(refLine[refPos] + 3, blackPixels);

                                                blackPixels ^= 1;

                                                if (codingLine[this.codingPos] < columns) {
                                                    ++refPos;

                                                    while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                                                        refPos += 2;
                                                    }
                                                }

                                                break;

                                            case twoDimVertR2:
                                                this._addPixels(refLine[refPos] + 2, blackPixels);

                                                blackPixels ^= 1;

                                                if (codingLine[this.codingPos] < columns) {
                                                    ++refPos;

                                                    while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                                                        refPos += 2;
                                                    }
                                                }

                                                break;

                                            case twoDimVertR1:
                                                this._addPixels(refLine[refPos] + 1, blackPixels);

                                                blackPixels ^= 1;

                                                if (codingLine[this.codingPos] < columns) {
                                                    ++refPos;

                                                    while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                                                        refPos += 2;
                                                    }
                                                }

                                                break;

                                            case twoDimVert0:
                                                this._addPixels(refLine[refPos], blackPixels);

                                                blackPixels ^= 1;

                                                if (codingLine[this.codingPos] < columns) {
                                                    ++refPos;

                                                    while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                                                        refPos += 2;
                                                    }
                                                }

                                                break;

                                            case twoDimVertL3:
                                                this._addPixelsNeg(refLine[refPos] - 3, blackPixels);

                                                blackPixels ^= 1;

                                                if (codingLine[this.codingPos] < columns) {
                                                    if (refPos > 0) {
                                                        --refPos;
                                                    } else {
                                                        ++refPos;
                                                    }

                                                    while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                                                        refPos += 2;
                                                    }
                                                }

                                                break;

                                            case twoDimVertL2:
                                                this._addPixelsNeg(refLine[refPos] - 2, blackPixels);

                                                blackPixels ^= 1;

                                                if (codingLine[this.codingPos] < columns) {
                                                    if (refPos > 0) {
                                                        --refPos;
                                                    } else {
                                                        ++refPos;
                                                    }

                                                    while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                                                        refPos += 2;
                                                    }
                                                }

                                                break;

                                            case twoDimVertL1:
                                                this._addPixelsNeg(refLine[refPos] - 1, blackPixels);

                                                blackPixels ^= 1;

                                                if (codingLine[this.codingPos] < columns) {
                                                    if (refPos > 0) {
                                                        --refPos;
                                                    } else {
                                                        ++refPos;
                                                    }

                                                    while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                                                        refPos += 2;
                                                    }
                                                }

                                                break;

                                            case ccittEOF:
                                                this._addPixels(columns, 0);

                                                this.eof = true;
                                                break;

                                            default:
                                                (0, _util.info)("bad 2d code");

                                                this._addPixels(columns, 0);

                                                this.err = true;
                                        }
                                    }
                                } else {
                                    codingLine[0] = 0;
                                    this.codingPos = 0;
                                    blackPixels = 0;

                                    while (codingLine[this.codingPos] < columns) {
                                        code1 = 0;

                                        if (blackPixels) {
                                            do {
                                                code1 += code3 = this._getBlackCode();
                                            } while (code3 >= 64);
                                        } else {
                                            do {
                                                code1 += code3 = this._getWhiteCode();
                                            } while (code3 >= 64);
                                        }

                                        this._addPixels(codingLine[this.codingPos] + code1, blackPixels);

                                        blackPixels ^= 1;
                                    }
                                }

                                var gotEOL = false;

                                if (this.byteAlign) {
                                    this.inputBits &= ~7;
                                }

                                if (!this.eoblock && this.row === this.rows - 1) {
                                    this.rowsDone = true;
                                } else {
                                    code1 = this._lookBits(12);

                                    if (this.eoline) {
                                        while (code1 !== ccittEOF && code1 !== 1) {
                                            this._eatBits(1);

                                            code1 = this._lookBits(12);
                                        }
                                    } else {
                                        while (code1 === 0) {
                                            this._eatBits(1);

                                            code1 = this._lookBits(12);
                                        }
                                    }

                                    if (code1 === 1) {
                                        this._eatBits(12);

                                        gotEOL = true;
                                    } else if (code1 === ccittEOF) {
                                        this.eof = true;
                                    }
                                }

                                if (!this.eof && this.encoding > 0 && !this.rowsDone) {
                                    this.nextLine2D = !this._lookBits(1);

                                    this._eatBits(1);
                                }

                                if (this.eoblock && gotEOL && this.byteAlign) {
                                    code1 = this._lookBits(12);

                                    if (code1 === 1) {
                                        this._eatBits(12);

                                        if (this.encoding > 0) {
                                            this._lookBits(1);

                                            this._eatBits(1);
                                        }

                                        if (this.encoding >= 0) {
                                            for (i = 0; i < 4; ++i) {
                                                code1 = this._lookBits(12);

                                                if (code1 !== 1) {
                                                    (0, _util.info)("bad rtc code: " + code1);
                                                }

                                                this._eatBits(12);

                                                if (this.encoding > 0) {
                                                    this._lookBits(1);

                                                    this._eatBits(1);
                                                }
                                            }
                                        }

                                        this.eof = true;
                                    }
                                } else if (this.err && this.eoline) {
                                    while (true) {
                                        code1 = this._lookBits(13);

                                        if (code1 === ccittEOF) {
                                            this.eof = true;
                                            return -1;
                                        }

                                        if (code1 >> 1 === 1) {
                                            break;
                                        }

                                        this._eatBits(1);
                                    }

                                    this._eatBits(12);

                                    if (this.encoding > 0) {
                                        this._eatBits(1);

                                        this.nextLine2D = !(code1 & 1);
                                    }
                                }

                                if (codingLine[0] > 0) {
                                    this.outputBits = codingLine[this.codingPos = 0];
                                } else {
                                    this.outputBits = codingLine[this.codingPos = 1];
                                }

                                this.row++;
                            }

                            var c;

                            if (this.outputBits >= 8) {
                                c = this.codingPos & 1 ? 0 : 0xff;
                                this.outputBits -= 8;

                                if (this.outputBits === 0 && codingLine[this.codingPos] < columns) {
                                    this.codingPos++;
                                    this.outputBits = codingLine[this.codingPos] - codingLine[this.codingPos - 1];
                                }
                            } else {
                                bits = 8;
                                c = 0;

                                do {
                                    if (this.outputBits > bits) {
                                        c <<= bits;

                                        if (!(this.codingPos & 1)) {
                                            c |= 0xff >> 8 - bits;
                                        }

                                        this.outputBits -= bits;
                                        bits = 0;
                                    } else {
                                        c <<= this.outputBits;

                                        if (!(this.codingPos & 1)) {
                                            c |= 0xff >> 8 - this.outputBits;
                                        }

                                        bits -= this.outputBits;
                                        this.outputBits = 0;

                                        if (codingLine[this.codingPos] < columns) {
                                            this.codingPos++;
                                            this.outputBits = codingLine[this.codingPos] - codingLine[this.codingPos - 1];
                                        } else if (bits > 0) {
                                            c <<= bits;
                                            bits = 0;
                                        }
                                    }
                                } while (bits);
                            }

                            if (this.black) {
                                c ^= 0xff;
                            }

                            return c;
                        },
                        _addPixels     : function _addPixels(a1, blackPixels) {
                            var codingLine = this.codingLine;
                            var codingPos = this.codingPos;

                            if (a1 > codingLine[codingPos]) {
                                if (a1 > this.columns) {
                                    (0, _util.info)("row is wrong length");
                                    this.err = true;
                                    a1 = this.columns;
                                }

                                if (codingPos & 1 ^ blackPixels) {
                                    ++codingPos;
                                }

                                codingLine[codingPos] = a1;
                            }

                            this.codingPos = codingPos;
                        },
                        _addPixelsNeg  : function _addPixelsNeg(a1, blackPixels) {
                            var codingLine = this.codingLine;
                            var codingPos = this.codingPos;

                            if (a1 > codingLine[codingPos]) {
                                if (a1 > this.columns) {
                                    (0, _util.info)("row is wrong length");
                                    this.err = true;
                                    a1 = this.columns;
                                }

                                if (codingPos & 1 ^ blackPixels) {
                                    ++codingPos;
                                }

                                codingLine[codingPos] = a1;
                            } else if (a1 < codingLine[codingPos]) {
                                if (a1 < 0) {
                                    (0, _util.info)("invalid code");
                                    this.err = true;
                                    a1 = 0;
                                }

                                while (codingPos > 0 && a1 < codingLine[codingPos - 1]) {
                                    --codingPos;
                                }

                                codingLine[codingPos] = a1;
                            }

                            this.codingPos = codingPos;
                        },
                        _findTableCode : function _findTableCode(start, end, table, limit) {
                            var limitValue = limit || 0;

                            for (var i = start; i <= end; ++i) {
                                var code = this._lookBits(i);

                                if (code === ccittEOF) {
                                    return [true, 1, false];
                                }

                                if (i < end) {
                                    code <<= end - i;
                                }

                                if (!limitValue || code >= limitValue) {
                                    var p = table[code - limitValue];

                                    if (p[0] === i) {
                                        this._eatBits(i);

                                        return [true, p[1], true];
                                    }
                                }
                            }

                            return [false, 0, false];
                        },
                        _getTwoDimCode : function _getTwoDimCode() {
                            var code = 0;
                            var p;

                            if (this.eoblock) {
                                code = this._lookBits(7);
                                p = twoDimTable[code];

                                if (p && p[0] > 0) {
                                    this._eatBits(p[0]);

                                    return p[1];
                                }
                            } else {
                                var result = this._findTableCode(1, 7, twoDimTable);

                                if (result[0] && result[2]) {
                                    return result[1];
                                }
                            }

                            (0, _util.info)("Bad two dim code");
                            return ccittEOF;
                        },
                        _getWhiteCode  : function _getWhiteCode() {
                            var code = 0;
                            var p;

                            if (this.eoblock) {
                                code = this._lookBits(12);

                                if (code === ccittEOF) {
                                    return 1;
                                }

                                if (code >> 5 === 0) {
                                    p = whiteTable1[code];
                                } else {
                                    p = whiteTable2[code >> 3];
                                }

                                if (p[0] > 0) {
                                    this._eatBits(p[0]);

                                    return p[1];
                                }
                            } else {
                                var result = this._findTableCode(1, 9, whiteTable2);

                                if (result[0]) {
                                    return result[1];
                                }

                                result = this._findTableCode(11, 12, whiteTable1);

                                if (result[0]) {
                                    return result[1];
                                }
                            }

                            (0, _util.info)("bad white code");

                            this._eatBits(1);

                            return 1;
                        },
                        _getBlackCode  : function _getBlackCode() {
                            var code, p;

                            if (this.eoblock) {
                                code = this._lookBits(13);

                                if (code === ccittEOF) {
                                    return 1;
                                }

                                if (code >> 7 === 0) {
                                    p = blackTable1[code];
                                } else if (code >> 9 === 0 && code >> 7 !== 0) {
                                    p = blackTable2[(code >> 1) - 64];
                                } else {
                                    p = blackTable3[code >> 7];
                                }

                                if (p[0] > 0) {
                                    this._eatBits(p[0]);

                                    return p[1];
                                }
                            } else {
                                var result = this._findTableCode(2, 6, blackTable3);

                                if (result[0]) {
                                    return result[1];
                                }

                                result = this._findTableCode(7, 12, blackTable2, 64);

                                if (result[0]) {
                                    return result[1];
                                }

                                result = this._findTableCode(10, 13, blackTable1);

                                if (result[0]) {
                                    return result[1];
                                }
                            }

                            (0, _util.info)("bad black code");

                            this._eatBits(1);

                            return 1;
                        },
                        _lookBits      : function _lookBits(n) {
                            var c;

                            while (this.inputBits < n) {
                                if ((c = this.source.next()) === -1) {
                                    if (this.inputBits === 0) {
                                        return ccittEOF;
                                    }

                                    return this.inputBuf << n - this.inputBits & 0xffff >> 16 - n;
                                }

                                this.inputBuf = this.inputBuf << 8 | c;
                                this.inputBits += 8;
                            }

                            return this.inputBuf >> this.inputBits - n & 0xffff >> 16 - n;
                        },
                        _eatBits       : function _eatBits(n) {
                            if ((this.inputBits -= n) < 0) {
                                this.inputBits = 0;
                            }
                        }
                    };
                    return CCITTFaxDecoder;
                }();

                exports.CCITTFaxDecoder = CCITTFaxDecoder;

                /***/
            }),
            /* 135 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.Jbig2Stream = void 0;

                var _primitives = __w_pdfjs_require__(125);

                var _stream = __w_pdfjs_require__(132);

                var _jbig = __w_pdfjs_require__(136);

                var _util = __w_pdfjs_require__(4);

                var Jbig2Stream = function Jbig2StreamClosure() {
                    function Jbig2Stream(stream, maybeLength, dict, params) {
                        this.stream = stream;
                        this.maybeLength = maybeLength;
                        this.dict = dict;
                        this.params = params;

                        _stream.DecodeStream.call(this, maybeLength);
                    }

                    Jbig2Stream.prototype = Object.create(_stream.DecodeStream.prototype);
                    Object.defineProperty(Jbig2Stream.prototype, "bytes", {
                        get          : function get() {
                            return (0, _util.shadow)(this, "bytes", this.stream.getBytes(this.maybeLength));
                        },
                        configurable : true
                    });

                    Jbig2Stream.prototype.ensureBuffer = function(requested) {
                    };

                    Jbig2Stream.prototype.readBlock = function() {
                        if (this.eof) {
                            return;
                        }

                        var jbig2Image = new _jbig.Jbig2Image();
                        var chunks = [];

                        if ((0, _primitives.isDict)(this.params)) {
                            var globalsStream = this.params.get("JBIG2Globals");

                            if ((0, _primitives.isStream)(globalsStream)) {
                                var globals = globalsStream.getBytes();
                                chunks.push({
                                    data  : globals,
                                    start : 0,
                                    end   : globals.length
                                });
                            }
                        }

                        chunks.push({
                            data  : this.bytes,
                            start : 0,
                            end   : this.bytes.length
                        });
                        var data = jbig2Image.parseChunks(chunks);
                        var dataLength = data.length;

                        for (var i = 0; i < dataLength; i++) {
                            data[i] ^= 0xff;
                        }

                        this.buffer = data;
                        this.bufferLength = dataLength;
                        this.eof = true;
                    };

                    return Jbig2Stream;
                }();

                exports.Jbig2Stream = Jbig2Stream;

                /***/
            }),
            /* 136 */
            /***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

                "use strict";

                function _typeof(obj) {
                    "@babel/helpers - typeof";
                    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
                        _typeof = function _typeof(obj) {
                            return typeof obj;
                        };
                    } else {
                        _typeof = function _typeof(obj) {
                            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                        };
                    }
                    return _typeof(obj);
                }

                Object.defineProperty(exports, "__esModule", ({
                    value : true
                }));
                exports.Jbig2Image = void 0;

                var _util = __w_pdfjs_require__(4);

                var _core_utils = __w_pdfjs_require__(128);

                var _arithmetic_decoder = __w_pdfjs_require__(137);

                var _ccitt = __w_pdfjs_require__(134);

                function _classCallCheck(instance, Constructor) {
                    if (!(instance instanceof Constructor)) {
                        throw new TypeError("Cannot call a class as a function");
                    }
                }

                function _inherits(subClass, superClass) {
                    if (typeof superClass !== "function" && superClass !== null) {
                        throw new TypeError("Super expression must either be null or a function");
                    }
                    subClass.prototype = Object.create(superClass && superClass.prototype, {
                        constructor : {
                            value        : subClass,
                            writable     : true,
                            configurable : true
                        }
                    });
                    if (superClass) _setPrototypeOf(subClass, superClass);
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
                        o.__proto__ = p;
                        return o;
                    };
                    return _setPrototypeOf(o, p);
                }

                function _createSuper(Derived) {
                    var hasNativeReflectConstruct = _isNativeReflectConstruct();
                    return function _createSuperInternal() {
                        var Super = _getPrototypeOf(Derived), result;
                        if (hasNativeReflectConstruct) {
                            var NewTarget = _getPrototypeOf(this).constructor;
                            result = Reflect.construct(Super, arguments, NewTarget);
                        } else {
                            result = Super.apply(this, arguments);
                        }
                        return _possibleConstructorReturn(this, result);
                    };
                }

                function _possibleConstructorReturn(self, call) {
                    if (call && (_typeof(call) === "object" || typeof call === "function")) {
                        return call;
                    }
                    return _assertThisInitialized(self);
                }

                function _assertThisInitialized(self) {
                    if (self === void 0) {
                        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                    }
                    return self;
                }

                function _isNativeReflectConstruct() {
                    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
                    if (Reflect.construct.sham) return false;
                    if (typeof Proxy === "function") return true;
                    try {
                        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
                        }));
                        return true;
                    } catch (e) {
                        return false;
                    }
                }

                function _getPrototypeOf(o) {
                    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
                        return o.__proto__ || Object.getPrototypeOf(o);
                    };
                    return _getPrototypeOf(o);
                }

                var Jbig2Error = /*#__PURE__*/function(_BaseException) {
                    _inherits(Jbig2Error, _BaseException);

                    var _super = _createSuper(Jbig2Error);

                    function Jbig2Error(msg) {
                        _classCallCheck(this, Jbig2Error);

                        return _super.call(this, "JBIG2 error: ".concat(msg));
                    }

                    return Jbig2Error;
                }(_util.BaseException);

                var Jbig2Image = function Jbig2ImageClosure() {
                    function ContextCache() {
                    }

                    ContextCache.prototype = {
                        getContexts : function getContexts(id) {
                            if (id in this) {
                                return this[id];
                            }

                            return this[id] = new Int8Array(1 << 16);
                        }
                    };

                    function DecodingContext(data, start, end) {
                        this.data = data;
                        this.start = start;
                        this.end = end;
                    }

                    DecodingContext.prototype = {
                        get decoder() {
                            var decoder = new _arithmetic_decoder.ArithmeticDecoder(this.data, this.start, this.end);
                            return (0, _util.shadow)(this, "decoder", decoder);
                        },

                        get contextCache() {
                            var cache = new ContextCache();
                            return (0, _util.shadow)(this, "contextCache", cache);
                        }

                    };

                    function decodeInteger(contextCache, procedure, decoder) {
                        var contexts = contextCache.getContexts(procedure);
                        var prev = 1;

                        function readBits(length) {
                            var v = 0;

                            for (var i = 0; i < length; i++) {
                                var bit = decoder.readBit(contexts, prev);
                                prev = prev < 256 ? prev << 1 | bit : (prev << 1 | bit) & 511 | 256;
                                v = v << 1 | bit;
                            }

                            return v >>> 0;
                        }

                        var sign = readBits(1);
                        var value = readBits(1) ? readBits(1) ? readBits(1) ? readBits(1) ? readBits(1) ? readBits(32) + 4436 : readBits(12) + 340 : readBits(8) + 84 : readBits(6) + 20 : readBits(4) + 4 : readBits(2);

                        if (sign === 0) {
                            return value;
                        } else if (value > 0) {
                            return -value;
                        }

                        return null;
                    }

                    function decodeIAID(contextCache, decoder, codeLength) {
                        var contexts = contextCache.getContexts("IAID");
                        var prev = 1;

                        for (var i = 0; i < codeLength; i++) {
                            var bit = decoder.readBit(contexts, prev);
                            prev = prev << 1 | bit;
                        }

                        if (codeLength < 31) {
                            return prev & (1 << codeLength) - 1;
                        }

                        return prev & 0x7fffffff;
                    }

                    var SegmentTypes = ["SymbolDictionary", null, null, null, "IntermediateTextRegion", null, "ImmediateTextRegion", "ImmediateLosslessTextRegion", null, null, null, null, null, null, null, null, "PatternDictionary", null, null, null, "IntermediateHalftoneRegion", null, "ImmediateHalftoneRegion", "ImmediateLosslessHalftoneRegion", null, null, null, null, null, null, null, null, null, null, null, null, "IntermediateGenericRegion", null, "ImmediateGenericRegion", "ImmediateLosslessGenericRegion", "IntermediateGenericRefinementRegion", null, "ImmediateGenericRefinementRegion", "ImmediateLosslessGenericRefinementRegion", null, null, null, null, "PageInformation", "EndOfPage", "EndOfStripe", "EndOfFile", "Profiles", "Tables", null, null, null, null, null, null, null, null, "Extension"];
                    var CodingTemplates = [[{
                        x : -1,
                        y : -2
                    }, {
                        x : 0,
                        y : -2
                    }, {
                        x : 1,
                        y : -2
                    }, {
                        x : -2,
                        y : -1
                    }, {
                        x : -1,
                        y : -1
                    }, {
                        x : 0,
                        y : -1
                    }, {
                        x : 1,
                        y : -1
                    }, {
                        x : 2,
                        y : -1
                    }, {
                        x : -4,
                        y : 0
                    }, {
                        x : -3,
                        y : 0
                    }, {
                        x : -2,
                        y : 0
                    }, {
                        x : -1,
                        y : 0
                    }], [{
                        x : -1,
                        y : -2
                    }, {
                        x : 0,
                        y : -2
                    }, {
                        x : 1,
                        y : -2
                    }, {
                        x : 2,
                        y : -2
                    }, {
                        x : -2,
                        y : -1
                    }, {
                        x : -1,
                        y : -1
                    }, {
                        x : 0,
                        y : -1
                    }, {
                        x : 1,
                        y : -1
                    }, {
                        x : 2,
                        y : -1
                    }, {
                        x : -3,
                        y : 0
                    }, {
                        x : -2,
                        y : 0
                    }, {
                        x : -1,
                        y : 0
                    }], [{
                        x : -1,
                        y : -2
                    }, {
                        x : 0,
                        y : -2
                    }, {
                        x : 1,
                        y : -2
                    }, {
                        x : -2,
                        y : -1
                    }, {
                        x : -1,
                        y : -1
                    }, {