<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * lang en file
 *
 * @package   local_kopere_bi
 * @copyright 2024 Eduardo Kraus {@link http://eduardokraus.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['active_enrolments'] = 'Active Enrolments';
$string['all_learners'] = 'All learners';
$string['area_desc'] = 'Generates an area chart';
$string['area_name'] = 'Area Chart';
$string['block_add'] = 'Add new Block';
$string['block_delete_message'] = 'Do you really want to delete this block and <br> its reports permanently?';
$string['block_delete_title'] = 'Delete Block';
$string['block_extra'] = 'Very advanced chart options';
$string['block_not_found'] = 'Block not found';
$string['block_theme'] = 'Block theme';
$string['block_theme_blue'] = 'Blue Theme';
$string['block_theme_dark'] = 'Dark Theme';
$string['block_theme_green'] = 'Green Theme';
$string['block_theme_light'] = 'Light Theme (default)';
$string['block_theme_orange'] = 'Orange Theme';
$string['block_theme_pink'] = 'Pink Theme';
$string['blocktype_not_found'] = 'Block type not found';
$string['c_enablecompletion'] = 'Completion enabled';
$string['c_format'] = 'Course Format';
$string['c_fullname'] = 'Full course name';
$string['c_id'] = 'Course ID';
$string['c_shortname'] = 'Short name';
$string['c_tempo'] = 'Time spent';
$string['c_timemodified'] = 'Modified on';
$string['c_visible'] = 'Visible';
$string['ca_completed_activities'] = 'Completed activities';
$string['cache_time'] = 'Cache time';
$string['cache_time_15min'] = '15 minutes';
$string['cache_time_1d'] = '24 hours';
$string['cache_time_1h'] = '1 hour';
$string['cache_time_30min'] = '30 minutes';
$string['cache_time_6h'] = '6 hours';
$string['cache_time_desc'] = 'Time that the SQL results should remain cached before being cleared';
$string['cache_time_no'] = 'No cache';
$string['cachedef_block_chart_data_15m'] = 'Cache of chart data for 15 minutes';
$string['cachedef_block_chart_data_1d'] = 'Cache of chart data for 1 day';
$string['cachedef_block_chart_data_1h'] = 'Cache of chart data for 1 hour';
$string['cachedef_block_chart_data_30m'] = 'Cache of chart data for 30 minutes';
$string['cachedef_block_chart_data_6h'] = 'Cache of chart data for 6 hour';
$string['cachedef_block_chart_data_none'] = 'Cache of chart data with no data';
$string['cachedef_ip_user_location'] = 'Cache of user location by IP';
$string['cachedef_mustache_nosql'] = 'Cache of Mustache data for NoSQL';
$string['cachedef_mustache_sql'] = 'Cache of Mustache data for SQL';
$string['case_complete'] = 'Complete';
$string['case_incomplete'] = 'Incomplete';
$string['case_never_accessed'] = 'Never accessed';
$string['cat_description'] = 'Category description';
$string['cat_edit'] = 'Edit';
$string['cat_name'] = 'Category name';
$string['cat_new'] = 'New category';
$string['cat_not_found'] = 'Category not found';
$string['cat_title'] = 'Category';
$string['category_delete_confirm'] = 'Category Deletion';
$string['category_delete_message'] = 'Do you really want to delete the category <strong>{$a}</strong> and all pages and blocks?';
$string['cc_id'] = 'Completed courses';
$string['cc_timecompleted'] = 'Completed on';
$string['chart_area_default'] = 'Default Area Chart configuration';
$string['chart_column_default'] = 'Default Column Chart configuration';
$string['chart_default_desc'] = 'Changing this value will not affect any existing charts<br>Only edit if you are familiar with Apex Charts. See more at <a target="_blank" href="https://apexcharts.com/docs/series/">apexcharts.com/docs</a>';
$string['chart_line_default'] = 'Default Line Chart configuration';
$string['chart_pie_default'] = 'Default Pie Chart configuration';
$string['city_name'] = 'City';
$string['class_not_found'] = 'Class not found';
$string['click_new_block'] = 'Click on the type of Block you want to add.';
$string['client_name'] = 'Browser';
$string['client_version'] = 'Version';
$string['cm_cmid'] = 'Course Module ID';
$string['column_desc'] = 'Generates a Column chart';
$string['column_name'] = 'Column Chart';
$string['completed_learners'] = 'Learners who completed the courses';
$string['completion_status'] = 'Tracking';
$string['completionstate_status'] = 'Completion';
$string['country_name'] = 'Country';
$string['course_completed'] = 'Completion percentage';
$string['create'] = 'Create';
$string['create_report'] = 'Create report';
$string['css_extra'] = 'Extra CSS';
$string['css_extra_desc'] = 'Add CSS or SCSS styles to this block.<br> The added CSS will only apply to the content of this Block, and will have no effect on any other part of Moodle';
$string['ctx_instanceid'] = 'Enrolled courses';
$string['data_not_found'] = 'No data found';
$string['delete_report_text'] = 'Do you really want to delete this report?';
$string['delete_report_title'] = 'Delete report';
$string['e_enrol'] = 'Enrollment type';
$string['edit_report'] = 'Edit report';
$string['enrol_status'] = 'Enrollment status';
$string['enrol_timeend'] = 'Enrollment completion';
$string['error_chart_renderer'] = 'Error rendering the chart';
$string['error_data_loader'] = 'Error loading chart data';
$string['expired_enrolments'] = 'Expired Enrolments';
$string['extra_langs_customs_title'] = 'To assist you with new strings, I left some fields blank:';
$string['extra_langs_filter_component'] = 'Component';
$string['extra_langs_header_identifier'] = 'Identifier';
$string['extra_langs_header_lang_key'] = 'Replacement key';
$string['extra_langs_header_string'] = 'Current text';
$string['extra_langs_title'] = 'Keys that already exist:';
$string['extra_options'] = 'Advanced block options';
$string['firstname'] = 'Student name';
$string['g_finalgrade'] = 'Final grade';
$string['grade'] = 'Grade';
$string['grade_course'] = 'Course grade';
$string['html_after'] = 'Optional additional text (in Text, HTML, or Mustache format) displayed after the chart.';
$string['html_before'] = 'Optional additional text (in Text, HTML, or Mustache format) displayed above the chart';
$string['html_block'] = 'HTML Block with Mustache support';
$string['html_block_desc'] = '<p>The HTML added to this field should follow the <strong>Mustache</strong> format, allowing dynamic data substitution in your pages. Use double braces <code>{{ }}</code> to reference SQL column values directly in the HTML, ensuring that the data is correctly inserted.</p>
<blockquote>
    <p>For example, using the following SQL query:</p>
    <pre>SELECT firstname, lastname, email FROM mdl_user WHERE id = :userid</pre>
    <p>You can reference the returned values in your HTML using the following syntax:</p>
    <pre>&lt;p&gt;Email: {{{email}}}&lt;/p&gt;
    &lt;p&gt;Full name: {{{firstname}}} {{{lastname}}}&lt;/p&gt;</pre>
</blockquote>
<blockquote>
    <p>In this example, I want to display multiple rows from an SQL result, which returns a list of users registered with manual authentication. The SQL used for this is:</p>
    <pre>SELECT firstname, lastname, email FROM mdl_user WHERE auth = \'manual\'</pre>
    <p>To iterate over the results and display the data in a table format, I use the <code>{{#lines}}</code> in the template to repeat the content for each returned record. The template would look like this:</p>
    <pre>&lt;table class="table table-bordered"&gt;
    &lt;tr&gt;
        &lt;th&gt;E-mail&lt;/th&gt;
        &lt;th&gt;Full name&lt;/th&gt;
    &lt;/tr&gt;
    <strong>{{#lines}}</strong>
        &lt;tr&gt;
            &lt;td&gt;{{{email}}}&lt;/td&gt;
            &lt;td&gt;{{{firstname}}} {{{lastname}}}&lt;/td&gt;
        &lt;/tr&gt;
    <strong>{{/lines}}</strong>
&lt;/table&gt;</pre>
</blockquote>
<p>Triple braces <code>{{{ }}}</code> allow the value to be inserted without escaping HTML, which is useful for displaying content that may contain HTML tags.</p>
<p>For more information on using Mustache templates in Moodle, see the official documentation: <a href="https://moodledev.io/docs/guides/templates" target="_blank">Moodle Templates Guide</a>.</p>';
$string['html_desc'] = 'Displays an HTML Block with data coming from the database';
$string['html_name'] = 'HTML Block';
$string['inactive_enrolments'] = 'Inactive Enrolments';
$string['info_desc'] = 'Just information. Ideal for showing student name, enrollment status, etc.';
$string['info_error_sql'] = 'Error executing SQL';
$string['info_name'] = 'Information Line';
$string['info_sql_warning'] = 'Remember that the SQL below must return only one row with just one column.';
$string['integracaoroot'] = 'Integrations';
$string['item_not_found'] = 'Item not found';
$string['kopere_bi:manage'] = 'Manage Business Intelligence';
$string['kopere_bi:view'] = 'View Business Intelligence';
$string['l_ip'] = 'IP';
$string['l_origin'] = 'Origin';
$string['l_timecreated'] = 'Created on';
$string['line_desc'] = 'Generates a line chart';
$string['line_name'] = 'Line Chart';
$string['line_sql_warning'] = '<p>Remember that the SQL below must return with the following structure:</p>
<ul>
    <li>The first column should contain the text that will be used as the X-axis names.</li>
    <li>The other columns should be structured as follows:
        <ul>
            <li>The column name will be used as the series name. You can use translation strings as explained on the
                <a href="?classname=bi-extra_langs&method=index" target="_blank">strings page</a>.</li>
            <li>The column value will represent the series data in the chart.</li>
        </ul>
    </li>
</ul>
<blockquote>In the example below, the first column returns the course name, and the second column returns the number of news items for each course:
<pre>SELECT fullname,
       newsitems AS "Course news items count"
  FROM mdl_course</pre></blockquote>
<blockquote>In the example below, besides the first column being the course name, it generates two additional lines on the chart, with translated column names:
<pre>  SELECT c.fullname AS course_name,
         COUNT(cm.section) AS \'lang::thiscourse::theme_rebel\',
         COUNT(cm.module)  AS \'lang::ca_completed_activities::local_kopere_bi\'
    FROM mdl_course AS c
    JOIN mdl_course_modules AS cm ON c.id = cm.course
GROUP BY c.id</pre></blockquote>';
$string['loading'] = 'Loading...';
$string['maps_1_city'] = '{a1} and one more city';
$string['maps_desc'] = 'Creates a map of online students based on their IPs';
$string['maps_many_city'] = '{a1} and {a2} more cities';
$string['maps_name'] = 'Online students map';
$string['maps_online'] = '{a1} student online';
$string['maps_onlines'] = '{a1} students online';
$string['maps_sql_warning'] = '<p>Remember that the SQL below should return only one column, and that column should contain a valid IP.<br>Example: the SQL <code>SELECT lastip FROM {user} WHERE lastaccess > UNIX_TIMESTAMP() - (10 * 60)</code> returns all students who accessed Moodle in the last 10 minutes</p>';
$string['module_count'] = 'Module count';
$string['module_name'] = 'Module name';
$string['modulename'] = 'Business Intelligence';
$string['new_block'] = 'New block on this page';
$string['new_block_1'] = 'One block';
$string['new_block_12'] = 'One plus two blocks';
$string['new_block_2'] = 'Two blocks';
$string['new_block_21'] = 'Two plus one block';
$string['new_block_25'] = 'One wide and one narrow';
$string['new_block_3'] = 'Three blocks';
$string['new_block_4'] = 'Four blocks';
$string['new_block_52'] = 'One narrow and one wide';
$string['not_accessed_learners'] = 'Students who haven’t accessed the platform';
$string['not_completed_learners'] = 'Students who haven’t completed courses';
$string['num_activelearners'] = 'Number of active students';
$string['num_completedlearners'] = 'Number of students who completed courses';
$string['num_courses'] = 'Number of available courses';
$string['num_learners'] = 'Total number of students';
$string['num_user'] = 'Number of students';
$string['os_name'] = 'Operating system';
$string['page_delete_confirm'] = 'Page Deletion';
$string['page_delete_message'] = 'Do you really want to delete the page <strong>{$a}</strong> and all blocks?';
$string['page_description'] = 'Page description';
$string['page_edit'] = 'Edit page';
$string['page_name'] = 'Page name';
$string['page_new_cat'] = 'New page';
$string['page_new_sequence'] = 'Drag blocks to change the block order.';
$string['page_not_found'] = 'Page not found';
$string['page_preview'] = 'Preview page';
$string['page_title_edit'] = 'Edit this page’s title';
$string['page_title_export'] = 'Export page';
$string['pie_desc'] = 'Creates a pie chart';
$string['pie_name'] = 'Pie chart';
$string['pie_sql_warning'] = '<p>The SQL below should return only two columns.</p><p>The first column will be the column name, and the second column must be a numeric value.</p>';
$string['pluginname'] = 'Business Intelligence';
$string['privacy:metadata:city_name'] = 'The name of the city from which the user accesses.';
$string['privacy:metadata:client_name'] = 'The name of the client or browser used by the user.';
$string['privacy:metadata:client_type'] = 'The type of client, such as browser or application.';
$string['privacy:metadata:client_version'] = 'The version of the client or browser.';
$string['privacy:metadata:country_code'] = 'The country code from which the user accesses.';
$string['privacy:metadata:country_name'] = 'The name of the country from which the user accesses.';
$string['privacy:metadata:day'] = 'The day of access.';
$string['privacy:metadata:lastip'] = 'The last registered IP address of the user.';
$string['privacy:metadata:latitude'] = 'The latitude of the user\'s location during access.';
$string['privacy:metadata:local_kopere_bi_online'] = 'Table storing information about users currently online for analysis.';
$string['privacy:metadata:local_kopere_bi_statistic'] = 'Table storing statistical data for analytics purposes.';
$string['privacy:metadata:longitude'] = 'The longitude of the user\'s location during access.';
$string['privacy:metadata:month'] = 'The month of access.';
$string['privacy:metadata:os_name'] = 'The name of the operating system used by the user.';
$string['privacy:metadata:os_version'] = 'The version of the operating system used by the user.';
$string['privacy:metadata:seconds'] = 'The seconds of the access time.';
$string['privacy:metadata:user_id'] = 'The unique identifier of the user on the platform.';
$string['privacy:metadata:userid'] = 'The identifier of the user for specific records.';
$string['privacy:metadata:weekday'] = 'The weekday of access.';
$string['privacy:metadata:year'] = 'The year of access.';
$string['reload_time'] = 'Reload data every';
$string['reload_time_10m'] = '10 minutes';
$string['reload_time_1h'] = '1 hour';
$string['reload_time_1m'] = '1 minute';
$string['reload_time_20m'] = '20 minutes';
$string['reload_time_2h'] = '2 hours';
$string['reload_time_30m'] = '30 minutes';
$string['reload_time_40m'] = '40 minutes';
$string['reload_time_50m'] = '50 minutes';
$string['reload_time_5m'] = '5 minutes';
$string['reload_time_desc'] = 'Reload data every X minutes. This value must be greater than the cache value!';
$string['reload_time_none'] = 'Never';
$string['report_1_cat_description'] = 'Reports on student performance and progress in their courses.';
$string['report_1_cat_title'] = 'Students';
$string['report_1_categories'] = 'Categories';
$string['report_1_description'] = 'Student status reports';
$string['report_1_modules'] = 'Modules';
$string['report_1_title'] = 'Active students';
$string['report_1_user_status'] = 'Student status';
$string['report_1_user_summary'] = 'Summary of active students';
$string['report_1_users'] = 'Students';
$string['report_2_cat_description'] = 'Comprehensive analyses of all available courses, student performance, progress, and development.';
$string['report_2_cat_title'] = 'Courses';
$string['report_2_completion_progress'] = 'Completion progress percentage';
$string['report_2_course_access_statistics'] = 'Course access statistics';
$string['report_2_course_analysis_participation_completion'] = 'Course analysis: Participation and completion';
$string['report_2_course_progress'] = 'Course progress';
$string['report_2_description'] = 'Course report';
$string['report_2_title'] = 'Courses';
$string['report_2_total_engagement'] = 'Total Engagement by Course';
$string['report_3_cat_description'] = 'Report of everyone online on Moodle';
$string['report_3_cat_title'] = 'Online';
$string['report_3_course_access_time'] = 'Course access time';
$string['report_3_course_last30days'] = 'Data from the last 30 days only';
$string['report_3_description'] = 'Shows online students and top regions';
$string['report_3_operating_systems'] = 'Operating systems with the most access time';
$string['report_3_title'] = 'Online Students';
$string['report_3_top_browsers'] = 'Browsers with the most access time';
$string['report_3_top_country_access'] = 'Cities/Countries with the most access time';
$string['report_3_users_online'] = 'Online Students';
$string['report_3_users_online_list'] = 'List of online students';
$string['report_4_cat_description'] = 'Enrollment reports covering history, current status, and enrollment trends in courses.';
$string['report_4_cat_title'] = 'Enrollments';
$string['report_4_completion_0'] = 'Completion tracking disabled for this activity';
$string['report_4_completion_1'] = 'Manual completion tracking enabled for this activity';
$string['report_4_completion_2'] = 'Automatic completion tracking enabled for this activity';
$string['report_4_completion_none'] = 'Completion unknown';
$string['report_4_completionstate_0'] = 'Activity not completed';
$string['report_4_completionstate_1'] = 'Activity completed, but pass or fail not specified';
$string['report_4_completionstate_2'] = 'Activity completed with a grade above the minimum required for passing';
$string['report_4_completionstate_3'] = 'Activity completed with a grade below the minimum required for passing';
$string['report_4_completionstate_4'] = 'Failed a hidden item';
$string['report_4_completionstate_none'] = 'Completion unknown';
$string['report_4_coursesenrollmentstatus'] = 'Courses enrollment status';
$string['report_4_description'] = 'Enrollment reports covering history, current status, and enrollment trends in courses.';
$string['report_4_enrolpercourse'] = 'Enrollments per course';
$string['report_4_title'] = 'Statistics';
$string['report_5_cat_description'] = 'This report provides an overview of key system metrics and information, enabling a comprehensive analysis of its performance and operation.';
$string['report_5_cat_title'] = 'System';
$string['report_5_component'] = 'Component';
$string['report_5_coursefilesizes'] = 'Course Files';
$string['report_5_coursefilesizes_title'] = 'Space occupied by each course';
$string['report_5_description'] = 'The General report offers a detailed summary of all system aspects, including usage data, performance, and areas for improvement. Ideal for administrators and managers seeking to optimize system efficiency.';
$string['report_5_filesize'] = 'File size';
$string['report_5_filesizes'] = 'File sizes';
$string['report_5_modulesdeleting'] = 'Modules deleting';
$string['report_5_modulesfilesizes'] = 'Module files';
$string['report_5_numfiles'] = 'Number of files';
$string['report_5_title'] = 'General';
$string['report_5_upload_title'] = 'Space occupied by each module';
$string['report_6_cat_description'] = 'Monitoring and statistics of system logins';
$string['report_6_cat_title'] = 'Login Reports';
$string['report_6_login'] = 'Logins';
$string['report_6_login_report'] = 'Moodle Login Report';
$string['report_7_inactive'] = 'Inactive Enrollments';
$string['report_7_inactive_report'] = 'Inactive Enrollments Report';
$string['report_7_users_not_accessed_course'] = 'Registered users who have not accessed their course';
$string['report_8_engagement'] = 'Engagement';
$string['report_8_student_teacher_engagement'] = 'Student and Teacher Engagement Report';
$string['report_8_teacher_access'] = 'Teacher Access';
$string['report_8_total_engagement_per_course'] = 'Total Engagement by Course';
$string['report_9_category_desc'] = 'Report on course modules';
$string['report_9_category_title'] = 'Course Modules';
$string['report_9_report_1_name'] = 'Module Statistics';
$string['report_dashboard_cat_title'] = 'Dashboard';
$string['report_dashboard_page_1_cursos'] = 'Courses / Visible';
$string['report_dashboard_page_1_newusers'] = 'New users in the last 12 months';
$string['report_dashboard_page_1_online'] = 'Online / Last hour';
$string['report_dashboard_page_1_title'] = 'Dashboard';
$string['report_dashboard_page_1_users'] = 'Users / Active';
$string['report_new'] = 'New report for "{$a}"';
$string['report_preview'] = 'Preview report';
$string['report_save'] = 'Save & go to column configuration';
$string['report_title'] = 'Report title';
$string['reports_selectcourse'] = 'Select the course to generate the report';
$string['reports_selectuser'] = 'Select the student to generate the report';
$string['return_edit'] = '<< Return to edit';
$string['rolename'] = 'Role name';
$string['save'] = 'Save';
$string['seconds'] = 'How long';
$string['select_report_select_type'] = 'Select report type';
$string['select_report_select_type_desc'] = 'First, choose which report type you want for this block';
$string['select_report_type'] = 'Report type';
$string['select_report_type_desc'] = 'You can switch between "{$a->line}", "{$a->area}", or "{$a->column}" types';
$string['setting_apex'] = 'Apex Charts settings';
$string['setting_apex_desc'] = 'Only edit if you are familiar with Apex Charts. See more at <a target="_blank" href="https://apexcharts.com/docs/series/">apexcharts.com/docs</a>';
$string['sql_no_rows'] = 'The SQL returned 0 rows. To configure the columns, the SQL query must return at least 1 row.';
$string['sql_read_only'] = 'All SQL queries are protected by a read-only connection, and it is not possible to execute INSERT/UPDATE/DELETE commands.';
$string['sql_replace_keys'] = '<h4>Replacement keys</h4>
<ul>
    <li><b>:userid</b> Student ID to generate the report.</li>
    <li><b>:courseid</b> Course ID to generate the report.</li>
</ul>
<h4>Multi-language</h4>
<p>To return columns that will be translated based on Moodle language packs, a specific format is required that allows strings to be processed and properly localized. The correct format is:</p>
<pre>lang::{identifier}::{component}</pre>
<p>Where:</p>
<ul>
    <li><b>{identifier}</b>: Represents the string identifier, which will be used to fetch the translation from the language pack.</li>
    <li><b>{component}</b>: Refers to the component where the language string is defined and is typically the name of the plugin (e.g., <code>mod_forum</code>, <code>local_kopere_dashboard</code>, <code>theme_degrade</code>).</li>
</ul>
<p><em>Example: If you need to return a translated string for the <code>mod_forum</code> component with the identifier <code>postmessage</code>, the return should be structured as follows:</em></p>
<pre>SELECT \'<b>lang::postmessage::mod_forum</b>\' FROM mdl_forum</pre>
<p>Visit the <a href="?classname=bi-extra_langs&method=index" target="_blank">strings page</a> to see all available strings.</p>';
$string['sql_replace_keys_mdl'] = '<h4>Database prefix</h4>
<p>You can always use the <code>mdl_</code> prefix even if your database uses the <code>{$a}</code> prefix.
        Business intelligence will handle this replacement.</p>';
$string['table_col_title'] = 'Column title';
$string['table_column_not_configured'] = 'Columns not configured in this table';
$string['table_desc'] = 'Displays a table with data pagination.';
$string['table_edit_column'] = 'Column';
$string['table_first_5'] = 'The first five records of the query';
$string['table_info_topo'] = 'First, you will see a preview of the search results. Then, a series of columns will be presented for you to name the titles and define the format of each column’s data.';
$string['table_info_types'] = 'You can now set a name for the column and then specify the desired format and whether you want any extra formatting with Mustache.
<ul>
    <li><strong>No formatting</strong>: Displays the content exactly as it is or applies Mustache if you add it.</li>
    <li><strong>Do not show this column</strong>: Hides the selected column in the view, but the data remains available for Mustache processing.</li>
    <ul><li>Mustache not available</li></ul>
    <li><strong>Numbers</strong>: Formats the column to display only numeric values, applying standard number display rules, such as thousands and decimal separators.</li>
    <ul><li>Mustache not available</li></ul>
    <li><strong>Convert column to full name "fullname()"</strong>: Runs the <code>fullname()</code> function to generate the full name based on the language, which will be stored in this same column. For this to work, the <code>lastname</code> column is required and should be hidden if possible.</li>
    <li><strong>Convert student ID to profile picture</strong>: Uses the ID from this column to create the profile picture.</li>
    <li><strong>Binary field for Visible/Invisible</strong>: Uses the binary value to determine visibility, where "0"/"false" means invisible and "1"/"true" means visible.</li>
    <li><strong>Binary field for Active/Inactive</strong>: Uses the binary value to determine the status, where "0"/"false" means Inactive and "1"/"true" means Active.</li>
    <li><strong>"Time" field formatted as date</strong>: Converts the time value (timestamp) in the column to a readable date, displaying only the date (day/month/year).</li>
    <ul><li>Mustache not available</li></ul>
    <li><strong>"Time" field formatted as date and time</strong>: Displays the time value (timestamp) in the column as a full date, including the time (day/month/year and hours:minutes).</li>
    <ul><li>Mustache not available</li></ul>
    <li><strong>"Time" field formatted as time</strong>: Formats the time value (timestamp) in the column to display only the time (hours:minutes), omitting the date.</li>
    <ul><li>Mustache not available</li></ul>
</ul>';

$string['table_name'] = 'Data table';
$string['table_renderer_date'] = '"Time" field formatted as date';
$string['table_renderer_datetime'] = '"Time" field formatted as date and time';
$string['table_renderer_filesize'] = 'Converts to disk data size';
$string['table_renderer_mustache'] = 'HTML of the
<a href="https://moodledev.io/docs/guides/templates" target="_blank">Mustache</a> column';
$string['table_renderer_none'] = 'Do not display this column';
$string['table_renderer_number'] = 'Numbers';
$string['table_renderer_seconds'] = '"Time" field formatted as time';
$string['table_renderer_status'] = 'Binary field for Active/Inactive';
$string['table_renderer_title'] = 'Column formatting';
$string['table_renderer_translate'] = 'Use get_string("identifier", "component") to translate the column';
$string['table_renderer_userfullname'] = 'Convert the column to the student’s full name with the "fullname()" function';
$string['table_renderer_userphoto'] = 'Convert student ID to profile picture';
$string['table_renderer_visible'] = 'Binary field for Visible/Invisible';
$string['theme_palette_default'] = 'Default Palette';
$string['theme_palette_desc'] = 'Palette colors:';
$string['theme_palette_desc2'] = 'See all themes here';
$string['theme_palette_palette'] = 'Palette {$a}';
$string['theme_palette_title'] = 'Color Palette';
$string['timecompleted'] = 'Enrollment completed';
$string['title'] = 'Business Intelligence';
$string['u_fullname'] = 'Student’s full name';
$string['u_id'] = 'Student ID';
$string['u_idnumber'] = 'ID number';
$string['ue_id'] = 'Enrollment ID';
$string['ue_status'] = 'Enrollment Status';
$string['ue_timecreated'] = 'Enrollment created on';
$string['ue_timeend'] = 'Enrollment ends on';
$string['ul_timeaccess'] = 'Last access';
$string['unknown'] = 'Unknown';
$string['use_this_type'] = 'Use this type';
$string['word_extra_00'] = '';
$string['word_extra_01'] = '';
$string['word_extra_02'] = '';
$string['word_extra_03'] = '';
$string['word_extra_04'] = '';
$string['word_extra_05'] = '';
$string['word_extra_06'] = '';
$string['word_extra_07'] = '';
$string['word_extra_08'] = '';
$string['word_extra_09'] = '';
$string['word_extra_10'] = '';
$string['word_extra_11'] = '';
$string['word_extra_12'] = '';
$string['word_extra_13'] = '';
$string['word_extra_14'] = '';
$string['word_extra_15'] = '';
$string['word_extra_16'] = '';
$string['word_extra_17'] = '';
$string['word_extra_18'] = '';
$string['word_extra_19'] = '';
$string['word_extra_20'] = '';
$string['word_extra_21'] = '';
$string['word_extra_22'] = '';
$string['word_extra_23'] = '';
$string['word_extra_24'] = '';
$string['word_extra_25'] = '';
$string['word_extra_26'] = '';
$string['word_extra_27'] = '';
$string['word_extra_28'] = '';
$string['word_extra_29'] = '';
$string['word_extra_30'] = '';
$string['word_extra_31'] = '';
$string['word_extra_32'] = '';
$string['word_extra_33'] = '';
$string['word_extra_34'] = '';
$string['word_extra_35'] = '';
$string['word_extra_36'] = '';
$string['word_extra_37'] = '';
$string['word_extra_38'] = '';
$string['word_extra_39'] = '';
$string['word_extra_40'] = '';
$string['word_extra_41'] = '';
$string['word_extra_42'] = '';
$string['word_extra_43'] = '';
$string['word_extra_44'] = '';
$string['word_extra_45'] = '';
$string['word_extra_46'] = '';
$string['word_extra_47'] = '';
$string['word_extra_48'] = '';
$string['word_extra_49'] = '';
$string['word_extra_50'] = '';
$string['word_extra_51'] = '';
$string['word_extra_52'] = '';
$string['word_extra_53'] = '';
$string['word_extra_54'] = '';
$string['word_extra_55'] = '';
$string['word_extra_56'] = '';
$string['word_extra_57'] = '';
$string['word_extra_58'] = '';
$string['word_extra_59'] = '';
$string['word_extra_60'] = '';
$string['word_extra_61'] = '';
$string['word_extra_62'] = '';
$string['word_extra_63'] = '';
$string['word_extra_64'] = '';
$string['word_extra_65'] = '';
$string['word_extra_66'] = '';
$string['word_extra_67'] = '';
$string['word_extra_68'] = '';
$string['word_extra_69'] = '';
$string['word_extra_70'] = '';
$string['word_extra_71'] = '';
$string['word_extra_72'] = '';
$string['word_extra_73'] = '';
$string['word_extra_74'] = '';
$string['word_extra_75'] = '';
$string['word_extra_76'] = '';
$string['word_extra_77'] = '';
$string['word_extra_78'] = '';
$string['word_extra_79'] = '';
$string['word_extra_80'] = '';
