/**
 * Javascript Module to handle rendering of course modules (e.g. resource/PDF, resource/html, page) in modal windows
 *
 * When the user clicks a PDF course module subtile or old style resource
 * if we are using modals for it (e.g. PDF) , create, populate, launch and size the modal
 *
 * @module      format_tiles/course_mod_modal
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since       Moodle 3.3
 */
define("format_tiles/course_mod_modal",["jquery","core/modal_factory","core/config","core/templates","core/notification","core/ajax","core/fragment","core/modal_events"],(function($,modalFactory,config,Templates,Notification,ajax,Fragment,ModalEvents){var loadingIconHtml;const win=$(window);var courseId,tilesConfig;const isSafari=/^((?!chrome|android).)*safari/i.test(navigator.userAgent),Selector_modal=".modal",Selector_modalDialog=".modal-dialog",Selector_modalBody=".modal-body",Selector_sectionMain=".section.main",Selector_pageContent="#page-content",Selector_regionMain="#region-main",Selector_moodleMediaPlayer=".mediaplugin_videojs",Selector_closeBtn="button.btn-close",Selector_modalHeader=".modal-header",Selector_embedModuleButtons=".embed-module-buttons",Selector_iframe="iframe",CLASS_COMPLETION_ENABLED="completion-enabled",CLASS_COMPLETION_MANUAL="completion-manual",CLASS_COMPLETION_CHECK_BOX="completioncheckbox",CLASS_COMPLETION_DROPDOWN="completion-dropdown",modalMinWidth=function(){return Math.min(win.width(),1100)},stopAllVideosOnDismiss=function(modal){modal.on(ModalEvents.hidden,(function(){const iframes=modal.find(Selector_iframe),objects=modal.find("object"),moodleMediaPlayer=modal.find(Selector_moodleMediaPlayer);(iframes.length||objects.length||moodleMediaPlayer.length)&&modal.remove()}))},launchCmModal=function(cmId,moduleContextId,sectionNum,title,objectType,completionEnabled,existingCompletionState,isManualCompletion,descriptionHTML){return modalFactory.create({type:modalFactory.types.DEFAULT,title:title,body:loadingIconHtml}).done((function(modal){modal.setLarge(),modal.show();const modalRoot=$(modal.root),modalId="embed_mod_modal_"+cmId;if($("#".concat(modalId)).remove(),modalRoot.attr("id",modalId),modalRoot.data("cmid",cmId),modalRoot.data("section",sectionNum),modalRoot.addClass("embed_cm_modal"),"page"===objectType)modalRoot.addClass("mod_"+objectType),stopAllVideosOnDismiss(modalRoot),Fragment.loadFragment("format_tiles","get_cm_content",moduleContextId,{contextid:moduleContextId}).done((function(html,js){modal.setBody(html),Templates.runTemplateJS(js)}));else{var templateData={id:cmId,objectType:null,width:"100%",height:Math.round(win.height()-60),cmid:cmId,tileid:sectionNum,isediting:0,sesskey:config.sesskey,activityname:title,config:{wwwroot:config.wwwroot},completionstring:"",description:descriptionHTML},template=null;"html"===objectType?(templateData.objectType="text/html",template="format_tiles/embed_file_modal_body"):"pdf"===objectType?(templateData.objectType="application/pdf",templateData.cachebustparam=isSafari?Date.now():null,template="format_tiles/embed_file_modal_body"):"url"===objectType&&(templateData.objectType="url",template="format_tiles/embed_url_modal_body");const redirectModule=["pdf","html"].includes(objectType)?"resource":objectType;null!==template?Templates.render(template,templateData).done((function(html){modal.setBody(html),modalRoot.find(Selector_modalBody).animate({"min-height":Math.round(win.height()+20)},"fast"),"html"===objectType||"url"===objectType?(modalRoot.find(Selector_modal).animate({"max-width":"100%"},"fast"),modalRoot.find(Selector_modalDialog).animate({"max-width":"100%"},"fast"),modalRoot.find(Selector_modalBody).animate({"max-width":"100%"},"fast"),stopAllVideosOnDismiss(modalRoot),"url"===objectType&&modalRoot.find(Selector_modalBody).addClass("text-center")):"pdf"===objectType&&(modalRoot.find(Selector_modal).animate({"max-width":modalMinWidth()},"fast"),modalRoot.find(Selector_modalDialog).animate({"max-width":modalMinWidth()},"fast"))})).fail((()=>{window.location.href="".concat(config.wwwroot,"/mod/").concat(redirectModule,"/view.php?id=").concat(cmId)})):window.location.href="".concat(config.wwwroot,"/mod/").concat(redirectModule,"/view.php?id=").concat(cmId)}var headerTemplateData={cmid:cmId,activityname:title,tileid:sectionNum,showDownload:"pdf"===objectType?1:0,showNewWindow:["pdf","url"].includes(objectType)?1:0,forModal:!0,config:{wwwroot:config.wwwroot}};if(completionEnabled){headerTemplateData.istrackeduser=1,headerTemplateData.hascompletion=1;const oldState=1===existingCompletionState;headerTemplateData.overallcomplete=oldState?1:0,headerTemplateData.overallincomplete=oldState?0:1,headerTemplateData.completionIsManual=isManualCompletion,headerTemplateData.completionIsManual||(headerTemplateData.statuscomplete=headerTemplateData.overallcomplete,headerTemplateData.statusincomplete=headerTemplateData.overallincomplete),oldState!==headerTemplateData.completionstate&&require(["format_tiles/completion"],(function(completion){completion.triggerCompletionChangedEvent(parseInt(sectionNum),parseInt(cmId))}))}return Templates.render("format_tiles/embed_module_modal_header_btns",headerTemplateData).done((function(html){modalRoot.find(Selector_embedModuleButtons).remove(),modalRoot.find($("button.close")).remove(),modalRoot.find($("button.btn-close")).remove(),modalRoot.find(Selector_modalHeader).append(html),modalRoot.find(Selector_closeBtn).detach().appendTo(modalRoot.find(Selector_embedModuleButtons));modalRoot.find('[data-action="toggle-manual-completion"]').on("click",(()=>{require(["format_tiles/completion"],(function(completion){setTimeout((()=>{completion.triggerCompletionChangedEvent(parseInt(modalRoot.data("section")),parseInt(modalRoot.data("cmid")))}),300)}))}))})).fail(Notification.exception),setTimeout((()=>{modalHeightChangeWatcher(modalRoot,3,1e3)}),500),!0})),!1};var resizeModal=function(modalRoot){modalRoot.find(Selector_modal).animate({"max-width":modalMinWidth()},"fast");var mediaPlayer=$(Selector_moodleMediaPlayer);mediaPlayer.find("div").each((function(index,child){$(child).css("max-width","")})),mediaPlayer.length>0&&stopAllVideosOnDismiss(modalRoot),modalRoot.find(Selector_iframe).each((function(index,iframe){const iframeSelector=$(iframe);var modal;0===(modal=modalRoot.find(Selector_modalDialog)).length&&(modal=modalRoot.find(Selector_modal));var iframeWidth=Math.min(iframeSelector.width(),win.width());iframeWidth>modal.width()-70&&(modal.animate({"max-width":Math.max(iframeWidth+70,modalMinWidth())},"fast"),modalRoot.find(Selector_modal).animate({"max-width":Math.max(iframeWidth+70,modalMinWidth())},"fast"));var modalBody=modalRoot.find(Selector_modalBody);iframeSelector.height()>modalBody.height()-70&&iframeSelector.attr("height",modalBody.height()-70),stopAllVideosOnDismiss(modalRoot)}))};const modalHeightChangeWatcher=function(modalRoot,howManyChecks,duration){let oldHeight=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;const iframe=modalRoot.find(Selector_modalBody);if(iframe){const newHeight=Math.round(iframe.height());newHeight&&newHeight>oldHeight+10&&resizeModal(modalRoot),howManyChecks>0&&setTimeout((()=>{modalHeightChangeWatcher(modalRoot,howManyChecks-1,duration,newHeight)}),duration)}},modalRequired=function(cmId,url){return void 0!==tilesConfig.modalallowedmodnames&&(void 0!==tilesConfig.modalallowedcmids&&(!!tilesConfig.modalallowedcmids.includes(cmId)&&(tilesConfig.modalallowedmodnames.includes("page")&&url.startsWith("".concat(config.wwwroot,"/mod/page/view.php"))||tilesConfig.modalallowedmodnames.includes("url")&&url.startsWith("".concat(config.wwwroot,"/mod/url/view.php"))||tilesConfig.modalallowedmodnames.includes("pdf")&&url.startsWith("".concat(config.wwwroot,"/mod/resource/view.php"))||tilesConfig.modalallowedmodnames.includes("html")&&url.startsWith("".concat(config.wwwroot,"/mod/resource/view.php")))))};return{init:function(courseIdInit,isEditing,pageType,launchModalCmid,usingJsNav){courseId=parseInt(courseIdInit),$(document).ready((function(){tilesConfig=$("#format-tiles-js-config").data();const courseIndex=$("nav#courseindex");if(["course-view-tiles","section-view-tiles","course-view-section-tiles"].includes(pageType)){!isEditing&&courseIndex.length>0&&courseIndex.on("click",(function(e){const target=$(e.target),link=target.hasClass("courseindex-link")?target:target.find("a.courseindex-link");if(link&&"cm_name"===link.data("for")){e.preventDefault();const linkUrl=link.attr("href");if(linkUrl){const cmId=link.closest("li.courseindex-item").data("id");ajax.call([{methodname:"format_tiles_get_course_mod_info",args:{cmid:cmId}}])[0].done((function(data){const expandedSection=$("li#section-".concat(data.sectionnumber,".state-visible"));if(modalRequired(cmId,linkUrl)){if(!data||!data.modalallowed)return void(window.location.href=linkUrl);usingJsNav?(0===expandedSection.length&&require(["format_tiles/course"],(function(course){course.populateAndExpandSection(data.coursecontextid,data.sectionid,data.sectionnumber)})),launchCmModal(cmId,data.modulecontextid,data.sectionnumber,data.name,data.modaltype,data.completionenabled?1:0,data.iscomplete?1:0,data.ismanualcompletion,data.description)):window.location.href=config.wwwroot+"/course/view.php?id=".concat(courseId)+"&section=".concat(data.sectionnumber,"&cmid=").concat(cmId)}else{link.data("anchor")||linkUrl.startsWith("#")?usingJsNav?0===expandedSection.length&&require(["format_tiles/course"],(function(course){course.populateAndExpandSection(data.coursecontextid,data.sectionid,data.sectionnumber)})):window.location.href=config.wwwroot+"/course/view.php?id=".concat(courseId)+"&section=".concat(data.sectionnumber):window.location.href=linkUrl}})).fail((function(){window.location.href=linkUrl}))}}})),launchModalCmid&&ajax.call([{methodname:"format_tiles_get_course_mod_info",args:{cmid:launchModalCmid}}])[0].done((function(data){if(data&&data.modalallowed&&data.courseid===courseId){0===$("li#section-".concat(data.sectionnumber,".state-visible")).length&&usingJsNav&&require(["format_tiles/course"],(function(course){course.populateAndExpandSection(data.coursecontextid,data.sectionid,data.sectionnumber)})),launchCmModal(launchModalCmid,data.modulecontextid,data.sectionnumber,data.name,data.modaltype,data.completionenabled?1:0,data.iscomplete?1:0,data.ismanualcompletion,data.description)}}));var pageContent=$(Selector_pageContent);0===pageContent.length&&(pageContent=$(Selector_regionMain)),pageContent.on("keydown",'[data-action="launch-tiles-cm-modal"]',(function(e){if(13===e.keyCode){e.preventDefault();const url=$(e.target).attr("href");url&&(window.location.href=url)}})),pageContent.on("click",'[data-action="launch-tiles-cm-modal"]',(function(e){const tgt=$(e.target);if(tgt.hasClass(CLASS_COMPLETION_CHECK_BOX)||tgt.parent().hasClass(CLASS_COMPLETION_CHECK_BOX)||tgt.hasClass(CLASS_COMPLETION_DROPDOWN)||tgt.parent().hasClass(CLASS_COMPLETION_DROPDOWN)||tgt.is(":button")||tgt.hasClass("expanded-content")||tgt.hasClass("collapsed-content"))return;e.preventDefault();var clickedCmObject=$(e.currentTarget).closest("li.activity");const cmId=clickedCmObject.data("cmid"),moduleContextId=clickedCmObject.data("contextid"),sectionNum=clickedCmObject.closest(Selector_sectionMain).data("section");launchCmModal(cmId,moduleContextId,sectionNum,clickedCmObject.data("title"),clickedCmObject.data("modal"),clickedCmObject.hasClass(CLASS_COMPLETION_ENABLED),clickedCmObject.data("completion-state")?parseInt(clickedCmObject.data("completion-state")):null,clickedCmObject.hasClass(CLASS_COMPLETION_MANUAL),clickedCmObject.find(".modal-description").html())})),Templates.render("format_tiles/loading",{}).catch(Notification.exception).done((function(html){loadingIconHtml=html})).fail(Notification.exception)}else pageType.match("^mod-[a-z]+-view$")&&courseIndex.on("click",(function(e){const target=$(e.target),link=target.hasClass("courseindex-link")?target:target.find("a.courseindex-link");if(link&&"cm_name"===link.data("for")){e.preventDefault();const linkUrl=link.attr("href");if(linkUrl){const link=$(e.target),cmId=link.closest("li.courseindex-item").data("id");if(modalRequired(cmId,linkUrl))if(usingJsNav)window.location.href="".concat(config.wwwroot,"/course/view.php?id=").concat(courseId,"&cmid=").concat(cmId);else{const sectionElement=link.closest(".courseindex-section"),sectionNumber=sectionElement?sectionElement.data("number"):0;window.location.href="".concat(config.wwwroot,"/course/view.php?id=").concat(courseId)+"&section=".concat(sectionNumber,"&cmid=").concat(cmId)}else window.location.href=linkUrl}}}))}))}}}));

//# sourceMappingURL=course_mod_modal.min.js.map