/**
 * Main Javascript module for format_tiles for when user is *NOT* editing.
 * See course_edit for if they are editing.
 * Handles the UI changes when tiles are selected and anything else not
 * covered by the specific modules
 *
 * @module      format_tiles/course
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("format_tiles/course",["jquery","core/templates","core/ajax","format_tiles/browser_storage","core/notification","core/str","format_tiles/tile_fitter","core/fragment"],(function($,Templates,ajax,browserStorage,Notification,str,tileFitter,Fragment){var isMobile,loadingIconHtml,courseId,courseContextId,stringStore=[],reopenLastVisitedSection=!1;let resizeTimeout;var enableCompletion,reorgSectionsDisabledUntil=0,expandedSubSectionIds={},openTile=0,Selector_BODY="body",Selector_TILE=".tile",Selector_TILEID="#tile-",Selector_MOVEABLE_SECTION=".moveablesection",Selector_FILTER_BUTTON=".filterbutton",Selector_TILE_LOADING_ICON=".tile-loading-icon",Selector_TILE_CLICKABLE=".tile-clickable",Selector_TILES="ul.tiles",Selector_ACTIVITY=".activity",Selector_ACTIVITY_NAME=".activityname",Selector_ABOVE_TILES="#abovetiles",Selector_FOCUSABLE_ELEMS='button, a, input:not([type="hidden"]), select, textarea, [tabindex]:not([tabindex="-1"])',Selector_INSTANCE_NAME=".instancename",Selector_SPACER=".spacer",Selector_SECTION_ID="#section-",Selector_SECTION_MAIN=".section.main",Selector_SECTION_BUTTONS=".sectionbuttons",Selector_CLOSE_SEC_BTN=".closesectionbtn",Selector_HIDE_SEC0_BTN=".buttonhidesec0",Selector_SECTION_ZERO="#section-0",Selector_MOODLE_VIDEO=".mediaplugin.mediaplugin_videojs",Selector_MOODLE_DIALOGUE=".moodle-dialogue-confirm",Selector_MANUAL_COMPLETION='[data-action="toggle-manual-completion"]',Selector_MATHJAX_EQUATION=".filter_mathjaxloader_equation",ClassNames_SELECTED="selected",ClassNames_OPEN="open",ClassNames_CLOSED="closed",ClassNames_STATE_VISIBLE="state-visible",ClassNames_HAS_OPEN_TILE="format-tiles-tile-open",ClassNames_ON_TILE_CONTROL="on-tile-control",Event_CLICK="click",Event_KEYDOWN="keydown",CSS_DISPLAY="display",CSS_Z_INDEX="z-index",CSS_BG_COLOUR="background-color",Keyboard_TAB=9,Keyboard_ENTER=13;const OVERLAY_ID="format_tiles_overlay";var stopVideoPlaying=function(section,sectionId){var contentSection=$(Selector_SECTION_ID+section);contentSection.find("iframe").each((function(index,iframe){(iframe=$(iframe)).attr("src")&&(iframe.data("src",iframe.attr("src")),iframe.attr("src",""))})),contentSection.find(Selector_MOODLE_VIDEO).length>0&&(contentSection.html(""),getSectionContentFromServer(courseContextId,sectionId).done((function(html,js){setCourseContentHTML(contentSection,html,js)})))},cancelTileSelections=function(sectionToFocus){$(Selector_MOVEABLE_SECTION).each((function(index,sec){(sec=$(sec)).is(":visible")&&(stopVideoPlaying(sec.data("section"),sec.data("sectionid")),sec.slideUp().removeClass(ClassNames_STATE_VISIBLE))})),$(Selector_TILE).removeClass(ClassNames_SELECTED).css(CSS_Z_INDEX,"").css(CSS_BG_COLOUR,""),$(".section "+ClassNames_SELECTED).removeClass(ClassNames_SELECTED).css(CSS_Z_INDEX,""),void 0!==sectionToFocus&&0!==sectionToFocus&&$(Selector_TILEID+sectionToFocus).focus(),$(Selector_TILE_LOADING_ICON).fadeOut(300,(function(){$(Selector_TILE_LOADING_ICON).html("")})),openTile=0,$(Selector_BODY).removeClass(ClassNames_HAS_OPEN_TILE),overlay.fadeOut(300),overlay.css("min-height","inherit"),$(Selector_MOODLE_DIALOGUE).remove()};const overlay=$("#"+OVERLAY_ID);overlay.attr("aria-hidden",!0);var setCourseContentHTML=function(contentArea,html,js){if(html){const newHtml=$(html),subSections=newHtml.find("li.modtype_subsection");if(subSections.each((i=>{const subSection=$(subSections[i]);if(subSection.find(".course-content-item-content.collapse").length){const subSectionId=subSection.find('a[data-toggle="collapse"]').data("subSectionId");void 0!==expandedSubSectionIds[subSectionId]&&(subSection.find('a[data-toggle="collapse"]').removeClass("collapsed").attr("aria-expanded",!0),subSection.find(".course-content-item-content").addClass("show").addClass("collapse").removeClass("collapsing"))}})),contentArea.html(newHtml.html()),contentArea.find('li.modtype_subsection a[data-toggle="collapse"]').on(Event_CLICK,(e=>{const clickedButton=$(e.currentTarget),isCollapsed=clickedButton.hasClass("collapsed"),subSectionId=clickedButton.data("subSectionId");isCollapsed&&void 0===expandedSubSectionIds[subSectionId]?expandedSubSectionIds[subSectionId]=!0:isCollapsed||void 0===expandedSubSectionIds[subSectionId]||delete expandedSubSectionIds[subSectionId]})),$(Selector_TILE_LOADING_ICON).fadeOut(300,(function(){$(Selector_TILE_LOADING_ICON).html("")})),contentArea.attr("id")!==Selector_SECTION_ZERO){if(contentArea.find(Selector_ACTIVITY).not(Selector_SPACER).find("a").on(Event_KEYDOWN,(function(e){if(e.keyCode===Keyboard_ENTER){var toClick=$(e.currentTarget).find("a");window.location.href=toClick.attr("href")}})),!isMobile){const focusableElements=contentArea.find(Selector_FOCUSABLE_ELEMS),firstFocusableElement=focusableElements.eq(0),lastFocusableElement=focusableElements.eq(focusableElements.length-1);lastFocusableElement.on(Event_KEYDOWN,(function(e){e.keyCode!==Keyboard_TAB||e.shiftKey||$(e.relatedTarget).closest(Selector_SECTION_MAIN).attr("id")===contentArea.attr("id")||setTimeout((function(){firstFocusableElement.focus(),contentArea.find(Selector_SECTION_BUTTONS).css("top","")}),100)})),firstFocusableElement.on(Event_KEYDOWN,(function(e){e.keyCode===Keyboard_TAB&&e.shiftKey&&$(e.relatedTarget).closest(Selector_SECTION_MAIN).attr("id")!==contentArea.attr("id")&&setTimeout((function(){lastFocusableElement.focus()}),100)}))}}isMobile||setTimeout((function(){try{const tooltipItems=contentArea.find(".badge-info");tooltipItems.length>0&&"function"==typeof tooltipItems.tooltip&&tooltipItems.tooltip()}catch(err){require(["core/log"],(function(log){log.debug(err)}))}}),500),setTimeout((()=>{contentArea.find(Selector_ACTIVITY_NAME).each(((i,el)=>{(el=$(el)).height()>110&&el.closest(Selector_INSTANCE_NAME).addClass("opaque-bg")}))}),100)}setTimeout((()=>{if(js){0===$("head").find("script").filter(((index,script)=>$(script).html()===js)).length&&Templates.runTemplateJS(js)}applyMathJax(contentArea);if(contentArea.find(Selector_MOODLE_VIDEO).length>0){require(["media_videojs/loader"],(function(videoJS){videoJS.setUp()}));["fullscreenchange","webkitfullscreenchang","mozfullscreenchange","msfullscreenchange"].forEach((function(ev){document.addEventListener(ev,(function(){reorgSectionsDisabledUntil=Date.now()+1e3}))}))}contentArea.find(".modal.fade").appendTo("body")}),1e3),$(document).trigger("format-tiles-section-content-changed",{courseId:parseInt(courseId),section:contentArea.data("section"),sectionid:contentArea.data("sectionid")})};const applyMathJax=function(contentArea){if(void 0!==window.MathJax)try{const mathJaxElems=contentArea.find(Selector_MATHJAX_EQUATION);mathJaxElems.length&&mathJaxElems.each(((i,node)=>{window.MathJax.Hub.Queue(["Typeset",window.MathJax.Hub,node])}))}catch(err){require(["core/log"],(function(log){log.debug(err)}))}};var expandSection=function(contentArea,sectionNumber){const tile=$("#tile-"+sectionNumber);contentArea.addClass(ClassNames_STATE_VISIBLE),(()=>{var _$$outerHeight,_$$outerHeight2,_$$outerHeight3,_$$outerHeight4,_$$outerHeight5;const footerHeight=null!==(_$$outerHeight=$("#page-footer").outerHeight())&&void 0!==_$$outerHeight?_$$outerHeight:0;$("li.section.state-visible").hide(),contentArea.show();const heights=[null!==(_$$outerHeight2=$("#page").outerHeight())&&void 0!==_$$outerHeight2?_$$outerHeight2:0,(null!==(_$$outerHeight3=$("#topofscroll.main-inner").outerHeight())&&void 0!==_$$outerHeight3?_$$outerHeight3:0)+(null!==(_$$outerHeight4=$("#page-header").outerHeight())&&void 0!==_$$outerHeight4?_$$outerHeight4:0),null!==(_$$outerHeight5=$("#page-content").outerHeight())&&void 0!==_$$outerHeight5?_$$outerHeight5:0];contentArea.hide(),overlay.css("min-height","".concat(Math.ceil(Math.max(...heights))+footerHeight+20,"px"))})(),overlay.fadeIn(300),tile.addClass(ClassNames_SELECTED),$(Selector_BODY).addClass(ClassNames_HAS_OPEN_TILE),contentArea.slideDown(350,(function(){!function(){var scrollTo=tile.offset().top-$("#section-zero-container").offset().top+60;scrollTo===$(window).scrollTop&&(scrollTo+=1);var events="mousedown wheel DOMMouseScroll mousewheel keyup touchmove";const page=$("html, body");page.on(events,(function(){page.stop()})),page.animate({scrollTop:scrollTo},"slow","swing",(function(){page.off(events,(function(){page.stop()})),contentArea.find(Selector_FOCUSABLE_ELEMS).eq(0).focus()})),setTimeout((()=>{contentArea.find(Selector_FOCUSABLE_ELEMS).eq(0).focus()}),300),openTile=sectionNumber;const iframes=contentArea.find("iframe");iframes.length>0&&(iframes.each((function(index,iframe){""===(iframe=$(iframe)).attr("src")&&void 0!==iframe.data("src")&&iframe.attr("src",iframe.data("src"))})),enableCompletion&&setTimeout((()=>{$(document).trigger("format-tiles-completion-changed",{courseid:courseId,section:sectionNumber})}),1e3))}()})),openTile=sectionNumber},reOrgSections=function(fitTilesToScreenWidth){var dfd=new $.Deferred;reorgSectionsDisabledUntil>Date.now()&&dfd.resolve();reorgSectionsDisabledUntil=Date.now()+1e3;var reOrgFunc=function(){tileFitter.runReOrg().done((function(result){dfd.resolve(result)})).fail((function(result){dfd.reject(result)}))};return fitTilesToScreenWidth?tileFitter.resizeTilesDivWidth(courseId).done((()=>{reOrgFunc()})):reOrgFunc(),dfd.promise()},getSectionContentFromServer=function(courseContextId,sectionId){return courseContextId&&sectionId||require(["core/log"],(function(log){log.debug("No course context ID '".concat(courseContextId.toString(),"' or section ID '").concat(sectionId.toString(),"'"))})),Fragment.loadFragment("format_tiles","get_cm_list",courseContextId,{sectionid:sectionId})},populateAndExpandSection=function(courseContextId,sectionId,sectionNumber){$(Selector_TILE).removeClass(ClassNames_SELECTED),openTile=sectionNumber,$(Selector_MOVEABLE_SECTION).each((function(index,sec){(sec=$(sec)).is(":visible")&&(stopVideoPlaying(sec.data("section"),sec.data("sectionid")),sec.slideUp(200).removeClass(ClassNames_STATE_VISIBLE))})),ajax.call([{methodname:"format_tiles_log_tile_click",args:{coursecontextid:courseContextId,sectionnumber:sectionNumber,sectionid:sectionId}}])[0].fail(Notification.exception);var relatedContentArea=$(Selector_SECTION_ID+sectionNumber);relatedContentArea.find(Selector_ACTIVITY).length>0?(expandSection(relatedContentArea,sectionNumber),getSectionContentFromServer(courseContextId,sectionId).done((function(html,js){setCourseContentHTML(relatedContentArea,html,js)}))):(relatedContentArea.html(loadingIconHtml),getSectionContentFromServer(courseContextId,sectionId).done((function(html,js){setCourseContentHTML(relatedContentArea,html,js),expandSection(relatedContentArea,sectionNumber)})).fail((function(failResult){!function(sectionNum,failResult,contentArea){failResult?("notavailablecourse"===failResult.errorcode?Notification.confirm(stringStore.sectionerrortitle,failResult.message,stringStore.continue):(Notification.confirm(stringStore.sectionerrortitle,stringStore.sectionerrorstring,stringStore.refresh,stringStore.cancel,(function(){window.location.reload()}),null),require(["core/log"],(function(log){log.debug(failResult)}))),contentArea.html("")):(setCourseContentHTML(contentArea,"<p>"+stringStore.noconnectionerror+"</p>",""),setTimeout((function(){expandSection(contentArea,sectionNum)}),500))}(sectionNumber,failResult,relatedContentArea),cancelTileSelections(sectionNumber)}))),browserStorage.setLastVisitedSection(sectionNumber),$(Selector_MOODLE_DIALOGUE).remove()};const removeUrlParam=function(pattern){window.location.href.match(pattern)&&history.pushState(null,null,window.location.href.replace(pattern,""))};return{init:function(courseIdInit,useJavascriptNav,isMobileInit,sectionNum,useFilterButtons,assumeDataStoreConsent,reopenLastSectionInit,userId,fitTilesToWidth,enableCompletionInit,useSubTiles,courseContextIdInit){courseId=parseInt(courseIdInit),courseContextId=courseContextIdInit,isMobile=isMobileInit,reopenLastVisitedSection="1"===reopenLastSectionInit,assumeDataStoreConsent="1"===assumeDataStoreConsent,enableCompletion="1"===enableCompletionInit,browserStorage.init(courseId,!1,sectionNum,assumeDataStoreConsent,userId),$(document).ready((function(){const isMultiSectionPage=1===$(Selector_TILES).length;useSubTiles&&$(Selector_BODY).addClass("format-tiles-subtiles");var pageContent=$("#page-content");0===pageContent.length&&(pageContent=$("#region-main")),0!==sectionNum?openTile=sectionNum:reopenLastVisitedSection&&browserStorage.storageEnabledLocal&&(openTile=browserStorage.getLastVisitedSection());const anchorMatches=window.location.href.match(/#module-(\d+)$/gi);if(anchorMatches&&anchorMatches.length){const anchorCmId=parseInt(anchorMatches[0].split("-")[1]);anchorCmId&&(openTile=null,ajax.call([{methodname:"format_tiles_get_course_mod_info",args:{cmid:anchorCmId}}])[0].done((function(data){data&&data.courseid===courseId&&(openTile=data.sectionnumber,useJavascriptNav&&populateAndExpandSection(data.coursecontextid,data.sectionid,data.sectionnumber))})))}0!==openTile?tileFitter.init(courseId,openTile,fitTilesToWidth,!1):tileFitter.init(courseId,null,fitTilesToWidth,!1);const pageContentElem=$("#page-content"),widthObservedElement=pageContentElem.length?pageContentElem:$(window);var observedElementWidth=widthObservedElement.outerWidth();const page=$("#page");if(useJavascriptNav){pageContent.on(Event_CLICK,Selector_TILE_CLICKABLE,(function(e){if(!useJavascriptNav)return;if(!$(e.target).hasClass(ClassNames_ON_TILE_CONTROL)){e.preventDefault(),$(Selector_TILE_LOADING_ICON).fadeOut(300,(function(){$(Selector_TILE_LOADING_ICON).html()}));var thisTile=$(e.currentTarget).closest(Selector_TILE),dataSection=parseInt(thisTile.data("section"));thisTile.hasClass(ClassNames_SELECTED)?(cancelTileSelections(dataSection),browserStorage.setLastVisitedSection(0),overlay.fadeOut(300),overlay.css("min-height","inherit")):populateAndExpandSection(courseContextId,thisTile.data("true-sectionid"),dataSection)}})),overlay.on(Event_CLICK,(function(e){cancelTileSelections(0),browserStorage.setLastVisitedSection(0),function(e){var clickedItem=$(e.currentTarget);if(clickedItem.attr("id")===OVERLAY_ID){clickedItem.hide();var BottomElement=$(document.elementFromPoint(e.clientX,e.clientY));if(clickedItem.show(),BottomElement.hasClass("filterbutton")||BottomElement.hasClass("list-group-item"))BottomElement.click();else{var clickedTile=BottomElement.closest(Selector_TILE);clickedTile&&clickedTile.click()}}}(e)}));new ResizeObserver((()=>{observedElementWidth!==widthObservedElement.outerWidth()&&(clearTimeout(resizeTimeout),resizeTimeout=setTimeout((function(){if(!(reorgSectionsDisabledUntil>Date.now())){var resizeRequired=!0,openContentSection=$(".moveablesection:visible");if(0!==openContentSection.length){var iframes=openContentSection.find("iframe");0!==iframes.length&&iframes.each((function(index,player){(player=$(player)).outerWidth()>openContentSection.outerWidth()&&(resizeRequired=!1)}))}resizeRequired&&(observedElementWidth=widthObservedElement.outerWidth(),reOrgSections(fitTilesToWidth))}}),100))})).observe(document.getElementById("page-content")),pageContent.on(Event_CLICK,Selector_CLOSE_SEC_BTN,(function(e){const currentSectionNumber=$(e.currentTarget).data("section");cancelTileSelections(currentSectionNumber),$("#sectionlink-"+currentSectionNumber).focus()})),function(){var buttonHideSecZero=$(Selector_HIDE_SEC0_BTN),sectionZero=$(Selector_SECTION_ZERO);browserStorage.storageEnabledLocal()?!0===browserStorage.getSecZeroCollapseStatus()?(sectionZero.slideUp(0),buttonHideSecZero.addClass(ClassNames_CLOSED).removeClass(ClassNames_OPEN),$(Selector_ABOVE_TILES).addClass("sec-zero-closed")):(sectionZero.slideDown(300),buttonHideSecZero.addClass(ClassNames_OPEN).removeClass(ClassNames_CLOSED),$(Selector_ABOVE_TILES).removeClass("sec-zero-closed")):(buttonHideSecZero.addClass(ClassNames_OPEN).removeClass(ClassNames_CLOSED),sectionZero.slideDown(300),$(Selector_ABOVE_TILES).removeClass("sec-zero-closed"))}(),isMultiSectionPage&&(removeUrlParam(/(&|\\?)cmid=\d+/gi),removeUrlParam(/(&|\\?)section=\d+/gi)),page.length&&$("#".concat(OVERLAY_ID)).appendTo(page).css("position","absolute"),(()=>{const courseIndex=$("nav#courseindex");courseIndex.length>0&&courseIndex.on("click",(e=>{const target=$(e.target);if(target.hasClass("courseindex-link")&&"togglecourseindexsection"===target.data("action")){const sec=target.closest(".courseindex-section"),sectionNumber=sec.data("number");sec&&void 0!==sectionNumber&&(e.preventDefault(),0===sectionNumber?cancelTileSelections(0):populateAndExpandSection(courseContextId,sec.data("id"),sectionNumber))}}))})()}else fitTilesToWidth&&tileFitter.resizeTilesDivWidth(courseId);$(document).on("format-tiles-completion-changed",(function(e,data){var _contentArea$data;if(data.courseid&&parseInt(courseId)!==parseInt(data.courseid))return;const allSectionNums=$(Selector_TILE).not(Selector_SPACER).map(((i,tile)=>parseInt($(tile).data("section")))).toArray();allSectionNums.push(0);const contentArea=$(Selector_SECTION_ID+data.section),sectionId=null!==(_contentArea$data=contentArea.data("sectionid"))&&void 0!==_contentArea$data?_contentArea$data:contentArea.data("section-id");Fragment.loadFragment("format_tiles","get_cm_list",courseContextId,{sectionid:sectionId}).done(((html,js)=>{setCourseContentHTML(contentArea,html,js)})).catch((err=>{require(["core/log"],(function(log){log.debug(err)}))})),ajax.call([{methodname:"format_tiles_get_section_information",args:{courseid:courseId,sectionnums:allSectionNums}}])[0].done((response=>{require(["format_tiles/completion"],(function(completion){completion.updateSectionsInfo(response.sections,response.overall.complete,response.overall.outof)}))})).catch((err=>{require(["core/log"],(function(log){log.debug(err)}))}))})),enableCompletion&&pageContent.on(Event_CLICK,Selector_MANUAL_COMPLETION,(function(e){const currentTarget=$(e.currentTarget),sectionNum=currentTarget.closest(Selector_SECTION_MAIN).data("section"),cmid=currentTarget.data("cmid");require(["format_tiles/completion"],(function(completion){setTimeout((()=>{completion.triggerCompletionChangedEvent(sectionNum?parseInt(sectionNum):0,cmid?parseInt(cmid):0)}),500)}))}));const sectionZero=$(Selector_SECTION_ZERO);pageContent.on(Event_CLICK,Selector_HIDE_SEC0_BTN,(function(e){"none"===sectionZero.css(CSS_DISPLAY)?(sectionZero.slideDown(250),$(Selector_ABOVE_TILES).removeClass("sec-zero-closed"),$(e.currentTarget).addClass(ClassNames_OPEN).removeClass(ClassNames_CLOSED),browserStorage.setSecZeroCollapseStatus("collapsed")):(sectionZero.slideUp(250),$(Selector_ABOVE_TILES).addClass("sec-zero-closed"),$(e.currentTarget).addClass(ClassNames_CLOSED).removeClass(ClassNames_OPEN),browserStorage.setSecZeroCollapseStatus("expanded"))})),useFilterButtons&&(require(["format_tiles/filter_buttons"],(function(filterButtons){filterButtons.init(courseId,browserStorage.storageEnabledLocal)})),useJavascriptNav&&pageContent.on(Event_CLICK,Selector_FILTER_BUTTON,(function(){cancelTileSelections(0),reOrgSections(!1)}))),$(".tiles_coursenav").removeClass("hidden"),Templates.render("format_tiles/loading",{}).done((function(html){loadingIconHtml=html}));var stringKeys=[{key:"sectionerrortitle",component:"format_tiles"},{key:"sectionerrorstring",component:"format_tiles"},{key:"refresh"},{key:"cancel",component:"moodle"},{key:"noconnectionerror",component:"format_tiles"},{key:"show"},{key:"hide"},{key:"other",component:"format_tiles"},{key:"continue"}];str.get_strings(stringKeys).done((function(s){s.forEach((function(str,index){str?stringStore[stringKeys[index].key]=str:(stringStore[stringKeys[index].key]="Error.",require(["core/log"],(function(log){log.debug("Format tiles get_strings error ".concat(index)),log.debug(s)})))}))})).fail((function(err){require(["core/log"],(function(log){log.debug(err)}))}));let fixButtonsDisabled=!1;$(window).scroll((function(){if(!fixButtonsDisabled)try{$(window).scrollTop()>=300&&$(".moveablesection.state-visible").each(((i,s)=>{s=$(s);const sectionRect=document.getElementById("section-"+s.data("section")).getBoundingClientRect(),right=document.body.clientWidth-sectionRect.right+30,sectionButtons=s.find(".sectionbuttons"),topMargin=page.offset().top;sectionRect.top+topMargin<0&&sectionRect.bottom-topMargin>0?(sectionButtons.addClass("position-fixed"),sectionButtons.css({top:topMargin+10,right:right})):(sectionButtons.removeClass("position-fixed"),sectionButtons.css({top:"unset",right:"unset"}))}))}catch(err){require(["core/log"],(function(log){log.debug(err)})),fixButtonsDisabled=!0}}));const urlMatches=window.location.href.match(/.*\/course\/view\.php\?id=([\d]+)#sectionid-([\d+]+)-title/);if(urlMatches&&3===urlMatches.length){const sectionId=urlMatches[2],redirectUrl=urlMatches[0].replace("#sectionid-".concat(sectionId,"-title"),"&sectionid=".concat(sectionId));window.location.replace(redirectUrl)}}))},populateAndExpandSection(courseContextId,sectionId,sectionNumber){populateAndExpandSection(courseContextId,sectionId,sectionNumber)}}}));

//# sourceMappingURL=course.min.js.map